<?php


namespace App\Http\Controllers\Backend\Agency\Agents;

use App\Http\Controllers\Controller;
use App\Models\Agency\Agents\Agents;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use App\Repositories\Backend\Agency\AgentsRepository;
use DB;
use App\Models\Superadmin\Plans\Plans;
use Illuminate\Support\Facades\Hash;
use DateTime;
use App\Http\Requests\Backend\Superadmin\CreateagentRequest;
use App\Http\Requests\Backend\Superadmin\AgenteditRequest;
use Illuminate\Support\Facades\Auth;

class AgentsController extends Controller
{
    protected $agent;
    public function __construct(AgentsRepository $agent)
    {
        $this->agent = $agent;
    }

    public function index()
    {
        return view('backend.agency.agents.index');
    }
    public function create()
    {
        $countries = DB::table('countries')->pluck('name', 'id');
        $agency = Plans::all()->where('status', 1)->pluck('agency_name', 'id');
        return view('backend.agency.agents.create', ['agency' => $agency, 'countries' => $countries]);
    }

    public function store(CreateagentRequest $request)
    {
        $current_user = Auth::user();
        $email = DB::table('dx_agents')->where('email', $request->email)->first();
        $useremail = DB::table('users')->where('email', $request->email)->first();
        if (empty($email->email) && empty($useremail->email)) {

            $agent = new Agents([
                'first_name' => $request->get('first_name'),
                'last_name' => $request->get('last_name'),
                'phone' => $request->get('phone'),
                'mobile' => $request->get('mobile'),
                'email' => $request->get('email'),
                'agency_id' => $current_user->agency_id,
                'country' => $request->get('country'),
                'city_id' => $request->get('city_id')
            ]);
            $agent->save();
            $insertedId = $agent->id;
            $data = array(
                'first_name' => $request->first_name,
                'last_name' => $request->last_name,
                'email' => $request->email,
                'password' => Hash::make($request->password),
                'status' => 1,
                'confirmed' => 1,
                'agent_id' => $insertedId,
                'confirmation_code' => md5(uniqid(mt_rand(), true)),
                'created_at' => new DateTime(),
                'updated_at' => new DateTime(),
            );
            $user = DB::table('users')->insert($data);
            $id = DB::getPdo()->lastInsertId();

            $role = array(
                'user_id' => $id,
                'role_id' => 3,
            );
            $record = DB::table('role_user')->insert($role);
            if ($record = true) {
                return redirect()->route('admin.agency.agents.index')->withFlashSuccess(__('The agent was successfully created.'));
            }
        } else {

            return back()->withInput()->withFlashDanger(__('Email already exists.'));

        }

    }

    public function edit($id)
    {
        $online = DB::table('users')->where('agent_id',$id)->first();
        $agent = Agents::first()->where('id', '=', $id)->first();
        $agency = Plans::all()->where('status', 1)->pluck('agency_name', 'id');
        $city = DB::table('cities')->where('country_id', $agent->country)->get();
        $countries = DB::table('countries')->pluck('name', 'id');
        return view('backend.agency.agents.edit', ['agent' => $agent, 'agency' => $agency,'online'=>$online,'countries'=>$countries,'city'=>$city]);

    }

    public function update(Agents $agent, AgenteditRequest $request)
    {
        $this->agent->update($agent, ['data' => $request]);
        DB::table('users')->where('agent_id', $agent->id)->update([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'status' => $request->status,
            'online' => $request->online,
        ]);

        return redirect()->route('admin.agency.agents.index')->withFlashSuccess(__('The agent was successfully updated. '));
    }

    public function destroy($id)
    {
        $user = DB::table('dx_agents')->where('id', $id)->first();
        DB::table('users')->where('email', $user->email)->delete();
        DB::table('dx_agents')->where('id', $id)->delete();
        return redirect()->route('admin.agency.agents.index')->withFlashSuccess(__('The agent was successfully deleted. '));
    }

    public function show($id)
    {
        $agent = DB::table('dx_agents')->where('id', '=', $id)->first();
        $agency = DB::table('dx_agencies')->where('id', '=', $agent->agency_id)->first();
        $city = DB::table('cities')->where('id', $agent->city_id)->first();
        $country = DB::table('countries')->where('id', $agent->country)->first();
        return view('backend.agency.agents.show', ['agent' => $agent, 'agency' => $agency,'country'=>$country,'city'=>$city]);
    }

}
