<?php

namespace App\Helpers\Stripe;

class StripeActions {

    public function __construct()
    {
        \Stripe\Stripe::setApiKey(env('STRIPE_SECRET'));
    }

    public function createCustomer($name, $email, $address, $token) {
        $customer = \Stripe\Customer::create([
            'name' => $name,
            'email' => $email,
            'address' => $address,
            'source'  => $token,
        ]);
        return $customer;
    }

    public function createCharge($customer_id, $amount, $description) {
        $charge = \Stripe\Charge::create([
            'customer' => $customer_id,
            'amount'   => $amount,
            'currency' => 'usd',
            'description' => $description
        ]);
        return $charge;
    }
}

?>