<?php

namespace App\Console\Commands;

use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class ImportLeads extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:leads';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'imports leads from the stored files';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $path = base_path("resources/pendingleads/*.csv"); 
        //run 2 loops at a time 
        foreach (array_slice(glob($path),0,2) as $file) {
            
            //read the data into an array
            $data = Excel::load($file, function($reader) {
            })->get();

            foreach ($data as $key => $value) {
                unset ($transformedLead);
                $transformedLead = $this->transformLead($value);
                DB::table('leads')->insert($transformedLead);
            }
            //delete the file
            unlink($file);
        }
    }

    private function transformLead($lead) {
        $insert[] = [
            'fname'=> $lead->first_name,
            'lname'=> $lead->last_name,
            'pphone'=> $lead->primary_phone,
            'sphone'=> $lead->secondary_phone,
            'email'=> $lead->email,
            'address'=> $lead->address,
            'city'=> $lead->city,
            'state'=> $lead->state,
            'zip'=> $lead->zip,
            'gender'=> $lead->gender,
            'birthdate'=> $lead->birthdate,
            'age'=> $lead->age,
            'self_assessed_credit'=> $lead->self_assessed_credit,
            'home_type'=> $lead->home_type,
            'year_built'=> $lead->year_built,
            'square_feet'=> $lead->square_feet,
            'bedrooms'=> $lead->bedrooms,
            'bathrooms'=> $lead->bathrooms,
            'construction_type'=> $lead->construction_type,
            'roof_surface'=> $lead->roof_surface,
            'foundation_type'=> $lead->foundation_type,
            'exterior_walls'=> $lead->exterior_walls,
            'garage_type'=> $lead->garage_type,
            'total_stories'=> $lead->total_stories,
            'electrical_system'=> $lead->electrical_system,
            'fireplaces'=> $lead->fireplaces,
            'pool'=> $lead->pool,
            'patio_deck'=> $lead->patio_deck,
            'alarm'=> $lead->alarm,
            'central_ac'=> $lead->central_ac,
            'dead_bolt'=> $lead->dead_bolt,
            'smoke_detector'=> $lead->smoke_detector,
            'fire_extinguisher'=> $lead->fire_extinguisher,
            'smoker_in_home'=> $lead->smoker_in_home,
            'dog_in_home'=> $lead->dog_in_home,
            'near_fire_station'=> $lead->near_fire_station,
            'near_fire_hydrant'=> $lead->near_fire_hydrant,
            'currently_insured'=> $lead->currently_insured,
            'current_carrier'=> $lead->current_carrier,
            'residence_coverage_amount'=> $lead->residence_coverage_amount,
            'personal_property_amount'=> $lead->personal_property_amount,
            'personal_liability_amount'=> $lead->personal_liability_amount,
            'deductible_amount'=> $lead->deductible_amount,
            'years_continuously_covered'=> $lead->years_continuously_covered,
            'policy_expiration'=> $lead->policy_expiration,
            'property_address'=> $lead->property_address,
            'property_city'=> $lead->property_city,
            'property_state'=> $lead->property_state,
            'property_zip'=> $lead->property_zip,
            'property_use'=> $lead->property_use,
            'home_value'=> $lead->home_value,
        ];
        return $insert;
    }
}
