<?php 
class Leaves_model extends CI_Model
{
    public function get_allowed_employee_listing()
    {
        if($this->permission->method('leave_report', 'update')->access()) {
            return  $this->db->select('employee_id id, CONCAT_WS(\' \', first_name, last_name, hrm_id) as label')->order_by('first_name')->get('employee_history')->result();
        } elseif ($this->session->userdata('supervisor')) {
            $this->load->model('employee/employees_model');
            return array_map(function($emp){
                return (object) [
                    'id' => $emp['employee_id'],
                    'label' => sprintf('%s %s %s', $emp['first_name'], $emp['last_name'], $emp['hrm_id'])
                ];
            }, $this->employees_model->get_subordinates());
        } else {
            return $this->db->select('employee_id id, CONCAT_WS(\' \', first_name, last_name, hrm_id) as label')->where('employee_id', $this->session->userdata('employee_id'))->get('employee_history')->result();
        }
    }
    public function dropdowns($params = ['years', 'employees', 'leave_types', 'departments', 'supervisors'])
    {
        $data = [];
        if(in_array('years', $params)) {
            $data['years'] = range(date('Y'), '1900');
        }
        if(in_array('employees', $params)) {
            $data['employees'] = $this->get_allowed_employee_listing();
        }
        if(in_array('leave_types', $params)) {
            $data['leave_types'] =  $this->db->select('leave_type_id id, leave_type as label')->order_by('leave_type_id')->get('leave_type')->result();
        }
        if(in_array('departments', $params)) {
            $data['department_ids'] =  $this->db->select('dept_id id, department_name as label')->order_by('department_name')->get('department')->result();
        }
        if(in_array('supervisors', $params)) {
            $data['supervisors_ids'] =  $this->db->select('employee_id id, CONCAT_WS(\' \', first_name, last_name, hrm_id) as label')->where('is_super_visor', 1)->order_by('first_name')->get('employee_history')->result();
        }
        return $data;
    }
    public function leave_report($year = null, $employee_ids = [], $leave_types = [], $department_ids = [], $supervisor_ids = [])
    {
        if(empty(trim(preg_replace('#[^\d]+#is', '', $year)))) {
            $year = date('Y');
        }
        $full_start_date = $year . '-01-01';
        $full_end_date = $year . '-12-31';
        $this->db->select("employee_history.employee_id,
        '{$year}' as year,
        CONCAT_WS(' ', employee_history.first_name, employee_history.last_name) AS name,
        employee_history.hrm_id,
        IFNULL(leave_type.leave_type, 'NOT ALLOCATED') AS type,
        IFNULL(employee_leaves.leave_qouta, 0) AS quota,
        GREATEST(IFNULL(employee_leaves.leave_qouta, 0) - SUM(IF(leave_apply.leave_type_id = leave_type.leave_type_id AND leave_apply.hr_status = 'approved', IFNULL(leave_apply.num_aprv_day, 0), 0)), 0) AS remaining,
        SUM(IF(leave_apply.leave_type_id = leave_type.leave_type_id, leave_apply.apply_day, 0)) AS applied,
        SUM(IF(leave_apply.leave_type_id = leave_type.leave_type_id AND leave_apply.hr_status = 'pending', leave_apply.apply_day, 0)) AS pending,
        SUM(IF(leave_apply.leave_type_id = leave_type.leave_type_id AND leave_apply.hr_status = 'approved', leave_apply.num_aprv_day, 0)) AS approved,
        SUM(IF(leave_apply.leave_type_id = leave_type.leave_type_id AND (leave_apply.hr_status = 'denied' OR leave_apply.supervisor_status = 'denied'), leave_apply.apply_day - leave_apply.num_aprv_day, 0)) AS denied", false)
        ->from('employee_history')
        ->join('employee_leaves', 'employee_leaves.emp_id = employee_history.employee_id', 'left')
        ->join('leave_type', 'employee_leaves.leave_type = leave_type.leave_type_id', 'left')
        ->join('leave_apply',
        "leave_type.leave_type_id = leave_apply.leave_type_id
        AND employee_history.employee_id = leave_apply.employee_id
        AND IFNULL(leave_apply.leave_aprv_strt_date, leave_apply.apply_strt_date) >= '{$full_start_date}'
        AND IFNULL(leave_apply.leave_aprv_end_date, leave_apply.apply_end_date) <= '{$full_end_date}'",
        'left')
        ->group_by('employee_history.employee_id, employee_leaves.leave_type')
        ->where('employee_history.employee_id IS NOT ', NULL);
        if(!$this->permission->module('show_inactive_employees')->access()) {
            $this->db->where('employee_history.status', 'active');
        }
        if($employee_ids || $leave_types || $department_ids || $supervisor_ids) {
            $this->db->group_start();
            if($employee_ids) {
                if(!$this->permission->method('leave_report', 'update')->access()) {
                    $allowed_emps = array_column($this->get_allowed_employee_listing(), 'id');
                    $employee_ids = array_filter($employee_ids, function($emp) use ($allowed_emps)
                    {
                        return in_array($emp, $allowed_emps);
                    });
                }
                $this->db->where_in('employee_history.employee_id', $employee_ids);
            }
            if($leave_types) {
                $this->db->where_in('leave_type.leave_type_id', $leave_types);
            }
            if($department_ids) {
                $this->db->where_in('employee_history.dept_id', $department_ids);
            }
            if($supervisor_ids) {
                $this->db->where_in('employee_history.super_visor_id', $supervisor_ids);
            }
            $this->db->group_end();
        }
        if(!$employee_ids && !$this->permission->method('leave_report', 'update')->access()) {
            $this->db->where_in('employee_history.employee_id', array_column($this->get_allowed_employee_listing(), 'id'));
        }
        return $this->db->get()->result();
    }
}