<?php 
class Employee extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['employees_model' => 'employee']);
    }
    public function report()
    {
        $this->permission->method('employee_report', 'read')->redirect();
        $data['title'] = display('employee_report');
        $data['module'] = 'reports';
        $data['page'] = "employee_report/employee";
        $data['dropdowns'] = $this->employee->dropdowns();

        if ($this->input->get('column') ||
            $this->input->get('employee') ||
            $this->input->get('department_id') ||
            $this->input->get('supervisor_id')) {
            $data['rows'] = $this->leaves->leave_report(
                $this->input->get('column'),
                $this->input->get('employee'),
                $this->input->get('department_id'),
                $this->input->get('supervisor_id'),
            );
        }
        echo Modules::run('template/layout', $data);
    }
}