<div class="form-group text-right">
    <?php if ($this->permission->method('requisition_list', 'create')->access()): ?>
    <a href="<?php echo base_url(); ?>recruitment/requisition/add" class="btn btn-primary"><i class="fa fa-plus-circle"
            aria-hidden="true"></i>&nbsp;Add Requisition Request</a>
    <?php endif;?>
</div>
<style>
    .label-warning {
        color: black;
        font-weight: 600;
    }
</style>
<div class="container-fluid">
    <div class="row">
        <ul class="nav nav-tabs">
            <li data-toggle="tab" data-target="#requisition-drafts" class="active"><a href="#requisition-drafts">Your Saved Drafts</a></li>
            <li data-toggle="tab" data-target="#requisition-list" class=""><a href="#requisition-list">Requisitions</a></li>
        </ul>

        <div class="tab-content">
            <div class="tab-pane fade in active" id="requisition-drafts">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <table width="100%" class="table table-striped table-bordered table-hover table-drafts requisition_list">
                            <thead>
                                <tr>
                                    <th><?php echo display('job_id') ?></th>
                                    <th><?php echo display('job_title') ?></th>
                                    <th><?php echo display('job_description') ?></th>
                                    <th><?php echo display('job_location') ?></th>
                                    <th width="100px" class="hideexport"><?php echo display('action') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="requisition-list">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <table width="100%" class="table table-striped table-bordered table-hover table-list requisition_list">
                            <thead>
                                <tr>
                                    <th><?php echo display('job_id') ?></th>
                                    <th><?php echo display('job_title') ?></th>
                                    <th><?php echo display('job_description') ?></th>
                                    <th><?php echo display('job_location') ?></th>
                                    <th>Requestor</th>
                                    <th><?php echo display('job_status') ?></th>
                                    <th width="100px" class="hideexport"><?php echo display('action') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function () {
        $(".table-list").DataTable($.extend({}, window.default_datatable_opts, {
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?=base_url('recruitment/requisition/get_requisitions')?>",
                method: 'post',
                beforeSend: function(){},
                complete: function(){}
            },
            columns: [{
                    'data': 'jp_id',
                },
                {
                    'data': 'position',
                },
                {
                    'data': 'jp_title_description',
                },
                {
                    'data': 'cities',
                    'sortable': false
                },
                {
                    'data': 'author'
                },
                {
                    'data': 'requisition_status'
                },
                {
                    'data': 'action',
                    'sortable': false
                },
            ],
            order: [[0, 'DESC']]
        }));
        $('.table').on('click', '.btn-download', function (e) {
            e.preventDefault()
            var id = $(this).data('id')
            var url = '<?= base_url() ?>recruitment/requisition/';
            $('body').append('<iframe id="printframe-apd" src="'+url+'print/apd/'+id+'" frameborder="0" style="visibility:hidden;width: 950px;height: 950px;"></iframe>')
            $('body').append('<iframe src="'+url+'pdf/'+id+'" frameborder="0" style="display:none"></iframe>')
        });
        $(".table-drafts").DataTable($.extend({}, window.default_datatable_opts, {
            processing: true,
            serverSide: true,
            ajax: {
                url: "<?=base_url('recruitment/requisition/get_requisitions')?>?drafts=yes",
                method: 'post',
                beforeSend: function(){},
                complete: function(){}
            },
            columns: [{
                    'data': 'jp_id',
                },
                {
                    'data': 'position',
                },
                {
                    'data': 'jp_title_description',
                },
                {
                    'data': 'cities',
                    'sortable': false
                },
                {
                    'data': 'action',
                    'sortable': false
                },
            ],
            order: [[0, 'DESC']]
        }));
    });
</script>