<style>
    .table .dropdown-menu {
        left: -110px
    }
</style>
<div class="container-fluid">
    <div class="row">
        <!--  table area -->
        <div class="col-sm-12">
            <div class="panel panel-default thumbnail">
                <div class="panel-body">
                    <table width="100%" class="table table-striped table-bordered table-hover table-main-applications">
                        <thead>
                            <tr>
                                <th><?= display('job_title') ?></th>
                                <th><?= display('name') ?></th>
                                <th><?= display('email') ?></th>
                                <th><?= display('phone') ?></th>
                                <th><?= display('status') ?></th>
                                <?php if($this->session->userdata('isAdmin')): ?>
                                <th>Interviewer</th>
                                <?php endif?>
                                <th>Interview Time</th>
                                <th class="hideexport"><?= display('action') ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($caninfo as $que) : ?>
                            <tr>
                                <td><?= $que->position; ?></td>
                                <td><?= $que->can_name ?></td>
                                <td><?= $que->email; ?></td>
                                <td><?= $que->phone; ?></td>
                                <?php if(in_array($que->status, ['interview_pending', 'interview_done', 'interview_canceled'])):
                                    $count = getByWhere('candidate_shortlist', 'count(*) as numrows', ['can_id' => $que->can_id])[0];
                                    ?>
                                <td><?= display($que->status) ?> #<?= $count->numrows ?></td>
                                <?php else:?>
                                <td><?= display($que->status) ?></td>
                                <?php endif?>
                                <?php if($this->session->userdata('isAdmin')): ?>
                                <td><?= $que->interviewer; ?></td>
                                <?php endif?>
                                <td><?= $que->status == 'interview_pending' ? formatted_date($que->interview_date, true) : null ?></td>
                                <td>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-default dropdown-toggle"
                                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            Action <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu">
                                            <?php if($que->status == 'interview_pending'):?>
                                            <li><a href="#" class="btn-interview-done" data-can-short-id="<?=$que->can_short_id?>">Mark
                                                    Interview Done</a></li>
                                            <?php endif?>
                                            <?php 
                                            $inter_recs = getByWhere('candidate_interview', 'count(*) numrows', ['can_id' => $que->can_id])[0];
                                            if($inter_recs->numrows): ?>
                                                <li role="separator" class="divider"></li>
                                                <li><a href="#" class="btn-interview-history" data-id="<?=$que->can_id?>">Interview History</a></li>
                                            <?php endif?>
                                            <li role="separator" class="divider"></li>
                                            <li><a href="#" class="btn-view-profile" data-id="<?=$que->can_id?>">View
                                                    Profile</a></li>
                                            <li><a href="<?=base_url($que->resume)?>" download>Download Resume</a></li>
                                        </ul>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function () {
        $('table.table-main-applications').dataTable($.extend({}, window.default_datatable_opts, {
            "columnDefs": [ {
                "targets": [5],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY hh:mm:ss A')
                    }
                    return data;
                }
            
            } ],
            "order": [[ 5, "desc" ]]
        }))
        $('table.table-main-applications').on('click', '.btn-view-profile', function (e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/job_posting/get_profile",
                data: {
                    'can_id': $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        $('#model-profile').find('.modal-body').html(res.success)
                        $('#model-profile').modal('show')
                    } else {
                        alert(res.error)
                    }
                }
            });
        });
        $('table.table-main-applications').on('click', '.btn-interview-history',function (e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/candidate_select/interview_history",
                data: {
                    'can_id': $(this).data('id')
                },
                success: function (res) {
                    if (res.success) {
                        $('#model-interview-history').find('.modal-body').html(res.success)
                        $('#model-interview-history').modal('show')
                    } else {
                        alert(res.error)
                    }
                }
            });
        });
        $('table.table-main-applications').on('click', '.btn-interview-done',function (e) {
            e.preventDefault()
            $modal = $('#model-interview-done');
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/candidate_select/interview_form",
                data: {
                    can_short_id: $(this).data('can-short-id'),
                },
                success: function (res) {
                    if(res.success){
                        $modal.find('.modal-body').html(res.success)
                        $modal.modal('show')
                    }else{
                        alert('Error while loading interview data try again later')
                    }
                }
            });
        })
    });
</script>
<div id="model-interview-done" class="modal fade right" data-backdrop="static" data-keyboard="false" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><strong> INTERVIEW FORM</strong></center>
            </div>
            <div class="modal-body">
                
            </div>
        </div>
        <div class="modal-footer">
        </div>
    </div>
</div>
<div class="modal fade" id="model-profile" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Candidate Information</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="model-interview-history" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
    aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Interview History</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>