<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Requisition_model extends CI_Model
{
    public function get($id)
    {
        $rec = getByWhere(
            'job_posting_locations,
            job_posting-job_posting_locations.jp_id=job_posting.jp_id-left,
            city-city.ID=job_posting_locations.jpl_city_id-left,
            position-position.pos_id=job_posting.pos_id-left',
            'job_posting.*,
            GROUP_CONCAT(DISTINCT city.Name) as cities,
            GROUP_CONCAT(DISTINCT job_posting_locations.jpl_city_id) as location_ids,
            position.position_name as position',
            ['job_posting.jp_id' => $id],
            [],
            0,
            0,
            [],
            'job_posting.jp_id'
        );
        if (!$rec) {
            return null;
        }
        $rec = $rec[0];
        $rec->cities = explode(',', $rec->cities);
        $rec->location_ids = explode(',', $rec->location_ids);
        $rec->skills = getByWhereAsArray('job_posting_skills', '*', ['jp_id' => $id]);
        $rec->job_wfh = getByWhereAsArray('job_posting_wfh', '*', ['jp_id' => $id]);
        return $rec;
    }
    public function requisitions($requisitor_id = null, $start = 0, $limit = 0, $order = [], $orWhere = [])
    {
        if ($limit < 0) {
            $limit = 0;
        }
        $this->db->select('job_posting.*, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as author, position.position_name as position')
            ->from('job_posting')
            ->join('position', 'position.pos_id=job_posting.pos_id', 'left')
            ->join('user', 'user.id=job_posting.created_by', 'left')
            ->join('employee_history', 'user.email=employee_history.email', 'left')
            ->limit($limit, $start)
            ->order_by($order[0], $order[1]);

        if ($this->session->userdata('isAdmin') || $this->permission->full('recruitment')->access()) {
        }elseif($this->permission->module('review_requisition_list')->access() && $this->permission->module('create_ad_from_requisition')->access()) {
        } elseif ($this->permission->module('review_requisition_list')->access()) {
            $this->db->where_in('requisition_status', ['pending_rm']);
        } elseif ($this->permission->module('create_ad_from_requisition')->access()) {
            $this->db->group_start()
                ->or_where('created_by', $this->session->userdata('id'))
                ->or_where('hr_assigned', $this->session->userdata('id'))
                ->group_end();
        } else {
            $this->db->where('created_by', $requisitor_id);
        }
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        if ($this->input->get('drafts')) {
            $this->db->where('created_by', $requisitor_id);
            $this->db->where('jp_is_draft', 1);
        } else {
            $this->db->where('jp_is_draft', 0);
        }
        $recs = $this->db->get()->result_array();

        foreach ($recs as $key => $rec) {
            $recs[$key]['cities'] = getByWhereAsArray(
                'job_posting_locations,
                city-city.ID=job_posting_locations.jpl_city_id-left',
                'GROUP_CONCAT(DISTINCT city.Name SEPARATOR \', \') as cities',
                ['job_posting_locations.jp_id' => $rec['jp_id']],
                [],
                0,
                0,
                [],
                'job_posting_locations.jp_id'
            )[0]['cities'];
        }

        return $recs;
    }
    public function get_remarks($id)
    {
        return getByWhere('requisition_request_history', '*', ['jp_id' => $id, 'processed' => false, 'remarks !=' => ''], ['created_at', 'asc']);
    }
    public function count_datatable($requisitor_id = null, $orWhere = [])
    {
        $this->db->select('job_posting.*, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as author, position.position_name as position')
            ->from('job_posting')
            ->join('position', 'position.pos_id=job_posting.pos_id', 'left')
            ->join('user', 'user.id=job_posting.created_by', 'left')
            ->join('employee_history', 'user.email=employee_history.email', 'left');
        if ($this->session->userdata('isAdmin') || $this->permission->full('recruitment')->access()) {
        } elseif ($this->permission->method('requisition_list', 'update')->access()) {
        } else {
            $this->db->where('created_by', $requisitor_id);
        }
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        if ($this->input->get('drafts')) {
            $this->db->where('jp_is_draft', 1);
        } else {
            $this->db->where('jp_is_draft', 0);
        }
        return $this->db->count_all_results();
    }
    public function change_status($id, $status, $remarks)
    {
        $this->db->trans_start();
        $requisition_rec = getByWhere('job_posting, position-position.pos_id=job_posting.pos_id-left', 'job_posting.created_by, position.position_name', ['jp_id' => $id])[0];
        $hr_exec_id = null;
        if ($status == 'pending_rm') {
            $this->notify->role('Recruitment Manager')->send(
                sprintf('Requisition request for post: \'%s\' has been resubmitted.<br>Remarks: %s', $requisition_rec->position_name, trim(strip_tags($remarks))),
                'recruitment/Requisition/view/' . $id
            );
        } elseif ($status == 'pending_hr') {
            $last_hr_assigned = $this->db->select('hr_assigned')->where('hr_assigned !=', null)->order_by('job_posting.hr_assigned_on', 'desc')->get('job_posting')->row();
            $hr_exec_id = $this->notify->round_robin_role('Requisition Reviewer', @$last_hr_assigned->hr_assigned);
            $this->notify->user($hr_exec_id)->send(sprintf('A new requisition request for post: \'%s\' needs your approval', $requisition_rec->position_name), 'recruitment/Requisition/view/' . $id);
        } elseif (in_array($status, ['rejected_rm', 'changes_required'])) {
            $this->notify->user($requisition_rec->created_by)->send(
                sprintf(
                    'Your requisition request for the post \'%s\' has been marked as \'%s\'<br>Reason: %s',
                    $requisition_rec->position_name,
                    ($status == 'rejected_rm' ? 'rejected' : 'amendments required'),
                    trim(strip_tags($remarks))
                ),
                'recruitment/Requisition/view/' . $id
            );
        }
        $this->db->where('jp_id', $id)->update('job_posting', [
            'requisition_status' => $status,
            'hr_assigned' => $hr_exec_id,
            'hr_assigned_on' => date('Y-m-d H:i:s'),
        ]);
        $this->db->where('jp_id', $id)->update('requisition_request_history', [
            'processed' => 1,
        ]);
        $this->db->insert('requisition_request_history', [
            'jp_id' => $id,
            'remarks' => $remarks,
            'user_id' => $this->session->userdata('id'),
            'created_at' => date("Y-m-d H:i:s"),
        ]);
        $this->db->trans_complete();

        return $this->db->trans_status();
    }
    public function get_options()
    {
        $recs = getByWhereAsArray('requisition_options');
        $data = [];
        foreach ($recs as $rec) {
            if (!isset($data[$rec['type']])) {
                $data[$rec['type']] = [];
            }
            $data[$rec['type']][] = $rec;
        }
        foreach ($data as $key => $rec) {
            usort($data[$key], function ($item1, $item2) {
                return $item1['sort_order'] <=> $item2['sort_order'];
            });
        }
        return $data;
    }
    public function sort($order)
    {
        $this->db->trans_start();
        $item_rec = $this->db->where('id', reset($order))->get('requisition_options')->row();
        foreach ($order as $sort_order => $id) {
            $this->db->where('id', $id)->update('requisition_options', [
                'sort_order' => $sort_order + 1,
            ]);
        }
        $this->activity->log([
            'requisition_option_sorted',
            slug_to_readable($item_rec->type)
        ]);
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
    public function get_option($id)
    {
        return $this->db->where('id', $id)->get('requisition_options')->row();
    }
    public function requision_duplicate($type, $value, $id = null)
    {
        return $this->db->select('id')->where([
            'type' => $type,
            'value' => $value,
            'id <>' => $id,
        ])->count_all_results('requisition_options') > 0;
    }
    public function save_option($data)
    {
        if ($data['id']) {
            $this->permission->method('requisition_options', 'update')->redirect();
            $this->activity
                ->set_url('recruitment/Requisition/options')
                ->log([
                    'requisition_option_updated',
                    $data['value'],
                    slug_to_readable($data['type']),
                ]);
            return $this->db->where('id', $data['id'])
                ->update('requisition_options', [
                    'type' => $data['type'],
                    'value' => $data['value'],
                    'sort_order' => $data['sort_order'] ?? 0,
                ]);
        } else {
            $this->permission->method('requisition_options', 'create')->redirect();
            $this->activity
                ->set_url('recruitment/Requisition/options')
                ->log([
                    'requisition_option_inserted',
                    $data['value'],
                    slug_to_readable($data['type']),
                ]);
            return $this->db->insert('requisition_options', [
                'type' => $data['type'],
                'value' => $data['value'],
                'sort_order' => $data['sort_order'] ?? 0,
            ]);
        }
    }
    public function delete_option($id)
    {
        $opt_rec = $this->get_option($id);
        $this->activity->log([
            'requisition_option_deleted',
            $opt_rec->value,
            slug_to_readable($opt_rec->type)
        ]);
        return $this->db->delete('requisition_options', [
            'id' => $id,
        ]);
    }
    public function generate_ad($id)
    {
        $this->db->trans_start();
        $this->db->where('jp_id', $id)->update('job_posting', [
            'requisition_status' => 'created',
        ]);
        $this->db->where('jp_id', $id)->update('requisition_request_history', [
            'processed' => 1,
        ]);
        $this->db->trans_complete();

        return $this->db->trans_status();
    }
    public function get_position_id($position)
    {
        $pos_rec = getByWhere('position', 'pos_id', ['position_name' => $position]);
        if ($pos_rec) {
            return $pos_rec[0]->pos_id;
        }
        $this->activity
        ->set_url('employee/Employees/create_position')
        ->log([
            'requisition_position_inserted',
            $position
        ]);
        $this->db->insert('position', [
            'position_name' => $position,
        ]);
        return $this->db->insert_id();
    }
}
