<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Hired_model extends CI_Model
{
    private $_active_creds = [];
    public function countAllRows()
    {
        return $this->db->where('status', 'completed')->count_all_results('candidate_basic_info');
    }
    public function countDatatable($orWhere = [])
    {
        $this->db->select(
            'candidate_basic_info.*, CONCAT_WS(\' \', candidate_basic_info.first_name, candidate_basic_info.last_name) as full_name,
            position.*, employee_history.hrm_id, employee_history.hire_date'
        )
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id', 'left')
            ->join('position', 'job_posting.pos_id = position.pos_id', 'left')
            ->join('employee_history', 'candidate_basic_info.employee_id = employee_history.employee_id', 'left')
            ->where('candidate_basic_info.status =', 'completed');
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        return $this->db->count_all_results('candidate_basic_info');
    }
    public function getDatatable($post = [], $orWhere = null)
    {
        $this->db->select(
            'candidate_basic_info.*, CONCAT_WS(\' \', candidate_basic_info.first_name, candidate_basic_info.last_name) as full_name,
            position.*, employee_history.hrm_id, employee_history.hire_date'
        )
            ->join('job_posting', 'candidate_basic_info.jp_id = job_posting.jp_id', 'left')
            ->join('position', 'job_posting.pos_id = position.pos_id', 'left')
            ->join('employee_history', 'candidate_basic_info.employee_id = employee_history.employee_id', 'left')
            ->where('candidate_basic_info.status =', 'completed');
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get('candidate_basic_info')
            ->result_array();
    }
    public function generate_credentials($post, $emp_rec)
    {
        $other_portals = false;
        foreach ($post['credentials'] as $cred_key => $cred_values) {
            if ($cred_key == 'hrm') {
                continue;
            }
            if ($cred_values['create'] == 'yes') {
                $other_portals = true;
                break;
            }
        }
        $email = null;
        if ($other_portals) {
            $try = 0;
            $num = -1;
            $exists = true;
            $femail = $emp_rec->first_name;
            if (str_word_count($femail) <= 1) {
                $femail .= ' ' . $emp_rec->last_name;
            }
            if (strlen($femail) >= 20) {
                $femail = $emp_rec->first_name;
            }
            $email = null;
            do {
                $num++;
                if ($try > 100) {
                    log_message('error', 'User name checking tries greater than 30, quitting');
                    log_message('error', 'User name: ' . $email);
                    sendJson(['error' => 'Unable to create MLM username, try again']);
                    break;
                }
                $email = trim(preg_replace('~\W+~is', ' ', $femail));
                $email = str_replace(' ', '.', $email);
                if ($num > 0) {
                    $email .= $num;
                }
                $email = strtolower($email);
                foreach ($post['credentials'] as $cred_key => $cred_values) {
                    if ($cred_key == 'hrm') {
                        continue;
                    }
                    if ($cred_values['create'] == 'yes') {
                        $this->load->model('recruitment/Cred' . $cred_key . '_model');
                        $res = $this->{'Cred' . $cred_key . '_model'}->userExists($email, $try > 10);
                        if ($res === null) {
                            $try++;
                            break;
                        }
                        $exists = $res === true;
                        if ($exists) {
                            break;
                        }
                    }
                }
            } while ($exists);
        }
        $credentials = [];
        $this->_active_creds = $this->load->config('other_portals', true);
        foreach ($post['credentials'] as $cred_key => $cred_values) {
            if ($cred_values['create'] == 'yes') {
                $this->load->model('recruitment/Cred' . $cred_key . '_model');
                $credentials[$this->_active_creds[$cred_key]['label']] = $this->{'Cred' . $cred_key . '_model'}->addUser($email, $emp_rec, $cred_values['role']);
                $credentials[$this->_active_creds[$cred_key]['label']]['key'] = $cred_key;
            }
        }
        $this->db->where('employee_id', $emp_rec->employee_id)->update('employee_history', [
            'medflow_id' => $email
        ]);
        return $credentials;
    }
}
