<?php
defined('BASEPATH') or exit('No direct script access allowed');
use Curl\Curl;
class Credmlmsp_model extends CI_Model
{
    private $_filter_role_ids = [
        1, 6
    ];
    private $_creds = null;
    function __construct()
    {
        parent::__construct();
        $this->_creds = $this->db->where('id', 'mlmsp')->get('other_portals')->row_array();
        if(empty($this->_creds)) {
            log_message('error', 'No settings found for MLM SP');
        }
    }
    public function getRoles()
    {
        if (!$data = $this->cache->get('Cred.mlmsp.Roles')) {
            try {
                $curl = new Curl();
                $raw_data = $curl->get($this->_creds['url'] . '/rolelisting?rl');
                foreach ($raw_data as $raw_dt) {
                    if(in_array($raw_dt->userRoleId, $this->_filter_role_ids)) {
                        continue;
                    }
                    $data[] = [
                        'id' => $raw_dt->userRoleId,
                        'name' => $raw_dt->userRoleName
                    ];
                }
            } catch (Throwable $e) {
                log_message('error', 'SP getRoles: ' . $e->getMessage());
                return [];
            }
            $this->cache->save('Cred.mlmsp.Roles', $data, 10800);
        }

        return $data;
    }
    public function getEmail($string)
    {
        return $string . '@' . $this->_creds['email'];
    }
    public function userExists($email, $verbose = false)
    {
        $curl = new Curl();
        try {
            $curl->setHeader('apikey', $this->_creds['api_key']);
            $res = $curl->post($this->_creds['url'] . '/userExists', [
                'email' => $this->getEmail($email),
            ]);
            if($verbose) {
                log_message('error', 'MLM SP user check reply: ' . json_encode($res));
                log_message('error', 'MLM SP user check status: ' . $curl->getHttpStatusCode());
            }
        } catch (Throwable $e) {
            log_message('error', 'SP userExists: ' . $e->getMessage());
            return null;
        }
        switch ($curl->getHttpStatusCode()) {
            case 202:
                return true;
                break;
            case 404:
                return false;
                break;
            default:
                return null;
                break;
        }
    }
    public function addUser($username, $employee, $roles)
    {
        $this->load->helper('string');
        $generated_password = str_replace('I', 'L', strtoupper(random_string('alpha', 6)));

        try {
            $curl = new Curl();
            $raw_data = $curl->post($this->_creds['url'] . '/signUp', [
                'fname' => $employee->first_name,
                'lname' => $employee->last_name,
                'email' => $this->getEmail($username),
                'password' => md5($generated_password),
                'location' => 0,
                'role' => $roles[0],
                'Supervisor' => 0,
                'status' => 1,
                'BDE_Level' => 0,
                'LoggedUser' => 0,
                'RealName' => implode(' ', [$employee->first_name, $employee->last_name])
            ]);
            if($curl->getHttpStatusCode() == 200 && $raw_data->status == 'success') {
                return [
                    'username' => $this->getEmail($username),
                    'password' => $generated_password,
                ];
            }
            log_message('error', 'Unknown reply from SP: ' . json_encode($raw_data));
            log_message('error', 'Unknown reply from SP Status: ' . $curl->getHttpStatusCode());
        } catch (Throwable $e) {
            log_message('error', 'SP addUser: ' . $e->getMessage());
        }
        return [];
    }
    public function setStatus($medflow_id, $status)
    {
        $curl = new Curl();
        try {
            $curl->setHeader('apikey', $this->_creds['api_key']);
            $curl->post($this->_creds['url'] . '/changeStatus', [
                'email' => $this->getEmail($medflow_id),
                'status' => $status ? 'Y' : 'N'
            ]);
        } catch (Throwable $e) {
            log_message('error', 'SP setStatus: ' . $e->getMessage());
            return null;
        }
        switch ($curl->getHttpStatusCode()) {
            case 202:
                return true;
                break;
            case 400:
                return false;
                break;
            default:
                return null;
                break;
        }
    }
}
