<style>
    .label-success {
        color: white;
        background-color: #45c203;
        border: 2px solid #45c203;
    }
</style>
<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12" id="action_btns" style="display:none">
            <button type="button" class="btn btn-warning btn-sm btn-sendselected">Resend Selected</button>
            <button type="button" class="btn btn-danger btn-sm btn-uncheckall">Unselect All</button>
        </div>
    </div>
    <br>
    <table class="table table-hover">
        <thead>
            <tr>
                <?php if($this->permission->method('email_logs', 'update')->access()) :?>
                <th class="hideexport"><input type="checkbox" id="checkall"></th>
                <?php endif;?>
                <th>#</th>
                <th>Subject</th>
                <th>To</th>
                <th>From</th>
                <th>Retries</th>
                <th>Last Tried Sending</th>
                <th>Status</th>
                <th class="hideexport">Action</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
    </table>
</div>
<script>
    window.checkedVals = []
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({},
            window.default_datatable_opts, {
                responsive: false,
                processing: true,
                serverSide: true,
                ajax: {
                    method: 'post',
                    beforeSend: function(){},
                    complete: function(){}
                },
                columns: [
                    <?php if($this->permission->method('email_logs', 'update')->access()) :?>
                    {
                        'data': 'chck',
                        'sortable': false,
                        'render': function (data) {
                            var checked = window.checkedVals.includes(data) ?
                                ' checked="checked"' : null;
                            return '<input type="checkbox" name="requeue[]" value="' + data +
                                '"' + checked + '>';
                        }
                    },
                    <?php endif; ?>
                    {
                        'data': 'id',
                    }, {
                        'data': 'subject',
                    }, {
                        'data': 'eto',
                    }, {
                        'data': 'efrom',
                    },
                    {
                        'data': 'total_retries'
                    },
                    {
                        'data': 'updated_at',
                    }, {
                        'data': 'status',
                    },
                    {
                        'data': 'action',
                        'sortable': false
                    },
                ],
                order: [
                    [<?= $this->permission->method('email_logs', 'update')->access() ? 1 : 0 ?>, 'desc']
                ]
            }
        ))
        setInterval(() => {
            window.dtable.ajax.reload()
        }, 15e4 /* 2.5 minutes interval */);
    });
    function requeueEmail(ids) {
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>outbox/email/requeue",
            data: {
                ids: ids
            },
            success: function (res) {
                if (res.success) {
                    window.checkedVals = [];
                    window.dtable.ajax.reload()
                    $('table.table [type=checkbox]').prop('checked', false).trigger('change')
                    alert(res.success)
                } else if (res.error) {
                    alert(res.error)
                } else {
                    console.log(res);
                    alert('Unknown error, try again')
                }
            }
        });
    }
    $('.btn-uncheckall').on('click', function () {
        if (!confirm('Are you sure you want to uncheck all the emails?')) {
            return
        }
        $('table.table [type=checkbox]').prop('checked', false).trigger('change')
    })
    $('.btn-sendselected').on('click', function () {
        if (!confirm('Are you sure you want to resend all the selected emails?')) {
            return
        }
        requeueEmail(window.checkedVals)
    })
    $('table.table').on('click', '.btn-requeue', function (e) {
        e.preventDefault()
        if (!confirm('Are you sure you want to resend this email?')) {
            return
        }
        requeueEmail([$(this).data('id')])
    })
    $('table.table').on('click', '.btn-view', function (e) {
        e.preventDefault()
        $modal = $('#modelViewEmail')
        $modal.find('.modal-body').html('')
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>outbox/email/view",
            data: {
                id: $(this).data('id')
            },
            success: function (res) {
                if(res.success){
                    $modal.find('.modal-body').html(res.success)
                    $modal.modal('show')
                }else if(res.error){
                    alert(res.error)
                }else{
                    console.log(res);
                    alert('Unknown error, try again')
                }
            }
        });
    })
    $('#checkall').on('change', function () {
        var mailcheck = $(this).is(':checked')
        var chcks = $('table.table').find('[name="requeue[]"]')
        chcks.each(function () {
            if (this.checked != mailcheck) {
                $(this).prop('checked', mailcheck)
                $(this).trigger('change')
            }
        })
    })
    $('table.table').on('change', '[name="requeue[]"]', function () {
        if (this.checked) {
            window.checkedVals.push(this.value)
        } else {
            window.checkedVals = window.checkedVals.filter((val) => {
                return this.value != val
            })
        }
        if (window.checkedVals.length) {
            $('#action_btns').show()
        } else {
            $('#checkall').prop('checked', false)
            $('#action_btns').hide()
        }
    })
</script>
<!-- Modal -->
<div class="modal fade" id="modelViewEmail" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Email View</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            <div class="modal-body">
            </div>
        </div>
    </div>
</div>