<?php
class Email_model extends CI_Model
{
    public function get($id = null)
    {
        $this->db->from('email_queue');
        if ($id) {
            return $this->db->where('id', $id)->get()->row();
        }
        return $this->db->order_by('id', 'asc')->get()->row();
    }
    public function countAllRows()
    {
        return $this->db->count_all('email_queue');
    }
    public function countDatatable($orWhere = [])
    {
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        return $this->db->count_all_results('email_queue');
    }
    public function getDatatable($orWhere = [])
    {
        $post = $this->input->post();

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                $this->db->or_like($key, $value, 'right', false);
            }
            $this->db->group_end();
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get('email_queue')->result_array();
    }
    public function requeue($ids)
    {
        $this->db->trans_start();
        foreach ($ids as $id) {
            $lg_rec = $this->get($id);
            $update_rec = [
                'status' => 'queued',
                'retries' => 0,
            ];
            if ($lg_rec->status != 'queued') {
                $update_rec['total_retries'] = $lg_rec->total_retries + 1;
            }
            $this->db->where('id', $id)->update('email_queue', $update_rec);
            $this->activity->log([
                'email_requeued',
                $id,
                $lg_rec->eto
            ]);
        }
        $this->db->trans_complete();
        return $this->db->trans_status();
    }
}
