<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Email extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->permission->method('email_logs', 'read')->redirect();
        $this->load->model(['email_model']);
    }
    public function log()
    {
        $this->permission->method('email_logs', 'read')->redirect();
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $this->getdatatable();
        }
        $data['title'] = 'Email Log';
        $data['module'] = 'outbox';
        $data['page'] = 'list';
        echo Modules::run('template/layout', $data);
    }
    public function requeue()
    {
        if ($this->input->post('ids') && $this->input->is_ajax_request()) {
            if ($this->email_model->requeue($this->input->post('ids'))) {
                sendJson(['success' => 'Emails queued for resending successfully.']);
            } else {
                sendJson(['error' => 'Unable to requeue emails for resending, try again']);
            }
        }
    }
    public function view()
    {
        if ($this->input->post('id') && $this->input->is_ajax_request()) {
            $mail = $this->email_model->get($this->input->post('id'));

            if ($mail) {
                $data['content'] = json_decode($mail->content, true);
                unset($mail->content);
                $data['mail'] = $mail;
                sendJson(['success' => $this->load->view('view', $data, true)]);
            }
            sendJson(['error' => 'Email not found']);
        }
    }
    private function getdatatable()
    {
        $search_arr = [];
        $search_columns = [
            'id',
            'efrom',
            'eto',
            'subject',
            'status',
            'retries',
            'DATE_FORMAT(updated_at, \'%d-%m-%Y %r\')',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->email_model->countAllRows();
        $out_arr["recordsFiltered"] = $this->email_model->countDatatable($search_arr);
        $rows = $this->email_model->getDatatable($search_arr);

        $status_classes = [
            'queued' => 'primary',
            'failed' => 'danger',
            'sent' => 'success',
        ];
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'chck':{
                            $tdData = $rec['id'];
                            break;
                        }
                    case 'eto':{
                            $etos = explode(',', $rec['eto']);
                            if (count($etos) > 2) {
                                $tdData = implode(', ', [$etos[0], $etos[1]]) . ' and ' . count($etos) . ' other(s)';
                                break;
                            }
                            $tdData = $rec['eto'];
                            break;
                        }
                    case 'updated_at':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'status':{
                            $tdData = '<span class="label label-' . $status_classes[$rec[$col['data']]] . '">' . ucfirst($rec[$col['data']]) . '</span>';
                            break;
                        }
                    case 'action':{
                            $tdData = '<div class="btn-group"><button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action <span class="caret"></span></button><ul class="dropdown-menu">';
                            $btns = [];

                            $btns[] = '<li><a href="#" class="btn-view" data-id="' . $rec['id'] . '">View Email</a></li>';
                            if($this->permission->method('email_logs', 'update')->access()) {
                                $btns[] = '<li><a href="#" class="btn-requeue" data-id="' . $rec['id'] . '">Resend</a></li>';
                            }

                            $tdData .= implode('', $btns);
                            $tdData .= '</ul></div>';
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
}
