<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Notification extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'Notification_model',
        ));
    }
    public function index()
    {
        $this->permission->method('notification', 'read')->redirect();
        $data['title'] = 'Notification';
        $data['module'] = "notification";
            $data['page'] = "index";
        echo Modules::run('template/layout', $data);
    }
    public function statusChange($userId)
    {
        $this->permission->method('notification', 'read')->redirect();
        if ($this->Notification_model->toggle_state($userId, $this->input->post('notification'), $this->input->post('viewed'))) {
            echo 1;
        } else {
            echo 0;
        }
    }
    public function mark_all_as_read()
    {
        $this->permission->method('notification', 'read')->redirect();
        if ($this->Notification_model->toggle_state_all($this->session->userdata('id'))) {
            $this->session->set_flashdata('message', display('successfully_updated'));
        } else {
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('notification/Notification/index');
    }
    public function countNotification()
    {
        $this->permission->method('notification', 'read')->redirect();
        echo json_encode($this->Notification_model->count_unread_notification($this->session->userdata('id')));
    }
    public function editData()
    {
        $this->permission->method('notification', 'update')->redirect();
        $id = $this->input->post('id');
        // echo $query = "select * from notification where id= $id";
        $result = $this->db->select('notification.*,employee_history.first_name as fname,employee_history.last_name as lname')->from('notification')
            ->join('employee_history', 'employee_history.employee_id=notification.emp_id')
            ->where('notification.id', $id)->get()->result();
        echo json_encode($result);
    }
    public function create_notification($id = null)
    {
        $this->permission->method('notification', 'create')->redirect();
        $this->form_validation->set_rules('text', display('notice_description'), 'required');
        $this->form_validation->set_rules('date', display('notice_date'), 'required');
        $this->form_validation->set_rules('emp_id', 'Employeer Name', 'required|max_length[50]');
        #-------------------------------#
        // print_r($this->input->post());exit;
        if ($this->form_validation->run() === true) {
            $postData = [
                'text' => $this->input->post('text', true),
                'date' => date('Y-m-d', strtotime($this->input->post('date', true))),
                'emp_id' => $this->input->post('emp_id', true),
                'created_by' => $this->session->userdata('id'),
            ];
            if (isset($id)) {
                $edit = $this->Notification_model->notification_update($postData, $id);
            } else {
                $create = $this->Notification_model->notification_create($postData);
            }
            if ($create) {
                $this->session->set_flashdata('message', display('successfully_created'));
            } else if ($edit) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("notification/Notification");
        } else {
            $data['title'] = 'Notification';
            $data['module'] = "notification"; //
            $data['results'] = $this->view_details();
            $data['page'] = "index";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_notification($id = null)
    {
        $this->permission->method('notification', 'delete')->redirect();
        if ($this->Notification_model->notice_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("notification/Notification");
    }
    public function getEmployees()
    {
        $this->permission->method('notification', 'read')->redirect();
        $post = $_POST['searchTerm'];
        $this->db->select('*')->from('employee_history');
        $this->db->like(['first_name' => $post]);
        if ($this->session->userdata('isAdmin') == 1) {
        } else {
            $userId = $this->session->userdata('employee_id');
            $this->db->where('employee_history.employee_id', $userId);
        }
        $e = $this->db->get()->result();
        $data = array();
        foreach ($e as $key => $value) {
            $data[] = array('id' => $value->employee_id, 'text' => $value->first_name . ' ' . $value->last_name);
        }
        echo json_encode($data);
    }
    public function get_notifications()
    {
        $this->permission->method('notification', 'read')->redirect();
        if ($this->input->post()) {
            $notif_recs = $this->Notification_model->notifications(
                $this->session->userdata('id'),
                $this->input->post('start'),
                $this->input->post('length'),
                $this->input->post('order')[0]['dir']
            );
            $total_recs = $this->Notification_model->count_notifications_datatable($this->session->userdata('id'));
            $total_users = $this->db->count_all('user');
            $out_arr['draw'] = $_POST['draw'];
            $out_arr['data'] = array();
            $out_arr["recordsTotal"] = $total_recs;
            $out_arr["recordsFiltered"] = $total_recs;
            $index_ids = intval($total_recs) - intval($this->input->post('start'));
            if(strtolower($this->input->post('order')[0]['dir']) == 'asc'){
                $index_ids = 1 + intval($this->input->post('start')); 
            }
            foreach ($notif_recs as $index => $rec) {
                foreach ($_POST['columns'] as $col) {
                    $tdData = null;
                    switch ($col['data']) {
                        case 'id':{
                                $tdData = $index_ids;
                                if(strtolower($this->input->post('order')[0]['dir']) == 'asc'){
                                    $index_ids++;                                    
                                }else{
                                    $index_ids--;
                                }
                                break;
                            }
                        case 'text':{
                                if (empty($rec->url)) {
                                    $tdData = $rec->text;
                                } else {
                                    $tdData = '<a href="' . base_url($rec->url) . '">' . $rec->text . '</a>';
                                }
                                break;
                            }
                        case 'date':{
                                $tdData = formatted_date($rec->date);
                                if ($tdData == date('d-m-Y')) {
                                    $tdData = formatted_time_now($rec->date);
                                }
                                break;
                            }
                        case 'viewed_users':{
                                $tdData = ($rec->total_viewed ? $rec->total_viewed : 0) . '/' . ($rec->global ? $total_users : $rec->total_recipient);
                                break;
                            }
                        case 'viewed':{
                                if ($this->permission->method('notification', 'delete')->access()) {
                                    $my_notif = $this->db->select('*')->where(['notification_id' => $rec->id, 'user_id' => $this->session->userdata('id')])->get('rel_notification_user')->row_array();
                                    if ($my_notif) {
                                        $rec->viewed = @$my_notif['viewed'];
                                        $tdData = '<button data-id="' . $rec->id . '" data-state="' . ($rec->viewed ? 1 : 0) . '" class="btn btn-xs btn-markviewed btn-' . ($rec->viewed ? 'primary' : 'success') . '" ' . ($rec->viewed ? 'disabled' : null) . '>' . ($rec->viewed ? null : 'Mark As') . ' Viewed</button>';
                                    }
                                } else {
                                    $tdData = '<button data-id="' . $rec->id . '" data-state="' . ($rec->viewed ? 1 : 0) . '" class="btn btn-xs btn-markviewed btn-' . ($rec->viewed ? 'primary' : 'success') . '"' . ($rec->viewed ? 'disabled' : null) . '>' . ($rec->viewed ? null : 'Mark As') . ' Viewed</button>';
                                }
                                break;
                            }
                        case 'action':{
                                if ($this->permission->method('notification', 'delete')->access()) {
                                    $tdData = '<a href="#" data-id="'.$rec->id.'" class="btn btn-xs btn-danger btn-delete"><i class="fa fa-close"></i></a>';
                                }
                                break;
                            }
                        default:{
                                $tdData = $rec->{$col['data']};
                                break;
                            }
                    }
                    $out_arr['data'][$index][$col['data']] = $tdData;
                }
            }
            sendJson($out_arr);
        }
    }
}
