<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Leave_model extends CI_Model {
 
    public function viewWeekly()
	{
		return $this->db->select('weekly_holiday.*,shift.name as shift_name')->from('weekly_holiday')
            ->join('shift','shift.id=weekly_holiday.shift_id')
            ->order_by('weekly_holiday.wk_id', 'desc')
			->get()
			->result();
	}
	public function weekleave_create($data = array()){
       $this->db->insert('weekly_holiday',$data);
	}

	public function weekleave_delete($id = null){
		$this->db->where('wk_id',$id)
			->delete('weekly_holiday');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 


public function update_weeklev($data = array()){
		return $this->db->where('wk_id',$data["wk_id"])
			->update("weekly_holiday", $data);
	}
	public function weekleave_updateForm($id){
        $this->db->where('wk_id',$id);
        $query = $this->db->get('weekly_holiday');
        return $query->row();
    }
    
    
public function viewholiday(){
return $this->db->select('payroll_holiday.*, GROUP_CONCAT(shift.name) as shifts')	
			->from('payroll_holiday')
            ->join('payroll_holiday_shift_wise', 'payroll_holiday_shift_wise.payrl_holi_id=payroll_holiday.payrl_holi_id','right')
            ->join('shift', 'shift.id=payroll_holiday_shift_wise.shift_id','left')
			->order_by('payroll_holiday.payrl_holi_id', 'desc')
            ->group_by('payroll_holiday.payrl_holi_id')
			->get()
			->result();
    }
	
    public function view_shift_holiday($id=null){
        if(isset($id)){
            return $this->db->get_where('payroll_holiday_shift_wise',['id'=>$id])->result();
        }else{
            return $this->db->select("ph.holiday_name as holiday_name, GROUP_CONCAT(s.name) AS shift_name,ph.*")   
                ->from('payroll_holiday_shift_wise as phsw')
                ->join('payroll_holiday as ph','phsw.payrl_holi_id = ph.payrl_holi_id')
                ->join('shift as s','s.id = phsw.shift_id','left')
                ->order_by('ph.payrl_holi_id', 'desc')
                ->group_by('ph.payrl_holi_id')
                ->get()
                ->result();   
        }
    }
    	
	public function holiday_create($data){
        $this->db->trans_begin();

        $res = $this->db->insert('payroll_holiday', [
            'holiday_name' => $data['holiday_name'],
            'start_date' => date('Y-m-d', strtotime($data['start_date'])),
            'end_date' => date('Y-m-d', strtotime($data['end_date'])),
            'no_of_days' => $data['no_of_days'],
            'created_by' => $this->session->userdata('id'),
            'updated_by' => $this->session->userdata('id'),
        ]);

        if($res){
            $res = $this->db->insert_id();
            foreach ($data['shifts'] as $shift_id) {
                $this->db->insert('payroll_holiday_shift_wise', [
                    'payrl_holi_id' => $res,
                    'shift_id' => $shift_id
                ]);
            }
        }

        if ($this->db->trans_status() === FALSE)
        {
                $this->db->trans_rollback();
                return false;
        }
        else
        {
                $this->db->trans_commit();
                return true;
        }
	}

public function holiday_delete($id = null,$table=null){
    if(isset($table)){
            $this->db->where('id',$id)
            ->delete($table);
    }else{
            $this->db->where('payrl_holi_id',$id)
            ->delete('payroll_holiday');
    }
		
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 


	public function update_holiday($data){
        $this->db->trans_begin();

        $res = $this->db->where('payrl_holi_id', $data["payrl_holi_id"])
            ->update("payroll_holiday", [
                'holiday_name' => $data['holiday_name'],
                'start_date' => date('Y-m-d', strtotime($data['start_date'])),
                'end_date' => date('Y-m-d', strtotime($data['end_date'])),
                'no_of_days' => $data['no_of_days'],
                'updated_by' => $this->session->userdata('id'),
            ]);  

        if($res){
            $res = $data["payrl_holi_id"];
            $this->db->where('payrl_holi_id', $res)->delete('payroll_holiday_shift_wise');
            foreach ($data['shifts'] as $shift_id) {
                $this->db->insert('payroll_holiday_shift_wise', [
                    'payrl_holi_id' => $res,
                    'shift_id' => $shift_id
                ]);
            }
        }

        if ($this->db->trans_status() === FALSE)
        {
                $this->db->trans_rollback();
                return false;
        }
        else
        {
                $this->db->trans_commit();
                return true;
        } 
	}
	public function holiday_updateForm($id){
        return $this->db->select('payroll_holiday.*, GROUP_CONCAT(shift.id) as shifts')
            ->where('payroll_holiday.payrl_holi_id',$id)
            ->join('payroll_holiday_shift_wise', 'payroll_holiday_shift_wise.payrl_holi_id=payroll_holiday.payrl_holi_id','right')
            ->join('shift', 'shift.id=payroll_holiday_shift_wise.shift_id','left')
			->order_by('payroll_holiday.payrl_holi_id', 'desc')
            ->group_by('payroll_holiday.payrl_holi_id')
			->get('payroll_holiday')
			->row();
    }

	public function application_create($data = array())
	{
		return $this->db->insert('leave_apply', $data);
	}
	 public function dropdown(){
	     
	     	 $admin               = $this->session->userdata('isAdmin');
		$is_supervisor       = $this->session->userdata('supervisor');
		$direct_supervisor   = $this->session->userdata('direct_supervisor');
		$indirect_supervisor = $this->session->userdata('indirect_supervisor');
		$employee_id         = $this->session->userdata('employee_id');
	     
    	$this->db->select('*');
    	$this->db->from('employee_history');
    	  if($admin !=1){
             if($is_supervisor == 1){
        		 $this->db->where('employee_history.super_visor_id',$employee_id);
        		 $this->db->or_where('employee_history.employee_id',$employee_id);
        		 $this->db->or_where('employee_history.indirect_super_visor_id',$employee_id);
        		}
                else{
                              $this->db->where('employee_history.employee_id',$employee_id);
                            }
		      }
    	$query=$this->db->get();
    	$data=$query->result();
    	$list = array('' => 'Select One...');
    	if(!empty($data)){
    		foreach ($data as  $value) {
    			$list[$value->employee_id]=$value->first_name." ".$value->last_name;
    		}
    	}
    	return $list;
    }

    public function manageleave()
	{

       $this->db->select('ap.*, count(DISTINCT(ap.leave_appl_id)) as leave_appl_id,ap.*,p.employee_id,p.first_name,p.last_name, type.leave_type')   
            ->from('leave_apply ap')
            ->join('employee_history p', 'ap.employee_id = p.employee_id', 'left')
            ->join('leave_type as type', 'type.leave_type_id = ap.leave_type_id', 'left');

            $admin = $this->session->userdata('isAdmin');
            $employee_id = $this->session->userdata('employee_id');
            $is_supervisor = $this->session->userdata('supervisor');
            $direct_supervisor = $this->session->userdata('direct_supervisor');
            $indirect_supervisor = $this->session->userdata('indirect_supervisor');
                                    if($admin != 1){
                                        if($is_supervisor == 1){
                                            $this->db->where('p.super_visor_id',$employee_id);
                                            $this->db->or_where('p.employee_id',$employee_id);
                                            $this->db->or_where('p.indirect_super_visor_id',$employee_id);
                                        }
                                        else{
                                            $this->db->where('p.employee_id',$employee_id);
                                        }
                                    }


      return      $this->db->group_by('ap.leave_appl_id')
            ->order_by('ap.leave_appl_id', 'desc')
            ->get()
            ->result();
    }
    public function application_delete($id = null)
	{
		$this->db->where('leave_appl_id',$id)
			->delete('leave_apply');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 
	public function update_application($data = array())
	{
		return $this->db->where('leave_appl_id', $data["leave_appl_id"])
			->update("leave_apply", $data);


	}
	public function application_updateForm($id){
        $this->db->where('leave_appl_id',$id);
        $query = $this->db->get('leave_apply');
        return $query->row();
    }
     public  function get_id($id)
    {
        $query=$this->db->select('leave_apply.*, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as employee_fullname, leave_type.leave_type as leave_name')
		->join('employee_history', 'leave_apply.employee_id=employee_history.employee_id','left')
		->join('leave_type', 'leave_apply.leave_type_id=leave_apply.leave_type_id','left')
		->get_where('leave_apply',array('leave_appl_id'=>$id));
        return $query->row_array();
    } 

    // insert others leave type 
    public function save_leave_type($data = array()){
    	return $this->db->insert('leave_type', $data);
    }  

     // get all leave type for apply leave
     public function get_leave_type(){
    	$this->db->select('*');
    	$this->db->from('leave_type');
    	$query=$this->db->get();
    	$data=$query->result();
        $list = array('' => 'Select One...');
    	if(!empty($data)){
    		foreach ($data as  $value) {
    			$list[$value->leave_type_id]=$value->leave_type;
    		}
    	}
    	return $list;
    }

    // get all leave type 
     public function get_all_leave_type(){
    	$this->db->select('*');
    	$this->db->from('leave_type');
    	$query=$this->db->get();
    	return $query->result();
    }

    //get leave type by leave type id
    public function get_leave_type_by_id($id){
        $this->db->where('leave_type_id',$id);
        $query = $this->db->get('leave_type');
        return $query->row();
    }

    // update leave type 
    public function save_update_leave_type($data = array()){
    	$this->db->where('leave_type_id', $data["leave_type_id"])
  			     ->update('leave_type', $data);
    }

    // delete leave type by id 
    public function delete_leave_type($id = null)
	{
		$this->db->where('leave_type_id',$id)
			->delete('leave_type');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 

    public function supervisorList(){
        return $result = $this->db->select('first_name,last_name,employee_id')->from('employee_history')->where('is_super_visor',1)->get()->result();
    }
    public function get_annual_holidays($shift_ids = null)
    {
        $this->db->select('payroll_holiday.holiday_name, payroll_holiday.start_date, payroll_holiday.end_date, GROUP_CONCAT(payroll_holiday_shift_wise.shift_id) as shifts')
        ->join('payroll_holiday_shift_wise', 'payroll_holiday.payrl_holi_id=payroll_holiday_shift_wise.payrl_holi_id', 'right')
        ->group_by('payroll_holiday_shift_wise.payrl_holi_id');

        if($shift_ids){
            $this->db->where_in('payroll_holiday_shift_wise.shift_id', is_array($shift_ids) ? $shift_ids : [$shift_ids]);
        }

        return $this->db->get('payroll_holiday')
        ->result_array();
    }
}
