<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Leave extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set('Asia/Karachi');
        $this->load->model(array(
            'Leave_model', 'department/Department_model',
        ));

    }
    public function check_holiday_settings()
    {
        $get = $this->input->post();
        $data = [];
        if (!empty($get['shift_id'])) {
            if (isset($get['id'])) {
                $where = ['shift_id' => $get['shift_id'], 'wk_id!=' => $get['id']];
            } else {
                $where = ['shift_id' => $get['shift_id']];
            }
            $already_assigned = $this->db->select('shift_id')->get_where('weekly_holiday', $where)->result();
            if (count($already_assigned) > 0) {
                $data['status'] = 'error';
                $data['message'] = 'shift already assigned weekly holiday';
            } else {
                $data['status'] = 'success';
                $data['message'] = 'Shift not booked already!';
            }
        } else {
            $data['status'] = 'error';
            $data['message'] = 'something went wrong';
        }
        echo json_encode($data);
    }
    public function weekly_leave_view()
    {
        $this->permission->method('leave_application', 'read')->redirect();
        $data['title'] = display('selection');
        $data['weeklev'] = $this->Leave_model->viewWeekly();
        $data['module'] = "leave";
        $data['page'] = "weeklyleave_view";
        echo Modules::run('template/layout', $data);
    }
    public function create_weekleave()
    {
        $data['title'] = display('selectionlist');
        #-------------------------------#
        $this->form_validation->set_rules('dayname[]', display('dayname[]'), 'max_length[30]');
        if ($this->form_validation->run() === true) {
            $Specilized_category = $this->input->post('dayname');
            $shift_id = $this->input->post('shift_id');
            $data = array('dayname' => implode(",", $Specilized_category), 'shift_id' => $shift_id);
            if ($this->Leave_model->weekleave_create($data)) {
                $this->session->set_flashdata('exception', display('please_try_again'));
            } else {
                $this->session->set_flashdata('message', display('save_successfully'));
            }
            redirect("leave/Leave/create_weekleave");
        } else {
            $data['title'] = display('create');
            $data['module'] = "leave";
            $data['page'] = "weeklyform";
            $data['shift'] = $this->Department_model->shift_management_list();
            $data['weeklev'] = $this->Leave_model->viewWeekly();
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_weekleave($id = null)
    {
        $this->permission->method('leave_application', 'delete')->redirect();
        if ($this->Leave_model->weekleave_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("leave/Leave/weekly_leave_view");
    }
    public function update_weekleave_form($id = null)
    {
        $this->form_validation->set_rules('wk_id');
        $this->form_validation->set_rules('dayname[]', display('dayname'), 'max_length[30]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $Specilized_category = $this->input->post('dayname');
            $shift = $this->input->post('shift_id');
            $dataf = array('wk_id' => $this->input->post('wk_id'),
                'dayname' => implode(",", $Specilized_category), 'shift_id' => $shift,
            );
            if ($this->Leave_model->update_weeklev($dataf)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("leave/Leave/create_weekleave");
        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Leave_model->weekleave_updateForm($id);
            $data['module'] = "leave";
            $data['page'] = "update_wkleave_form";
            $data['shift'] = $this->Department_model->shift_management_list();
            echo Modules::run('template/layout', $data);
        }
    }
    public function holiday_view()
    {
        $this->permission->method('leave_application', 'read')->redirect();
        $data['title'] = display('holiday');
        $data['holiday'] = $this->Leave_model->viewholiday();
        $data['shifts'] = $this->db->select('id, name')->order_by('name', 'asc')->get('shift')->result_array();
        $data['module'] = "leave";
        $data['page'] = "holiday_form";
        echo Modules::run('template/layout', $data);
    }
    public function manage_holiday()
    {
        $this->permission->method('leave_application', 'read')->redirect();
        $data['title'] = display('selection');
        $data['holiday'] = $this->Leave_model->viewholiday();
        $data['module'] = "leave";
        $data['page'] = "holiday_view";
        echo Modules::run('template/layout', $data);
    }
    public function add_shift_holiday_view($id = null)
    {
        if (isset($id)) {
            $view_shift_holiday = $this->Leave_model->view_shift_holiday($id);
            $data['id'] = $view_shift_holiday[0]->id;
            $data['shift_id'] = $view_shift_holiday[0]->shift_id;
            $data['payrl_holi_id'] = $view_shift_holiday[0]->payrl_holi_id;
            $data['start_date'] = date('d-m-Y', strtotime($view_shift_holiday[0]->start_date));
            $data['end_date'] = date('d-m-Y', strtotime($view_shift_holiday[0]->end_date));
            $data['no_of_days'] = $view_shift_holiday[0]->no_of_days;
            echo json_encode($data);
        } else {
            $data['holiday'] = $this->Leave_model->viewholiday();
            $data['shift'] = $this->Department_model->shift_management_list();
            $this->permission->method('leave_application', 'read')->redirect();
            $data['title'] = display('selection');
            $data['shift_holidays'] = $this->Leave_model->view_shift_holiday();
            $data['module'] = "leave";
            $data['page'] = "add_shift_holiday_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function create_shift_holiday()
    {
        $data['title'] = display('ab');
        #-------------------------------#
        // $this->form_validation->set_rules('shift_id',display('shift_id'),'required');
        $this->form_validation->set_rules('payrl_holi_id', display('payrl_holi_id'), 'required');
        $this->form_validation->set_rules('start_date', display('start_date'), 'required');
        $this->form_validation->set_rules('end_date', display('end_date'), 'required');
        $this->form_validation->set_rules('no_of_days', display('no_of_days'), 'required');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $start = date("Y-m-d", strtotime($this->input->post('start_date', true)));
            $end = date("Y-m-d", strtotime($this->input->post('end_date', true)));
            $postData = [
                'payrl_holi_id' => $this->input->post('payrl_holi_id', true),
                'shift_id' => $this->input->post('shift_id', true),
                'start_date' => $start,
                'end_date' => $end,
                'no_of_days' => $this->input->post('no_of_days', true),
            ];
            if (!empty($this->input->post('id'))) {
                $postData['id'] = $this->input->post('id');
                $updated = $this->Leave_model->update_holiday($postData, 'payroll_holiday_shift_wise');
                $message = display('successfully_updated');
            } else {
                $updated = $this->Leave_model->holiday_create($postData, 'payroll_holiday_shift_wise');
                $message = display('successfully_saved');
            }
            if ($updated) {
                $this->session->set_flashdata('message', $message);
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("leave/Leave/add_shift_holiday_view");
        } else {
            $data['title'] = display('create');
            $data['module'] = "leave";
            $data['page'] = "";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_shift_holiday($id)
    {
        $this->permission->module('holiday', 'delete')->redirect();
        if ($this->Leave_model->holiday_delete($id, 'payroll_holiday_shift_wise')) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("leave/Leave/add_shift_holiday_view");
    }
    public function create_holiday()
    {
        #-------------------------------#
        $this->form_validation->set_rules('holiday_name', display('holiday_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('start_date', display('start_date'), 'required');
        $this->form_validation->set_rules('end_date', display('end_date'), 'required');
        $this->form_validation->set_rules('no_of_days', display('no_of_days'));
        $this->form_validation->set_rules('shifts[]', 'Shifts', 'required');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            if ($this->Leave_model->holiday_create($this->input->post())) {
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
        } else {
            $this->session->set_flashdata('exception', validation_errors());
        }
        redirect("leave/Leave/holiday_view");
    }
    public function delete_holiday($id = null)
    {
        $this->permission->module('leave', 'delete')->redirect();
        if ($this->Leave_model->holiday_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("leave/Leave/holiday_view");
    }
    public function update_holiday_form($id = null)
    {
        if ($this->input->post()) {
            $this->form_validation->set_rules('payrl_holi_id', null, 'required|max_length[11]');
            $this->form_validation->set_rules('holiday_name', display('holiday_name'), 'required|max_length[30]');
            $this->form_validation->set_rules('start_date', display('start_date'), 'required');
            $this->form_validation->set_rules('end_date', display('end_date'), 'required');
            $this->form_validation->set_rules('no_of_days', display('no_of_days'), 'required');
            $this->form_validation->set_rules('shifts[]', 'Shifts', 'required');
            #-------------------------------#
            if ($this->form_validation->run() === true) {
                if ($this->Leave_model->update_holiday($this->input->post())) {
                    $this->session->set_flashdata('message', display('successfully_updated'));
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
                redirect("leave/Leave/holiday_view");
            } else {
                $this->session->set_flashdata('exception', validation_errors());
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Leave_model->holiday_updateForm($id);
            $data['shifts'] = $this->db->select('id, name')->order_by('name', 'asc')->get('shift')->result_array();
            $data['module'] = "leave";
            $data['page'] = "update_holiday_form"; //
            echo Modules::run('template/layout', $data);
        }
    }
    public function application()
    {
        $data['title'] = display('application'); //agent_picture
        #-------------------------------#
        $this->form_validation->set_rules('employee_id', display('employee_id'));
        $this->form_validation->set_rules('apply_strt_date', display('apply_strt_date'));
        $this->form_validation->set_rules('apply_end_date', display('apply_end_date'), 'max_length[50]');
        $this->form_validation->set_rules('leave_aprv_strt_date', display('leave_aprv_strt_date'), 'max_length[100]');
        $this->form_validation->set_rules('leave_aprv_end_date', display('leave_aprv_end_date'), 'max_length[32]');
        $this->form_validation->set_rules('num_aprv_day', display('num_aprv_day'), 'max_length[100]');
        $this->form_validation->set_rules('reason', display('reason'), 'max_length[100]');
        $this->load->library('Fileupload');
        $img = $this->fileupload->do_upload(
            './application/modules/leave/assets/images/',
            'apply_hard_copy');
        $this->form_validation->set_rules('apply_date', display('apply_date'), 'max_length[100]');
        $this->form_validation->set_rules('approve_date', display('approve_date'), 'max_length[100]');
        $this->form_validation->set_rules('approved_by', display('approved_by'));
        $this->form_validation->set_rules('leave_type', display('leave_type'));
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'employee_id' => $this->input->post('employee_id', true),
                'apply_strt_date' => $this->input->post('apply_strt_date', true),
                'apply_end_date' => $this->input->post('apply_end_date', true),
                'leave_aprv_strt_date' => $this->input->post('leave_aprv_strt_date', true),
                'leave_aprv_end_date' => $this->input->post('leave_aprv_end_date', true),
                'num_aprv_day' => $this->input->post('num_aprv_day', true),
                'reason' => $this->input->post('reason', true),
                'apply_date' => $this->input->post('apply_date', true),
                'approve_date' => $this->input->post('approve_date', true),
                'approved_by' => $this->input->post('approved_by', true),
                'leave_type' => $this->input->post('leave_type', true),
                'apply_hard_copy' => $img,
            ];
            if ($this->Leave_model->application_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_created'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("leave/Leave/application");
        } else {
            $data['title'] = display('leave');
            $data['module'] = "leave"; //
            $data['dropdown'] = $this->Leave_model->dropdown();
            $data['mang'] = $this->Leave_model->manageleave();
            $data['page'] = "application_form";
            echo Modules::run('template/layout', $data);
        }
    }
    // others leave info
    public function others_leave()
    {
        if($this->input->post()) {
            $this->form_validation->set_rules('employee_id', display('employee_id'), 'required');
            $this->form_validation->set_rules('apply_strt_date', display('apply_strt_date'), 'required');
            $this->form_validation->set_rules('apply_end_date', display('apply_end_date'), 'required|max_length[50]');
            $this->form_validation->set_rules('leave_type_id', 'Leave Type', 'required|max_length[50]');
            $this->form_validation->set_rules('apply_day', display('apply_day'), 'required|greater_than[0]');
            if (strtolower(trim($this->input->post('apply_day'))) == 'holiday') {
                $this->session->set_flashdata('exception', display('apply_day') . ' cannot be holiday');
                redirect($_SERVER['HTTP_REFERER']);
            }
            $this->load->library('Fileupload');
            $img = $this->fileupload->do_upload(
                './application/modules/leave/assets/images/',
                'apply_hard_copy');
            $supervisor_id = 0;
            $emp_rec = null;
            if ($this->session->userdata('employee_id') == $this->input->post('employee_id')) {
                $supervisor_id = $this->session->userdata('direct_supervisor');
            } else {
                $emp_rec = getByWhere('employee_history', 'CONCAT_WS(\' \', first_name, last_name) as fullname, hrm_id, super_visor_id as direct_supervisor', ['employee_id' => $this->input->post('employee_id')]);
                if ($emp_rec) {
                    $emp_rec = $emp_rec[0];
                }
                $supervisor_id = $emp_rec->direct_supervisor;
            }
            #-------------------------------#
            if ($this->form_validation->run() === true) {
                $postData = [
                    'employee_id' => $this->input->post('employee_id', true),
                    'leave_type_id' => $this->input->post('leave_type_id', true),
                    'apply_strt_date' => date('Y-m-d', strtotime($this->input->post('apply_strt_date', true))),
                    'apply_end_date' => date('Y-m-d', strtotime($this->input->post('apply_end_date', true))),
                    'leave_aprv_strt_date' => '0000-00-00',
                    'leave_aprv_end_date' => '0000-00-00',
                    'num_aprv_day' => 0,
                    'reason' => htmlspecialchars($this->input->post('reason', true)),
                    'apply_date' => date('Y-m-d'),
                    'approve_date' => '0000-00-00',
                    'apply_day' => $this->input->post('apply_day', true),
                    'approved_by' => 0,
                    'apply_hard_copy' => (!empty($img) ? $img : null),
                    'supervisor_id' => $supervisor_id,
                ];
                // print_r($postData);exit();
                if ($this->Leave_model->application_create($postData)) {
                    $lastId = $this->db->insert_id();
                    $this->session->set_flashdata('message', display('successfully_created'));
                    $this->notify->department('hr')->employee([$supervisor_id, $postData['employee_id']]);
                    if ($this->session->userdata('employee_id') == $postData['employee_id']) {
                        $this->notify->send(sprintf('%s added a leave application', $this->session->userdata('fullname')), 'leave/Leave/update_application_form/' . $lastId);
                    } else {
                        $this->notify->send(sprintf('%s added a leave application for employee %s (%s)', $this->session->userdata('fullname'), $emp_rec->fullname, $emp_rec->hrm_id), 'leave/Leave/update_application_form/' . $lastId);
                    }
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
            }
            redirect("leave/Leave/others_leave");
        }
        $data['title'] = display('leave');
        $data['module'] = "leave"; //
        $data['type'] = $this->Leave_model->get_leave_type();
        $data['dropdown'] = $this->Leave_model->dropdown();
        $data['supr'] = $this->Leave_model->supervisorList();
        
        $shifts = $this->db->select('employee_id, shift')->where_in('employee_id', array_keys($data['dropdown']))->get('employee_history')->result_array();
        $data['employee_shifts'] = [];
        foreach ($shifts as $shift_rec) {
            $data['employee_shifts'][$shift_rec['employee_id']] = $shift_rec['shift'];
        }
        $weekend_arr = $this->db->get('weekly_holiday')->result_array();
        $data['weekend_arr'] = [];
        foreach ($weekend_arr as $wk_ar) {
            $data['weekend_arr'][$wk_ar['shift_id']] = $wk_ar['dayname'];
        }
        $data['annual_holidays_arr'] = $this->Leave_model->get_annual_holidays(array_column($shifts, 'shift'));

        $data['page'] = "other_leave_application_form";
        echo Modules::run('template/layout', $data);
    }
    // add others leave type form
    public function add_leave_type()
    {
        $data['title'] = display('leave_type');
        #-------------------------------#
        $this->form_validation->set_rules('leave_type', display('leave_type_name'), 'required|max_length[100]');
        // $this->form_validation->set_rules('leave_days',display('number_of_leave_days'),'max_length[30]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'leave_type' => $this->input->post('leave_type', true),
                'leave_days' => $this->input->post('leave_days', true),
            ];
            if ($this->Leave_model->save_leave_type($postData)) {
                $this->session->set_flashdata('message', display('successfully_created'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("leave/Leave/add_leave_type");
        } else {
            $data['title'] = display('leave_type');
            $data['module'] = "leave";
            $data['type'] = $this->Leave_model->get_all_leave_type();
            $data['page'] = "leave_type_form";
            echo Modules::run('template/layout', $data);
        }
    }
    // update leave type
    public function update_leave_type($id = null)
    {
        $data['title'] = display('update');
        #-------------------------------#
        $this->form_validation->set_rules('leave_type', display('leave_type_name'), 'required|max_length[100]');
        // $this->form_validation->set_rules('leave_days',display('number_of_leave_days'),'max_length[30]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'leave_type_id' => $this->input->post('leave_type_id', true),
                'leave_type' => $this->input->post('leave_type', true),
            ];
            if ($this->Leave_model->save_update_leave_type($postData)) {
                $this->session->set_flashdata('message', display('successfully_created'));
            }
            // else {
            //     $this->session->set_flashdata('exception',  display('please_try_again'));
            // }
            redirect("leave/Leave/add_leave_type");
        } else {
            $data['title'] = display('update');
            $data['module'] = "leave";
            $data['data'] = $this->Leave_model->get_leave_type_by_id($id);
            $data['page'] = "update_leave_type_form";
            echo Modules::run('template/layout', $data);
        }
    }
    // delete leave type
    public function delete_leave_type($id = null)
    {
        $this->permission->module('leave', 'delete')->redirect();
        if ($this->Leave_model->delete_leave_type($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("leave/Leave/add_leave_type");
    }
    public function delete_application($id = null)
    {
        $this->permission->module('leave', 'delete')->redirect();
        if ($this->Leave_model->application_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("leave/Leave/application_view");
    }
    public function application_view()
    {
        $this->permission->method('leave_application', 'read')->redirect();
        $data['title'] = display('selection');
        $data['module'] = "leave";
        $data['page'] = "application_view";
        echo Modules::run('template/layout', $data);
    }
    public function update_application_form($id = null)
    {
        $subordinates = array_column($this->Leave_model->get_subordinates(false, true), 'employee_id');
        $leave_rec = $this->Leave_model->get_id($id);
        if ($this->input->post('reject')) {
            $postData = [
                'leave_appl_id' => $id,
                'leave_aprv_strt_date' => null,
                'leave_aprv_end_date' => null,
                'num_aprv_day' => 0,
                'approve_date' => null,
                'approved_by' => 0,
            ];
            $emp_rec = getByWhere('employee_history', 'CONCAT_WS(\' \', first_name, last_name) as fullname, hrm_id, super_visor_id as direct_supervisor', ['employee_id' => $leave_rec['employee_id']]);
            if ($emp_rec) {
                $emp_rec = $emp_rec[0];
            }
            if($this->permission->method('leave_application','update')->access()) {
                $postData['hr_status'] = 'denied';
                $postData['hr_approver'] = $this->session->userdata('employee_id');
                $this->notify
                    ->employee($leave_rec['supervisor_id'])
                    ->send(sprintf('HR rejected leave application #%s of %s', $id, $emp_rec->fullname), 'leave/Leave/update_application_form/' . $id);
                $this->notify
                    ->employee($leave_rec['employee_id'])
                    ->send(sprintf('HR rejected your leave application #%s', $id), 'leave/Leave/application_view');
                $this->activity
                    ->set_employee($leave_rec['employee_id'])
                    ->log([
                        'leave_denied',
                        $id,
                        'HR'
                    ]);
                $this->Leave_model->send_email($leave_rec, 'rejected');
            } elseif (in_array($leave_rec['employee_id'], $subordinates)) {
                $postData['supervisor_status'] = 'denied';
                $this->notify
                    ->department('hr')
                    ->send(sprintf('Supervisor %s rejected leave application #%s of %s', $this->session->userdata('fullname'), $id, $emp_rec->fullname), 'leave/Leave/update_application_form/' . $id);
                $this->notify
                    ->employee($leave_rec['employee_id'])
                    ->send(sprintf('Supervisor %s rejected your leave application #%s', $this->session->userdata('fullname'), $id), 'leave/Leave/application_view');
                $this->activity
                ->set_employee($leave_rec['employee_id'])
                ->log([
                    'leave_denied',
                    $id,
                    'supervisor'
                ]);
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
                redirect("leave/Leave/application_view");
            }
            if ($this->Leave_model->update_application($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("leave/Leave/application_view");
        }
        $this->form_validation->set_rules('leave_aprv_strt_date', display('leave_aprv_strt_date'), 'trim|required|max_length[100]');
        $this->form_validation->set_rules('leave_aprv_end_date', display('leave_aprv_end_date'), 'trim|required|max_length[32]');
        $this->form_validation->set_rules('num_aprv_day', display('num_aprv_day'), 'required|greater_than[0]');
        if (strtolower(trim($this->input->post('num_aprv_day'))) == 'holiday') {
            $this->session->set_flashdata('exception', display('num_aprv_day') . ' cannot be holiday');
            redirect($_SERVER['HTTP_REFERER']);
        }
        if ($this->session->userdata('isAdmin') == 1) {
            $this->form_validation->set_rules('approved_by', display('approved_by'), 'trim|required|is_natural');
        }
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'leave_appl_id' => $id,
                'leave_aprv_strt_date' => date('Y-m-d', strtotime($this->input->post('leave_aprv_strt_date', true))),
                'leave_aprv_end_date' => date('Y-m-d', strtotime($this->input->post('leave_aprv_end_date', true))),
                'num_aprv_day' => (!empty($this->input->post('num_aprv_day', true)) ? $this->input->post('num_aprv_day', true) : 0),
            ];
            $emp_rec = getByWhere('employee_history', 'CONCAT_WS(\' \', first_name, last_name) as fullname, hrm_id, super_visor_id as direct_supervisor', ['employee_id' => $leave_rec['employee_id']]);
            if ($emp_rec) {
                $emp_rec = $emp_rec[0];
            }
            if($this->permission->method('leave_application','update')->access()) {
                $postData['approve_date'] = date('Y-m-d', strtotime($this->input->post('approve_date', true)));
                $postData['approved_by'] = $this->session->userdata('isAdmin') == 1 ? $this->input->post('approved_by', true) : $this->session->userdata('employee_id');
                $postData['hr_status'] = 'approved';
                $postData['hr_approver'] = $this->session->userdata('employee_id');
                $this->notify
                    ->employee($leave_rec['supervisor_id'])
                    ->send(sprintf('HR approved leave application #%s of %s', $id, $emp_rec->fullname), 'leave/Leave/update_application_form/' . $id);
                $this->notify
                    ->employee($leave_rec['employee_id'])
                    ->send(sprintf('HR approved your leave application #%s', $id), 'leave/Leave/application_view');
                $this->activity
                    ->set_employee($leave_rec['employee_id'])
                    ->log([
                        'leave_approved',
                        $id,
                        'HR'
                    ]);
                $this->Leave_model->send_email($leave_rec, 'approved');
            } elseif (in_array($leave_rec['employee_id'], $subordinates)) {
                $postData['supervisor_status'] = 'approved';
                $this->notify
                    ->department('hr')
                    ->send(sprintf('Supervisor %s approved leave application #%s of %s', $this->session->userdata('fullname'), $id, $emp_rec->fullname), 'leave/Leave/update_application_form/' . $id);
                $this->notify
                    ->employee($leave_rec['employee_id'])
                    ->send(sprintf('Supervisor %s approved your leave application #%s', $this->session->userdata('fullname'), $id), 'leave/Leave/application_view');
                $this->activity
                    ->set_employee($leave_rec['employee_id'])
                    ->log([
                        'leave_approved',
                        $id,
                        'supervisor'
                    ]);
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
                redirect("leave/Leave/application_view");
            }
            if ($this->Leave_model->update_application($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("leave/Leave/application_view");
        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Leave_model->application_updateForm($id);
            $data['dropdown'] = $this->Leave_model->dropdown();
            $data['bb'] = $this->Leave_model->get_id($id);
            $data['type'] = $this->Leave_model->get_leave_type();
            $data['subordinates'] = $subordinates;
            $data['supr'] = $this->Leave_model->supervisorList();
            $shift_id = $this->db->select('shift')->where('employee_id', $data['data']->employee_id)->get('employee_history')->row()->shift;
            $data['weekend'] = $this->db->select('dayname')->where('shift_id', $shift_id)->from('weekly_holiday')->get()->row()->dayname;
            $data['annual_holidays_arr'] = $this->Leave_model->get_annual_holidays($shift_id);
            $data['module'] = "leave";
            $data['page'] = "update_application_form"; //
            echo Modules::run('template/layout', $data);
        }
    }
    // Leave free for employee
    public function free_leave()
    {
        $data = [];
        if($this->input->post('employee_id') && $this->input->post('leave_type')) {
            $employee_id = $this->input->post('employee_id');
            $type = $this->input->post('leave_type');
            $employee_leave = $this->db->select('SUM(num_aprv_day) as lv')
                ->where([
                    'leave_type_id' => $type,
                    'employee_id' => $employee_id,
                    'leave_aprv_strt_date >=' => date('Y') . '-01-01',
                    'leave_aprv_end_date <=' => date('Y') . '-12-31',
                ])
                ->get('leave_apply')->row();
            $totalleave = $this->db->select('leave_qouta leave_days')->from('employee_leaves')->where(['emp_id' => $employee_id, 'leave_type' => $type])->get()->row();
            $data = array(
                'enjoy' => intval($employee_leave->lv ?? 0),
                'due' => intval($totalleave->leave_days ?? 0),
            );
        }
        
        sendJson($data);
    }
    public function getDatatable()
    {
        $where_arr = [];
        $search_arr = [];
        $search_columns = [
            'leave_apply.leave_appl_id',
            'employee_history.first_name',
            'employee_history.last_name',
            'employee_history.hrm_id',
            'leave_type.leave_type',
            'leave_apply.num_aprv_day',
            'leave_apply.apply_strt_date',
            'leave_apply.apply_end_date',
            'leave_apply.leave_aprv_strt_date',
            'leave_apply.leave_aprv_end_date',
            'leave_apply.apply_date'
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            $originalSearchVal = $searchVal;
            $searchVal = explode(' ', $searchVal);
            foreach ($searchVal as $keyword) {
                if(!trim($keyword)) {
                    continue;
                }
                foreach ($search_columns as $value) {
                    if(convert_excel_date($keyword)) {
                        $search_arr[] = [$value, convert_excel_date($keyword)];
                    } else {
                        $keyword2 = preg_replace('@\s+@', '%', $keyword);
                        $keyword2 .= '%';
                        $search_arr[] = [$value, $keyword2];
                    }
                }
            }
            if(stripos($originalSearchVal, 'supervisor') !== false) {
                if(stripos($originalSearchVal, 'awaiting') !== false) {
                    $where_arr[] = ['leave_apply.supervisor_status', 'pending'];
                }
                if(stripos($originalSearchVal, 'approved') !== false) {
                    $where_arr[] = ['leave_apply.supervisor_status', 'approved'];
                }
                if(stripos($originalSearchVal, 'denied') !== false) {
                    $where_arr[] = ['leave_apply.supervisor_status', 'denied'];
                }
                $where_arr[] = ['leave_apply.hr_status', 'pending'];
                $search_arr = [];
            } elseif (stripos($originalSearchVal, 'hr') !== false) {
                if(stripos($originalSearchVal, 'awaiting') !== false) {
                    $where_arr[] = ['leave_apply.hr_status', 'pending'];
                }
                if(stripos($originalSearchVal, 'approved') !== false) {
                    $where_arr[] = ['leave_apply.hr_status', 'approved'];
                }
                if(stripos($originalSearchVal, 'denied') !== false) {
                    $where_arr[] = ['leave_apply.hr_status', 'denied'];
                }
                $search_arr = [];
                $search_arr[] = ['leave_apply.supervisor_status', 'approved'];
                $search_arr[] = ['leave_apply.supervisor_status', 'denied'];
            } elseif(stripos($originalSearchVal, 'approved') !== false) {
                $where_arr[] = ['leave_apply.supervisor_status', 'approved'];
                $where_arr[] = ['leave_apply.hr_status', 'approved'];
                $search_arr = [];
            } elseif(stripos($originalSearchVal, 'awaiting') !== false) {
                $where_arr[] = ['leave_apply.supervisor_status', 'pending'];
                $where_arr[] = ['leave_apply.hr_status', 'pending'];
                $search_arr = [];
            } elseif(stripos($originalSearchVal, 'denied') !== false) {
                $where_arr[] = ['leave_apply.supervisor_status', 'denied'];
                $where_arr[] = ['leave_apply.hr_status', 'denied'];
                $search_arr = [];
            }
        };
        $search_arr = array_filter($search_arr, function($v) {
            return !empty(trim($v[1]));
        });
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $out_arr["recordsFiltered"] = $this->Leave_model->countDatatable($search_arr, $where_arr);
        $rows = $this->Leave_model->getDatatable($search_arr, $where_arr);

        $subordinates = array_column($this->Leave_model->get_subordinates(false, true), 'employee_id');
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'apply_strt_date':
                    case 'apply_end_date':
                    case 'leave_aprv_strt_date':
                    case 'leave_aprv_end_date':
                    case 'apply_date': {
                        $tdData = formatted_date($rec[$col['data']]);
                        break;
                    }
                    case 'num_aprv_day': {
                        $tdData = sprintf('%s/%s', $rec['num_aprv_day'], $rec['apply_day']);
                        break;
                    }
                    case 'hr_status': {
                        if($rec['supervisor_id'] && $rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'pending'){
                            $tdData = 'Awaiting Supervisor Response';
                        }elseif($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'approved'){
                            $tdData = 'Approved By Supervisor';
                        }elseif($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'denied'){
                            $tdData = 'Denied By Supervisor';
                        }elseif($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'approved'){
                            $tdData = 'Approved By Supervisor';
                        }elseif(!$rec['supervisor_id'] && $rec['hr_status'] == 'pending'){
                            $tdData = 'Awaiting HR Response';
                        }elseif($rec['hr_status'] == 'approved'){
                            $tdData = 'Approved By HR';
                        }elseif($rec['hr_status'] == 'denied'){
                            $tdData = 'Denied By HR';
                        }
                        break;
                    }
                    case 'action':{
                            if($rec['hr_status'] == 'approved') {
                                $tdData = '<span>' . display('approved') . '</span>';
                                break;
                            }
                            if($rec['employee_id'] == $this->session->userdata('employee_id')) {
                                break;
                            }

                            if($this->session->userdata('isAdmin')==1 && $rec['hr_status'] == 'pending') {
                                $tdData = '<a href="' . base_url("leave/Leave/update_application_form/". $rec['leave_appl_id']) . '" class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                            } elseif (in_array($rec['employee_id'], $subordinates) && $rec['supervisor_status'] == 'pending' && $rec['hr_status'] == 'pending') {
                                $tdData = '<a href="' . base_url("leave/Leave/update_application_form/". $rec['leave_appl_id']) . '" class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                            } elseif ($this->permission->method('leave_application','update')->access() && $rec['hr_status'] == 'pending') {
                                $tdData = '<a href="' . base_url("leave/Leave/update_application_form/". $rec['leave_appl_id']) . '" class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                            }
                            if($this->permission->method('leave_application','delete')->access()) {
                                $tdData .= '<a href="#" class="btn btn-xs btn-danger" onclick="return confirmdelete(\'' . display('are_you_sure') . '\', \'' . base_url("leave/Leave/delete_application/" . $rec['leave_appl_id']) . '\') "><i class="fa fa-close"></i></a>';
                            }
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
}
