<style>
    .ck-editor__editable {
        min-height: 500px;
    }

    .mce-tinymce.mce-fullscreen {
        z-index: 9999;
    }

    .mce-tinymce button {
        background-color: #fff;
        color: #000;
    }

    .mce-btn.mce-active button,
    .mce-btn.mce-active:hover button,
    .mce-btn.mce-active i,
    .mce-btn.mce-active:hover i {
        color: #000;
    }
    ul#sortable{
        list-style: none;
    }
    ul#sortable .del-item{
        position: absolute;
        right: 25px;
    }
    ul#sortable .fa-arrows{
        cursor: pointer;
        margin-right: 10px;
    }
</style>
<div class="container-fluid">
    <form method="post">
        <div class="form-group">
            <label for="txtTitle">Title</label>
            <input type="text" name="title" id="txtTitle" class="form-control" placeholder="Letter title"
                value="<?= set_value('title') ?>">
        </div>
        <div class="form-group">
            <label for="selAuthor">Author Type</label>
            <select class="form-control dont-select-me" name="author_type" id="selAuthor" required>
                <option <?= set_select('author_type', 'HR') ?>>HR</option>
                <option <?= set_select('author_type', 'Manager') ?>>Manager</option>
            </select>
        </div>
        <div class="form-group">
            <label for="txtFooterNote">Footer Note</label>
            <input type="text" class="form-control" name="footer_note" id="txtFooterNote" placeholder="Footer note" maxlength="145" value="<?= set_value('footer_note') ?>">
            <small id="helpId" class="form-text text-muted">Leave empty to hide footer note</small>
        </div>
        <div class="form-check">
            <label class="form-check-label">
                <input type="checkbox" class="form-check-input" name="requires_admin_approval" value="1"
                    <?= set_checkbox('requires_admin_approval', '1') ?>>
                HR Manager Approval Required
            </label>
        </div>
        <br>
        <div class="form-group">
            <label>Questions</label> <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#modelQuestions" style="margin: 10px"><i class="fa fa-plus" aria-hidden="true"></i> Add Question</button>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Title</th>
                        <th>Tag</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody id="questions-body"></tbody>
            </table>
        </div>
        <div class="form-group">
            <label for="txtBody">Letter Body</label>
            <textarea class="form-control editor" name="body" id="txtBody" rows="15"><?= set_value('body') ?></textarea>
        </div>
        <div class="row pull-right">
            <div class="form-group">
                <button type="submit" class="btn btn-primary" style="margin-right: 15px;">Add</button>
            </div>
        </div>
    </form>
</div>
<script>
    $(document).ready(function () {
        $("select:not(.no-seletize)").selectize();
    });
</script>
<?php require_once(APPPATH . 'modules/incident/views/letter/scripts/tinymce.php') ?>
<?php require_once(APPPATH . 'modules/incident/views/letter/scripts/questions-modal.php') ?>