<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Incident extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model([
            'letter_model',
            'incident_model',
            'incident_type_model' => 'incident_type',
        ]);
    }
    public function create($type = null)
    {
        $this->permission->method('incident_create', 'create')->redirect();
        if ($type == 'letter') {
            $this->incident_letter();return;
        } elseif ($type == 'incident') {
            $this->incident_incident();return;
        }
        $data['title'] = 'Select Type';
        $data['module'] = 'incident';
        $data['page'] = 'incident/create';
        echo Modules::run('template/layout', $data);
    }
    public function get_email($id)
    {
        $rec = $this->incident_model->get_email_model($id);
        if ($rec) {
            sendJson(['success' => $rec]);
        }
        sendJson(['error' => 'not found']);
    }
    public function details($id)
    {
        if(!($this->permission->method('incident_create', 'create')->access() || $this->permission->method('incident_pending', 'read')->access() || $this->permission->method('incident_rejected', 'read')->access() || $this->permission->method('incident_approved', 'read')->access())){
            redirect();
        }
        $data['incident'] = $incident = $this->incident_model->get_details($id);
        if(!($this->permission->method('incident_pending', 'update')->access() || $this->permission->method('incident_rejected', 'update')->access() || $this->permission->method('incident_approved', 'update')->access())) {
            $subords = $this->incident_model->get_supervisor_subordinates(true);
            if($incident->employee_id != $this->session->userdata('employee_id')
                && $incident->added_by != $this->session->userdata('id')
                && !in_array($incident->employee_id, $subords)) {
                $this->session->set_flashdata('exception', 'You don\'t have permission to view this page');
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
        $data['title'] = 'Incident Details';
        $data['module'] = 'incident';
        $data['page'] = 'incident/details';
        echo Modules::run('template/layout', $data);
    }
    private function incident_letter()
    {
        $this->permission->method('incident_create', 'create')->redirect();
        if ($this->input->post()) {
            if ($this->letter_model->add_letter($this->input->post('employee_id'), $this->input->post('letter_id'), $this->input->post('reason'), $this->input->post('inputs'))) {
                redirect('incident/pending');
            } else {
                $this->session->set_flashdata('exception', 'Unable to generate letter, try again!');
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
        $data['title'] = 'Generate Letter';
        $data['module'] = 'incident';
        $data['employees'] = $this->incident_model->get_employees();
        $data['letters'] = $this->letter_model->get_all_letters_filtered();
        $data['page'] = 'incident/create_letter';
        echo Modules::run('template/layout', $data);
    }
    private function incident_incident()
    {
        $this->permission->method('incident_create', 'create')->redirect();
        if ($this->input->post()) {
            $file = [
                'id' => null,
                'file' => null,
            ];
            if ($this->letter_model->add_incident($this->input->post('employee_id'), $this->input->post('subject'), $this->input->post('description'), $this->input->post('letter_id') ? $this->input->post('letter_id') : null, $this->input->post('letter_id') ? $this->input->post('inputs') : null)) {
                $this->session->set_flashdata('success', 'Incident created successfully');
                if ($this->input->post('letter_id')) {
                    redirect('incident/pending');
                } else {
                    redirect('incident/approved');
                }
            } else {
                $this->session->set_flashdata('exception', 'Unable to generate incident, try again!');
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
        $data['title'] = display('incident_create');
        $data['module'] = 'incident';
        $data['incidents_types'] = $this->incident_type->get();
        $data['letters'] = $this->letter_model->get_all_letters_filtered();
        $data['employees'] = $this->incident_model->get_employees();
        $data['page'] = 'incident/create_incident';
        echo Modules::run('template/layout', $data);
    }
    public function pending()
    {
        $this->permission->method('incident_pending', 'read')->redirect();
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $this->get_datatable('pending');
        }
        $data['title'] = display('incident_pending');
        $data['module'] = 'incident';
        $data['page'] = 'incident/pending';
        echo Modules::run('template/layout', $data);
    }
    public function approved()
    {
        $this->permission->method('incident_approved', 'read')->redirect();
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $this->get_datatable('approved');
        }
        $data['title'] = display('incident_approved');
        $data['module'] = 'incident';
        $data['email_settings'] = $this->db->select('division_id, email_from')->order_by('email_from', 'asc')->get('email_templates')->result();
        $data['email_templates'] = $this->db->select('id, name')->where('category_id <', 17)->or_where('category_id >', 21)->order_by('name')->get('document_template')->result();
        $data['page'] = 'incident/approved';
        echo Modules::run('template/layout', $data);
    }
    public function rejected()
    {
        $this->permission->method('incident_rejected', 'read')->redirect();
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $this->get_datatable('rejected');
        }
        $data['title'] = display('incident_rejected');
        $data['module'] = 'incident';
        $data['page'] = 'incident/rejected';
        echo Modules::run('template/layout', $data);
    }
    private function get_datatable($type)
    {
        $types = [];

        switch ($type) {
            case 'approved':
                $types = ['approved'];
                break;
            case 'rejected':
                $types = ['rejected', 'contested-p', 'contested-r'];
                break;
            case 'pending':
            default:
                $types = [
                    'pending',
                    'pending-admin',
                    'contested-a',
                ];
                break;
        }
        $search_arr = [];
        $search_columns = [
            'incidents.id',
            'incidents.genID',
            'incidents.type',
            'incidents.employee_name',
            'DATE_FORMAT(incidents.updated_at, \'%d-%m-%Y %r\')',
            'DATE_FORMAT(incidents.added_at, \'%d-%m-%Y %r\')',
            'employee_history.first_name',
            'employee_history.last_name',
            'incidents.incident_type',
            'incidents.file_path',
            'incidents.description',
            'incidents.reason',
            'incidents.status',
            'CONCAT_WS(\' \', employee_history.first_name, employee_history.middle_name, employee_history.last_name)',
            'CONCAT_WS(\' \', user.firstname, user.lastname)',
            'CONCAT_WS(\' \', em2.first_name, em2.middle_name, em2.last_name)',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->incident_model->countAllRows($types);
        $out_arr["recordsFiltered"] = $this->incident_model->countDatatable($types, $search_arr);
        $rows = $this->incident_model->getDatatable($types, $search_arr);
        $status_arr = [
            'pending' => 'Pending',
            'pending-admin' => 'Pending',
            'approved' => 'Approved',
            'rejected' => 'Rejected',
            'contested-r' => 'Rejected',
            'contested-a' => 'Contested',
            'contested-p' => 'Contested',
        ];
        $label_class = [
            'pending' => 'primary',
            'pending-admin' => 'primary',
            'approved' => 'success',
            'rejected' => 'danger',
            'contested-r' => 'danger',
            'contested-a' => 'warning',
            'contested-p' => 'warning',
        ];
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'type':{
                            $tdData = ucfirst($rec[$col['data']]);
                            break;
                        }
                    case 'file_path':{
                            if (!$rec['letter_id']) {
                                $tdData = 'N/A';
                                break;
                            }
                            if (isset($rec[$col['data']])) {
                                $tdData = sprintf(
                                    '<a target="_blank" class="btn btn-primary" href="%semployee/document/inc/%s" role="button"><i class="fa fa-file" aria-hidden="true"></i></a>',
                                    base_url(),
                                    urlencode($rec[$col['data']])
                                );
                            } else {
                                $tdData = sprintf(
                                    '<a target="_blank" class="btn btn-primary" href="%sincident/view/%s" role="button"><i class="fa fa-file" aria-hidden="true"></i></a>',
                                    base_url(),
                                    $rec['id']
                                );
                            }
                            break;
                        }
                    case 'status':{
                            $tdData = '<span class="label label-' . $label_class[$rec[$col['data']]] . '">' . $status_arr[$rec[$col['data']]] . '</span>';
                            break;
                        }
                    case 'updated_at':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'remarks':{
                            $tdData = '';
                            $inc_log = $this->db->where('letter_id', $rec['id'])->order_by('id', 'desc')->limit(1)->get('incident_logs')->row();
                            if ($inc_log) {
                                if(strlen($inc_log->remarks) > 60){
                                    $inc_log->remarks = '<span class="readmore-block">' . $inc_log->remarks . '</span>';
                                }
                                $tdData = $inc_log->remarks;
                            }
                            break;
                        }
                    case 'details':{
                            $tdData = $rec[$col['data']];
                                if(strlen($tdData) > 60){
                                    $tdData = '<span class="readmore-block">' . $tdData . '</span>';
                                }
                            $tdData = $tdData;
                            break;
                        }
                    case 'action':{
                            $tdData = '<div class="btn-group"><button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action <span class="caret"></span></button><ul class="dropdown-menu">';
                            $btns = [];

                            $override_self_letters = $this->permission->method('incident_' . $type, 'delete')->access();

                            $btns[] = '<li><a href="' . base_url('incident/details/') . $rec['id'] . '" >View Details</a></li>';
                            if($rec['employee_id'] != $this->session->userdata('employee_id') || $override_self_letters){
                                if($this->session->userdata('isAdmin') || ($rec['added_by'] != $this->session->userdata('id') || $override_self_letters)){
                                    if ($rec['status'] == 'pending-admin' && $this->permission->module('approve_hr_manager_letters')->access()) {
                                        $btns[] = '<li><a href="#" class="btn-approve" data-type="' . $rec['type'] . '" data-id="' . $rec['id'] . '">Approve</a></li>';
                                        $btns[] = '<li><a href="#" class="btn-reject" data-id="' . $rec['id'] . '">Reject</a></li>';
                                    } elseif ($this->permission->method('incident_pending', 'update')->access() && in_array($rec['status'], ['pending', 'contested-a'])) {
                                        $btns[] = '<li><a href="#" class="btn-approve" data-type="' . $rec['type'] . '" data-id="' . $rec['id'] . '">Approve</a></li>';
                                        $btns[] = '<li><a href="#" class="btn-reject" data-id="' . $rec['id'] . '">Reject</a></li>';
                                    }
                                }
                                if (in_array($rec['status'], ['rejected'])) {
                                    if ($rec['added_by'] == $this->session->userdata('id') || $override_self_letters) {
                                        $btns[] = '<li><a href="#" class="btn-contest" data-id="' . $rec['id'] . '">Contest Rejection</a></li>';
                                    }
                                }
                                if (($this->permission->method('incident_approved', 'update')->access() || $this->permission->method('incident_rejected', 'update')->access()) && in_array($rec['status'], ['approved', 'rejected']) && !empty($rec['letter_id'])) {
                                    $btns[] = '<li><a href="#" class="btn-print" data-url="' . base_url('incident/view/' . $rec['id']) . '">Print</a></li>';
                                    $btns[] = '<li><a class="btn-savepdf" href="' . base_url('incident/view/' . $rec['id']) . '" download="' . $rec['incident_type'] . '.pdf">Save as PDF</a></li>';
                                }
                                if ($this->permission->method('incident_approved', 'update')->access() && in_array($rec['status'], ['approved']) && !empty($rec['letter_id'])) {
                                    $btns[] = '<li><a href="#" class="btn-sendemail" data-id="' . $rec['id'] . '">Email</a></li>';
                                }
                                if($this->session->userdata('isAdmin') || ($rec['added_by'] != $this->session->userdata('id') || $override_self_letters)){
                                    if ($this->permission->method('incident_rejected', 'update')->access() && in_array($rec['status'], ['contested-p'])) {
                                        $btns[] = '<li><a href="#" class="btn-contest-p" data-type="accept" data-id="' . $rec['id'] . '">Accept Contestation</a></li>';
                                        $btns[] = '<li><a href="#" class="btn-contest-p" data-type="reject" data-id="' . $rec['id'] . '">Reject Contestation</a></li>';
                                    }
                                }
                            }
                            $inc_log = $this->db->where('letter_id', $rec['id'])->order_by('id', 'desc')->limit(1)->get('incident_logs')->row();
                            if ($inc_log && $rec['employee_id'] != $this->session->userdata('employee_id')) {
                                if (count($btns)) {
                                    $btns[] = '<li role="separator" class="divider"></li>';
                                }
                                $btns[] = '<li><a href="#" class="btn-showlogs" data-id="' . $rec['id'] . '">Incident Logs</a></li>';
                            }
                            if (!$btns) {
                                $tdData = '';
                                break;
                            }
                            if(count($btns) > 1){
                                array_splice( $btns, 1, 0, ['<li role="separator" class="divider"></li>'] );
                            }
                            $tdData .= implode('', $btns);
                            $tdData .= '</ul></div>';
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function add_type()
    {
        $this->permission->method('incident_type_add', 'create')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'type',
                    'label' => 'Incident Type Title',
                    'rules' => 'trim|strip_tags|required|min_length[3]|max_length[150]',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                if ($this->incident_type->add($this->input->post())) {
                    $this->session->set_flashdata('success', 'Incident Type added successfully');
                    redirect('incident/incident/types');
                } else {
                    $this->session->set_flashdata('exception', 'Unable to add Incident Type, try again');
                }
            } else {
                $this->session->set_flashdata('exception', validation_errors());
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = display('incident_type_add');
        $data['module'] = 'incident';
        $data['letters'] = $this->letter_model->get_all_letters();
        $data['page'] = 'incident-type/add';
        echo Modules::run('template/layout', $data);
    }
    public function update_type($id)
    {
        $this->permission->method('incident_type_list', 'update')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'type',
                    'label' => 'Incident Type Title',
                    'rules' => 'trim|strip_tags|required|min_length[3]|max_length[150]',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                if ($this->incident_type->update($id, $this->input->post())) {
                    $this->session->set_flashdata('success', 'Incident Type update successfully');
                    redirect('incident/incident/types');
                } else {
                    $this->session->set_flashdata('exception', 'Unable to update Incident Type, try again');
                }
            } else {
                $this->session->set_flashdata('exception', validation_errors());
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
        $data['title'] = 'Update Incident Type';
        $data['module'] = 'incident';
        $data['letters'] = $this->letter_model->get_all_letters();
        $data['incident'] = $this->incident_type->get($id);
        $data['page'] = 'incident-type/update';
        echo Modules::run('template/layout', $data);
    }
    public function delete_type($id)
    {
        $this->permission->method('incident_type_list', 'delete')->redirect();
        if ($this->incident_type->delete($id)) {
            $this->session->set_flashdata('success', 'Incident Type deleted successfully');
        } else {
            $this->session->set_flashdata('exception', 'Unable to delete Incident Type, try again');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function types()
    {
        $this->permission->method('incident_type_list', 'read')->redirect();
        $data['title'] = display('incident_type_list');
        $data['module'] = 'incident';
        $data['incidents'] = $this->incident_type->get();
        $data['page'] = 'incident-type/list';
        echo Modules::run('template/layout', $data);
    }
    public function letter_details()
    {
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $letter_id = $this->input->post('letter_id');
            if ($this->input->post('incident_type_id')) {
                $rec = $this->incident_type->get($this->input->post('incident_type_id'));
                $letter_id = $rec->required_letter_id;
            }
            if ($letter_id) {
                $letter_data = $this->letter_model->get_letter($letter_id);
                if ($letter_data && $letter_data->input_structure) {
                    sendJson([
                        'fields' => $this->load->view('letter/user_input', ['inputs' => json_decode($letter_data->input_structure, true)], true),
                    ]);
                }
            }
            sendJson(['nodata' => 1]);
        }
    }
    public function approve()
    {
        $this->permission->method('incident_pending', 'update')->redirect();
        if ($this->input->post() && $this->input->is_ajax_request()) {
            if ($this->incident_model->approve($this->input->post('id'))) {
                sendJson(['success' => 'Incident/Letter request has been approved']);
            } else {
                sendJson(['error' => 'Unable to process approval request, try again']);
            }
        }
    }
    public function reject()
    {
        $this->permission->method('incident_rejected', 'update')->redirect();
        if ($this->input->post() && $this->input->is_ajax_request()) {
            if ($this->incident_model->reject($this->input->post('id'), $this->input->post('remarks'))) {
                sendJson(['success' => 'Incident/Letter request has been rejected']);
            } else {
                sendJson(['error' => 'Unable to process rejection request, try again']);
            }
        }
    }
    public function contest()
    {
        if ($this->input->post() && $this->input->is_ajax_request()) {
            if ($this->incident_model->contest($this->input->post('id'), $this->input->post('remarks'))) {
                sendJson(['success' => 'Incident/Letter is marked as contested']);
            } else {
                sendJson(['error' => 'Unable to process contest request, try again']);
            }
        }
    }
    public function contest_update()
    {
        $this->permission->method('incident_rejected', 'update')->redirect();
        if ($this->input->post('id') && $this->input->post('status')) {
            if ($this->incident_model->contest_status($this->input->post('id'), $this->input->post('status'))) {
                sendJson(['success' => 'Contestation request has been ' . $this->input->post('status') . 'ed']);
            } else {
                sendJson(['error' => 'Unable to perform contestation update, try again']);
            }
        }
    }
    public function logs()
    {
        if ($this->input->post('id')) {
            $incident = $this->incident_model->get_logs($this->input->post('id'));
            if ($incident->logs) {
                sendJson(['success' => $this->load->view('incident/incident/logs', ['incident' => $incident], true)]);
            } else {
                sendJson(['error' => 'No logs found']);
            }
        }
    }
    public function email_status($id)
    {
        sendJson(['sent' => $this->incident_model->get_email_status($id)]);
    }
    public function send_email()
    {
        if (!($this->input->post('id'))) {
            return;
        }
        $rules_config = array(
            array(
                'field' => 'inOrg',
                'label' => 'Send In Organization',
                'rules' => 'strip_tags|trim|required|in_list[yes,no]',
            ),
            array(
                'field' => 'eto',
                'label' => 'To',
                'rules' => 'strip_tags|trim|required',
            ),
            array(
                'field' => 'cc',
                'label' => 'CC',
                'rules' => 'strip_tags|trim|required',
            ),
            array(
                'field' => 'subject',
                'label' => 'Subject',
                'rules' => 'strip_tags|trim|required|min_length[3]',
            ),
            array(
                'field' => 'body',
                'label' => 'Body',
                'rules' => 'trim|required',
            ),
        );
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === false) {
            $errors = [];
            foreach ($_POST as $key => $value) {
                if (form_error($key)) {
                    $errors[] = [$key, form_error($key)];
                }
            }
            if (trim(strip_tags($_POST['body']))) {
                $errors[] = ['body', 'The body field is required'];
            }
            sendJson(['errors' => $errors]);
        }
        $id = $this->input->post('id');
        $this->load->library(['TemplateMailer' => 'mailer']);
        $letter_rec = $this->incident_model->get($id);
        $emails = $this->incident_model->get_emails($id);
        $filename = $this->letter_model->generate_pdf($id, true, APPPATH . 'modules/incident/assets/generated_letters/');
        if ($letter_rec) {
            $this->db->trans_start();
            $this->mailer->config($_POST['efrom'] ?? $emails->division_id)->_send($this->input->post('inOrg') == 'no' ? $this->input->post('eto') : $emails->employee, null, $this->input->post('subject'), $this->input->post('body'), $this->input->post('inOrg') == 'no' ? $this->input->post('cc') : $emails->supervisor, [], [$letter_rec->incident_type . '.pdf' => $filename]);
            $this->db->where('id', $id)->update('incidents', [
                'email_sent' => 1,
            ]);
            $this->db->trans_complete();
            if ($this->db->trans_status()) {
                $this->activity->log([
                    'letter_email_sent',
                    $letter_rec->incident_type,
                    $id,
                    $this->input->post('inOrg') == 'no' ? $this->input->post('eto') : $emails->employee
                ]);
                sendJson(['success' => 'Email has been sent successfully']);
            }
        }
        sendJson(['error' => 'Unable to send email at this time, try again']);
    }
    public function view($letter_id)
    {
        if (!($this->permission->method('incident_pending', 'update')->access() || $this->permission->method('incident_rejected', 'update')->access() || $this->permission->method('incident_approved', 'update')->access())) {
            redirect();
        }
        $this->letter_model->view($letter_id);
    }
}
