<div class="container-fluid">
    <div class="row">
        <div class="col-sm-12" id="action_btns" style="display:none">
            <button type="button" class="btn btn-warning btn-sm btn-sendselected">Resend Selected</button>
            <button type="button" class="btn btn-danger btn-sm btn-uncheckall">Unselect All</button>
        </div>
    </div>
    <br>
    <table class="table table-hover">
        <thead>
            <tr>
                <th>Employee</th>
                <th>Field</th>
                <th>Old Value</th>
                <th>Requested Change</th>
                <th>Requested At</th>
                <th class="hideexport">Action</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($rows as $row) :?>
                <tr>
                    <td><?= sprintf('%s (%s)', $row['employee_name'], $row['hrm_id']) ?></td>
                    <td><?= $field_alias[$row['col_name']] ?></td>
                    <td><?= $row['old_value'] ?></td>
                    <td><?= $row['col_value'] ?></td>
                    <td><?= formatted_date($row['requested_at'], true) ?></td>
                    <td class="time_action_btn">
                        <?php if($this->permission->method('pending_changes', 'update')->access()): ?>
                        <form action="<?= base_url('employee/pending_changes/process') ?>" method="post">
                            <input type="hidden" name="employee_id" value="<?= $row['employee_id'] ?>">
                            <input type="hidden" name="col_name" value="<?= $row['col_name'] ?>">
                            <button type="submit" class="btn btn-success btn-sm" name="process" value="approve">Approve</button>
                            <button type="submit" class="btn btn-danger btn-sm" name="process" value="reject">Reject</button>
                        </form>
                        <?php endif?>
                    </td>
                </tr>
            <?php endforeach?>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({},
            window.default_datatable_opts, {
                responsive: false,
                columnDefs: [{
                    targets: [4],
                    type: "date",
                    render: function ( data, type ) {
                        if(type === 'sort'){
                            return moment(data, 'DD-MM-YYYY hh:mm:ss A')
                        }
                        return data;
                    }
                }],
                order: [
                    [4, 'desc']
                ]
            }
        ))
    });
</script>