<style>
    .form-check-inline {
        display: inline-block;
        padding: 0px 5%;
    }
</style>
<div class="container-fluid">
    <?php if($this->permission->method('employee_document_types', 'create')->access()): ?>
    <div class="row">
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#modelAddType"><i class="fa fa-plus" aria-hidden="true"></i> <?= display('add_employee_document_type') ?></button>
    </div>
    <br>
    <?php endif?>
    <div class="row">
        <table class="datatable table table-hover">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?= display('document_name') ?></th>
                    <th><?= display('required') ?></th>
                    <th><?= display('has_deadline') ?></th>
                    <th class="hideexport"><?= display('action') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($types as $type) :?>
                    <tr>
                        <td><?= $type->id ?></td>
                        <td><?= $type->title ?></td>
                        <td><?= $type->is_required ? 'Yes' : 'No' ?></td>
                        <td><?= $type->has_deadline ? 'Yes' : 'No' ?></td>
                        <td>
                            <?php if($this->permission->method('employee_document_types', 'update')->access()): ?>
                                <a class="btn btn-primary btn-sm btn-edit" data-id="<?= $type->id ?>" role="button"><i class="fa fa-pencil" aria-hidden="true"></i></a>
                            <?php endif?>
                            <?php if($this->permission->method('employee_document_types', 'delete')->access()): ?>
                                <a class="btn btn-danger btn-sm" href="#" onclick="confirmdelete('Are you sure you want to delete this document type?', '<?= base_url('employee/employees_documents/delete_type/') . $type->id ?>')" role="button"><i class="fa fa-trash" aria-hidden="true"></i></a>
                            <?php endif?>
                        </td>
                    </tr>
                <?php endforeach?>
            </tbody>
        </table>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('.modal form').on('submit', function(e) {
            e.preventDefault();
            var $form = $(this);
            myajax({
                type: 'POST',
                url: $.trim($form.attr('action')).length > 0 ? $form.attr('action') : null, 
                data: $form.serialize(),
                beforeSend: function() {
                    $form.find('span.error').remove()
                },
                success: function (res) {
                    if(!res) {
                        alert('Network error, please contact administrator');
                    }
                    if(res.success) {
                        $form.closest('.modal').modal('hide')
                    } else if (res.error) {
                        alert(res.error)
                    } else if (res.errors) {
                        res.errors.forEach(err => {
                            $form.find(`[name=${err[0]}]`).closest('div').append(`<span class="error" style="color:red">${err[1]}</span>`);
                        });
                    } else {
                        alert('Invalid server response, try again');
                        console.log(res);
                    }
                    if(res.reload) {
                        setTimeout(() => {
                            $('.se-pre-con').show()
                        }, 200);
                        location.reload()
                    }
                }
            })
        })
        $('.btn-edit').on('click', function(e) {
            e.preventDefault();
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>employee/employees_documents/get_type",
                data: {
                    id: $(this).data('id')
                },
                success: function (res) {
                    if(res.success) {
                        var $modal = $('#modelUpdateType');
                        $modal.find('[name=id]').val(res.success.id)
                        $modal.find('[name=title]').val(res.success.title)
                        $modal.find('[name=is_required][value=no]').prop('checked', true)
                        if(res.success.is_required == 1) {
                            $modal.find(`[name=is_required][value=yes]`).prop('checked', true)                            
                        }
                        $modal.find(`[name=is_required]`).trigger('change')
                        
                        $modal.find('[name=has_deadline][value=no]').prop('checked', true)
                        if(res.success.has_deadline == 1) {
                            $modal.find(`[name=has_deadline][value=yes]`).prop('checked', true)                            
                        }
                        $modal.find(`[name=has_deadline]`).trigger('change')
                        $modal.modal('show')
                    } else if (res.error) {
                        alert(res.error)
                    } else {
                        alert('Unknown error, try again');
                        console.log(res);
                    }
                }
            });
        })
        $('.modal').on('hidden.bs.modal', function () {
            $(this).find('span.error').remove();
            $(this).find('input').each(function() {
                if (this.type == 'text') {
                    this.value = ''
                } else if (this.type == 'radio') {
                    $(`[name=${this.name}]`).each(function() {
                        if(this.value == 'no') {
                            $(this).prop('checked', true)
                        } else {
                            $(this).prop('checked', false)
                        }
                    })
                    $(`[name=${this.name}]`).trigger('change')
                } else {
                    this.value = '0'
                }
            })
        })
        $('[name=is_required]').on('change', function() {
            var $form = $(this).closest('form');
            if($form.find('[name=is_required]:checked').val() == 'yes') {
                $form.find('.deadline-block').show()
            } else {
                var $deadlineblock = $form.find('.deadline-block');
                $deadlineblock.find('input[value=no]').prop('checked', true);
                $deadlineblock.find('input[value=no]').trigger('change')
                $deadlineblock.hide();
            }
        })
    });
</script>
<!-- Modal -->
<div class="modal fade" id="modelAddType" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form method="post">
                <div class="modal-header">
                    <h5 class="modal-title"><?= display('add_employee_document_type') ?>:</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                      <label for="txtName"><?= display('add_employee_document_type') ?>:</label>
                      <input type="text" class="form-control" name="title" id="txtName" placeholder="<?= display('add_employee_document_type') ?>">
                    </div>
                    <div class="form-group">
                      <label><?= display('required') ?>:</label>
                      <div class="form-check form-check-inline">
                          <label class="form-check-label">
                          <input type="radio" class="form-check-input" name="is_required" value="no" checked>
                          <?= display('no') ?>
                        </label>
                      </div>
                      <div class="form-check form-check-inline">
                          <label class="form-check-label">
                          <input type="radio" class="form-check-input" name="is_required" value="yes">
                          <?= display('yes') ?>
                        </label>
                      </div>
                    </div>
                    <div class="form-group deadline-block" style="display: none;">
                      <label><?= display('has_deadline') ?>:</label>
                      <div class="form-check form-check-inline">
                          <label class="form-check-label">
                          <input type="radio" class="form-check-input" name="has_deadline" value="no" checked>
                          <?= display('no') ?>
                        </label>
                      </div>
                      <div class="form-check form-check-inline">
                          <label class="form-check-label">
                          <input type="radio" class="form-check-input" name="has_deadline" value="yes">
                          <?= display('yes') ?>
                        </label>
                      </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="modelUpdateType" tabindex="-1" role="dialog" data-backdrop="static" data-keyboard="false" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form method="post">
                <input type="hidden" name="id">
                <div class="modal-header">
                    <h5 class="modal-title"><?= display('update_employee_document_type') ?>:</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                      <label for="etxtName"><?= display('add_employee_document_type') ?>:</label>
                      <input type="text" class="form-control" name="title" id="etxtName" placeholder="<?= display('add_employee_document_type') ?>">
                    </div>
                    <div class="form-group">
                      <label><?= display('required') ?>:</label>
                      <div class="form-check form-check-inline">
                          <label class="form-check-label">
                          <input type="radio" class="form-check-input" name="is_required" value="no" checked>
                          <?= display('no') ?>
                        </label>
                      </div>
                      <div class="form-check form-check-inline">
                          <label class="form-check-label">
                          <input type="radio" class="form-check-input" name="is_required" value="yes">
                          <?= display('yes') ?>
                        </label>
                      </div>
                    <div class="form-group deadline-block" style="display: none;">
                      <label><?= display('has_deadline') ?>:</label>
                      <div class="form-check form-check-inline">
                          <label class="form-check-label">
                          <input type="radio" class="form-check-input" name="has_deadline" value="no" checked>
                          <?= display('no') ?>
                        </label>
                      </div>
                      <div class="form-check form-check-inline">
                          <label class="form-check-label">
                          <input type="radio" class="form-check-input" name="has_deadline" value="yes">
                          <?= display('yes') ?>
                        </label>
                      </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Save</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>