<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Fields_model extends CI_Model
{
    private $field_aliases = [
        'marital_status' => 'Marital Status',
        'middle_name' => 'Middle Name',
        'phone' => 'Phone',
        'alter_phone' => 'Alternative Phone',
        'home_phone' => 'Home Phone',
        'emerg_contct' => 'Emergency Contact Number',
        'cell_phone' => 'Cell Phone',
        'home_email' => 'Personal Email'
    ];
    public function get_aliases($key = null)
    {
        if($key) {
            return $this->field_aliases[$key];
        }
        return $this->field_aliases;
    }
    public function get($employee_id)
    {
        $data = [];
        $recs = getByWhere('employee_pending_fields', 'col_name, col_value', ['employee_id' => $employee_id, 'status' => 'pending']);

        if ($recs) {
            foreach ($recs as $rec) {
                if ($rec->col_name == 'marital_status') {
                    $marital_status = $this->db->where('id', $rec->col_value)->get('marital_info')->row();
                    if ($marital_status) {
                        $rec->col_value = $marital_status->marital_sta;
                    }
                }
                $data[$rec->col_name] = $rec->col_value;
            }
        }
        return decrypt_employee_data($data);
    }
    public function get_all($status = 'pending')
    {
        $employees_data = [];
        $recs = getByWhereAsArray(
            'employee_pending_fields,
            employee_history-employee_pending_fields.employee_id=employee_history.employee_id-left',
            'employee_pending_fields.*,
            COALESCE(employee_pending_fields.updated_at, employee_pending_fields.added_at) as requested_at,
            CONCAT_WS(\' \', employee_history.first_name, employee_history.middle_name, employee_history.last_name) as employee_name,
            employee_history.hrm_id',
            ['employee_pending_fields.status' => $status]
        );
        return array_map(function($rec) use ($employees_data) {
            if ($rec['col_name'] == 'marital_status') {
                $marital_status = $this->db->where('id', $rec['col_value'])->get('marital_info')->row();
                if ($marital_status) {
                    $rec['col_value'] = $marital_status->marital_sta;
                }
            }
            if(!isset($employees_data[$rec['employee_id']])) {
                $employees_data[$rec['employee_id']] = decrypt_employee_data($this->db->select('employee_history.*, marital_info.marital_sta as marital_status')->where('employee_history.employee_id', $rec['employee_id'])->join('marital_info', 'marital_info.id=employee_history.marital_status', 'left')->get('employee_history')->row_array());
            }
            $rec['old_value'] = $employees_data[$rec['employee_id']][$rec['col_name']];

            $rec['col_value'] = decrypt_employee_data([$rec['col_name'] => $rec['col_value']])[$rec['col_name']];
            return $rec;
        }, $recs);
    }
    public function save($data)
    {
        $data = encrypt_employee_data($data);
        $emp_rec = $this->db->select('first_name, last_name, hrm_id')->where('employee_id', $this->session->userdata('employee_id'))->get('employee_history')->row();
        $this->db->trans_begin();
        foreach ($data as $key => $value) {
            $chck = $this->db->select('col_name')->where([
                'employee_id' => $this->session->userdata('employee_id'),
                'col_name' => $key,
                'status' => 'pending',
            ])->get('employee_pending_fields')->row();

            if ($chck) {
                $this->db->where([
                    'employee_id' => $this->session->userdata('employee_id'),
                    'col_name' => $key,
                    'status' => 'pending',
                ])->update('employee_pending_fields', [
                    'col_value' => $value,
                    'updated_at' => date('Y-m-d H:i:s'),
                ]);
            } else {
                $this->db->insert('employee_pending_fields', [
                    'employee_id' => $this->session->userdata('employee_id'),
                    'col_name' => $key,
                    'col_value' => $value,
                    'added_at' => date('Y-m-d H:i:s')
                ]);
            }
            $this->notify->department('hr')->send(
                sprintf('%s %s (%s) added a change request for their %s', $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id, $this->get_aliases($key)),
                'employee/Pending_changes/list'
            );
        }
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
            return true;
        }
        return false;
    }
    public function process($process, $data)
    {
        $this->db->trans_begin();
        if($process == 'approve') {
            $rec = getByWhere('employee_pending_fields', 'col_name, col_value', ['employee_id' => $data['employee_id'], 'status' => 'pending', 'col_name' => $data['col_name']], ['added_at, updated_at', 'desc'])[0];
            $old_data = decrypt_employee_data($this->db->select($rec->col_name)->where('employee_id', $data['employee_id'])->get('employee_history')->row_array());
            $new_data = decrypt_employee_data([$rec->col_name => $rec->col_value]);
            if($rec) {
                $this->db->where('employee_id', $data['employee_id'])->update('employee_history', [
                    $rec->col_name => $rec->col_value
                ]);
            }
            $this->notify->employee($data['employee_id'])->send(
                sprintf('Your request to update %s was approved.', $this->get_aliases($data['col_name'])),
                'employee/employees/cv/' . $data['employee_id']
            );
            $this->load->model('employees_model');
            $this->employees_model->log_employee_change($data['employee_id'], $new_data, $old_data, [], 'employee_update_request');
        }
        if($process == 'reject') {
            $this->notify->employee($data['employee_id'])->send(
                sprintf('Your request to update %s was rejected.', $this->get_aliases($data['col_name'])),
                'employee/employees/cv/' . $data['employee_id']
            );
        }
        $this->db->where(['employee_id' => $data['employee_id'], 'status' => 'pending', 'col_name' => $data['col_name']])->delete('employee_pending_fields');
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
        } else {
            $this->db->trans_commit();
            return true;
        }
        return false;
    }
}
