<?php defined('BASEPATH') or exit('No direct script access allowed');
class Employee_ajax_model extends CI_Model
{
    private $_bool_cols = [
        'work_from_home',
        'transportation_required',
        'voluntary_termination',
        'is_super_visor'
    ];
    private $_date_cols = [
        'hire_date',
        'original_hire_date',
        'termination_date',
        'rehire_date',
        'dob'
    ];
    private $_alt_cols = [
        'division_id' => [
            'raw' => ['dv.name'],
            'final' => 'division_name'
        ],
        'dept_id' => [
            'raw' => ['d.department_name'],
            'final' => 'department_name'
        ],
        'pos_id' => [
            'raw' => ['po.position_name'],
            'final' => 'position_name'
        ],
        'duty_type' => [
            'raw' => ['dt.type_name'],
            'final' => 'type_name'
        ],
        'super_visor_id' => [
            'raw' => ['sp.first_name', 'sp.last_name'],
            'final' => 'supervisor_name',
        ],
        'indirect_super_visor_id' => [
            'raw' => ['isp.first_name', 'isp.last_name'],
            'final' => 'indirect_supervisor_name',
        ],
        'gender' => [
            'raw' => ['gd.gender_name'],
            'final' => 'gender_name'
        ],
        'marital_status' => [
            'raw' => ['ms.marital_sta'],
            'final' => 'marital_sta'
        ],
        'shift' => [
            'raw' => ['sh.name'],
            'final' => 'shift_name'
        ]
    ];
    public function get_bool_cols()
    {
        return $this->_bool_cols;
    }
    public function get_date_cols()
    {
        return $this->_date_cols;
    }
    public function get_alt_cols()
    {
        return $this->_alt_cols;
    }
    public function search_columns()
    {
        return [
            'business_email' => 'business_email',
            'campaign' => 'campaign',
            'dept_id' => 'department',
            'division_id' => 'division',
            'duty_type' => 'duty_type',
            'first_name' => 'first_name',
            'hrm_id' => 'hrm_id',
            'last_name' => 'last_name',
            'pos_id' =>'designation',
            'pseudo' => 'Pseudo',
            'status' => 'status',
        ];
    }
    public function view_columns()
    {
        $cols = [
            'hrm_id' => 'hrm_id',
            'status' => 'status',
            'picture' => 'picture',
            'first_name' => 'first_name',
            'last_name' => 'last_name',
            'phone' => 'phone',
            'email' => 'email',
            'state' => 'state',
            'city' => 'city',
            'present_address' => 'present_address',
            'division_id' => 'division',
            'dept_id' => 'department',
            'pos_id' =>'designation',
            'duty_type' => 'duty_type',
            'shift' => 'shift',
            'hire_date' => 'hire_date',
            'original_hire_date' => 'original_h_date',
            'termination_date' => 'separation_date',
            'termination_reason' => 'separation_reason',
            'voluntary_termination' => 'voluntary_resignation',
            'super_visor_id' => 'super_visor_name',
            'indirect_super_visor_id' => 'indirect_supervisor_name',
            'dob' => 'dob',
            'gender' => 'gender',
            'marital_status' => 'marital_stats',
            'ethnic_group' => 'religion',
            'cnic' => 'cnic',
            'business_email' => 'business_email',
            'home_phone' => 'home_phone',
            'emerg_contct' => 'emergency_contact',
            'cell_phone' => 'cell_phone',
            'campaign' => 'campaign',
            'primary_project' => 'primary_project',
            'pseudo' => 'pseudo',
            'work_from_home' => 'work_from_home',
            'transportation_required' => 'transportation_required'
        ];
        if($this->permission->method('employee_salary_permission', 'read')->access()) {
            $cols = array_merge($cols, [
                'current_salary' => 'gross_salary',
            ]);
        }
        return $cols;
    }
    private function query($employees = [])
    {
        $this->load->model('Employees_model');
        $subords = [];
        if ($this->session->userdata('supervisor') == 1) {
            $subords = array_column($this->Employees_model->get_subordinates(), 'employee_id');
        }
        $this->db->select('p.*,d.department_name,dv.name as division_name,po.position_name,dt.type_name, gd.gender_name,ms.marital_sta, sh.name as shift_name, CONCAT_WS(\' \', sp.first_name, sp.last_name) as supervisor_name, CONCAT_WS(\' \', isp.first_name, isp.last_name) as indirect_supervisor_name');
        $this->db->from('employee_history p');
        $this->db->join('department d', 'p.dept_id = d.dept_id', 'left');
        $this->db->join('divisions dv', 'p.division_id = dv.id', 'left');
        $this->db->join('position po', 'p.pos_id = po.pos_id', 'left');
        $this->db->join('duty_type dt', 'p.duty_type = dt.id', 'left');
        $this->db->join('gender gd', 'p.gender = gd.id', 'left');
        $this->db->join('marital_info ms', 'p.marital_status = ms.id', 'left');
        $this->db->join('shift sh', 'p.shift = sh.id', 'left');
        $this->db->join('employee_history sp', 'p.super_visor_id = sp.employee_id', 'left');
        $this->db->join('employee_history isp', 'p.indirect_super_visor_id = isp.employee_id', 'left');

        if ($this->session->userdata('isAdmin') == 1 || $this->permission->method('manage_employee', 'read')->access()) {
            if($employees) {
                $this->db->where_in('p.employee_id', $employees);
            }
        }elseif ($this->session->userdata('supervisor') == 1) {
            if($employees) {
                $this->db->where_in('p.employee_id', $employees);
            } else {
                $this->db->where_in('p.employee_id', $subords);
            }
        } else {
            $this->db->where('p.employee_id', $this->session->userdata('employee_id'));
        }
        if(!$this->permission->method('show_inactive_employees', 'read')->access()) {
            $this->db->where('p.status', 'active');
        }
    }
    public function countAllRows()
    {
        if(!$this->permission->method('show_inactive_employees', 'read')->access()) {
            $this->db->where('status', 'active');
        }
        return $this->db->count_all_results('employee_history');
    }
    public function countDatatable($orWhere = [], $employees = [])
    {
        if(is_null($employees)) {
            return 0;
        }
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                if(strpos($value, '%') === false) {
                    $this->db->or_where($key, $value);
                } else {
                    $this->db->or_like($key, $value, 'right', false);
                }
            }
            $this->db->group_end();
        }
        $this->query($employees);
        return $this->db->count_all_results();
    }
    public function getDatatable($orWhere = [], $employees = [])
    {
        if(is_null($employees)) {
            return [];
        }
        $post = $this->input->post();

        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $key => $value) {
                if(strpos($value, '%') === false) {
                    $this->db->or_where($key, $value);
                } else {
                    $this->db->or_like($key, $value, 'right', false);
                }
            }
            $this->db->group_end();
        }
        $this->query($employees);
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
            
        $this->db->order_by('p.emp_his_id', 'desc');
        $query = $this->db->get()->result_array();
        return array_map(function($val){
            return decrypt_employee_data($val);
        }, $query);
    }
    public function search_encrypted($col_name, $value)
    {
        if($col_name == 'cnic') {
            $value = str_replace(['-'], '', $value);
        }
        $this->db->select("employee_id, {$col_name}");
        if($this->permission->method('manage_employee', 'read')->access()) {
        } elseif ($this->session->userdata('supervisor')) {
            $this->load->model('Employees_model');
            $subords = array_column($this->Employees_model->get_subordinates(), 'employee_id');
            $this->db->where_in('employee_id', $subords);
        } else {
            $this->db->where('employee_id', $this->session->userdata('employee_id'));
        }
        $employees = $this->db->get('employee_history')->result_array();
        $employees = array_map('decrypt_employee_data', $employees);
        $employees = array_filter($employees, function($employee) use($col_name, $value) {
            if(empty($employee)) {
                return false;
            }
            return stripos($employee[$col_name], $value) !== false;
        });
        return array_column($employees, 'employee_id');
    }
}
