<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employees_terminate extends MX_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		$this->load->model(array(
			'Employees_model',
			'Country_model'	
		));	

			$this->load->library('zklibrary'); 
			$this->load->library("PHPMailer_Library");
			if (! $this->session->userdata('isLogIn'))
			redirect('login?rback=' . uri_string());
	}

	public function employeeTerminate(){
		$data['title']     = "Employee Termination";
        $data['module']    = "employee";
        $data['page']      = "employee_terminate";
        $this->db->select('et.id as id,eh.first_name emp_name,eh.employee_id emp_id,
 							 et.cause cause,
   							 dt.name template_name,
                                    et.created_on date')
        							->from('employee_terminate et')
        							->join('employee_history eh','eh.employee_id=et.emp_id')
        							->join('document_template dt','et.template_id=dt.id');
                                    $admin = $this->session->userdata('isAdmin');
                                    $employee_id = $this->session->userdata('employee_id');
                                    $is_supervisor = $this->session->userdata('supervisor');
                                    $direct_supervisor = $this->session->userdata('direct_supervisor');
                                    $indirect_supervisor = $this->session->userdata('indirect_supervisor');
                                    if($this->input->post()){
                                        $post = $this->input->post();
                                        $to = $post['to'];
                                        $from = $post['from'];
                                        if($to && $from){
                                            $this->db->where("et.created_on BETWEEN '$to' and '$from'");
                                        }
                                        if($post['emp_id']){
                                            $employee_id = $post['emp_id'];
                                            // $this->db->where("et.emp_id",$employee_id);      
                                        }
                                    }
                                    if($admin != 1){
                                        if($is_supervisor == 1){
                                            $this->db->where('eh.super_visor_id',$employee_id);
                                            $this->db->or_where('eh.employee_id',$employee_id);
                                            $this->db->or_where('eh.indirect_super_visor_id',$employee_id);
                                        }
                                        else{
                                            $this->db->where('eh.employee_id',$employee_id);
                                        }
                                    }
        $result =  $this->db->get()->result();
        $data['terminate'] = $result;
        echo modules::run('template/layout', $data);
	}



   public function getTemplateCategory(){
           $post = $_POST['searchTerm'];
            $e = $this->db->select('*')->from('template_category')->like(['name'=>$post])->get()->result();
            $data  = array();
            foreach ($e as $key => $value) {
                $data[] =array('id'=>$value->id,'text'=>$value->name);
            }
            echo json_encode($data);
            exit;
    }
    
    public function getTemplateByCategory(){
        $cat = $this->input->post('category_id');
        $result = $this->db->select('*')->from('document_template')->where('category_id',$cat)->get()->result();
        echo json_encode($result);
    }

    public function getTemplateByCategories(){
        $cat = $this->input->post('category_id');
        $result = $this->db->select('*')->from('document_template')->where('category_id',$cat)->get()->result();
        $html = "";
        // $html .= "<option></option>";
        foreach($result as $key=>$value){
                $html .= "<option value=".$value->id." >".$value->name."</option>";
        }
        echo $html;
    }


    public function getTemplateById(){
        $id = $this->input->post('id');
        $result = $this->db->select('*')->from('document_template')->where('id',$id)->get()->result();
        echo json_encode($result);
    }



	public function update_terminate($id=null){
redirect();
		$this->form_validation->set_rules('emp_id','Employeer Name'  ,'required');
        $this->form_validation->set_rules('cause','Cause'  ,'required');
        $this->form_validation->set_rules('category_id','Category'  ,'required');
        $this->form_validation->set_rules('template_name','Template Name'  ,'required');
        $this->form_validation->set_rules('template','Template'  ,'required');

		$post = $this->input->post();
		$return = 0;
        if ($this->form_validation->run() === true) {
        	$return = 1;
        	$data['emp_id'] =  $post['emp_id'];
        	$data['cause'] =  $post['cause'];
            $data['template_id'] =  $post['template_name'];
        	$data['text'] =  $post['template'];

            if($this->input->post('category_id') == 11){
                $this->db->where('employee_id', $post['emp_id'])->update('employee_history', [
                    'termination_date' => date('Y-m-d h:i:s A'),
                    'termination_reason' => $data['cause'],
                    'voluntary_termination' => 0
                ]);
            }
        	if(isset($id)){
	            $updateData = $this->db->where('id',$id)->update('employee_terminate',$data);
        	}else{
        		$data['created_on'] = date('Y-m-d');
	            $data['created_by'] = $this->session->userdata('id');	
        		//$updateData = $this->db->insert('employee_terminate',$data);
                $emp_email = $this->db->select('*')->from('employee_history')->where('employee_id',$post['emp_id'])->get()->first_row();
                $this->db->where('email',$emp_email->email)->update('user',array('status'=>0));
        	}
            if($updateData && $return ==1){
                $this->session->set_flashdata('message', "Terminate Updated Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("/employee/Employees_terminate/employeeTerminate");

        }else{
			$this->employeeTerminate();
        }
	}

	public function getEmployeeTerminates(){
		$id = $this->input->post('id');
		$result  = $this->db->select('
									et.id,eh.employee_id as emp_id,
									eh.first_name fname,
									eh.last_name lname,
                                    eh.email as email,
        							et.cause cause,
        							dt.name template_name,
        							dt.category_id as category_id,
        							tc.name as category_name,
        							et.template_id as template_id,
                                    et.text as text')
        							->from('employee_terminate et')
        							->join('employee_history eh','eh.employee_id=et.emp_id')
        							->join('document_template dt','et.template_id=dt.id')
        							->join('template_category tc','tc.id=dt.category_id')
        							->where('et.id',$id)
        							->get()
        							->result();
       	echo json_encode($result);
	}

	public function deleteTerminate($id){
	    
        redirect();
                $emp_email = $this->db->select('employee_history.*')->from('employee_history')
                 ->join('employee_terminate','employee_terminate.emp_id=employee_history.employee_id')
                 ->where('employee_terminate.id',$id)
                              ->get()->first_row();
                              
        $this->db->where('email',$emp_email->email)->update('user',array('status'=>1));

        $this->db->where('id',$id)->delete('employee_terminate');   
        $this->session->set_flashdata('message', "Terminate Deleted Successfully!");
        redirect("/employee/Employees_terminate/employeeTerminate");
	}

    public function sendEmail(){
        $sent = 0;
        $id = $this->input->post('id');
     	$result  = $this->db->select('
									et.id,eh.employee_id as emp_id,
									eh.first_name fname,eh.last_name lname,
                                    eh.email as email,
        							et.cause cause,
        							dt.name template_name,
        							dt.category_id as category_id,
        							tc.name as category_name,
        							et.template_id as template_id,
                                    et.text as text')
        							->from('employee_terminate et')
        							->join('employee_history eh','eh.employee_id=et.emp_id')
        							->join('document_template dt','et.template_id=dt.id')
        							->join('template_category tc','tc.id=dt.category_id')
        							->where('et.id',$id)
        							->get()
        							->result();
        foreach($result as $key=>$value){
            $send = $this->sendingEmailNew($value->email,$value->fname.' '.$value->lname,'Important Notification From Admin',$value->text);
        }
        if($send){
         echo 1;   
        }
         
    }


	public function sendingEmailNew($sendToEmail=null,$name=null,$subject=null,$templatePath=null){
	    if($sendToEmail != null && $subject != null && $templatePath != null){
	        $mail = $this->phpmailer_library->load();
    		$mail->SMTPDebug = 0;                                 // Enable verbose debug output
    		$mail->SMTPOptions = array(
    			'ssl' => array(
    				'verify_peer' => false,
    				'verify_peer_name' => false,
    				'allow_self_signed' => true
    			)
    		);
    		$mail->Host ="SMTP.gmail.com";  // Specify main and backup SMTP servers
    		$mail->isSMTP();
    		$mail->Port = 465;
    		$mail->SMTPAuth = true;
    		$mail->SMTPSecure = "ssl"; // Enable SMTP authentication
    		$mail->Username = $this->config->item('smtp_user'); // SMTP username
            $mail->Password = $this->config->item('smtp_pass');  // TCP port to connect to
    		$mail->setFrom($this->config->item('admin_info'), $this->config->item('mail_subject'));
    		$mail->addAddress($sendToEmail, $name);
    		$mail->isHTML(true);  // Set email format to HTML
    		$mail->Subject = $subject;
    		$mail->Body = $templatePath;   
    		if($mail->send()){
    		    return true;
    		}
    		// else{
    		// 	print_r($mail);
    		// 	exit;
    		// }
        }
	}

    // public function terminate_employee(){
    //     $data['title']     = "Terminate Employee";
    //     $data['module']    = "employee";
    //     $data['page']      = "terminate_employee";
    //     echo modules::run('template/layout', $data);
    // }



}