<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Employees_documents extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'Documents_model',
            'department/Department_model',
        ));

    }
    public function index($type, $file)
    {
        if (!in_array($type, ['my', 'emp', 'inc'])) {
            show_404();
        }
        if ($type == 'my') {
            $file_rec = $this->Documents_model->get_by_name($file);
            if (!$file_rec) {
                show_404();
            }
            if ($file_rec->employee_id != $this->session->userdata('employee_id')) {
                $this->output
                    ->set_status_header(401)
                    ->set_output('Error, you do not have permission to access to this file.')
                    ->_display();exit;
            }
        }
        if ($type == 'emp' && !$this->permission->method('employee_document_permission', 'read')->access()) {
            $this->output
                ->set_status_header(401)
                ->set_output('Error, you do not have permission to access to this file.')
                ->_display();exit;
        }
        if ($type == 'inc' && !($this->permission->method('incident_pending', 'read')->access() || $this->permission->method('incident_approved', 'read')->access() || $this->permission->method('incident_rejected', 'read')->access())) {
            $this->output
                ->set_status_header(401)
                ->set_output('Error, you do not have permission to access to this file.')
                ->_display();exit;
        }
        $file = urldecode($file);
        $paths = [
            'my' => array_to_path(['assets', 'employee_documents']),
            'emp' => array_to_path(['assets', 'employee_documents']),
            'inc' => array_to_path(['application', 'modules', 'incident', 'assets', 'generated_letters']),
        ];
        $this->load->helper('file');
        $path = array_to_path([FCPATH, $paths[$type], $file]);
        if (file_exists($path)) {
            header('Pragma: public'); // required
            header('Expires: 0'); // no cache
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s', filemtime($path)) . ' GMT');
            header('Cache-Control: private', false);
            header('Content-Type: ' . get_mime_by_extension($path)); // Add the mime type from Code igniter.
            //header('Content-Disposition: attachment; filename="' . $file . '"'); // Add the file name
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: ' . filesize($path)); // provide file size
            header('Connection: close');
            readfile($path); // push it out
            exit();
        }
        show_404();
    }
    public function manual_bulk()
    {
        $this->permission->method('bulk_doc_update', 'create')->redirect();
        $file_dir = FCPATH . 'uploads/bulk/';
        $excel_path = $file_dir . 'bulk.xlsx';
        if(!file_exists($excel_path)) {
            echo 'Error: Excel file not found in path "' . $excel_path . '"'; 
        }
        $emp_dir_path = FCPATH . 'assets/employee_documents/';

        $this->load->library('excel');
        $excel_data = $this->excel->read($excel_path);

        $heading_row = array_shift($excel_data);
        $heading_row = array_map(function ($val) {
            return strtolower(preg_replace('~[^\d\w]+~is', '_', trim($val)));
        }, $heading_row);
        array_filter($heading_row);

        $hrm_id_key = array_search('employee_id', $heading_row);

        if ($hrm_id_key === false) {
            echo 'Error: Required "Employee ID" Column not found in sheet. Make sure first row is heading';return;
        }

        if (!in_array('documents', $heading_row) || !in_array('document_type_name', $heading_row)) {
            echo 'Error: Columns "Documents" and "Document Type Name" are required';return;
        }

        $employee_data = [];

        $doc_types = [];
        $doctype_recs = $this->db->select('id, title')->get('upload_documents_type')->result();
        foreach ($doctype_recs as $doctype_rec) {
            $doc_types[strtolower(trim($doctype_rec->title))] = $doctype_rec->id;
        }

        $all_documents = [];
        $this->db->trans_start();
        foreach ($excel_data as $row_num => $row_data) {
            $row_num+=2;

            if (emptyArray($row_data)) {
                continue;
            }

            if (empty($row_data[$hrm_id_key])) {
                echo 'Error: Required "Employee ID" column is empty on row #' . $row_num;return;
            }
            if (!isset($employee_data[$row_data[$hrm_id_key]])) {
                $employee_rec = $this->db->select('employee_id')
                    ->where('hrm_id', trim($row_data[$hrm_id_key]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if (!$employee_rec) {
                    echo 'Error: Employee ID "' . trim($row_data[$hrm_id_key]) . '" doesn\'t exist from row# ' . $row_num;return;
                }
                $employee_data[$row_data[$hrm_id_key]] = $employee_rec->employee_id;
            }
            $employee_id = $employee_data[$row_data[$hrm_id_key]];

            $document_data = [
                'employee_id' => $employee_id,
                'created_date' => date('Y-m-d'),
            ];
            foreach ($heading_row as $head_key => $head_value) {
                if ($head_key == $hrm_id_key) {
                    continue;
                }
                if (!in_array($head_value, ['documents', 'document_type_name'])) {
                    continue;
                }
                if (empty(trim($row_data[$head_key]))) {
                    echo 'Error: Required "' . $head_key . '" column is empty on row #' . $row_num;return;
                }
                $head_value = trim($head_value);

                if (strtolower($head_value) == 'document_type_name') {
                    if (!isset($doc_types[strtolower(trim($row_data[$head_key]))])) {
                        $res = $this->db->insert('upload_documents_type', [
                            'title' => $row_data[$head_key],
                        ]);
                        if (!$res) {
                            echo 'Error: Unable to create new document type "' . $row_data[$head_key] . '". row #' . $row_num;return;
                        }
                        $doc_types[strtolower(trim($row_data[$head_key]))] = $this->db->insert_id();
                    }
                    $document_data['orig_document_type'] = strtolower(trim($row_data[$head_key]));
                    $document_data['document_type'] = $doc_types[strtolower(trim($row_data[$head_key]))];
                }

                if (strtolower($head_value) == 'documents') {
                    $file_key = trim($row_data[$head_key]);
                    if (!file_exists($file_dir . 'files/' . $file_key)) {
                        echo 'Error: File "' . $row_data[$head_key] . '" doesn\'t exist in batch. row #' . $row_num;return;
                    }
                    $file_name = $file_key;
                    if (file_exists($emp_dir_path . $file_name)) {
                        $file_name = file_time_append($file_name);
                    }
                    $document_data['orig_document'] = $row_data[$head_key];
                    $document_data['documents'] = $file_name;
                }
            }
            $all_documents[] = $document_data;
        }
        foreach ($all_documents as $all_document) {
            if (rename($file_dir . 'files/' . $all_document['orig_document'], $emp_dir_path . $all_document['documents']) === false) {
                echo 'Error: Fatal error! Unable to move file "' . $all_document['orig_document'] . '" to employee directory.';return;
            }
            if (in_array($all_document['orig_document_type'], ['photo', 'photograph'])) {
                $this->db->where('employee_id', $all_document['employee_id'])->update('employee_history', [
                    'picture' => './assets/employee_documents/' . $all_document['documents'],
                ]);
            }
            unset($all_document['orig_document_type']);
            unset($all_document['orig_document']);
            $this->db->insert('upload_documents', $all_document);
            $this->activity->set_url('employee/Employees/documents_update/' . $all_document['employee_id'])->log([
                'employee_document_added',
                $all_document['documents'],
            ], $all_document['employee_id'], 'employee', 'employee_history');
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === true) {
            @unlink($excel_path);
            echo 'Success: All files have been uploaded against provided employees';
        } else {
            echo 'Error: Unable to add documents to db. transaction failed';            
        }
    }
    public function bulk_upload()
    {
        $this->permission->method('bulk_doc_update', 'create')->redirect();
        if ($_FILES) {
            if (isset($_FILES["excel_file"]["name"]) && !empty($_FILES["excel_file"]["name"])) {
                if (isset($_FILES["documents"]["name"]) && count($_FILES['documents']['name']) > 0) {
                    $emp_dir_path = FCPATH . 'assets/employee_documents/';
                    $path = $_FILES["excel_file"]["tmp_name"];

                    $this->load->library('excel');
                    $excel_data = $this->excel->read($path);

                    $heading_row = array_shift($excel_data);
                    $heading_row = array_map(function ($val) {
                        return strtolower(preg_replace('~[^\d\w]+~is', '_', trim($val)));
                    }, $heading_row);
                    array_filter($heading_row);

                    $hrm_id_key = array_search('employee_id', $heading_row);

                    if ($hrm_id_key === false) {
                        $this->session->set_flashdata('exception', 'Required "Employee ID" Column not found in sheet. Make sure first row is heading');
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }

                    if (!in_array('documents', $heading_row) || !in_array('document_type_name', $heading_row)) {
                        $this->session->set_flashdata('exception', 'Columns "Documents" and "Document Type Name" are required');
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }

                    $employee_data = [];

                    $doc_types = [];
                    $doctype_recs = $this->db->select('id, title')->get('upload_documents_type')->result();
                    foreach ($doctype_recs as $doctype_rec) {
                        $doc_types[strtolower(trim($doctype_rec->title))] = $doctype_rec->id;
                    }

                    $all_documents = [];
                    $this->db->trans_start();
                    foreach ($excel_data as $row_num => $row_data) {
                        $row_num+=2;

                        if (emptyArray($row_data)) {
                            continue;
                        }

                        if (empty($row_data[$hrm_id_key])) {
                            $this->session->set_flashdata('exception', 'Required "Employee ID" column is empty on row #' . $row_num);
                            redirect($_SERVER['HTTP_REFERER']);return;
                        }
                        if (!isset($employee_data[$row_data[$hrm_id_key]])) {
                            $employee_rec = $this->db->select('employee_id')
                                ->where('hrm_id', trim($row_data[$hrm_id_key]))
                                ->from('employee_history')
                                ->get()
                                ->row();
                            if (!$employee_rec) {
                                $this->session->set_flashdata('exception', 'Employee ID "' . trim($row_data[$hrm_id_key]) . '" doesn\'t exist from row# ' . $row_num);
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $employee_data[$row_data[$hrm_id_key]] = $employee_rec->employee_id;
                        }
                        $employee_id = $employee_data[$row_data[$hrm_id_key]];

                        $document_data = [
                            'employee_id' => $employee_id,
                            'created_date' => date('Y-m-d'),
                        ];
                        foreach ($heading_row as $head_key => $head_value) {
                            if ($head_key == $hrm_id_key) {
                                continue;
                            }
                            if (!in_array($head_value, ['documents', 'document_type_name'])) {
                                continue;
                            }
                            if (empty(trim($row_data[$head_key]))) {
                                $this->session->set_flashdata('exception', 'Required "' . $head_key . '" column is empty on row #' . $row_num);
                                redirect($_SERVER['HTTP_REFERER']);return;
                            }
                            $head_value = trim($head_value);

                            if (strtolower($head_value) == 'document_type_name') {
                                if (!isset($doc_types[strtolower(trim($row_data[$head_key]))])) {
                                    $res = $this->db->insert('upload_documents_type', [
                                        'title' => $row_data[$head_key],
                                    ]);
                                    if (!$res) {
                                        $this->session->set_flashdata('exception', 'Unable to create new document type "' . $row_data[$head_key] . '". row #' . $row_num);
                                        redirect($_SERVER['HTTP_REFERER']);return;
                                    }
                                    $doc_types[strtolower(trim($row_data[$head_key]))] = $this->db->insert_id();
                                }
                                $document_data['orig_document_type'] = strtolower(trim($row_data[$head_key]));
                                $document_data['document_type'] = $doc_types[strtolower(trim($row_data[$head_key]))];
                            }

                            if (strtolower($head_value) == 'documents') {
                                $file_key = array_search($row_data[$head_key], $_FILES['documents']['name']);
                                if ($file_key === false) {
                                    $this->session->set_flashdata('exception', 'File "' . $row_data[$head_key] . '" doesn\'t exist in batch. row #' . $row_num);
                                    redirect($_SERVER['HTTP_REFERER']);return;
                                }
                                if (is_array($file_key)) {
                                    $this->session->set_flashdata('exception', 'Duplicate file name "' . $row_data[$head_key] . '" in batch. row #' . $row_num);
                                    redirect($_SERVER['HTTP_REFERER']);return;
                                }
                                $file_name = $_FILES['documents']['name'][$file_key];
                                if (file_exists($emp_dir_path . $file_name)) {
                                    $file_name = file_time_append($file_name);
                                }
                                $document_data['temp_file'] = $_FILES['documents']['tmp_name'][$file_key];
                                $document_data['orig_document'] = $row_data[$head_key];
                                $document_data['documents'] = $file_name;
                            }
                        }
                        $all_documents[] = $document_data;
                    }
                    foreach ($all_documents as $all_document) {
                        if (move_uploaded_file($all_document['temp_file'], $emp_dir_path . $all_document['documents']) === false) {
                            $this->session->set_flashdata('exception', 'Fatal error! Unable to move file "' . $all_document['orig_document'] . '" to employee directory.');
                            redirect($_SERVER['HTTP_REFERER']);return;
                        }
                        if (in_array($all_document['orig_document_type'], ['photo', 'photograph'])) {
                            $this->db->where('employee_id', $all_document['employee_id'])->update('employee_history', [
                                'picture' => './assets/employee_documents/' . $all_document['documents'],
                            ]);
                        }
                        unset($all_document['orig_document_type']);
                        unset($all_document['temp_file']);
                        unset($all_document['orig_document']);
                        $this->db->insert('upload_documents', $all_document);
                        $this->activity->set_url('employee/Employees/documents_update/' . $all_document['employee_id'])->log([
                            'employee_document_added',
                            $all_document['documents'],
                        ], $all_document['employee_id'], 'employee', 'employee_history');
                    }
                    $this->db->trans_complete();
                    if ($this->db->trans_status() === true) {
                        $this->session->set_flashdata('success', 'All files have been uploaded against provided employees');
                    }
                } else {
                    $this->session->set_flashdata('exception', 'Unable to upload bulk files');
                }
                redirect($_SERVER['HTTP_REFERER']);
            } else {
                $this->session->set_flashdata('exception', 'Excel file wasn\'t uploaded');
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
        $data['title'] = display('bulk_doc_update');
        $data['module'] = "employee";
        $data['page'] = "bulk_doc_upload";
        echo Modules::run('template/layout', $data);
    }
    public function add_document_structure()
    {
        // echo "Obaidrehman07"; die;
        /*-----------------------------------*/
        $this->form_validation->set_rules('department_name', "Department name cannot be blanked!", 'required|max_length[50]');
        #------------------------#
        $sess = $this->session->userdata();
        if ($this->form_validation->run()) {
            echo "<pre>";
            print_r($_POST);die;
            $data['user'] = (object) $userLevelData = array(
                'name' => $this->input->post('department_name'),
                'status' => 1,
                'created_at' => date("Y-m-d H:i:s", strtotime("now")),
                'created_by' => $sess['id'],
            );
            if ($this->Documents_model->document_create($userLevelData, $_POST)) {
                $this->session->set_flashdata('message', display('save_successfully'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees_documents/manage_document_structure/");
        } else {
            $required_status[0] = "Optional";
            $required_status[1] = "Mandatory";
            $data['title'] = "Document Structure";
            $data['empl'] = $this->Department_model->department_dropdown();
            $data['required_status'] = $required_status;
            $data['module'] = "employee";
            $data['page'] = "document_structure_add";
            echo Modules::run('template/layout', $data);
        }
    }
    public function get_department_ajax()
    {
        $departments = $this->Department_model->department_dropdown();
        $get_data = array();
        foreach ($departments as $key => $value) {
            $get['key'] = $key;
            $get['value'] = $value;
            $get_data[] = $get;
        }
        echo json_encode(array("status" => true, "data" => $get_data, "msg" => "Success"));die;
    }
    public function manage_document_structure()
    {
        $sess = $this->session->userdata();
        $data['title'] = 'Manage Document Structure';
        $data['userId'] = $sess['id'];
        $data['isAdmin'] = $sess['isAdmin'];
        $data['document_list'] = $this->Documents_model->document_list();
        $data['module'] = "employee";
        $data['page'] = "document_structure_manage";
        echo Modules::run('template/layout', $data);
    }
    public function delete_document($id)
    {
        redirect();
        $this->Documents_model->document_delete($id);
        $this->session->set_flashdata('message', "Successfully Deleted");
        redirect("employee/Employees/manage_360_reviews/");
    }
    public function edit_document($id)
    {
        // echo "Obaidrehman07"; die;
        /*-----------------------------------*/
        $this->form_validation->set_rules('department_name', "Department name cannot be blanked!", 'required|max_length[50]');
        #------------------------#
        $sess = $this->session->userdata();
        if ($this->form_validation->run()) {
            $data['user'] = (object) $userLevelData = array(
                'name' => $this->input->post('department_name'),
                'status' => 1,
                'created_at' => date("Y-m-d H:i:s", strtotime("now")),
                'created_by' => $sess['id'],
            );
            if ($this->Documents_model->document_create($userLevelData, $_POST)) {
                $this->session->set_flashdata('message', display('save_successfully'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees_documents/manage_document_structure/");
        } else {
            $required_status[0] = "Optional";
            $required_status[1] = "Mandatory";
            $data['title'] = "Document Structure";
            $data['empl'] = $this->Department_model->department_dropdown();
            $data['get_document'] = $this->Documents_model->get_document($id);
            $data['get_document_fields'] = $this->Documents_model->get_document_fields($id);
            $data['required_status'] = $required_status;
            //         echo "<pre>"; print_r($data['get_document_fields']); die;
            $data['module'] = "employee";
            $data['page'] = "document_structure_edit";
            echo Modules::run('template/layout', $data);
        }
    }
    public function types()
    {
        if ($this->input->post() && $this->input->is_ajax_request() && $this->permission->method('employee_document_types', 'read')->access()) {
            $this->save_type();return;
        }
        $this->permission->method('employee_document_types', 'read')->redirect();
        $data['title'] = display('employee_document_types');
        $data['types'] = $this->Documents_model->document_types();
        $data['module'] = "employee";
        $data['page'] = "document_types";
        echo Modules::run('template/layout', $data);
    }
    public function get_type()
    {
        $data['error'] = 'No type found';
        if ($this->input->post('id')) {
            $res = $this->Documents_model->document_types($this->input->post('id'));
            if ($res) {
                $data['success'] = $res;
            }
        }
        sendJson($data);
    }
    public function delete_type($id)
    {
        if ($this->Documents_model->document_type_delete($id)) {
            $this->session->set_flashdata('success', 'Document Type is deleted successfully');
        } else {
            $this->session->set_flashdata('exception', 'Unable to delete document type at this moment, try again later');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    private function save_type()
    {
        $rules_config = array(
            array(
                'field' => 'title',
                'label' => 'Type Name',
                'rules' => 'trim|required',
            ),
            array(
                'field' => 'is_required',
                'label' => 'Required',
                'rules' => 'trim|required|in_list[yes,no]',
            ),
            array(
                'field' => 'has_deadline',
                'label' => 'Required',
                'rules' => 'trim|required|in_list[yes,no]',
            ),
        );
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === false) {
            $form_errs = [];
            foreach ($_POST as $key => $value) {
                $f_err = form_error($key);
                if ($f_err) {
                    $form_errs[] = [$key, $f_err];
                }
            }
            sendJson(['errors' => $form_errs]);
        }
        $dupe_title_check = getByWhere('upload_documents_type', 'id', ['title' => $this->input->post('title'), 'id <>' => $_POST['id'] ?? 0]);
        if ($dupe_title_check) {
            sendJson(['errors' => [['title', sprintf('Document type with name \'%s\' already exists', $this->input->post('title'))]]]);
        }
        if ($this->Documents_model->document_type_save($this->input->post())) {
            $this->session->set_flashdata('success', empty($this->input->post('id')) ? 'Document type is added successfully' : 'Document type is updated successfully');
            sendJson(['success' => empty($this->input->post('id')) ? 'Document type is added successfully' : 'Document type is updated successfully', 'reload' => true]);
        }
        sendJson(['error' => 'Unable to perform this action, try again']);
    }
    public function pending()
    {
        $this->permission->method('employee_documents_pending', 'read')->redirect();
        if ($this->input->post() && $this->permission->method('employee_documents_pending', 'update')->access()) {
            $this->process_document();
        }
        $data['title'] = display('employee_documents_pending');
        $data['documents'] = $this->Documents_model->get_pending();
        $data['module'] = "employee";
        $data['page'] = "pending_documents";
        echo Modules::run('template/layout', $data);
    }
    private function process_document()
    {
        $rules_config = array(
           array(
              'field' => 'id',
              'label' => 'ID',
              'rules' => 'trim|required|is_natural',
           ),
           array(
              'field' => 'type',
              'label' => 'Type',
              'rules' => 'required|in_list[approve,reject]',
            ),
        );
        if($this->input->post('type') == 'reject') {
            $rules_config[] =  array(
               'field' => 'remarks',
               'label' => 'Rejection Reason',
               'rules' => 'trim|required|min_length[5]|max_length[100]',
            );
        }
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === true) {
            $doc_rec = $this->Documents_model->get_by_id($this->input->post('id'));
            $res = $this->Documents_model->process_document($this->input->post('id'), $this->input->post('type'), $this->input->post('remarks'));

            if($res) {
                $this->session->set_flashdata('success', sprintf(
                    'Document "%s" of "%s (%s)" is %s.',
                    $doc_rec->title,
                    $doc_rec->employee_name,
                    $doc_rec->hrm_id,
                    $this->input->post('type') == 'approve' ? 'approved' : 'rejected',
                ));
            } else {
                $this->session->set_flashdata('exception', sprintf(
                    'Unable to %s document "%s" of "%s (%s)". Try again later!',
                    $this->input->post('type') == 'approve' ? 'approve' : 'reject',
                    $doc_rec->title,
                    $doc_rec->employee_name,
                    $doc_rec->hrm_id,
                ));
            }
        } else {
            $this->session->set_flashdata('exception', validation_errors());
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function upload()
    {
        if ($this->input->post() && $this->input->is_ajax_request()) {
            $this->upload_ajax();
        }
        $data['title'] = display('employee_documents');
        $data['module'] = "employee";
        $data['page'] = "employee_self_doc_upload";
        $data['documents'] = $this->Documents_model->get_missing_documents($this->session->userdata('employee_id'));
        echo Modules::run('template/layout', $data);
    }
    public function upload_ajax()
    {
        $config['upload_path'] = './assets/employee_documents/';
        $config['allowed_types'] = 'jpeg|jpg|png|pdf|doc|docx|xls|xlsx';
        $config['file_ext_tolower'] = true;
        $config['max_size'] = 2048;

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload('file')) {
            sendJson(array('error' => strip_tags($this->upload->display_errors())));
        } else {
            $doc_rec = $this->db->where('id', $this->input->post('id'))->get('upload_documents')->row();
            $url_segment = 'my';
            if ($doc_rec->employee_id != $this->session->userdata('employee_id')) {
                $url_segment = 'emp';
            }
            $data = $this->upload->data();
            if ($data) {
                if ($this->input->post('id') && $this->Documents_model->upload_missing($this->input->post('id'), $data['file_name'])) {
                    sendJson(['success' => base_url("employee/document/{$url_segment}/") . urlencode($data['file_name'])]);
                }
            }
        }
        sendJson(['error' => 'Unable to upload file, try again later']);
    }
    public function upload_ajax_multi()
    {
        $config['upload_path'] = './assets/employee_documents/';
        $config['allowed_types'] = 'jpeg|jpg|png|pdf|doc|docx|xls|xlsx';
        $config['file_ext_tolower'] = true;
        $config['max_size'] = 2048;

        $this->load->library('upload', $config);

        $response = [];
        $this->db->trans_begin();
        foreach ($_FILES as $fieldname => $fileObject)
        {
            if (!empty($fileObject['name'])) {
                $this->upload->initialize($config);
                if (!$this->upload->do_upload($fieldname)) {
                    $response = ['errors' => [[$fieldname, strip_tags($this->upload->display_errors())]]];
                    break;
                } else {
                    $id = @explode('_', $fieldname)[1];
                    $data = $this->upload->data();
                    if ($data) {
                        $res = $this->db->where('id', $id)->update('upload_documents', [
                            'documents' => $data['file_name'],
                            'status' => 'uploaded',
                            'rejection_reason' => null
                        ]);
                        if ($res) {
                            if(!isset($response['success'])) {
                                $response = ['success' => []];
                            }
                            $response['success'][] = [$id, base_url("employee/document/my/") . urlencode($data['file_name'])];
                        }
                    }
                }
            }
        }
        if ($this->db->trans_status() === true && isset($response['success'])) {
            $this->db->trans_commit();
            $this->Documents_model->check_for_missing_documents($this->session->userdata('employee_id'));
            $this->notify->department('hr')->send(
                sprintf(
                    'Documents uploaded by %s %s (%s) need your approval',
                    $this->session->userdata('first_name'),
                    $this->session->userdata('last_name'),
                    $this->session->userdata('hrm_id'),
                ),
                'employee/Employees_documents/pending'
            );
        } else {
            $this->db->trans_rollback();
            if(!isset($response['errors'])){
                $response = ['error' => 'Unable to add documents, try again later'];
            }
        }
        sendJson($response);
    }
}
