<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Employees extends Loggedin_Controller
{
    private $_active_creds = [];
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'Employees_model',
            'dashboard/User_model',
            'Country_model',
            'fields_model'
        ));
        $this->load->library(['excel']);
    }
    public function cv()
    {
        $data['title'] = display('view details');
        $data['custom_module_name'] = 'Employee Details';
        $id = $this->session->userdata('employee_id');

        if ($this->permission->full('employee')->access() || $this->permission->method('manage_employee', 'read')->access()) {
            $id = $this->uri->segment(4) ?? $id;
        } elseif ($this->session->userdata('supervisor') == 1 && in_array($this->uri->segment(4), array_column($this->Employees_model->get_subordinates(), 'employee_id'))) {
            $id = $this->uri->segment(4);
        }

        $data['row'] = $this->Employees_model->employee_details($id);
        $data['pending_data'] = $this->fields_model->get($id);
        $data['probation_extensions'] = $this->Employees_model->extension_records($id);
        $data['edu'] = $this->Employees_model->updateedu($id);
        $this->load->model('incident/incident_model');
        $data['incidents'] = $this->incident_model->get_employee_incidents($id, 'approved');
        $data['benifit'] = $this->Employees_model->benifit($id);
        $data['award'] = $this->Employees_model->award($id);
        $data['perform'] = $this->Employees_model->performance($id);
        $data['employee_leaves'] = $this->Employees_model->employee_leaves($id);
        $data['module'] = "employee"; //
        $data['page'] = "resumepdf";
        echo Modules::run('template/layout', $data);
    }
    public function cv_print()
    {
        $data['title'] = display('view details');
        $id = $this->session->userdata('employee_id');

        if ($this->permission->full('employee')->access() || $this->permission->method('manage_employee', 'read')->access()) {
            $id = $this->uri->segment(4) ?? 1;
        } elseif ($this->session->userdata('supervisor') == 1 && in_array($this->uri->segment(4), array_column($this->Employees_model->get_subordinates(), 'employee_id'))) {
            $id = $this->uri->segment(4);
        }
        $data['row'] = $this->Employees_model->employee_details($id);
        $data['probation_extensions'] = $this->Employees_model->extension_records($id);
        $data['edu'] = $this->Employees_model->updateedu($id);
        $data['benifit'] = $this->Employees_model->benifit($id);
        $data['award'] = $this->Employees_model->award($id);
        $this->load->model('incident/incident_model');
        $data['incidents'] = $this->incident_model->get_employee_incidents($id, 'approved');
        $data['perform'] = $this->Employees_model->performance($id);
        $data['employee_leaves'] = $this->Employees_model->employee_leaves($id);
        $data['module'] = "employee"; //
        $data['page'] = "resumepdf-print";
        $this->load->view('resumepdf-print', $data);
    }
    public function cv_pdf()
    {
        $data['title'] = display('view details');
        $id = $this->session->userdata('employee_id');

        if ($this->session->userdata('isAdmin') == 1 || $this->permission->full('employee')->access()) {
            $id = $this->uri->segment(4) ?? 1;
        } elseif ($this->session->userdata('supervisor') == 1 && in_array($this->uri->segment(4), array_column($this->Employees_model->get_subordinates(), 'employee_id'))) {
            $id = $this->uri->segment(4);
        }
        $data['row'] = $this->Employees_model->employee_details($id);
        $data['edu'] = $this->Employees_model->updateedu($id);
        $data['benifit'] = $this->Employees_model->benifit($id);
        $data['award'] = $this->Employees_model->award($id);
        $data['perform'] = $this->Employees_model->performance($id);
        $data['employee_leaves'] = $this->Employees_model->employee_leaves($id);
        $data['module'] = "employee"; //
        $data['page'] = "resumepdf-print";
        $this->load->library('pdfgenerator');
        $this->pdfgenerator->generate($this->load->view('resumepdf-print', $data, true), 'employee-' . $data['row']->hrm_id . '-pdf', true);
    }
    public function viewEmhistory()
    {
        redirect('employee/employees/create_employee');
        $this->permission->method('add_employee', 'create')->redirect();
        // $this->permission->module('employee','read')->redirect();
        $data['title'] = display('view_salary_setup');
        $data['emp_history'] = $this->Employees_model->emp_historyview();
        $data['module'] = "employee";
        $data['designation'] = $this->Employees_model->designation();
        $data['dropdowndept'] = $this->Employees_model->dropdowndept();
        $data['supervisor'] = $this->Employees_model->supervisorlist();
        //         $data['country_list'] = $this->Country_model->state('Pakistan');
        $data['country_list'] = array('Pakistan' => 'Pakistan');
        $data['leave_type'] = $this->Employees_model->leave_type();
        $data['page'] = "employ_form";
        $data['dropdowndev'] = $this->db->select('*')->from('divisions')->order_by('id', 'desc')->get()->result();
        $data['shift'] = $this->db->get('shift')->result();
        $data['benefits'] = $this->db->select('*')->from('salary_addition')->order_by('id', 'desc')->get()->result();
        $data['document_types'] = getByWhere('upload_documents_type', '*', [], ['title', 'ASC']);
        echo Modules::run('template/layout', $data);
    }
    public function manageemployee()
    {
        if($this->input->post()) {
            $this->getmanageemployeedatatable();
        }
        if ($this->permission->method('manage_employee', 'read')->access() || $this->session->userdata('supervisor') == 1) {
            $data['title'] = display('view_salary_setup');
            $data['module'] = "employee";
            $data['page'] = "employee_view";
            $this->load->model('Employee_ajax_model');
            $data['columns'] = $this->Employee_ajax_model->view_columns();
            $data['search_columns'] = $this->Employee_ajax_model->search_columns();
            $data['encrypted_cols'] = $this->config->item('encrypted_columns')['employee_history'];
            echo Modules::run('template/layout', $data);
        } else {
            redirect("employee/Employees/cv");
        }
    }
    private function getmanageemployeedatatable()
    {
        $this->load->model('Employee_ajax_model');
        $bool_cols = $this->Employee_ajax_model->get_bool_cols();
        $date_cols = $this->Employee_ajax_model->get_date_cols();
        $alt_cols = $this->Employee_ajax_model->get_alt_cols();
        $encrypted_cols = $this->config->item('encrypted_columns')['employee_history'];

        $search_arr = [];
        $search_columns = [];
        $employees = [];
        $search_data = $this->input->post('search');
        if (!empty(@$search_data['value']) && !empty(@$search_data['column'])) {
            if(in_array($search_data['column'], $encrypted_cols)) {
                $employees = $this->Employee_ajax_model->search_encrypted($search_data['column'], $search_data['value']);
                if(empty($employees)) {
                    $employees = null;
                }
            } else {
                if(in_array($search_data['column'], $bool_cols)) {
                    $search_data['value'] = strtolower(trim($search_data['value'])) == 'yes' ? '1' : '0';
                }
                if(in_array($search_data['column'], $date_cols)) {
                    $search_data['value'] = sql_date(trim($search_data['value']), true);
                }
                if(isset($alt_cols[$search_data['column']])) {
                    $search_columns = $alt_cols[$search_data['column']]['raw'];
                } else {
                    $search_columns = ['p.' . $search_data['column']];
                }
                foreach ($search_columns as $value) {
                    if(in_array($search_data['column'], $bool_cols) || in_array($search_data['column'], $date_cols)) {
                        $search_arr[$value] = $search_data['value'];
                    } else {
                        $search_arr[$value] = preg_replace('@\s+@', '%', $search_data['value']);
                        $search_arr[$value] .= '%';
                    }
                }
                $search_arr = array_filter($search_arr);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->Employee_ajax_model->countAllRows();
        $out_arr["recordsFiltered"] = $this->Employee_ajax_model->countDatatable($search_arr, $employees);
        $rows = $this->Employee_ajax_model->getDatatable($search_arr, $employees);

        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'status': {
                        $tdData = slug_to_readable($rec[$col['data']]);
                        break;
                    }
                    case 'cnic': {
                        $tdData = cnic_with_dashes($rec[$col['data']]);
                        break;
                    }
                    case 'picture': {
                        $tdData = '<img src="' . base_url(empty($rec['picture']) ? 'assets/img/icons/default.jpg' : ltrim($rec['picture'], './')) . '" alt="Image" height="64" >';
                        break;
                    }
                    case 'action':{
                            $tdData = '';
                            if($this->permission->method('manage_employee','update')->access()) {
                                $tdData .= '<a  title="Edit Employee"  href="'. base_url("employee/Employees/update_employee_form/" . $rec['employee_id']) .'" class="btn btn-xs btn-success"><i class="fa fa-pencil"></i></a>';
                            }
                            if($this->permission->method('manage_employee','delete')->access()) {
                                $tdData .= '&nbsp<a  title="Delete Employee" data-name="' . sprintf('%s %s (%s)', $rec['first_name'], $rec['last_name'], $rec['hrm_id']) . '" data-id="' . $rec['employee_id'] . '"  href="#" class="btn btn-xs btn-danger btn-delete"><i class="fa fa-trash"></i></a>';
                            }
                            if($this->permission->method('employee_document_permission', 'create')->access() || $this->permission->method('employee_document_permission', 'read')->access() || $this->permission->method('employee_document_permission', 'update')->access()) {
                                $tdData .= '&nbsp<a title="Upload Document"  href="' . base_url("employee/Employees/documents_update/" . $rec['employee_id']) . '" class="btn btn-default btn-xs"><i class="fa fa-file"></i></a>';
                            }
                            $tdData .= '&nbsp<a   title="Employee Information"  href="' . base_url("employee/Employees/cv/" . $rec['employee_id']) .'" class="btn btn-default btn-xs"><i class="fa fa-user"></i></a>';
                            break;
                        }
                    default:{
                            if(in_array($col['data'], $bool_cols)) {
                                $rec[$col['data']] = $rec[$col['data']] ? 'Yes' : 'No';
                            }
                            if(in_array($col['data'], $date_cols)) {
                                $rec[$col['data']] = formatted_date($rec[$col['data']]);
                            }
                            if(isset($alt_cols[$col['data']])) {
                                $rec[$col['data']] = $rec[$alt_cols[$col['data']]['final']];
                            }
                            if(empty(trim($rec[$col['data']]))) {
                                $rec[$col['data']] = '-';
                            }
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function documents_update($id)
    {
        if (!($this->permission->method('employee_document_permission', 'read')->access() || $this->permission->method('employee_document_permission', 'create')->access() || $this->permission->method('employee_document_permission', 'update')->access())) {
            redirect();
        }
        $data['title'] = 'Employee Documents';
        $data['module'] = "employee";
        $data['page'] = "employee_documents";
        $data['id'] = $id;
        $data['document_types'] = getByWhere('upload_documents_type', '*', [], ['title', 'ASC']);
        $documents = $this->db->select('upload_documents.*, edt.title as document_type')
            ->from('upload_documents')
            ->join('upload_documents_type edt', 'edt.id = upload_documents.document_type')
            ->where('upload_documents.employee_id', $id)
            ->where_not_in('upload_documents.status', ['uploaded'])
            ->get()
            ->result();
        $data['result'] = $documents;
        echo Modules::run('template/layout', $data);
    }
    public function trash_document($id, $emp)
    {
        $this->permission->method('employee_document_permission', 'delete')->redirect();
        $where = ['id' => $id, 'employee_id' => $emp];
        $document = $this->db->select('*')->from('upload_documents')->where($where)->get()->first_row()->documents;
        $this->db->where($where);
        if ($this->db->delete('upload_documents')) {
            $this->activity->set_url('employee/Employees/documents_update/' . $emp)->log([
                'employee_document_removed',
                $document,
            ], $emp, 'employee', 'employee_history');
            $file_path = base_url() . '/assets/employee_documents/' . $document;
            if (file_exists($file_path)) {
                unlink($file_path);
            }
            $this->session->set_flashdata('message', 'deleted successfully');
        } else {
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("employee/Employees/documents_update/$emp");
    }
    public function trash_document_ajax()
    {
        $this->permission->method('employee_document_permission', 'delete')->redirect();
        $document = $this->db->select('*')->from('upload_documents')->where('id', $_POST['id'])->get()->first_row();
        if ($document) {
            $res = $this->db->where('id', $_POST['id'])->delete('upload_documents');
            if ($res) {
                $file_path = base_url() . '/assets/employee_documents/' . $document->documents;
                @unlink($file_path);

                $this->activity->set_url('employee/Employees/documents_update/' . $document->employee_id)->log([
                    'employee_document_removed',
                    $document->documents,
                ], $document->employee_id, 'employee', 'employee_history');
                sendJson(['success' => $document->id]);
            }
        }
        sendJson(['error' => 'Error while deleting file. try again later']);
    }
    public function uploadDocumentsAjax()
    {
        $this->permission->method('employee_document_permission', 'create')->redirect();
        $post = $this->input->post();
        // Set preference
        $config['upload_path'] = 'assets/employee_documents/';
        $config['file_name'] = @pathinfo($_FILES['file']['name'], PATHINFO_FILENAME) . '-' . time();
        $config['allowed_types'] = 'gif|jpg|jpeg|png|iso|dmg|zip|rar|doc|docx|xls|xlsx|ppt|pptx|csv|ods|odt|odp|pdf|rtf|sxc|sxi|txt|exe|avi|mpeg|mp3|mp4|3gp|svg';
        $config['max_size'] = '50000'; // max_size in kb
        //Load upload library
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        // File upload
        if ($this->upload->do_upload('file')) {
            // Get data about the file
            $uploadData = $this->upload->data();
            $filename = $uploadData['file_name'];
            // Initialize array
            $data['documents'] = $filename;
            $data['document_type'] = $post['document_type'];
            $data['employee_id'] = $post['employee_id'];
            $data['created_date'] = date('Y-m-d');
            $res = $this->db->insert('upload_documents', $data);
            if ($res) {
                $res = $this->db->insert_id();
                $this->activity->set_url('employee/Employees/documents_update/' . $post['employee_id'])->log([
                    'employee_document_added',
                    $filename,
                ], $post['employee_id'], 'employee', 'employee_history');
                sendJson([
                    'success' => @getByWhere(
                        'upload_documents,
						upload_documents_type-upload_documents.document_type=upload_documents_type.id-left',
                        'upload_documents.*, upload_documents_type.title as type_title',
                        ['upload_documents.id' => $res]
                    )[0],
                ]);
            } else {
                sendJson(['error' => 'Error uploading file try again later']);
            }
        } else {
            $error = array('error' => $this->upload->display_errors());
            sendJson($error);
        }
    }
    public function uploadDocuments($id)
    {
        $this->permission->method('employee_document_permission', 'create')->redirect();
        $post = $this->input->post();
        if (isset($post)) {
            $rules_config = array(
               array(
                  'field' => 'document_type',
                  'label' => 'Document Type',
                  'rules' => 'trim|required|is_natural',
               ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                $data = array();
                // Count total files
                $countfiles = count($_FILES['files']['name']);
                //  $this->upload_files('assets/employee_documents/', 'images', $_FILES['files[]']);
                // Looping all files
                for ($i = 0; $i < $countfiles; $i++) {
                    if (!empty($_FILES['files']['name'][$i])) {
                        // Define new $_FILES array - $_FILES['file']
                        $_FILES['file']['name'] = $_FILES['files']['name'][$i];
                        $_FILES['file']['type'] = $_FILES['files']['type'][$i];
                        $_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
                        $_FILES['file']['error'] = $_FILES['files']['error'][$i];
                        $_FILES['file']['size'] = $_FILES['files']['size'][$i];
                        // Set preference
                        $config['upload_path'] = 'assets/employee_documents/';
                        $config['allowed_types'] = 'gif|jpg|jpeg|png|iso|dmg|zip|rar|doc|docx|xls|xlsx|ppt|pptx|csv|ods|odt|odp|pdf|rtf|sxc|sxi|txt|exe|avi|mpeg|mp3|mp4|3gp|svg';
                        $config['max_size'] = '50000'; // max_size in kb
                        $config['file_name'] = $_FILES['files']['name'][$i];
                        //Load upload library
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        // File upload
                        if ($this->upload->do_upload('file')) {
                            // Get data about the file
                            $uploadData = $this->upload->data();
                            $filename = $uploadData['file_name'];
                            // Initialize array
                            $data['documents'] = $filename;
                            $data['document_type'] = $post['document_type'];
                            $data['employee_id'] = $id;
                            $data['created_date'] = date('Y-m-d');
                            $this->activity->set_url('employee/Employees/documents_update/' . $id)->log([
                                'employee_document_added',
                                $filename,
                            ], $post['employee_id'], 'employee', 'employee_history');
                            $this->db->insert('upload_documents', $data);
                        } else {
                            $error = array('error' => $this->upload->display_errors());
                            $this->session->set_flashdata('exception', $error['error']);
                            redirect("employee/Employees/documents_update/$id");
                        }
                    }
                }
                $this->session->set_flashdata('message', display('successfully_saved'));
            }else{
                $this->session->set_flashdata('exception', validation_errors());                
            }
            redirect("employee/Employees/documents_update/$id");
        }
    }
    public function create_employee()
    {
        $this->permission->method('add_employee', 'create')->redirect();
        if($this->input->post()) {
            $this->form_validation->set_rules('first_name', display('first_name'), 'max_length[50]');
            $this->load->library('myupload');
            $img = $this->myupload->do_upload(
                './application/modules/employee/assets/images/',
                'picture'
            );
            $this->form_validation->set_rules('c_f_name[]', 'Custom Field Name');
            $this->form_validation->set_rules('c_f_type[]', 'Custom Field Type');
            $this->form_validation->set_rules('customvalue[]', 'Custom Value');
            $employee_h = $this->db->select('employee_id')
                ->from('employee_history')
                ->order_by('emp_his_id', 'desc')
                ->get()
                ->row();
            if ($employee_h) {
                $max_id = $employee_h->employee_id;
                $employee_id = $max_id + 1;
            } else {
                $employee_id = 1;
            }
            //print_r($employee_id);exit();
            $customr_field = $this->input->post('c_f_name');
            $customr_field_type = $this->input->post('c_f_type');
            $customr_value = $this->input->post('customvalue');
            $benifit_code = $this->input->post('benefit_id', true);
            $benifit_code_desc = $this->input->post('benifit_c_code_d', true);
            $benifit_acc_date = $this->input->post('benifit_acc_date', true);
            //print_r($benifit_acc_date);exit();
            $benift_status = $this->input->post('benifit_sst', true);
            #-------------------------------#
            if ($this->form_validation->run() === true) {
                $this->load->library('myupload');
                if ($this->input->post('gender') == 3 && !empty(trim($this->input->post('other_gender')))) {
                    $this->db->insert('gender', [
                        'gender_name' => trim($this->input->post('other_gender')),
                    ]);
                    $_POST['gender'] = $this->db->insert_id();
                    $this->activity->log([
                        'gender_inserted',
                        trim($this->input->post('other_gender')),
                    ]);
                }
                if ($this->input->post('marital_status') == 5 && !empty(trim($this->input->post('other_marital')))) {
                    $this->db->insert('marital_info', [
                        'marital_sta' => trim($this->input->post('other_marital')),
                    ]);
                    $_POST['marital_status'] = $this->db->insert_id();
                    $this->activity->log([
                        'marital_status_inserted',
                        trim($this->input->post('other_marital')),
                    ]);
                }
                $postData = [
                    'employee_id' => $employee_id,
                    'pos_id' => $this->input->post('pos_id', true),
                    'hrm_id' => $this->input->post('hrm_id', true),
                    'status' => $this->input->post('status', true),
                    'first_name' => $this->input->post('first_name', true),
                    'middle_name' => $this->input->post('middle_name', true),
                    'last_name' => $this->input->post('last_name', true),
                    'maiden_name' => $this->input->post('maiden_name'),
                    'father_name' => $this->input->post('father_name'),
                    'email' => $this->input->post('email', true),
                    'phone' => $this->input->post('phone', true),
                    'alter_phone' => $this->input->post('alter_phone', true),
                    'present_address' => $this->input->post('present_address', true),
                    'parmanent_address' => $this->input->post('parmanent_address', true),
                    'work_from_home' => $this->input->post('work_from_home') ? 1 : 0,
                    'transportation_required' => $this->input->post('transportation_required') ? 1 : 0,
                    'picture' => $img,
                    'dept_id' => $this->input->post('department', true),
                    'division_id' => $this->input->post('division', true),
                    'state' => $this->input->post('state', true),
                    'city' => $this->input->post('city', true),
                    'zip' => $this->input->post('zip_code', true),
                    'citizenship' => $this->input->post('citizenship', true),
                    'duty_type' => $this->input->post('duty_type', true),
                    'hire_date' => empty($this->input->post('hiredate', true)) ? null : date('Y-m-d', strtotime($this->input->post('hiredate', true))),
                    'original_hire_date' => empty($this->input->post('ohiredate', true)) ? null : date('Y-m-d', strtotime($this->input->post('ohiredate', true))),
                    'termination_date' => empty($this->input->post('terminatedate', true)) ? null : date('Y-m-d', strtotime($this->input->post('terminatedate', true))),
                    'termination_reason' => htmlspecialchars($this->input->post('termreason', true)),
                    'exit_interview' => $this->input->post('exit_interview') == '1' ? 1 : 0,
                    'exit_interview_date' => empty($this->input->post('exit_interview_date', true)) ? null : date('Y-m-d', strtotime($this->input->post('exit_interview_date'))),
                    'exit_interview_details' => htmlspecialchars($this->input->post('exit_interview_date', true)),
                    'voluntary_termination' => $this->input->post('volunt_termination', true),
                    'rehire_date' => empty($this->input->post('rehiredate', true)) ? null : date('Y-m-d', strtotime($this->input->post('rehiredate', true))),
                    'rate_type' => $this->input->post('rate_type', true),
                    'pay_frequency' => $this->input->post('pay_frequency', true),
                    'pay_frequency_txt' => $this->input->post('pay_f_text', true),
                    'hourly_rate2' => $this->input->post('h_rate2', true),
                    'hourly_rate3' => $this->input->post('h_rate3', true),
                    'home_department' => $this->input->post('h_department', true),
                    'department_text' => $this->input->post('h_dep_text', true),
                    'class_code' => $this->input->post('c_code', true),
                    'class_code_desc' => $this->input->post('c_code_d', true),
                    'class_acc_date' => date("Y-m-d", strtotime(!empty($this->input->post('class_acc_date', true)) ? $this->input->post('class_acc_date', true) : date('Y-m-d'))),
                    'class_status' => $this->input->post('class_sst', true),
                    'is_super_visor' => $this->input->post('is_supervisor', true),
                    'super_visor_id' => $this->input->post('supervisorname', true),
                    'indirect_super_visor_id' => $this->input->post('indirect_supervisorname', true),
                    'supervisor_report' => $this->input->post('reports', true),
                    'dob' => date("Y-m-d", strtotime(!empty($this->input->post('dob', true)) ? $this->input->post('dob', true) : date('Y-m-d'))),
                    'gender' => $this->input->post('gender', true),
                    'marital_status' => $this->input->post('marital_status', true),
                    'ethnic_group' => $this->input->post('ethnic', true),
                    'eeo_class_gp' => $this->input->post('eeo_class', true),
                    'cnic' => preg_replace('@[^\d]@', '', $this->input->post('cnic')),
                    'eobi_check' => ($this->input->post('eobi_check', true) ? 1 : 0),
                    'work_in_state' => $this->input->post('w_s', true),
                    'live_in_state' => $this->input->post('l_in_s', true),
                    'home_email' => $this->input->post('h_email', true),
                    'business_email' => $this->input->post('b_email', true),
                    'home_phone' => $this->input->post('h_phone', true),
                    'business_phone' => $this->input->post('w_phone', true),
                    'cell_phone' => $this->input->post('c_phone', true),
                    'emerg_contct' => $this->input->post('emerg_contct', true),
                    'emrg_h_phone' => $this->input->post('e_h_phone', true),
                    'emrg_w_phone' => $this->input->post('e_w_phone', true),
                    'emgr_contct_relation' => $this->input->post('e_c_relation', true),
                    'alt_em_contct' => $this->input->post('alt_em_cont', true),
                    'alt_emg_h_phone' => $this->input->post('a_e_h_phone', true),
                    'alt_emg_w_phone' => $this->input->post('a_e_w_phone', true),
                    'shift' => $this->input->post('shift', true),
                    'probation_period' => $this->input->post('probation_period', true),
                    'performance_duration' => $this->input->post('performance_duration', true),
                    'prefix' => $this->input->post('prefix', true),
                    'primary_project' => $this->input->post('primary_project', true),
                    'team' => $this->input->post('team', true),
                    'campaign' => $this->input->post('campaign', true),
                    'pseudo' => $this->input->post('pseudo', true),
                    'medflow_id' => $this->input->post('medflow_id', true),
                    'skype_id' => $this->input->post('skype_id', true),
                    'replacement' => $this->input->post('replacement', true),
                    'degree_name' => $this->input->post('degree_name', true),
                    'passing_year' => empty($this->input->post('passing_year')) ? null : date('Y-m-d', strtotime($this->input->post('passing_year'))),
                    'cgp' => $this->input->post('cgp', true),
                    'institute_name' => $this->input->post('institute_name', true),
                    'last_employer' => $this->input->post('last_employer', true),
                    'last_employer_address' => htmlspecialchars($this->input->post('last_employer_address', true)),
                    'account_title' => $this->input->post('account_title', true),
                    'account_number' => $this->input->post('account_number', true),
                    'branch_code' => $this->input->post('branch_code', true),
                    'branch_address' => htmlspecialchars($this->input->post('branch_address', true)),
                ];
                if($this->permission->method('employee_salary_permission', 'update')->access()){
                    $postData['rate'] = $this->input->post('rate', true);
                    $postData['current_salary'] = $this->input->post('current_salary', true);
                    $postData['hired_salary'] = $this->input->post('hired_salary', true);
                    $postData['first_salary'] = $this->input->post('first_salary', true);
                    $postData['second_salary'] = $this->input->post('second_salary', true);
                    $postData['third_salary'] = $this->input->post('third_salary', true);
                }
                //print_r($postData);exit();
                $coa = $this->Employees_model->headcode();
                if ($coa->HeadCode != null) {
                    $headcode = $coa->HeadCode + 1;
                } else {
                    $headcode = "502020000001";
                }
                $c_code = $employee_id;
                $c_name = $this->input->post('first_name') . $this->input->post('last_name');
                $c_acc = $c_code . '-' . $c_name;
                $createby = $this->session->userdata('fullname');
                $createdate = date('Y-m-d H:i:s');
                $data['aco'] = (Object) $coaData = [
                    'HeadCode' => $headcode,
                    'HeadName' => $c_acc,
                    'PHeadName' => 'Account Payable',
                    'HeadLevel' => '2',
                    'IsActive' => '1',
                    'IsTransaction' => '1',
                    'IsGL' => '0',
                    'HeadType' => 'L',
                    'IsBudget' => '0',
                    'IsDepreciation' => '0',
                    'DepreciationRate' => '0',
                    'CreateBy' => $createby,
                    'CreateDate' => $createdate,
                ];
                if(!$this->Employees_model->hrm_id_exists($postData['hrm_id'])){
                    if(!$this->Employees_model->employee_email_exists($postData['email'])) {
                        if(!$this->Employees_model->user_email_exists($postData['email'])) {
                            $employee_id = $this->Employees_model->create_employee($postData);
                            if ($employee_id) {
                                $this->activity->set_employee($employee_id)->set_url('employee/Employees/cv/' . $employee_id)->log('employee_created', $employee_id, 'employee', 'employee_history');
                                $this->db->where('employee_id', $employee_id)->delete('emp_salary_setup_details');
                                foreach ($_POST['addition'] as $key => $value) {
                                    $addition = [];
                                    $addition['addition_id'] = $key;
                                    $addition['employee_id'] = $employee_id;
                                    $addition['value'] = $value;
                                    $addition['created_on'] = date('Y-m-d');
                                    if (!empty($addition['addition_id']) && !empty($addition['value'])) {
                                        $this->db->insert('emp_salary_setup_details', $addition);
                                    }
                                }
                                foreach ($_POST['deduction'] as $key => $value) {
                                    $deduction['deduction_id'] = $key;
                                    $deduction['employee_id'] = $employee_id;
                                    $deduction['value'] = $value;
                                    $deduction['created_on'] = date('Y-m-d');
                                    if (!empty($deduction['deduction_id']) && !empty($deduction['value'])) {
                                        $this->db->insert('emp_salary_setup_details', $deduction);
                                    }
                                }
                                // $insertLeave['emp_id'] = $employee_id;
                                $insertLeave['emp_id'] = $employee_id;
                                $employeeType = $this->input->post('leave_type', true);
                                $employeeQuote = $this->input->post('leave_qouta', true);
                                for ($i = 0; $i < count($employeeType); $i++) {
                                    $insertLeave['leave_type'] = $employeeType[$i];
                                    $insertLeave['leave_qouta'] = $employeeQuote[$i];
                                    if (!empty($employeeType[$i]) && !empty($employeeQuote[$i])) {
                                        $this->db->insert('employee_leaves', $insertLeave);
                                    }
                                }
                                // $insertLeave['leave_type'] = $this->input->post('leave_type',true);
                                // $insertLeave['leave_qouta'] = $this->input->post('leave_qouta',true);
                                // $this->db->insert()
                                //  $zk = new ZKLibrary($device_ip, 4370);
                                //      // echo 'welcome';exit();
                                //          $zk->connect();
                                //          $zk->disableDevice();
                                // $zk->setUser($employee_id, $employee_id, $this->input->post('first_name').' '.$this->input->post('last_name'), '', 0);
                                // $zk->enableDevice();
                                //             $zk->disconnect();
                                $this->Employees_model->create_coa($coaData);
                                for ($i = 0; $i < count($customr_field); $i++) {
                                    //print_r(count($customr_field));exit();
                                    $custom = [
                                        'custom_field' => $customr_field[$i],
                                        'custom_data_type' => $customr_field_type[$i],
                                        'custom_data' => $customr_value[$i],
                                        'employee_id' => $employee_id,
                                    ];
                                    if (!empty($customr_field[$i])) {
                                        $this->db->insert('custom_table', $custom);
                                    }
                                }
                                for ($i = 0; $i < count($benifit_code); $i++) {
                                    if ($benifit_code[$i] !== 'Select Benefits') {
                                        $benifit = [
                                            'bnf_cl_code_des' => $benifit_code_desc[$i],
                                            'bnff_acural_date' => date("Y-m-d", strtotime(!empty($benifit_acc_date[$i]) ? $benifit_acc_date[$i] : date('Y-m-d'))),
                                            'bnf_status' => $benift_status[$i],
                                            'employee_id' => $employee_id,
                                            'benefit_id' => $benifit_code[$i],
                                        ];
                                        // print_r($benefit);
                                        if (!empty($benifit_code[$i])) {
                                            $this->db->insert('employee_benifit', $benifit);
                                        }
                                    } else {
                                    }
                                }
                                $this->load->model('recruitment/selection_model');
                                $this->selection_model->make_required_documents($employee_id);
                                $this->session->set_flashdata('message', display('save_successfully') . ' Please provide below information to complete onboarding process.');
                                redirect('employee/employees/generate_credentials/' . $employee_id);
                            }
                        } else {
                            $this->session->set_flashdata('exception', 'User with this email \'' . $postData['email'] . '\' already exists, choose another');
                        }
                    } else {
                        $this->session->set_flashdata('exception', 'Employee email \'' . $postData['email'] . '\' already exists, choose another');
                    }
                } else {
                    $this->session->set_flashdata('exception', 'HRM ID \'' . $postData['hrm_id'] . '\' already exists, choose another');
                }
            }
        }
        $data['title'] = display('create_employee');
        $data['emp_history'] = $this->Employees_model->emp_historyview();
        $data['module'] = "employee";
        $data['designation'] = $this->Employees_model->designation();
        $data['dropdowndept'] = $this->Employees_model->dropdowndept();
        $data['supervisor'] = $this->Employees_model->supervisorlist();
        //         $data['country_list'] = $this->Country_model->state('Pakistan');
        $data['country_list'] = array('Pakistan' => 'Pakistan');
        $data['leave_type'] = $this->Employees_model->leave_type();
        $data['page'] = "employ_form";
        $data['dropdowndev'] = $this->db->select('*')->from('divisions')->order_by('id', 'desc')->get()->result();
        $data['shift'] = $this->db->get('shift')->result();
        $data['benefits'] = $this->db->select('*')->from('salary_addition')->order_by('id', 'desc')->get()->result();
        $data['document_types'] = getByWhere('upload_documents_type', '*', [], ['title', 'ASC']);
        $data['genders'] = getByWhere('gender', 'id, gender_name as name', [], ['id', 'ASC']);
        $data['marital_statuses'] = getByWhere('marital_info', 'id, marital_sta as name', [], ['id', 'ASC']);
        echo Modules::run('template/layout', $data);
    }
    public function bulk_import()
    {
        $this->permission->method('add_employee_bulk', 'create')->redirect();
        if ($this->input->method() != 'post') {
            $data['title'] = 'Bulk Import Employees';
            $data['module'] = "employee";
            $data['page'] = "bulk_import";
            echo Modules::run('template/layout', $data);return;
        }
        $column_order = [
            'HRM ID',
            'First Name',
            'Middle Name',
            'Last Name',
            'Father Name',
            'HRM Email Address',
            'Phone',
            'Alternative Phone',
            'Country',
            'City',
            'Division',
            'Department',
            'Position',
            'Duty Type',
            'Probation Period (Months)',
            'Shift Type',
            'Hire Date',
            'Original Hire Date',
            'Separation Date',
            'Separation Reason',
            'Voluntary Resignation',
            'Rehire Date',
            'Salary Type',
            'Performance Review Duration',
            'Hired Salary',
            'Salary 1st Raise',
            'Salary 2nd Raise',
            'Salary 3rd Raise',
            'Basic Salary',
            'Gross Salary',
            'Other Allowances',
            'EOBI',
            'EOBI Amount',
            'Is Supervisor',
            'Direct Reporting',
            'Indirect Reporting',
            'Date of birth',
            'Gender',
            'Marital Status',
            'Religion',
            'CNIC',
            'Personal Email',
            'Business Email',
            'Home Phone',
            'Emergency Contact Number',
            'Cell Phone',
            'Present Address',
            'Permanent Address',
            'Work From Home',
            'Transportation Required',
            'Password',
            'Role',
            'Prefix',
            'Primary Project',
            'Team',
            'Campaign',
            'Pseudo',
            'Medflow ID',
            'Skype ID',
            'Hiring In Replacement Of',
            'Qualification',
            'Passing Date',
            'CGPA',
            'Institute',
            'Last Employer',
            'Last Employer Address',
            'Account Title',
            'Account Number',
            'Branch Code',
            'Branch Address',
            'Employee Status',
            'Exit Interview Conducted',
            'Exit Interview Date',
            'Exit Interview Details',
        ];
        $this->load->library('myupload');
        $file = $this->myupload->do_upload(FCPATH . 'uploads/temp/', 'file', true);
        if (!$file) {
            $this->session->set_flashdata('exception', 'File upload failed, try again later!');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $excel_data = $this->excel->read($file);

        $alpha_header = range('A', 'Z');
        //Generate cross multiplication of columns if data is bigger than 25 columns
        $alp_i = 0;
        while (count($alpha_header) < count($excel_data['1'])) {
            $alphabet = $alpha_header[$alp_i];
            $new_range = range('A', 'Z');
            foreach ($new_range as $alp) {
                $alpha_header[] = $alphabet . $alp;
            }
            $alp_i++;
        }
        $alpha_column_order = [];
        foreach ($column_order as $col_num => $col) {
            $alpha_column_order[$col] = $alpha_header[$col_num];
        }

        $header_row = json_decode('{"A":"HRM ID","B":"First Name","C":"Middle Name","D":"Last Name","E":"Father Name","F":"HRM Email Address","G":"Phone","H":"Alternative Phone","I":"Country","J":"City","K":"Division","L":"Department","M":"Position","N":"Duty Type","O":"Probation Period (Months)","P":"Shift","Q":"Hire Date","R":"Original Hire Date","S":"Separation Date","T":"Separation Reason","U":"Voluntary Resignation","V":"Rehire Date","W":"Salary Type","X":"Performance Review Duration (Months)","Y":"Hired Salary","Z":"Salary 1st Raise","AA":"Salary 2nd Raise","AB":"Salary 3rd Raise","AC":"Basic Salary","AD":"Gross Salary","AE":"Other Allowances","AF":"EOBI","AG":"EOBI Amount","AH":"Is Supervisor","AI":"Direct Reporting To","AJ":"Indirect Reporting To","AK":"Date of Birth","AL":"Gender","AM":"Martial Status","AN":"Religion","AO":"CNIC","AP":"Personal Email","AQ":"Business Email","AR":"Home Phone","AS":"Emergency Contact Number","AT":"Cell Phone","AU":"Present Address","AV":"Permanent Address","AW":"Work From Home","AX":"Transportation Required","AY":"Password","AZ":"Role","BA":"Prefix","BB":"Primary Project","BC":"Team","BD":"Campaign","BE":"Pseudo","BF":"Medflow ID","BG":"Skype ID","BH":"Hiring In Replacement Of","BI":"Qualification (Last Degree)","BJ":"Passing Date","BK":"CGPA \/ Div \/ %","BL":"Institute","BM":"Last Employer","BN":"Last Employer Address","BO":"Account Title","BP":"Account Number","BQ":"Branch Code","BR":"Branch Address","BS":"Employee Status","BT":"Exit Interview Conducted","BU":"Exit Interview Date","BV":"Exit Interview Details"}', true);
        $required_cols = [
            'HRM ID' => 'required',
            'First Name' => 'required',
            'Last Name' => 'required',
            'HRM Email Address' => 'required|email',
            'Phone' => 'required',
            'Division' => 'required',
            'Department' => 'required',
            'Position' => 'required',
            'Hire Date' => 'required',
            'Original Hire Date' => 'required',
            'Salary Type' => 'required',
            'Basic Salary' => 'required',
            'Date of birth' => 'required',
            'Gender' => 'required',
            'CNIC' => 'required',
            'Personal Email' => 'email',
            'Business Email' => 'email',
            'Home Phone' => 'required',
            'Cell Phone' => 'required',
            'Password' => 'required',
            'Role' => 'required',
        ];

        $this->db->trans_start();
        foreach ($excel_data as $row_num => $row_data) {
            if (count(array_diff($row_data, $header_row)) <= 12) {
                continue;
            }
            if (emptyArray($row_data)) {
                continue;
            }
            // Generate Employee ID
            $employee_h = $this->db->select('employee_id')
                ->from('employee_history')
                ->order_by('emp_his_id', 'desc')
                ->get()
                ->row();
            if ($employee_h) {
                $max_id = $employee_h->employee_id;
                $employee_id = $max_id + 1;
            } else {
                $employee_id = 1;
            }
            /**
             * Check required columns
             */
            foreach ($required_cols as $col_name => $req_col) {
                $req_col = explode('|', $req_col);
                if (in_array('required', $req_col) && empty($row_data[$alpha_column_order[$col_name]])) {
                    $this->session->set_flashdata('exception', 'Required column "' . $col_name . '" is empty on row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                } elseif (!empty($row_data[$alpha_column_order[$col_name]])) {
                    if (in_array('email', $req_col) && !filter_var($row_data[$alpha_column_order[$col_name]], FILTER_VALIDATE_EMAIL)) {
                        $this->session->set_flashdata('exception', 'Invalid Email in "' . $col_name . '" column on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                }
            }
            /**
             * Duplicate Email check
             */
            $employee_email_exist = $this->db->select('employee_id')
                ->where('email', trim($row_data[$alpha_column_order['HRM Email Address']]))
                ->from('employee_history')
                ->get()
                ->row();
            if ($employee_email_exist) {
                $this->session->set_flashdata('exception', 'Email "' . trim($row_data[$alpha_column_order['HRM Email Address']]) . '" already exists from row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            $employee_user_email_exist = $this->db->select('id')
                ->where('email', trim($row_data[$alpha_column_order['HRM Email Address']]))
                ->from('user')
                ->get()
                ->row();
            if ($employee_user_email_exist) {
                $this->session->set_flashdata('exception', 'User with email "' . trim($row_data[$alpha_column_order['HRM Email Address']]) . '" already exists from row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Check gender exists
             */
            $gender = getByWhereAsArray('gender', 'id', ['gender_name' => trim($row_data[$alpha_column_order['Gender']])]);
            if ($gender) {
                $gender = $gender[0]['id'];
            } else {
                $this->db->insert('gender', [
                    'gender_name' => trim($row_data[$alpha_column_order['Gender']]),
                ]);
                $gender = $this->db->insert_id();
                $this->activity->log([
                    'gender_inserted',
                    trim($row_data[$alpha_column_order['Gender']]),
                ]);
            }
            /**
             * Check marital status exists
             */
            $marital_status = getByWhereAsArray('marital_info', 'id', ['marital_sta' => trim($row_data[$alpha_column_order['Marital Status']])]);
            if ($marital_status) {
                $marital_status = $marital_status[0]['id'];
            } else {
                $this->db->insert('marital_info', [
                    'marital_sta' => trim($row_data[$alpha_column_order['Marital Status']]),
                ]);
                $marital_status = $this->db->insert_id();
                $this->activity->log([
                    'marital_status_inserted',
                    trim($row_data[$alpha_column_order['Marital Status']]),
                ]);
            }
            /**
             * Check Division exists
             */
            $original_div = $row_data[$alpha_column_order['Division']];
            $row_data[$alpha_column_order['Division']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Division']]));
            $row_data[$alpha_column_order['Division']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Division']]);
            $div_prefix = '';
            $division = getByWhereAsArray('divisions', 'id, prefix', [], [], 0, 0, ['name' => $row_data[$alpha_column_order['Division']]]);
            if ($division) {
                $div_prefix = $division[0]['prefix'];
                $division = $division[0]['id'];
            } else {
                $this->session->set_flashdata('exception', 'Division "' . $original_div . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Duplicate HRM ID check
             */
            if (empty($row_data[$alpha_column_order['HRM ID']])) {
                $row_data[$alpha_column_order['HRM ID']] = $div_prefix . '-' . generate_hrm_id($division);
            } else {
                $employee_email_exist = $this->db->select('employee_id')
                    ->where('hrm_id', trim($row_data[$alpha_column_order['HRM ID']]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if ($employee_email_exist) {
                    $this->session->set_flashdata('exception', 'HRM ID "' . trim($row_data[$alpha_column_order['HRM ID']]) . '" already exists from row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
            }

            /**
             * Check department exists
             */
            $original_deptt = $row_data[$alpha_column_order['Department']];
            $row_data[$alpha_column_order['Department']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Department']]));
            $row_data[$alpha_column_order['Department']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Department']]);
            $department = getByWhereAsArray('department', 'dept_id', [], [], 0, 0, ['department_name' => $row_data[$alpha_column_order['Department']]]);
            if ($department) {
                $department = $department[0]['dept_id'];
            } else {
                $this->session->set_flashdata('exception', 'Department "' . $original_deptt . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Check position exists
             */
            $original_pos = $row_data[$alpha_column_order['Position']];
            $row_data[$alpha_column_order['Position']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Position']]));
            $row_data[$alpha_column_order['Position']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Position']]);
            $position = getByWhereAsArray('position', 'pos_id', [], [], 0, 0, ['position_name' => $row_data[$alpha_column_order['Position']]]);
            if ($position) {
                $position = $position[0]['pos_id'];
            } else {
                $this->session->set_flashdata('exception', 'Position "' . $original_pos . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Check duty type exists
             */
            $original_duty = $row_data[$alpha_column_order['Duty Type']];
            $row_data[$alpha_column_order['Duty Type']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Duty Type']]));
            $row_data[$alpha_column_order['Duty Type']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Duty Type']]);
            $duty_type = getByWhereAsArray('duty_type', 'id', [], [], 0, 0, ['type_name' => $row_data[$alpha_column_order['Duty Type']]]);
            if ($duty_type) {
                $duty_type = $duty_type[0]['id'];
            } else {
                $this->session->set_flashdata('exception', 'Duty Type "' . $original_duty . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Check shift exists
             */
            $original_shift = $row_data[$alpha_column_order['Shift Type']];
            $row_data[$alpha_column_order['Shift Type']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Shift Type']]));
            $row_data[$alpha_column_order['Shift Type']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Shift Type']]);
            $shift_type = getByWhereAsArray('shift', 'id', [], [], 0, 0, ['name' => $row_data[$alpha_column_order['Shift Type']]]);
            if ($shift_type) {
                $shift_type = $shift_type[0]['id'];
            } else {
                $this->session->set_flashdata('exception', 'Shift "' . $original_shift . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Check role exists
             */
            $original_role = $row_data[$alpha_column_order['Role']];
            $row_data[$alpha_column_order['Role']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Role']]));
            $row_data[$alpha_column_order['Role']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Role']]);
            $role_id = getByWhereAsArray('sec_role_tbl, sec_user_access_tbl-sec_user_access_tbl.fk_role_id=sec_role_tbl.role_id-left', 'sec_role_tbl.role_id', [], [], 0, 0, ['sec_role_tbl.role_name' => $row_data[$alpha_column_order['Role']]]);
            if ($role_id) {
                $role_id = $role_id[0]['role_id'];
            } else {
                $this->session->set_flashdata('exception', 'Role "' . $original_role . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Salary Type Check
             */
            $original_salary_type = $row_data[$alpha_column_order['Salary Type']];
            $s_types = [
                'monthly' => 2,
            ];
            $s_type = 0;
            if (@$s_types[trim(strtolower($row_data[$alpha_column_order['Salary Type']]))]) {
                $s_type = $s_types[trim(strtolower($row_data[$alpha_column_order['Salary Type']]))];
            } else {
                $this->session->set_flashdata('exception', 'Salary Type "' . $original_salary_type . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            $postData = [
                'employee_id' => $employee_id,
                'hrm_id' => trim($row_data[$alpha_column_order['HRM ID']]),
                'pos_id' => $position,
                'first_name' => $row_data[$alpha_column_order['First Name']],
                'middle_name' => $row_data[$alpha_column_order['Middle Name']],
                'last_name' => $row_data[$alpha_column_order['Last Name']],
                'father_name' => $row_data[$alpha_column_order['Father Name']],
                'maiden_name' => '',
                'email' => $row_data[$alpha_column_order['HRM Email Address']],
                'phone' => $row_data[$alpha_column_order['Phone']],
                'alter_phone' => $row_data[$alpha_column_order['Alternative Phone']],
                'present_address' => $row_data[$alpha_column_order['Present Address']],
                'parmanent_address' => $row_data[$alpha_column_order['Permanent Address']],
                'picture' => '',
                'dept_id' => $department,
                'division_id' => $division,
                'state' => trim($row_data[$alpha_column_order['Country']]),
                'city' => trim($row_data[$alpha_column_order['City']]),
                'zip' => '',
                'citizenship' => '',
                'duty_type' => $duty_type,
                'hire_date' => convert_excel_date($row_data[$alpha_column_order['Hire Date']]),
                'original_hire_date' => convert_excel_date($row_data[$alpha_column_order['Original Hire Date']]),
                'termination_date' => convert_excel_date($row_data[$alpha_column_order['Separation Date']]),
                'termination_reason' => $row_data[$alpha_column_order['Separation Reason']],
                'voluntary_termination' => strtolower(trim($row_data[$alpha_column_order['Voluntary Resignation']])) == 'yes' ? 1 : 0,
                'rehire_date' => convert_excel_date($row_data[$alpha_column_order['Rehire Date']]),
                'rate_type' => $s_type,
                'pay_frequency' => '',
                'pay_frequency_txt' => '',
                'hourly_rate2' => '',
                'hourly_rate3' => '',
                'home_department' => '',
                'department_text' => '',
                'class_code' => '',
                'class_code_desc' => '',
                'class_acc_date' => date("Y-m-d", strtotime(!empty($this->input->post('class_acc_date', true)) ? $this->input->post('class_acc_date', true) : date('Y-m-d'))),
                'class_status' => '',
                'is_super_visor' => strtolower(trim($row_data[$alpha_column_order['Is Supervisor']])) == 'yes' ? 1 : 0,
                'dob' => convert_excel_date($row_data[$alpha_column_order['Date of birth']]),
                'gender' => $gender,
                'marital_status' => $marital_status,
                'ethnic_group' => trim(ucwords($row_data[$alpha_column_order['Religion']])),
                'eeo_class_gp' => '',
                'cnic' => preg_replace('@[^\d]@', '', $row_data[$alpha_column_order['CNIC']]),
                'work_in_state' => '',
                'live_in_state' => '',
                'home_email' => $row_data[$alpha_column_order['Personal Email']],
                'business_email' => $row_data[$alpha_column_order['Business Email']],
                'home_phone' => $row_data[$alpha_column_order['Home Phone']],
                'business_phone' => '',
                'cell_phone' => $row_data[$alpha_column_order['Cell Phone']],
                'emerg_contct' => $row_data[$alpha_column_order['Emergency Contact Number']],
                'emrg_h_phone' => '',
                'emrg_w_phone' => '',
                'emgr_contct_relation' => '',
                'alt_em_contct' => '',
                'alt_emg_h_phone' => '',
                'alt_emg_w_phone' => '',
                'shift' => $shift_type,
                'probation_period' => $row_data[$alpha_column_order['Probation Period (Months)']],
                'performance_duration' => $row_data[$alpha_column_order['Performance Review Duration']],
                'eobi_check' => trim(strtolower($row_data[$alpha_column_order['EOBI']])) == 'yes' ? 1 : 0,
                'eobi' => floatval($row_data[$alpha_column_order['EOBI Amount']]),
                'work_from_home' => trim(strtolower($row_data[$alpha_column_order['Work From Home']])) == 'yes' ? 1 : 0,
                'transportation_required' => trim(strtolower($row_data[$alpha_column_order['Transportation Required']])) == 'yes' ? 1 : 0,
                'prefix' => $row_data[$alpha_column_order['Prefix']],
                'primary_project' => $row_data[$alpha_column_order['Primary Project']],
                'team' => $row_data[$alpha_column_order['Team']],
                'campaign' => $row_data[$alpha_column_order['Campaign']],
                'pseudo' => $row_data[$alpha_column_order['Pseudo']],
                'medflow_id' => $row_data[$alpha_column_order['Medflow ID']],
                'skype_id' => $row_data[$alpha_column_order['Skype ID']],
                'replacement' => $row_data[$alpha_column_order['Hiring In Replacement Of']],
                'degree_name' => $row_data[$alpha_column_order['Qualification']],
                'passing_year' => convert_excel_date($row_data[$alpha_column_order['Passing Date']]),
                'cgp' => $row_data[$alpha_column_order['CGPA']],
                'institute_name' => $row_data[$alpha_column_order['Institute']],
                'last_employer' => $row_data[$alpha_column_order['Last Employer']],
                'last_employer_address' => $row_data[$alpha_column_order['Last Employer Address']],
                'account_title' => $row_data[$alpha_column_order['Account Title']],
                'account_number' => $row_data[$alpha_column_order['Account Number']],
                'branch_code' => $row_data[$alpha_column_order['Branch Code']],
                'branch_address' => $row_data[$alpha_column_order['Branch Address']],
                'status' => preg_replace('#[^\w]#is', '-', trim($row_data[$alpha_column_order['Employee Status']])),
                'exit_interview' => empty(trim($row_data[$alpha_column_order['Exit Interview Conducted']])) ? null : (strtolower(trim($row_data[$alpha_column_order['Exit Interview Conducted']])) == 'yes' ? 1 : 0),
                'exit_interview_date' =>  convert_excel_date($row_data[$alpha_column_order['Exit Interview Date']]),
                'exit_interview_details' => empty(trim($row_data[$alpha_column_order['Exit Interview Details']])) ? null : strip_tags($row_data[$alpha_column_order['Exit Interview Details']]),
            ];
            if($this->permission->method('employee_salary_permission', 'update')->access()){
                $postData['rate'] = $row_data[$alpha_column_order['Basic Salary']];
                $postData['current_salary'] = $row_data[$alpha_column_order['Gross Salary']];
                $postData['hired_salary'] = $row_data[$alpha_column_order['Hired Salary']];
                $postData['first_salary'] = $row_data[$alpha_column_order['Salary 1st Raise']];
                $postData['second_salary'] = $row_data[$alpha_column_order['Salary 2nd Raise']];
                $postData['third_salary'] = $row_data[$alpha_column_order['Salary 3rd Raise']];
            }
            $employee_id = $this->Employees_model->create_employee($postData);

            $addition = [];
            $addition['addition_id'] = 1;
            $addition['employee_id'] = $employee_id;
            $addition['value'] = floatval($row_data[$alpha_column_order['Other Allowances']]);
            $addition['created_on'] = date('Y-m-d');
            if (!empty($addition['addition_id']) && !empty($addition['value'])) {
                $this->db->insert('emp_salary_setup_details', $addition);
            }
            
            $this->db->insert('user', [
                'firstname' => trim($row_data[$alpha_column_order['First Name']]),
                'lastname' => trim($row_data[$alpha_column_order['Last Name']]),
                'email' => trim($row_data[$alpha_column_order['HRM Email Address']]),
                'password' => md5($row_data[$alpha_column_order['Password']]),
            ]);
            $inserted_user_id = $this->db->insert_id();
            $this->activity->set_employee($employee_id)->set_url('employee/Employees/cv/' . $employee_id)->log('employee_created', $employee_id, 'employee', 'employee_history');
            $this->activity->set_user($inserted_user_id)->set_url('dashboard/user/index')->log('user_inserted', 'settings');
            $this->db->insert('sec_user_access_tbl', [
                'fk_role_id' => $role_id,
                'fk_user_id' => $inserted_user_id,
            ]);
            $this->activity->set_url('dashboard/role/user_access_role')->set_user($inserted_user_id)->log([
                'role_assigned',
                $original_role,
            ], $employee_id, 'settings');
            $coa = $this->Employees_model->headcode();
            if ($coa->HeadCode != null) {
                $headcode = $coa->HeadCode + 1;
            } else {
                $headcode = "502020000001";
            }
            $c_code = $employee_id;
            $c_name = $row_data[$alpha_column_order['First Name']] . $row_data[$alpha_column_order['Last Name']];
            $c_acc = $c_code . '-' . $c_name;
            $createby = $this->session->userdata('fullname');
            $createdate = date('Y-m-d H:i:s');
            $data['aco'] = (Object) $coaData = [
                'HeadCode' => $headcode,
                'HeadName' => $c_acc,
                'PHeadName' => 'Account Payable',
                'HeadLevel' => '2',
                'IsActive' => '1',
                'IsTransaction' => '1',
                'IsGL' => '0',
                'HeadType' => 'L',
                'IsBudget' => '0',
                'IsDepreciation' => '0',
                'DepreciationRate' => '0',
                'CreateBy' => $createby,
                'CreateDate' => $createdate,
            ];
            $this->Employees_model->create_coa($coaData);
        }
        foreach ($excel_data as $row_num => $row_data) {
            if (count(array_diff($row_data, $header_row)) <= 10) {
                continue;
            }
            if (empty($row_data[$alpha_column_order['Direct Reporting']]) && empty($row_data[$alpha_column_order['Indirect Reporting']])) {
                continue;
            }
            $emp_rec = $this->db->where(['hrm_id' => trim($row_data[$alpha_column_order['HRM ID']])])->order_by('emp_his_id', 'DESC')->get('employee_history')->row();
            if (!$emp_rec) {
                $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Employee failed to insert. Try again later');
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            $direct_supervisor_id = 0;
            if (!empty($row_data[$alpha_column_order['Direct Reporting']])) {
                $direct_supervisor_id = $this->db->select('employee_id')
                    ->where('hrm_id', trim($row_data[$alpha_column_order['Direct Reporting']]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if ($direct_supervisor_id) {
                    $direct_supervisor_id = $direct_supervisor_id->employee_id;
                } else {
                    $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Direct Supervisor with ID "' . trim($row_data[$alpha_column_order['Direct Reporting']]) . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
            }
            /**
             * Get Indirect Supervisor ID
             */
            $indirect_supervisor_id = 0;
            if (!empty($row_data[$alpha_column_order['Indirect Reporting']])) {
                $indirect_supervisor_id = $this->db->select('employee_id')
                    ->where('hrm_id', trim($row_data[$alpha_column_order['Indirect Reporting']]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if ($indirect_supervisor_id) {
                    $indirect_supervisor_id = $indirect_supervisor_id->employee_id;
                } else {
                    $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Indirect Supervisor with ID "' . trim($row_data[$alpha_column_order['Indirect Reporting']]) . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
            }
            $this->db->where('emp_his_id', $emp_rec->emp_his_id)->update('employee_history', [
                'super_visor_id' => $direct_supervisor_id,
                'indirect_super_visor_id' => $indirect_supervisor_id,
            ]);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === false) {
            $this->session->set_flashdata('exception', 'Error importing data, try again later');
        } else {
            $this->session->set_flashdata('message', 'Data imported successfully');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function bulk_update()
    {
        $this->permission->method('update_employee_bulk', 'create')->redirect();
        if ($this->input->method() != 'post') {
            $data['title'] = 'Bulk Update Employees';
            $data['module'] = "employee";
            $data['page'] = "bulk_update";
            echo Modules::run('template/layout', $data);return;
        }
        $this->load->library('myupload');
        $file = $this->myupload->do_upload(FCPATH . 'uploads/temp/', 'file', true);
        if (!$file) {
            $this->session->set_flashdata('exception', 'File upload failed, try again later!');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $excel_data = $this->excel->read($file);
        $heading_row = array_shift($excel_data);
        $hrm_id_key = array_search('HRM ID', $heading_row);
        if ($hrm_id_key === false) {
            $this->session->set_flashdata('exception', 'Required "HRM ID" Column not found in sheet. Make sure first row is heading');
            redirect($_SERVER['HTTP_REFERER']);return;
        }
        $this->db->trans_start();
        foreach ($excel_data as $row_num => $row_data) {
            $row_num++;
            if (emptyArray($row_data)) {
                continue;
            }
            /**
             * Duplicate HRM ID check
             */
            if (empty($row_data[$hrm_id_key])) {
                $this->session->set_flashdata('exception', 'Required "HRM ID" Column empty on row #' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            } else {
                $employee_rec = $this->db->select('*')
                    ->where('hrm_id', trim($row_data[$hrm_id_key]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if (!$employee_rec) {
                    $this->session->set_flashdata('exception', 'HRM ID "' . trim($row_data[$hrm_id_key]) . '" doesn\'t exist from row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
                $employee_rec = decrypt_employee_data($employee_rec);
            }
            $employee_history_data = [];
            $user_data = [];
            foreach ($heading_row as $head_key => $head_value) {
                if ($head_key == $hrm_id_key) {
                    continue;
                }
                if (empty(trim($row_data[$head_key]))) {
                    continue;
                }
                $head_value = trim($head_value);
                if (strtolower($head_value) == 'first name') {
                    $employee_history_data['first_name'] = $row_data[$head_key];
                    $user_data['firstname'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'middle name') {
                    $employee_history_data['middle_name'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'last name') {
                    $employee_history_data['last_name'] = $row_data[$head_key];
                    $user_data['lastname'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'father name') {
                    $employee_history_data['father_name'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'phone') {
                    $employee_history_data['phone'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'alternative phone') {
                    $employee_history_data['alter_phone'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'country') {
                    $employee_history_data['state'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'city') {
                    $employee_history_data['city'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'division') {
                    /**
                     * Check Division exists
                     */
                    $original_div = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $division = getByWhereAsArray('divisions', 'id, prefix', [], [], 0, 0, ['name' => $row_data[$head_key]]);
                    if ($division) {
                        $division = $division[0]['id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Division "' . $original_div . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }

                    $employee_history_data['division_id'] = $division;
                }
                if (strtolower($head_value) == 'department') {
                    /**
                     * Check department exists
                     */
                    $original_deptt = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $department = getByWhereAsArray('department', 'dept_id', [], [], 0, 0, ['department_name' => $row_data[$head_key]]);
                    if ($department) {
                        $department = $department[0]['dept_id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Department "' . $original_deptt . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['dept_id'] = $department;
                }
                if (strtolower($head_value) == 'position') {
                    /**
                     * Check position exists
                     */
                    $original_pos = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $position = getByWhereAsArray('position', 'pos_id', [], [], 0, 0, ['position_name' => $row_data[$head_key]]);
                    if ($position) {
                        $position = $position[0]['pos_id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Position "' . $original_pos . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['pos_id'] = $position;
                }
                if (strtolower($head_value) == 'duty type') {
                    /**
                     * Check duty type exists
                     */
                    $original_duty = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $duty_type = getByWhereAsArray('duty_type', 'id', [], [], 0, 0, ['type_name' => $row_data[$head_key]]);
                    if ($duty_type) {
                        $duty_type = $duty_type[0]['id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Duty Type "' . $original_duty . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['duty_type'] = $duty_type;
                }
                if (strtolower($head_value) == 'probation period (months)') {
                    $employee_history_data['probation_period'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'shift') {
                    /**
                     * Check shift exists
                     */
                    $original_shift = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $shift_type = getByWhereAsArray('shift', 'id', [], [], 0, 0, ['name' => $row_data[$head_key]]);
                    if ($shift_type) {
                        $shift_type = $shift_type[0]['id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Shift "' . $original_shift . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['shift'] = $shift_type;
                }
                if (strtolower($head_value) == 'hire date') {
                    $employee_history_data['hire_date'] = convert_excel_date($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'original hire date') {
                    $employee_history_data['original_hire_date'] = convert_excel_date($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'separation date') {
                    $employee_history_data['termination_date'] = convert_excel_date($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'separation reason') {
                    $employee_history_data['termination_reason'] = strip_tags($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'voluntary resignation') {
                    $employee_history_data['voluntary_termination'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                if (strtolower($head_value) == 'rehire date') {
                    $employee_history_data['rehire_date'] = convert_excel_date($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'salary type') {
                    /**
                     * Salary Type Check
                     */
                    $original_salary_type = $row_data[$head_key];
                    $s_types = [
                        'monthly' => 2,
                    ];
                    $s_type = 0;
                    if (@$s_types[trim(strtolower($row_data[$head_key]))]) {
                        $s_type = $s_types[trim(strtolower($row_data[$head_key]))];
                    } else {
                        $this->session->set_flashdata('exception', 'Salary Type "' . $original_salary_type . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['rate_type'] = $s_type;
                }
                if (strtolower($head_value) == 'performance review duration (months)') {
                    $employee_history_data['performance_duration'] = $row_data[$head_key];
                }
                if($this->permission->method('employee_salary_permission', 'update')->access()){
	                if (strtolower($head_value) == 'hired salary') {
	                    $employee_history_data['hired_salary'] = $row_data[$head_key];
	                }
	                if (strtolower($head_value) == 'salary 1st raise') {
	                    $employee_history_data['first_salary'] = $row_data[$head_key];
	                }
	                if (strtolower($head_value) == 'salary 2nd raise') {
	                    $employee_history_data['second_salary'] = $row_data[$head_key];
	                }
	                if (strtolower($head_value) == 'salary 3rd raise') {
	                    $employee_history_data['third_salary'] = $row_data[$head_key];
	                }
	                if (strtolower($head_value) == 'basic salary') {
	                    $employee_history_data['rate'] = $row_data[$head_key];
	                }
	                if (strtolower($head_value) == 'gross salary') {
	                    $employee_history_data['current_salary'] = $row_data[$head_key];
	                }
                }
                if (strtolower($head_value) == 'eobi') {
                    $employee_history_data['eobi_check'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                if (strtolower($head_value) == 'eobi amount') {
                    $employee_history_data['eobi'] = floatval($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'is supervisor') {
                    $employee_history_data['is_super_visor'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                if (strtolower($head_value) == 'direct reporting to') {
                    $direct_supervisor_id = $this->db->select('employee_id')
                        ->where('hrm_id', trim($row_data[$head_key]))
                        ->from('employee_history')
                        ->get()
                        ->row();
                    if ($direct_supervisor_id) {
                        $direct_supervisor_id = $direct_supervisor_id->employee_id;
                    } else {
                        $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Direct Supervisor with ID "' . trim($row_data[$head_key]) . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['super_visor_id'] = $direct_supervisor_id;
                }
                if (strtolower($head_value) == 'indirect reporting to') {
                    $indirect_supervisor_id = $this->db->select('employee_id')
                        ->where('hrm_id', trim($row_data[$head_key]))
                        ->from('employee_history')
                        ->get()
                        ->row();
                    if ($indirect_supervisor_id) {
                        $indirect_supervisor_id = $indirect_supervisor_id->employee_id;
                    } else {
                        $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Indirect Supervisor with ID "' . trim($row_data[$head_key]) . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['indirect_super_visor_id'] = $indirect_supervisor_id;
                }
                if (strtolower($head_value) == 'date of birth') {
                    $employee_history_data['dob'] = convert_excel_date($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'gender') {
                    /**
                     * Check gender exists
                     */
                    $gender = getByWhereAsArray('gender', 'id', ['gender_name' => trim($row_data[$head_key])]);
                    if ($gender) {
                        $gender = $gender[0]['id'];
                    } else {
                        $this->db->insert('gender', [
                            'gender_name' => trim($row_data[$head_key]),
                        ]);
                        $gender = $this->db->insert_id();
                        $this->activity->log([
                            'gender_inserted',
                            trim($row_data[$head_key]),
                        ]);
                    }
                    $employee_history_data['gender'] = $gender;
                }
                if (strtolower($head_value) == 'martial status') {
                    /**
                     * Check marital status exists
                     */
                    $marital_status = getByWhereAsArray('marital_info', 'id', ['marital_sta' => trim($row_data[$head_key])]);
                    if ($marital_status) {
                        $marital_status = $marital_status[0]['id'];
                    } else {
                        $this->db->insert('marital_info', [
                            'marital_sta' => trim($row_data[$head_key]),
                        ]);
                        $marital_status = $this->db->insert_id();
                        $this->activity->log([
                            'marital_status_inserted',
                            trim($row_data[$head_key]),
                        ]);
                    }
                    $employee_history_data['marital_status'] = $marital_status;
                }
                if (strtolower($head_value) == 'religion') {
                    $employee_history_data['ethnic_group'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'cnic') {
                    $employee_history_data['cnic'] = preg_replace('@[^\d]@', '', $row_data[$head_key]);
                }
                if (strtolower($head_value) == 'personal email') {
                    $employee_history_data['home_email'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'business email') {
                    $employee_history_data['business_email'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'home phone') {
                    $employee_history_data['home_phone'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'emergency contact number') {
                    $employee_history_data['emerg_contct'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'cell phone') {
                    $employee_history_data['cell_phone'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'present address') {
                    $employee_history_data['present_address'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'permanent address') {
                    $employee_history_data['parmanent_address'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'work from home') {
                    $employee_history_data['work_from_home'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                if (strtolower($head_value) == 'transportation required') {
                    $employee_history_data['transportation_required'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                if (strtolower($head_value) == 'prefix') {
                    $employee_history_data['prefix'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'primary project') {
                    $employee_history_data['primary_project'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'team') {
                    $employee_history_data['team'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'campaign') {
                    $employee_history_data['campaign'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'pseudo') {
                    $employee_history_data['pseudo'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'medflow id') {
                    $employee_history_data['medflow_id'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'skype id') {
                    $employee_history_data['skype_id'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'hiring in replacement of') {
                    $employee_history_data['replacement'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'last degree') {
                    $employee_history_data['degree_name'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'passing date') {
                    $employee_history_data['passing_year'] = convert_excel_date(trim($row_data[$head_key]));
                }
                if (strtolower($head_value) == 'cgpa / div / %') {
                    $employee_history_data['cgp'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'institute') {
                    $employee_history_data['institute_name'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'last employer') {
                    $employee_history_data['last_employer'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'last employer address') {
                    $employee_history_data['last_employer_address'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'account title') {
                    $employee_history_data['account_title'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'account number') {
                    $employee_history_data['account_number'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'branch code') {
                    $employee_history_data['branch_code'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'branch address') {
                    $employee_history_data['branch_address'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'employee status') {
                    $employee_history_data['status'] = preg_replace('#[^\w]#is', '-', trim($row_data[$head_key]));
                }
                if (strtolower($head_value) == 'exit interview conducted') {
                    $employee_history_data['exit_interview'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                if (strtolower($head_value) == 'exit interview date') {
                    $employee_history_data['exit_interview_date'] = convert_excel_date(trim($row_data[$head_key]));
                }
                if (strtolower($head_value) == 'exit interview details') {
                    $employee_history_data['exit_interview_details'] = strip_tags(trim($row_data[$head_key]));
                }

                $user_rec = $this->db->where('email', $employee_rec->email)->get('user')->row();
                if (!$user_rec) {
                    $this->session->set_flashdata('exception', 'User with email "' . $employee_rec->email . '" not found on row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
                if (strtolower($head_value) == 'role') {
                    /**
                     * Check role exists
                     */
                    $original_role = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $role_id = getByWhereAsArray('sec_role_tbl, sec_user_access_tbl-sec_user_access_tbl.fk_role_id=sec_role_tbl.role_id-left', 'sec_role_tbl.role_id', [], [], 0, 0, ['sec_role_tbl.role_name' => $row_data[$head_key]]);
                    if ($role_id) {
                        $role_id = $role_id[0]['role_id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Role "' . $original_role . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $this->db->where('fk_user_id', $user_rec->id)->delete('sec_user_access_tbl');
                    $this->db->insert('sec_user_access_tbl', [
                        'fk_role_id' => $role_id,
                        'fk_user_id' => $user_rec->id,
                    ]);
                    $this->activity->set_url('dashboard/role/user_access_role')->set_employee($employee_rec->employee_id)->log([
                        'role_assigned',
                        $original_role,
                    ], $employee_rec->employee_id, 'settings');
                }
                if (strtolower($head_value) == 'password') {
                    $user_data['password'] = md5($row_data[$head_key]);
                }

                if (strtolower($head_value) == 'other allowances') {
                    $addition = [];
                    $addition['value'] = floatval($row_data[$head_key]);
                    $addition_exist = $this->db->where(['addition_id' => 1, 'employee_id' => $employee_rec->employee_id])->get('emp_salary_setup_details')->row();
                    if($addition_exist) {
                        if($addition['value'] != $addition_exist->value){
                            $this->activity->set_url('employee/Employees/cv/' . $employee_rec->employee_id)->log([
                                'employee_update',
                                'Other Allowances',
                                $addition_exist->value,
                                $addition['value'],
                            ], $employee_rec->employee_id, 'employee', 'employee_history');
                            $this->db->where(['addition_id' => 1, 'employee_id' => $employee_rec->employee_id])->update('emp_salary_setup_details', $addition);                        
                        }
                    } else {
                        $this->activity->set_url('employee/Employees/cv/' . $employee_rec->employee_id)->log([
                            'employee_update',
                            'Other Allowances',
                            '',
                            $addition['value'],
                        ], $employee_rec->employee_id, 'employee', 'employee_history');
                        $addition['addition_id'] = 1;
                        $addition['employee_id'] = $employee_rec->employee_id;
                        $addition['created_on'] = date('Y-m-d');
                        if (!empty($addition['addition_id']) && !empty($addition['value'])) {
                            $this->db->insert('emp_salary_setup_details', $addition);
                        }
                    }
                }
            }
            if ($employee_history_data) {
                $employee_history_data = encrypt_employee_data($employee_history_data);
                if ($this->db->where('hrm_id', trim($row_data[$hrm_id_key]))->update('employee_history', $employee_history_data)) {
                    $this->Employees_model->log_employee_change($employee_rec->employee_id, decrypt_employee_data($employee_history_data), (array) $employee_rec);
                }
            }
            if ($user_data) {
                $this->db->where('email', $employee_rec->email)->update('user', $user_data);
            }
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === false) {
            $this->session->set_flashdata('exception', 'Error importing data, try again later');
        } else {
            $this->session->set_flashdata('message', 'Data updated successfully');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function bulk_leave_update()
    {
        $this->permission->method('bulk_leave_update', 'create')->redirect();
        if ($this->input->method() != 'post') {
            $data['title'] = 'Bulk Update Employee Leaves';
            $data['module'] = "employee";
            $data['heading_row'] = getByWhereAsArray('leave_type', 'leave_type name', [], ['leave_type', 'ASC']);
            $data['page'] = "bulk_update_leaves";
            echo Modules::run('template/layout', $data);return;
        }
        $this->load->library('myupload');
        $file = $this->myupload->do_upload(FCPATH . 'uploads/temp/', 'file', true);
        if (!$file) {
            $this->session->set_flashdata('exception', 'File upload failed, try again later!');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $excel_data = $this->excel->read($file);
        $heading_row = array_shift($excel_data);
        $hrm_id_key = array_search('HRM ID', $heading_row);
        if ($hrm_id_key === false) {
            $this->session->set_flashdata('exception', 'Required "HRM ID" Column not found in sheet. Make sure first row is heading');
            redirect($_SERVER['HTTP_REFERER']);return;
        }
        $employee_rec = null;
        $this->db->trans_start();
        foreach ($excel_data as $row_num => $row_data) {
            $row_num++;
            if (emptyArray($row_data)) {
                continue;
            }
            if (empty($row_data[$hrm_id_key])) {
                $this->session->set_flashdata('exception', 'Required "HRM ID" Column empty on row #' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            } else {
                $employee_rec = $this->db->select('*')
                    ->where('hrm_id', trim($row_data[$hrm_id_key]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if (!$employee_rec) {
                    $this->session->set_flashdata('exception', 'HRM ID "' . trim($row_data[$hrm_id_key]) . '" doesn\'t exist from row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
                $employee_rec = decrypt_employee_data($employee_rec);
            }
            foreach ($heading_row as $head_key => $head_value) {
                if ($head_key == $hrm_id_key) {
                    continue;
                }
                if (empty(trim($row_data[$head_key])) && trim($row_data[$head_key]) != '0') {
                    continue;
                }

                $original_leave = $head_value;
                $head_value = str_replace(' ', '_', trim($head_value));
                $head_value = preg_replace('/[^\w\d]+/', '%', $head_value);
                $leave_type = getByWhereAsArray('leave_type', 'leave_type_id id', [], [], 0, 0, ['leave_type' => $head_value]);

                if ($leave_type) {
                    $leave_type = $leave_type[0]['id'];
                } else {
                    $this->session->set_flashdata('exception', 'Leave type "' . $original_leave . '" not found in database on row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }

                $this->db->delete('employee_leaves', [
                    'emp_id' => $employee_rec->employee_id,
                    'leave_type' => $leave_type,
                ]);
                $this->db->insert('employee_leaves', [
                    'emp_id' => $employee_rec->employee_id,
                    'leave_type' => $leave_type,
                    'leave_qouta' => intval($row_data[$head_key]),
                ]);
            }
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === false) {
            $this->session->set_flashdata('exception', 'Error updating leaves, try again later');
        } else {
            $this->session->set_flashdata('message', 'Leave records updated successfully');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function delete_employhistory($id = null)
    {
        $this->permission->method('manage_employee', 'delete')->redirect();
        if ($this->Employees_model->emplyee_history_delete($id)) {
            /* $zk = new ZKLibrary($device_ip, 4370);
            // echo 'welcome';exit();
            $zk->connect();
            $zk->disableDevice();
            $delete = $zk->deleteUser($id);
            $zk->enableDevice();
            $zk->disconnect();
            #set success message */
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("employee/Employees/manageemployee");
    }
    public function delete_employhistory_ajax()
    {
        $this->permission->method('manage_employee', 'delete')->redirect();
        if(!$this->input->post('id')) {
            return sendJson(['error' => 'Invalid employee ID,try again', 'reload' => true]);
        }
        if ($this->Employees_model->emplyee_history_delete($this->input->post('id'))) {
            return sendJson(['success' => display('delete_successfully'), 'reload' => true]);
        } else {
            return sendJson(['success' => display('please_try_again'), 'reload' => true]);
        }
    }
    public function DOWNLOAD_pdf()
    {
        $data = array();
        $data['cv'] = $this->Employees_model->employee_details();
        $html = $this->load->view('cv', $data, true);
        pdf_create($html, 'User List');
    }
    public function position_view()
    {
        $this->permission->method('position', 'read')->redirect();
        $data['title'] = 'Positions';
        $data['position'] = $this->Employees_model->viewPosition();
        $data['module'] = "employee";
        $data['page'] = "positionview";
        echo Modules::run('template/layout', $data);
    }
    public function create_position()
    {
        $this->permission->method('position', 'read')->redirect();
        #-------------------------------#
        $this->form_validation->set_rules('position_name', display('position_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('position_details', display('position_details'), 'max_length[200]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'position_name' => $this->input->post('position_name', true),
                'position_details' => $this->input->post('position_details', true),
            ];
            if ($this->Employees_model->position_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/create_position");
        } else {
            $data['title'] = 'Positions';
            $data['module'] = "employee";
            $data['position'] = $this->Employees_model->viewPosition();
            $data['page'] = "position_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_pos($id = null)
    {
        $this->permission->method('position', 'delete')->redirect();
        if ($this->Employees_model->delete_p($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('employee/Employees/position_view');
    }
    public function update_form($id = null)
    {
        $this->permission->method('position', 'update')->redirect();
        $this->form_validation->set_rules('pos_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('position_name', display('position_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('position_details', display('position_details'), 'max_length[30]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'pos_id' => $this->input->post('pos_id', true),
                'position_name' => $this->input->post('position_name', true),
                'position_details' => $this->input->post('position_details', true),
            ];
            if ($this->Employees_model->update_position($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect('employee/Employees/position_view');
        } else {
            $data['data'] = $this->Employees_model->pos_updateForm($id);
            $data['module'] = "employee";
            $data['page'] = "update_position";
            echo Modules::run('template/layout', $data);
        }
    }
    ////************Employee Update Part***********//
    public function update_employee_form($id)
    {
        $this->permission->method('manage_employee', 'update')->redirect();
        if($this->input->post()) {
            /***** file upload code start ***********/
            $data['title'] = display('employee_update_form');
            $this->form_validation->set_rules('first_name', display('first_name'), 'max_length[50]');
            $this->load->library('myupload');
            $img = $this->myupload->do_upload(
                './application/modules/employee/assets/images/',
                'picture'
            );
            $this->form_validation->set_rules('c_f_name[]', 'Custom Field Name');
            $this->form_validation->set_rules('c_f_type[]', 'Custom Field Type');
            $this->form_validation->set_rules('customvalue[]', 'Custom Value');
            $customr_field = $this->input->post('c_f_name');
            $customr_field_type = $this->input->post('c_f_type');
            $customr_value = $this->input->post('customvalue');
            $benifit_code = $this->input->post('benefit_id', true);
            $benifit_code_desc = $this->input->post('benifit_c_code_d', true);
            $benifit_acc_date = $this->input->post('benifit_acc_date', true);
            $benift_status = $this->input->post('benifit_sst', true);
            $c_code = $id;
            $c_name = $this->input->post('first_name') . $this->input->post('last_name');
            $c_acc = $c_code . '-' . $c_name;
            $old_accname = $id . '-' . $this->input->post('oldfirstname') . $this->input->post('oldlastname');
            #-------------------------------#
            if ($this->form_validation->run() === true) {
                $empOriginal = $this->db->select('*')->where('employee_id', $id)->get('employee_history')->row();
                $user_rec = null;
                if ($empOriginal) {
                    $empOriginal = decrypt_employee_data($empOriginal);
                    $user_rec = $this->db->where('email', $empOriginal->email)->get('user')->row();
                }
                $data['employee'] = (Object) $postData = [
                    'employee_id' => $this->input->post('employee_id', true),
                    'pos_id' => $this->input->post('pos_id', true),
                    'hrm_id' => $this->input->post('hrm_id', true),
                    'status' => $this->input->post('status', true),
                    'first_name' => $this->input->post('first_name', true),
                    'maiden_name' => $this->input->post('maiden_name'),
                    'middle_name' => $this->input->post('middle_name', true),
                    'last_name' => $this->input->post('last_name', true),
                    'father_name' => $this->input->post('father_name'),
                    'email' => $this->input->post('email', true),
                    'phone' => $this->input->post('phone', true),
                    'alter_phone' => $this->input->post('alter_phone', true),
                    'present_address' => $this->input->post('present_address', true),
                    'parmanent_address' => $this->input->post('parmanent_address', true),
                    'work_from_home' => $this->input->post('work_from_home') ? 1 : 0,
                    'transportation_required' => $this->input->post('transportation_required') ? 1 : 0,
                    'picture' => (!empty($img) ? $img : $this->input->post('old_image')),
                    'dept_id' => $this->input->post('department', true),
                    'division_id' => $this->input->post('division', true),
                    'state' => $this->input->post('state', true),
                    'city' => $this->input->post('city', true),
                    'zip' => $this->input->post('zip_code', true),
                    'citizenship' => $this->input->post('citizenship', true),
                    'duty_type' => $this->input->post('duty_type', true),
                    'hire_date' => empty($this->input->post('hiredate', true)) ? null : date('Y-m-d', strtotime($this->input->post('hiredate', true))),
                    'original_hire_date' => empty($this->input->post('ohiredate', true)) ? null : date('Y-m-d', strtotime($this->input->post('ohiredate', true))),
                    'termination_date' => empty($this->input->post('terminatedate')) ? null : date('Y-m-d', strtotime($this->input->post('terminatedate'))),
                    'termination_reason' => htmlspecialchars($this->input->post('termreason', true)),
                    'exit_interview' => $this->input->post('exit_interview') == '1' ? 1 : 0,
                    'exit_interview_date' => empty($this->input->post('exit_interview_date', true)) ? null : date('Y-m-d', strtotime($this->input->post('exit_interview_date'))),
                    'exit_interview_details' => htmlspecialchars($this->input->post('exit_interview_details', true)),
                    'voluntary_termination' => $this->input->post('volunt_termination', true),
                    'rehire_date' => empty($this->input->post('rehiredate')) ? null : date("Y-m-d", strtotime($this->input->post('rehiredate'))),
                    'rate_type' => $this->input->post('rate_type', true),
                    'pay_frequency' => $this->input->post('pay_frequency', true),
                    'pay_frequency_txt' => $this->input->post('pay_f_text', true),
                    'hourly_rate2' => $this->input->post('h_rate2', true),
                    'hourly_rate3' => $this->input->post('h_rate3', true),
                    'home_department' => $this->input->post('h_department', true),
                    'department_text' => $this->input->post('h_dep_text', true),
                    'class_code' => $this->input->post('c_code', true),
                    'class_code_desc' => $this->input->post('c_code_d', true),
                    'class_acc_date' => date("Y-m-d", strtotime(!empty($this->input->post('class_acc_date', true)) ? $this->input->post('class_acc_date', true) : date('Y-m-d'))),
                    'class_status' => $this->input->post('class_sst', true),
                    'is_super_visor' => $this->input->post('is_supervisor', true),
                    'super_visor_id' => $this->input->post('supervisorname', true),
                    'indirect_super_visor_id' => $this->input->post('indirect_supervisorname', true),
                    'supervisor_report' => $this->input->post('reports', true),
                    'dob' => date("Y-m-d", strtotime(!empty($this->input->post('dob', true)) ? $this->input->post('dob', true) : date('Y-m-d'))),
                    'gender' => $this->input->post('gender', true),
                    'marital_status' => $this->input->post('marital_status', true),
                    'ethnic_group' => $this->input->post('ethnic', true),
                    'eeo_class_gp' => $this->input->post('eeo_class', true),
                    'cnic' => preg_replace('@[^\d]@', '', $this->input->post('cnic')),
                    'work_in_state' => $this->input->post('w_s', true),
                    'live_in_state' => $this->input->post('l_in_s', true),
                    'home_email' => $this->input->post('h_email', true),
                    'business_email' => $this->input->post('b_email', true),
                    'home_phone' => $this->input->post('h_phone', true),
                    'business_phone' => $this->input->post('w_phone', true),
                    'cell_phone' => $this->input->post('c_phone', true),
                    'emerg_contct' => $this->input->post('emerg_contct', true),
                    'emrg_h_phone' => $this->input->post('e_h_phone', true),
                    'emrg_w_phone' => $this->input->post('e_w_phone', true),
                    'emgr_contct_relation' => $this->input->post('e_c_relation', true),
                    'alt_em_contct' => $this->input->post('alt_em_cont', true),
                    'alt_emg_h_phone' => $this->input->post('a_e_h_phone', true),
                    'alt_emg_w_phone' => $this->input->post('a_e_w_phone', true),
                    'shift' => $this->input->post('shift', true),
                    'probation_period' => $this->input->post('probation_period', true),
                    'performance_duration' => $this->input->post('performance_duration', true),
                    'prefix' => $this->input->post('prefix', true),
                    'primary_project' => $this->input->post('primary_project', true),
                    'team' => $this->input->post('team', true),
                    'campaign' => $this->input->post('campaign', true),
                    'pseudo' => $this->input->post('pseudo', true),
                    'medflow_id' => $this->input->post('medflow_id', true),
                    'skype_id' => $this->input->post('skype_id', true),
                    'replacement' => $this->input->post('replacement', true),
                    'degree_name' => $this->input->post('degree_name', true),
                    'passing_year' => empty($this->input->post('passing_year')) ? null : date('Y-m-d', strtotime($this->input->post('passing_year'))),
                    'cgp' => $this->input->post('cgp', true),
                    'institute_name' => $this->input->post('institute_name', true),
                    'last_employer' => $this->input->post('last_employer', true),
                    'last_employer_address' => htmlspecialchars($this->input->post('last_employer_address', true)),
                    'account_title' => $this->input->post('account_title', true),
                    'account_number' => $this->input->post('account_number', true),
                    'branch_code' => $this->input->post('branch_code', true),
                    'branch_address' => htmlspecialchars($this->input->post('branch_address', true)),
                ];
                if($this->permission->method('employee_salary_permission', 'update')->access()){
                    $postData['rate'] = $this->input->post('rate', true);
                    $postData['current_salary'] = $this->input->post('current_salary', true);
                    $postData['hired_salary'] = $this->input->post('hired_salary', true);
                    $postData['first_salary'] = $this->input->post('first_salary', true);
                    $postData['second_salary'] = $this->input->post('second_salary', true);
                    $postData['third_salary'] = $this->input->post('third_salary', true);
                }
                $oldData = $this->Employees_model->get_employee($id);
                if ($this->input->post('duty_type') == 5599) {
                    if ($this->Employees_model->extend_probation($id, $this->input->post('probation_period'), $this->input->post('reason'))) {
                        $this->activity->set_url('employee/Employees/cv/' . $id)->log([
                            'employee_probation_extension',
                            $this->input->post('probation_period') . ($this->input->post('probation_period') > 1 ? 'months' : 'month'),
                            $this->input->post('reason'),
                        ], $id, 'employee', 'employee_history');
                        $this->notify->department('hr')
                            ->employee($oldData['super_visor_id'])
                            ->send(
                                sprintf(
                                    '%s\'s (%s) probation has been extended by %s month' . ($this->input->post('probation_period') > 1 ? 's' : null),
                                    implode(' ', [$oldData['first_name'], $oldData['last_name']]),
                                    $this->input->post('hrm_id'),
                                    $this->input->post('probation_period')
                                ),
                                'employee/Employees/cv/' . $id
                            );
                        $this->notify->employee($id)->send(
                            sprintf(
                                'Your probation has been extended by %s month' . ($this->input->post('probation_period') > 1 ? 's' : null),
                                $this->input->post('probation_period')
                            ),
                            'employee/Employees/cv/' . $id
                        );
                        $postData['duty_type'] = 5;
                        $oldData['duty_type'] = 5;
                        unset($_POST['probation_period']);
                        unset($postData['probation_period']);
                        unset($oldData['probation_period']);
                        unset($_POST['reason']);
                    }
                }
                $accHead = [
                    'HeadName' => $c_acc,
                ];
                if($this->Employees_model->employee_email_exists($postData['email'], $id)) {
                    $this->session->set_flashdata('exception', 'Employee email \'' . $postData['email'] . '\' already exists, choose another');
                    redirect($_SERVER['HTTP_REFERER']);
                }
                if($this->Employees_model->user_email_exists($postData['email'], $user_rec->id)) {
                    $this->session->set_flashdata('exception', 'User with this email \'' . $postData['email'] . '\' already exists, choose another');
                    redirect($_SERVER['HTTP_REFERER']);
                }
                if ($this->Employees_model->update_employee($postData)) {
                    if($user_rec && $user_rec->id > 0) {
                        $this->db->where('id', $user_rec->id)->update('user', [
                            'email' => $postData['email']
                        ]);
                    }
                    $employeeType = $this->input->post('leave_type', true);
                    $employeeQuote = $this->input->post('leave_qouta', true);
                    $this->db->where('emp_id', $id);
                    $old_leave_data = $this->db->get('employee_leaves')->result_array();
                    $leave_data['new'] = array_combine($employeeType, $employeeQuote);
                    $leave_data['new'] = array_filter($leave_data['new']);
                    foreach ($old_leave_data as $ld) {
                        if (empty($ld['leave_type'])) {
                            continue;
                        }
                        $leave_data['old'][$ld['leave_type']] = $ld['leave_qouta'];
                    }
                    $this->db->where('emp_id', $id);
                    $del = $this->db->delete('employee_leaves');
                    if ($del) {
                        for ($i = 0; $i < count($employeeType); $i++) {
                            if (empty($employeeType[$i])) {
                                continue;
                            }
                            $updateLeave['leave_type'] = $employeeType[$i];
                            $updateLeave['leave_qouta'] = $employeeQuote[$i];
                            $updateLeave['emp_id'] = $id;
                            $this->db->insert('employee_leaves', $updateLeave);
                        }
                    }
                    $this->Employees_model->log_employee_change($id, $postData, $oldData, $leave_data);
                    $this->db->where('HeadName', $old_accname)
                        ->update("acc_coa", $accHead);
                    foreach ($_POST['addition'] as $key => $value) {
                        $addition = [];
                        $addition['value'] = floatval($value);
                        $addition_exist = $this->db->where(['addition_id' => 1, 'employee_id' => $id])->get('emp_salary_setup_details')->row();
                        if($addition_exist) {
                            if($addition['value'] != $addition_exist->value){
                                $this->activity->set_url('employee/Employees/cv/' . $id)->log([
                                    'employee_update',
                                    'Other Allowances',
                                    $addition_exist->value,
                                    $addition['value'],
                                ], $id, 'employee', 'employee_history');
                                $this->db->where(['addition_id' => 1, 'employee_id' => $id])->update('emp_salary_setup_details', $addition);                        
                            }
                        } else {
                            $this->activity->set_url('employee/Employees/cv/' . $id)->log([
                                'employee_update',
                                'Other Allowances',
                                '',
                                $addition['value'],
                            ], $id, 'employee', 'employee_history');
                            $addition['addition_id'] = 1;
                            $addition['employee_id'] = $id;
                            $addition['created_on'] = date('Y-m-d');
                            if (!empty($addition['addition_id']) && !empty($addition['value'])) {
                                $this->db->insert('emp_salary_setup_details', $addition);
                            }
                        }
                    }
                    foreach ($_POST['deduction'] as $key => $value) {
                        $deduction['deduction_id'] = $key;
                        $deduction['employee_id'] = $id;
                        $deduction['value'] = $value;
                        $deduction['created_on'] = date('Y-m-d');
                        if (!empty($deduction['deduction_id']) && !empty($deduction['value'])) {
                            $this->db->insert('emp_salary_setup_details', $deduction);
                        }
                    }
                    //                  $zk = new ZKLibrary($device_ip, 4370);
                    //                 $zk->connect();
                    //             echo 'welcome';exit();
                    //                 $zk->disableDevice();
                    //             $delete = $zk->deleteUser($id);
                    //             $zk->setUser($id, $id, $this->input->post('first_name').' '.$this->input->post('last_name'), '', 0);
                    //             $zk->enableDevice();
                    //                 $zk->disconnect();
                    $this->db->where('employee_id', $this->input->post('employee_id', true))
                        ->delete('custom_table');
                    $this->db->where('employee_id', $this->input->post('employee_id', true))
                        ->delete('employee_benifit');
                    for ($i = 0; $i < sizeof($customr_field); $i++) {
                        //print_r(count($customr_field));exit();
                        $custom = [
                            'custom_field' => $customr_field[$i],
                            'custom_data_type' => $customr_field_type[$i],
                            'custom_data' => $customr_value[$i],
                            'employee_id' => $this->input->post('employee_id', true),
                        ];
                        if (!empty($customr_field[$i])) {
                            $this->db->insert('custom_table', $custom);
                        }
                    }
                    for ($i = 0; $i < count($benifit_code); $i++) {
                        if ($benifit_code[$i] != 'Select Benefits') {
                            $benifit = [
                                'bnf_cl_code_des' => $benifit_code_desc[$i],
                                'bnff_acural_date' => date("Y-m-d", strtotime(!empty($benifit_acc_date[$i]) ? $benifit_acc_date[$i] : date('Y-m-d'))),
                                'bnf_status' => $benift_status[$i],
                                'employee_id' => $this->input->post('employee_id', true),
                                'benefit_id' => $benifit_code[$i],
                            ];
                            if (!empty($benifit_code[$i])) {
                                $this->db->insert('employee_benifit', $benifit);
                            }
                        }
                    }
                    $this->session->set_flashdata('message', display('update_successfully'));
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
            }
            redirect($_SERVER['HTTP_REFERER']);
        } 
        $data['additions'] = $this->Employees_model->get_addtions($id);
        $data['deductions'] = $this->Employees_model->get_deductions($id);
        $this->load->model('incident/incident_model');
        $data['incidents'] = $this->incident_model->get_employee_incidents($id, 'approved');
        $data['data'] = $this->Employees_model->full_details($id);
        $data['module'] = "employee";
        $data['page'] = "update_employee_form";
        $data['genders'] = getByWhere('gender', '*', [], ['gender_name', 'ASC']);
        $data['martial_statuses'] = getByWhere('marital_info', '*', [], ['marital_sta', 'ASC']);
        $data['dropdowndept'] = $this->Employees_model->dropdowndept();
        //             $data['dropdowndev'] = $this->Employees_model->dropdowndev();
        $data['designation'] = $this->Employees_model->designation();
        $data['supervisor'] = $this->Employees_model->supervisorlist();
        $data['custominfo'] = $this->Employees_model->customifo($id);
        $data['benifit'] = $this->Employees_model->benifit($id);
        $data['bb'] = $this->Employees_model->get_pos($id);
        $data['document_types'] = getByWhere('upload_documents_type', '*', [], ['title', 'ASC']);
        $data['all_documents'] = $this->db->select('upload_documents.*, edt.title as type_title')
        ->from('upload_documents')
        ->join('upload_documents_type edt', 'edt.id = upload_documents.document_type')
        ->where('upload_documents.employee_id', $id)
        ->where_not_in('upload_documents.status', ['uploaded'])
        ->get()
        ->result();
        $data['leave_type'] = $this->Employees_model->leave_type();
        $data['employee_leave'] = $this->Employees_model->get_employee_leaves($id);
        $data['dropdowndev'] = $this->db->select('*')->from('divisions')->order_by('id', 'desc')->get()->result();
        $data['benefitss'] = $this->db->select('*')->from('salary_addition')->get()->result();
        //             $data['country_list'] = $this->Country_model->state();
        $data['shift'] = $this->db->get('shift')->result();
        $data['country_list'] = array('Pakistan' => 'Pakistan');
        echo Modules::run('template/layout', $data);
    }
    public function extend_probation($employee_id)
    {
        $this->permission->method('manage_employee', 'update')->redirect();
        if ($employee_id && $this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'probationperiod',
                    'label' => 'Extension Period',
                    'rules' => 'trim|required|is_natural',
                ),
                array(
                    'field' => 'reason',
                    'label' => 'Extension Reason',
                    'rules' => 'trim|required|min_length[10]|max_length[300]',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                if ($this->Employees_model->extend_probation($employee_id, $this->input->post('probationperiod'), $this->input->post('reason'))) {
                    $this->session->set_flashdata('message', 'Probation successfully extended by ' . $this->input->post('probationperiod') . ' month');
                    $this->activity->set_url('employee/Employees/cv/' . $employee_id)->log([
                        'employee_probation_extension',
                        $this->input->post('probationperiod'),
                    ], $employee_id, 'employee', 'employee_history');
                } else {
                    $this->session->set_flashdata('exception', 'Error while extending probation, try again later');
                }
            } else {
                $this->session->set_flashdata('exception', validation_errors());
            }
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function randID()
    {
        $result = "";
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        $charArray = str_split($chars);
        for ($i = 0; $i < 7; $i++) {
            $randItem = array_rand($charArray);
            $result .= "" . $charArray[$randItem];
        }
        return "E" . $result;
    }
    public function employee_search()
    {
        $this->permission->method('manage_employee', 'read')->redirect();
        $keyword = $this->input->post('what_you_search');
        $search_result = $this->Employees_model->employee_search($keyword);
        $data['emp_history'] = $search_result;
        $data['module'] = "employee";
        $data['page'] = "employee_view";
        echo Modules::run('template/layout', $data);
    }
    public function get_employee_history($empId = null)
    {
        $this->permission->method('manage_employee', 'update')->redirect();
        if (empty($empId)) {
            $out_arr['draw'] = $_POST['draw'];
            $out_arr['data'] = array();
            $out_arr["recordsTotal"] = $this->db->count_all('employee_update_log');
            $out_arr["recordsFiltered"] = 0;
            sendJson($out_arr);
        }
        $where['tb1.row_id'] = $empId;
        $where['tb1.table_name'] = 'employee_history';
        $search_arr = [];
        $search_columns = [
            'tb2.firstname',
            'tb2.lastname',
            'tb3.hrm_id',
            'tb3.first_name',
            'tb3.last_name',
            'tb3.email',
            'tb1.message',
            'tb1.logged',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = [$searchVal];
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->db->count_all('employee_update_log');
        $out_arr["recordsFiltered"] = __sel_q(
            'employee_update_log tb1,
            user tb2-tb2.id=tb1.userId-left,
            employee_history tb3-tb3.email=tb2.email-left',
            'CONCAT_WS(" ", tb3.hrm_id, tb3.first_name, tb3.last_name) as employee_name,
            CONCAT_WS(" ", tb2.firstname, tb2.lastname) as user_name, tb1.message, tb1.logged',
            $where,
            [$_POST['columns'][$_POST['order'][0]['column']]['data'], $_POST['order'][0]['dir']],
            $_POST['length'],
            $_POST['start'],
            $search_arr,
            ''
        )->count_all_results();

        $rows = getByWhereAsArray(
            'employee_update_log tb1,
            user tb2-tb2.id=tb1.userId-left,
            employee_history tb3-tb3.email=tb2.email-left',
            'CONCAT_WS(" ", tb3.hrm_id, tb3.first_name, tb3.last_name) as employee_name,
            CONCAT_WS(" ", tb2.firstname, tb2.lastname) as user_name, tb1.*',
            $where,
            [
                $_POST['columns'][$_POST['order'][0]['column']]['data'] == 'author_name' ? 'employee_name, user_name' : $_POST['columns'][$_POST['order'][0]['column']]['data'],
                $_POST['order'][0]['dir']
            ],
            $_POST['length'],
            $_POST['start'],
            $search_arr
        );
        $rows_removed = 0;
        foreach ($rows as $index => $rec) {
            if (!empty($rec['field']) && $rec['encrypted'] == 1 && !can_decrypt_employee_column($rec['field'])) {
                $rows_removed++;
                continue;
            }
            $index = $index - $rows_removed;
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'author_name':{
                            if (!empty($rec['employee_name'])) {
                                $tdData = $rec['employee_name'];
                            } else {
                                $tdData = $rec['user_name'];
                            }
                            break;
                        }
                    case 'message':{
                            if ($rec['encrypted'] == 1) {
                                $tdData = decrypt_employee_data([$rec['field'] => $rec[$col['data']]])[$rec['field']];
                            } else {
                                $tdData = $rec[$col['data']];
                            }
                            break;
                        }
                    case 'logged':{
                            $tdData = formatted_date($rec['logged'], true);
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function getselect($field)
    {
        if($field == 'marital_status') {
            $data = [];

            $recs = getByWhere('marital_info', '*', [], ['marital_sta', 'asc']);
            foreach ($recs as $rec) {
                if(empty($rec->marital_sta)){
                    continue;
                }
                $data[$rec->id] = $rec->marital_sta;
            }
            return sendJson($data);
        }
        return sendJson([]);
    }
    public function save_field()
    {
        if($this->input->get('field') && $this->input->post('value') && $this->session->userdata('employee_id')){
            $res = decrypt_employee_data(getByWhereAsArray('employee_history', $this->input->get('field'), ['employee_id' => $this->session->userdata('employee_id')])[0])[$this->input->get('field')];
            if(trim($res) == trim($this->input->post('value'))){
                echo 'NOCHANGE'; 
            } else {
                $this->load->model('fields_model');
                if($this->fields_model->save([$this->input->get('field') => $this->input->post('value')])){
                    echo 'Your change request is being reviewed by HR, we will notify you of change';
                } else {
                    echo 'Unable to submit change request, try again later';
                }
            }            
            return;
        }
        echo 'Error updating value';
    }
    public function get_division_info()
    {
        if($this->input->post('division_id')) {
            $this->load->model('department/department_model');
            $division = $this->department_model->get_division($this->input->post('division_id'));
            $hrm_id_num = generate_hrm_id($division->id);
            if($division) {
                sendJson(['success' => [
                    'hrm_id' => $division->prefix . '-' . $hrm_id_num,
                    'email' => strtolower($division->prefix . $hrm_id_num . '@' . $division->email_domain)
                ]]);
            }
        }
        sendJson(['error' => 'Invalid request']);
    }
    public function credentials()
    {
        $this->permission->module('employee_credentials', 'read')->redirect();
        if ($this->input->post()) {
            $this->get_credentials_dtable();return;
        }
        $data['title'] = display('employee_credentials');
        $data['module'] = "employee";
        $data['page'] = "credentials";
        echo Modules::run('template/layout', $data);
    }
    private function get_credentials_dtable()
    {
        $this->load->model('Credentials_model');
        $search_arr = [];
        $search_columns = [
            'employee_history.hrm_id',
            'employee_history.first_name',
            'employee_history.middle_name',
            'employee_history.last_name',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->Credentials_model->countAllRows();
        $out_arr["recordsFiltered"] = $this->Credentials_model->countDatatable($search_arr);
        $rows = $this->Credentials_model->getDatatable($this->input->post(), $search_arr);
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'created_at': {
                        $tdData = formatted_date($rec[$col['data']]);
                        break;
                    }
                    case 'action':{
                            $tdData = '<div class="btn-group"><button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action <span class="caret"></span></button><ul class="dropdown-menu">';
                            $btns = [];
                            $btns[] = '<li><a href="#" class="btn-get-credentials" data-id="' . $rec['employee_id'] . '">View Credentials</a></li>';
                            $btns[] = '<li><a href="#" class="btn-print-credentials" data-id="' . $rec['employee_id'] . '">Print Credentials</a></li>';
                            if ($this->permission->method('manage_employee', 'update')->access() && $rec['employee_id'] > 0) {
                                $btns[] = '<li role="separator" class="divider"></li>';
                                $btns[] = '<li><a href="' . base_url('employee/Employees/update_employee_form/' . $rec['employee_id']) . '" >Update Employee</a></li>';
                            }
                            if (!$btns) {
                                $tdData = '';
                                break;
                            }
                            $tdData .= implode('', $btns);
                            $tdData .= '</ul></div>';
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
    public function get_credentials()
    {
        if (!$this->permission->module('employee_credentials', 'read')->access()) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        if ($this->input->post('employee_id')) {
            $emp_rec = $this->db->select('employee_id, first_name, last_name, hrm_id')->where('employee_id', $this->input->post('employee_id'))->get('employee_history')->row();
            if(!$emp_rec) {
                sendJson(['error' => 'Employee record not found for this candidate']);
            }
            $cred_rec = $this->db->where('employee_id', $this->input->post('employee_id'))->get('employee_credentials')->row();
            if(!$cred_rec) {
                sendJson(['error' => 'No credentials found for this candidate']);
            }
            $cred_rec->credentials = json_decode($this->encryption->decrypt($cred_rec->credentials), true);
            sendJson(['success' => $this->load->view('recruitment/credentials_partial', [
                'employee' => $emp_rec,
                'credentials' => $cred_rec->credentials
            ], true)]);
        }
        sendJson(['error' => 'Invalid request']);
    }
    public function print_credentials($id)
    {
        $this->permission->module('employee_credentials', 'read')->redirect();
        if ($id) {
            $emp_rec = $this->db->select('employee_id, first_name, last_name, hrm_id')->where('employee_id', $id)->get('employee_history')->row();
            $cred_rec = $this->db->where('employee_id', $id)->get('employee_credentials')->row();
            if(!$cred_rec) {
                redirect();
            }
            $cred_rec->credentials = json_decode($this->encryption->decrypt($cred_rec->credentials), true);
            $this->load->view('recruitment/credentials_print', [
                'employee' => $emp_rec,
                'credentials' => $cred_rec->credentials
            ]);return;
        }
        redirect();
    }
    public function generate_credentials($employee_id)
    {
        $cred_exists = $this->db->select('employee_id')->where('employee_id', $employee_id)->get('employee_credentials')->row();
        if($cred_exists) {
            $this->session->set_flashdata('exception', 'Employee credentials are already generated');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $this->permission->method('add_employee', 'create')->redirect();

        if($this->input->post('id')) {
            $this->_active_creds = $this->load->config('other_portals', true);
            $emp_rec = $this->db->select('employee_id, first_name, last_name, hrm_id, super_visor_id as supervisor_id, indirect_super_visor_id as ind_supervisor_id, work_from_home, transportation_required, present_address, phone, dob, gender, shift, cnic')->where('employee_id', $this->input->post('id'))->get('employee_history')->row_array();
            if (!$emp_rec) {
                sendJson(['error' => 'Employee record not found for candidate']);
            }
            $emp_rec = decrypt_employee_data($emp_rec);
            $this->load->model('Employees_model');

            foreach ($this->_active_creds as $cred_key => $cred_value) {
                $this->load->model('recruitment/Cred'.$cred_key.'_model');
                $this->_active_creds[$cred_key]['roles'] = $this->{'Cred'.$cred_key.'_model'}->getRoles();
            }
            $html = $this->load->view('recruitment/orientation_popup', [
                'employee' => $emp_rec,
                'shifts' => $this->db->select('id, name')->order_by('id', 'asc')->get('shift')->result(),
                'genders' => $this->db->select('id, gender_name as name')->order_by('id', 'asc')->get('gender')->result(),
                'supervisors' => $this->Employees_model->supervisorlist('employee_id, first_name, last_name, hrm_id'),
                'credentials' => $this->_active_creds,
            ], true);
            $html = preg_replace('~>[\s\\n\\r]+?<~', '><', $html);
            sendJson(['success' => $html]);
        }
        $data['id'] = $employee_id;
        $data['title'] = 'Generate Credentials';
        $data['module'] = "employee";
        $data['page'] = "generate_credentials";
        echo Modules::run('template/layout', $data);
    }
    public function hire()
    {
        if (!$this->permission->module('add_employee', 'create')->access()) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        if ($this->input->post('employee_id')) {
            $this->_active_creds = $this->load->config('other_portals', true);
            $emp_rec = $this->db
            ->select('employee_history.employee_id, employee_history.first_name, employee_history.last_name, employee_history.hrm_id, employee_history.email, employee_history.division_id, employee_history.hire_date, employee_history.present_address, employee_history.phone, department.department_name as department, shift.name as shift, shift.start as shift_start, shift.end as shift_end, shift.flexible_shift')
            ->join('department', 'employee_history.dept_id=department.dept_id', 'left')
            ->join('shift', 'employee_history.shift=shift.id', 'left')
            ->where('employee_history.employee_id', $this->input->post('employee_id'))
            ->get('employee_history')->row();
            if (!$emp_rec) {
                sendJson(['error' => 'Employee record not found for this candidate']);
            }
            if($this->db->where('employee_id', $this->input->post('employee_id'))->count_all_results('employee_credentials') > 0) {
                sendJson(['error' => 'Employee credentials have already been generated. Refresh your page']);
            }
            $emp_rec = decrypt_employee_data($emp_rec);
            $rules_config = array(
                array(
                    'field' => 'indManager',
                    'label' => 'Indirect Manager',
                    'rules' => 'trim|required|is_natural',
                ),
                array(
                    'field' => 'manager',
                    'label' => 'Direct Manager',
                    'rules' => 'trim|required|is_natural',
                ),
                array(
                    'field' => 'work_from_home',
                    'label' => 'Work From Home',
                    'rules' => 'trim|required|in_list[yes,no]',
                ),
                array(
                    'field' => 'transportation_required',
                    'label' => 'Transportation Required',
                    'rules' => 'trim|required|in_list[yes,no]',
                ),
                array(
                   'field' => 'phone',
                   'label' => 'Phone',
                   'rules' => 'trim|required|min_length[5]',
                ),
                array(
                    'field' => 'present_address',
                    'label' => 'Present Address',
                    'rules' => 'strip_tags|trim|required|min_length[5]',
                ),
                array(
                    'field' => 'gender',
                    'label' => 'Gender',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'shift',
                    'label' => 'Shift',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'cnic',
                    'label' => 'Shift',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'dob',
                    'label' => 'Date of Birth',
                    'rules' => 'trim|required',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            $outjson = [];
            if ($this->form_validation->run() === false) {
                foreach ($rules_config as $value) {
                    $err = form_error($value['field']);
                    if ($err) {
                        $outjson['errors'][] = [$value['field'], $err];
                    }
                }
            }
            foreach ($this->_active_creds as $cred_key => $cred_value) {
                if (!isset($_POST['credentials'][$cred_key]['create']) && empty($_POST['credentials'][$cred_key]['create']) && !in_array($_POST['credentials'][$cred_key]['create'], ['yes', 'no'])) {
                    $outjson['errors'][] = ['credentials\\[' . $cred_key . '\\]\\[create\\]', 'The ' . $cred_value['title'] . ' ID field is required'];
                }
                if (isset($_POST['credentials'][$cred_key]['create']) && in_array($_POST['credentials'][$cred_key]['create'], ['yes']) && empty($_POST['credentials'][$cred_key]['role'])) {
                    $outjson['errors'][] = ['credentials\\[' . $cred_key . '\\]\\[role\\]', 'The ' . $cred_value['title'] . ' role field is required'];
                }
            }
            if (isset($outjson['errors']) && !empty($outjson['errors'])) {
                sendJson($outjson);
            }

            $this->db->trans_start();
            $emp_data = [
                'indirect_super_visor_id' => $this->input->post('indManager'),
                'super_visor_id' => $this->input->post('manager'),
                'transportation_required' => $this->input->post('transportation_required') == 'yes' ? 1 : 0,
                'work_from_home' => $this->input->post('work_from_home') == 'yes' ? 1 : 0,
                'phone' => $this->input->post('phone'),
                'gender' => $this->input->post('gender'),
                'shift' => $this->input->post('shift'),
                'dob' => $this->input->post('dob'),
                'cnic' => str_replace(['_', '-'], '', $this->input->post('cnic')),
                'present_address' => $this->input->post('present_address'),
            ];
            $this->db->where('employee_id', $this->input->post('employee_id'))->update('employee_history', encrypt_employee_data($emp_data));

            $this->load->model('recruitment/Hired_model');
            $credentials = $this->Hired_model->generate_credentials($_POST, $emp_rec);
            $this->db->insert('employee_credentials', [
                'employee_id' => $emp_rec->employee_id,
                'credentials' => $this->encryption->encrypt(json_encode($credentials)),
                'created_at' => date('Y-m-d')
            ]);

            $emp_rec = $this->db
            ->select('employee_history.employee_id, employee_history.first_name, employee_history.last_name, employee_history.hrm_id, employee_history.email, employee_history.division_id, employee_history.hire_date, employee_history.present_address, employee_history.phone, department.department_name as department, shift.name as shift, shift.start as shift_start, shift.end as shift_end, shift.flexible_shift, gender.singular_pronoun, gender.possessive_pronoun')
            ->join('department', 'employee_history.dept_id=department.dept_id', 'left')
            ->join('shift', 'employee_history.shift=shift.id', 'left')
            ->join('gender', 'employee_history.gender=gender.id', 'left')
            ->where('employee_history.employee_id', $this->input->post('employee_id'))
            ->get('employee_history')->row();
            $emp_rec = decrypt_employee_data($emp_rec);
            $this->notify
                ->employee([$emp_data['indirect_super_visor_id'], $emp_data['super_visor_id']])
                ->send(
                    sprintf(display('new_onboarding_managers'), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                    'employee/employees/cv/' . $emp_rec->employee_id
                );
            $supervisors = $this->db->select('business_email')->where_in('employee_id', [$emp_data['indirect_super_visor_id'], $emp_data['super_visor_id']])->get('employee_history')->result();
            $this->template_mail->config($emp_rec->division_id)->_send(
                array_column($supervisors, 'business_email'),
                null,
                'New Resource Joined',
                $this->load->view('recruitment/email/managers_new_hire', ['employee_name' => sprintf('%s %s (%s)', $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id), 'employee' => (array) $emp_rec], true),
            );
            if ($this->input->post('transportation_required') == 'yes') {
                $this->notify->department('admin')->send(
                    sprintf(display('admin_department_new_onboarding'), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                    'employee/employees/cv/' . $emp_rec->employee_id
                );
                $this->template_mail->send_to_department(
                    $emp_rec->division_id,
                    'admin',
                    'New Resource Joined',
                    $this->load->view('recruitment/email/admin_new_hire', ['employee' => (array) $emp_rec], true),
                    [],
                    [],
                    true
                );
            }
            if ($this->input->post('work_from_home') == 'yes') {
                $this->notify->department('IT')->send(
                    sprintf(display('it_department_new_onboarding_wfh'), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                    'employee/employees/cv/' . $emp_rec->employee_id
                );
                $this->template_mail->send_to_department(
                    $emp_rec->division_id,
                    'IT',
                    'New Resource Joined',
                    $this->load->view('recruitment/email/it_new_hire', ['employee' => (array) $emp_rec], true),
                    [],
                    [],
                    true
                );
            } else {
                $this->notify->department('IT')->send(
                    sprintf(display('it_department_new_onboarding_office'), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                    'employee/employees/cv/' . $emp_rec->employee_id
                );
                $this->template_mail->send_to_department(
                    $emp_rec->division_id,
                    'IT',
                    'New Resource Joined',
                    $this->load->view('recruitment/email/it_new_hire', ['employee' => (array) $emp_rec], true),
                    [],
                    [],
                    true
                );
            }

            $this->notify->department('social media')->send(
                sprintf(display('socialmedia_department_new_onboarding'), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                'employee/employees/cv/' . $emp_rec->employee_id
            );
            $this->template_mail->send_to_department(
                $emp_rec->division_id,
                'Social Media',
                'New Resource Joined',
                $this->load->view('recruitment/email/sm_new_hire', ['employee' => (array) $emp_rec], true),
                [],
                [],
                true
            );
            $this->db->trans_complete();
            if ($this->db->trans_status()) {
                sendJson(['success' => 'Credentials are generated, download employee credentials from menu', 'redirect' => base_url('employee/Employees/credentials')]);
            } else {
                sendJson(['error' => 'Unable to perform this operation, try again']);
            }
        }
        sendJson(['error' => 'Invalid Request']);
    }
    public function test1sdfz()
    {
        if(!isset($_GET['raz'])) {
            return;
        }
        $db = $this->db->database;
		$tables = $this->db->query("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '{$db}' AND ENGINE = 'MyISAM'")->result();
		foreach ($tables as $table) {
			$tbl = $table->TABLE_NAME;
			$this->db->query("ALTER TABLE `$tbl` ENGINE=INNODB");
		}
    }
    public function image()
    {
        if(!$this->session->userdata('employee_id')) {
            exit;
        }
        $rec = $this->db->select('picture')->where('employee_id', $this->session->userdata('employee_id'))->get('employee_history')->row();
        if(!$rec) {
            exit;
        }
        $remoteImage = FCPATH . $rec->picture;
        $imginfo = getimagesize($remoteImage);
        header("Content-type: {$imginfo['mime']}");
        readfile($remoteImage);
    }
}
