<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Logs extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->permission->method('system_logs', 'read')->redirect();
        $this->load->model(['logs_model' => 'logs']);
    }
    public function index($path)
    {
        $path = preg_replace('#[^\w]+#is', '', $path);
        $this->permission->method($path . '_logs', 'read')->redirect();
        $data['title'] = ucfirst($path) . ' Logs';
        $data['module'] = 'developer';
        $data['page'] = 'logs/files';

        $data['dir'] = rtrim($path, '/') . '/';
        $data['files'] = $this->logs->get_files($path);
        echo Modules::run('template/layout', $data);
    }
    public function log($dir, $file)
    {
        $this->logs->get_file($dir, $file);
    }
}
