<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User_model extends CI_Model {
 
	public function create($data = array())
	{
		$res = $this->db->insert('user', $data);
		$this->activity->set_user($this->db->insert_id())->log([
			'user_inserted'
		]);
		return $res;
	}

	public function read()
	{
		return $this->db->select("
				user.*, 
				CONCAT_WS(' ', firstname, lastname) AS fullname 
			")
			->from('user')
			->order_by('id', 'desc')
			->get()
			->result();
	}

	public function single($id = null)
	{
		return $this->db->select('*')
			->from('user')
			->where('id', $id)
			->get()
			->row();
	}

	public function update($data = array())
	{
		$this->activity
		->set_user($data['id'])
		->set_url('dashboard/user/index')
		->log('user_updated');
		return $this->db->where('id', $data["id"])
			->update("user", $data);
	}

	public function delete($id = null)
	{
		$this->activity->set_user($id)->log('user_deleted');
		return $this->db->where('id', $id)
			->where_not_in('is_admin',1)
			->delete("user");
	}

	public function dropdown($isAdmin = false)
	{
		$this->db->select("id, CONCAT_WS(' ', firstname, lastname) AS fullname");
			$this->db->from("user");
			$this->db->where('status', 1);
			if($isAdmin != true){
			    $this->db->where_not_in('is_admin', 1);
			}
			
			$data = $this->db->get()
			->result();
		$list[''] = display('select_option');
		if (!empty($data)) {
			foreach($data as $value)
				$list[$value->id] = $value->fullname;
			return $list;
		} else {
			return false; 
		}
	}
 
public function employee(){
    
       $admin               = $this->session->userdata('isAdmin');
		$is_supervisor       = $this->session->userdata('supervisor');
		$direct_supervisor   = $this->session->userdata('direct_supervisor');
		$indirect_supervisor = $this->session->userdata('indirect_supervisor');
		
		$employee_id         = $this->session->userdata('employee_id');
   
        	    $this->db->select("employee_id, CONCAT_WS(' ', first_name, last_name) AS fullname")->from("employee_history");
        if($admin ==1){
            
        }else{
         

	        if($is_supervisor == 1){
        		 $this->db->where('employee_history.super_visor_id',$employee_id);
        		 $this->db->or_where('employee_history.employee_id',$employee_id);
        		 $this->db->or_where('employee_history.indirect_super_visor_id',$employee_id);
    		}else{
              $this->db->where('employee_history.employee_id',$employee_id);
            }   
        }
	$data = $this->db->get()->result();
	$list[''] = display('select_option');
	if (!empty($data)) {
		foreach($data as $value)
			$list[$value->employee_id] = $value->fullname;
		return $list;
	} else {
		return false; 
	}
}
// employee info
public function empinfo($email){
return $result = $this->db->select('first_name,last_name,employee_id')->from('employee_history')->where('email',$email)->get()->row();
}

}
