<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Role extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'module_permission_model',
            'module_model',
            'role_model',
        ));
    }
    public function create_system_role()
    {
		if($this->input->post()) {
			$this->save_create();
		}
        $data['title'] = display('add_role');
        $data['module'] = "dashboard";
        $data['modules'] = $this->db->select('*')->from('sec_menu_item')->where('active', 1)->group_by('module')->get()->result();
        $menu_items = $this->db->select('*')->from('sec_menu_item')->where(['active' => 1])->order_by('parent_menu', 'asc')->get()->result();
        $all_data = [];
        foreach ($menu_items as $menu) {
            if (!isset($all_data[$menu->module])) {
                $all_data[$menu->module] = [];
            }
            if (empty($menu->parent_menu)) {
                $all_data[$menu->module][$menu->menu_id] = $menu;
            } else {
                if (!isset($all_data[$menu->module][$menu->parent_menu])) {
                    $all_data[$menu->module][$menu->parent_menu] = new stdClass();
                    $all_data[$menu->module][$menu->parent_menu]->childs = [];
                }
                $all_data[$menu->module][$menu->parent_menu]->childs[] = $menu;
            }
        }
        $data['module_data'] = $all_data;
        $this->load->model('auth_model');
        $data['exclude_full_permission'] = $this->auth_model->exclude_full_permission;
        $data['page'] = "role/_create_system_role";
        echo Modules::run('template/layout', $data);
    }
    private function save_create()
    {
        $this->form_validation->set_rules('role_name', display('role_name'), 'required|max_length[100]|is_unique[sec_role_tbl.role_name]');
        $this->form_validation->set_rules('role_description', display('role_description'), 'required|max_length[200]');
        if ($this->form_validation->run() == true) {
            /*-----------------------------------*/
            $menu = $this->input->post('menu');
            $new_array = array();
            foreach ($menu as $menu_id => $menu_data) {
                $dataStore = array(
                    'menu_id' => $menu_id,
                    'can_create' => in_array('create', $menu_data) ? 1 : 0,
                    'can_edit' => in_array('edit', $menu_data) ? 1 : 0,
                    'can_access' => in_array('read', $menu_data) ? 1 : 0,
                    'can_delete' => in_array('delete', $menu_data) ? 1 : 0,
                );
                array_push($new_array, $dataStore);
            }
            $save_data = array(
                'role_name' => $this->input->post('role_name'),
                'role_description' => $this->input->post('role_description'),
                'create_by' => $this->session->userdata('id'),
                'date_time' => date('Y-m-d h:i:s'),
                'roles' => $new_array,
            );
            if ($this->role_model->create($save_data, $_POST)) {
                $this->activity->set_url('dashboard/role/role_list')->log([
                    'role_inserted',
                    $save_data['role_name'],
                ]);
                $this->session->set_flashdata('message', display('module_permission_added_successfully'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("dashboard/role/create_system_role");
        }
    }
    public function role_list()
    {
        $data['title'] = display('role_list');
        $data['module'] = "dashboard";
        $data['role_list'] = $this->db->select('*')->from('sec_role_tbl')->get()->result();
        $data['page'] = "role/_role_list";
        echo Modules::run('template/layout', $data);
    }
    public function edit_role($id = null)
    {
		if($this->input->post()) {
			$this->save_update();
		}
        $data['title'] = display('edit_role');
        $data['module'] = "dashboard";
        $data['modules'] = $this->db->select('*')->from('sec_menu_item')->where('active', 1)->group_by('module')->get()->result();
        $menu_items = $this->db->select('*')->from('sec_menu_item')->where(['active' => 1])->order_by('parent_menu', 'asc')->get()->result();
        $all_data = [];
        foreach ($menu_items as $menu) {
            if (!isset($all_data[$menu->module])) {
                $all_data[$menu->module] = [];
            }
            if (empty($menu->parent_menu)) {
                $all_data[$menu->module][$menu->menu_id] = $menu;
            } else {
                if (!isset($all_data[$menu->module][$menu->parent_menu])) {
                    $all_data[$menu->module][$menu->parent_menu] = new stdClass();
                    $all_data[$menu->module][$menu->parent_menu]->childs = [];
                }
                $all_data[$menu->module][$menu->parent_menu]->childs[] = $menu;
            }
        }
        $data['module_data'] = $all_data;
        $data['roleData'] = $this->db->select('*')
            ->from('sec_role_tbl')
            ->where('role_id', $id)
            ->get()->row();
        $data['roleAcc'] = $this->db->select('sec_role_permission.*,sec_menu_item.menu_title')
            ->from('sec_role_permission')
            ->join('sec_menu_item', 'sec_menu_item.menu_id=sec_role_permission.menu_id')
            ->where('role_id', $id)
            ->get()->result();
        $data['full_access'] = [];
        $full_access = $this->db->where('role_id', $id)->get('sec_full_access_permission')->result();
        foreach ($full_access as $facc) {
            $data['full_access'][$facc->module] = $facc;
        }
        $data['page'] = "role/edit_role";
        $this->load->model('auth_model');
        $data['exclude_full_permission'] = $this->auth_model->exclude_full_permission;
        echo Modules::run('template/layout', $data);
    }
    private function save_update()
    {
        /*-----------------------------------*/
        $this->form_validation->set_rules('role_name', display('role_name'), 'required|max_length[100]');
        $this->form_validation->set_rules('role_description', display('role_description'), 'required|max_length[200]');
        if ($this->form_validation->run() == true) {
            /*-----------------------------------*/
            $menu = $this->input->post('menu');
            $new_array = array();
            foreach ($menu as $menu_id => $menu_data) {
                $dataStore = array(
                    'menu_id' => $menu_id,
                    'can_create' => in_array('create', $menu_data) ? 1 : 0,
                    'can_edit' => in_array('edit', $menu_data) ? 1 : 0,
                    'can_access' => in_array('read', $menu_data) ? 1 : 0,
                    'can_delete' => in_array('delete', $menu_data) ? 1 : 0,
                );
                array_push($new_array, $dataStore);
            }
            $save_data = array(
                'role_name' => $this->input->post('role_name'),
                'role_description' => $this->input->post('role_description'),
                'role_id' => $this->input->post('role_id'),
                'roles' => $new_array,
            );
            if ($this->role_model->update_perms($save_data, $_POST)) {
                $this->activity->log([
                    'role_updated',
                    $save_data['role_name'],
                    $save_data['role_id'],
                ]);
                $this->session->set_flashdata('message', display('module_permission_updated_successfully'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("dashboard/role/role_list");
        }
    }
    public function delete_role($id = null)
    {
        $role_rec = $this->db->where('role_id', $id)->get('sec_role_tbl')->row();
        $delete = $this->db->where('role_id', $id)->delete('sec_role_tbl');
        $delete = $this->db->where('role_id', $id)->delete('sec_role_permission');
        if ($delete) {
            $this->activity->log([
                'role_deleted',
                $role_rec->role_name,
                $id,
            ]);
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("dashboard/role/role_list");
    }
    public function user_access_role()
    {
        $data['title'] = display('user_access_role');
        $data['module'] = "dashboard";
        $data['page'] = "role/user_access_role";
        $data['user_access_role'] = $this->db->select('sec_user_access_tbl.*,sec_role_tbl.*,user.firstname,user.lastname, GROUP_CONCAT(sec_role_tbl.role_name SEPARATOR \', \') role_name')
            ->from('sec_user_access_tbl')
            ->join('user', 'user.id=sec_user_access_tbl.fk_user_id')
            ->join('sec_role_tbl', 'sec_role_tbl.role_id=sec_user_access_tbl.fk_role_id')
            ->order_by('sec_user_access_tbl.fk_user_id')
            ->group_by('user.id')
            ->get()->result();
        echo Modules::run('template/layout', $data);
    }
    public function assign_role_to_user()
    {
        $data['title'] = " Assing Role To User";
        $data['module'] = "dashboard";
        $data['role'] = $this->db->select('role_name,role_id')->from('sec_role_tbl')->get()->result();
        $data['user'] = $this->db->select('id,firstname,lastname')
            ->from('user')
            ->where('is_admin!=', 1)
            ->get()
            ->result();
        $data['page'] = "role/_assign_role_to_user";
        echo Modules::run('template/layout', $data);
    }
    public function save_role_access()
    {
        $new_array = array();
        $role_id = $this->input->post('role');
        $user_id = $this->input->post('user_id');
        for ($j = 0; $j < sizeof($role_id); $j++) {
            $rolData = array(
                'fk_role_id' => $role_id[$j],
                'fk_user_id' => $user_id,
            );
            array_push($new_array, $rolData);
        }
        $user_roles_old = $this->db->select('fk_role_id, fk_user_id')->where('fk_user_id', $user_id)->get('sec_user_access_tbl')->result_array();
        $changes = array_diff_multi($user_roles_old, $new_array, 'fk_role_id');
        foreach ($changes['added'] as $added_role) {
            $role_rec = $this->db->where('role_id', $added_role['fk_role_id'])->get('sec_role_tbl')->row();
            $this->activity->set_url('dashboard/role/user_access_role')->set_user($user_id)->log([
                'role_assigned',
                $role_rec->role_name,
            ], get_employee_by_user_id($user_id)->employee_id, 'employee');
        }
        foreach ($changes['removed'] as $removed_role) {
            $role_rec = $this->db->where('role_id', $removed_role['fk_role_id'])->get('sec_role_tbl')->row();
            $this->activity->set_url('dashboard/role/user_access_role')->set_user($user_id)->log([
                'role_unassigned',
                $role_rec->role_name,
            ], get_employee_by_user_id($user_id)->employee_id, 'employee');
        }
        $this->db->where('fk_user_id', $new_array[0]['fk_user_id'])->delete('sec_user_access_tbl');
        $this->db->insert_batch('sec_user_access_tbl', $new_array);
        $this->session->set_flashdata('message', display('save_successfully'));
        redirect("dashboard/role/assign_role_to_user");
    }
    public function edit_access_role($id = null)
    {
        $data['title'] = display('edit');
        $data['module'] = "dashboard";
        $data['page'] = "role/edit_role_access";
        $data['role'] = $this->db->select('role_name,role_id')->from('sec_role_tbl')->get()->result();
        $data['user'] = $this->db->select('id,firstname,lastname')
            ->from('user')
            ->where('is_admin!=', 1)
            ->get()
            ->result();
        $data['info'] = $this->db->select('*')->from('sec_user_access_tbl')->where('role_acc_id', $id)->get()->row();
        echo Modules::run('template/layout', $data);
    }
    public function update_access_role()
    {
        $new_array = array();
        $role_id = $this->input->post('role');
        $user_id = $this->input->post('user_id');
        for ($j = 0; $j < sizeof($role_id); $j++) {
            $rolData = array(
                'fk_role_id' => $role_id[$j],
                'fk_user_id' => $user_id,
            );
            array_push($new_array, $rolData);
        }
        $user_roles_old = $this->db->select('fk_role_id, fk_user_id')->where('fk_user_id', $user_id)->get('sec_user_access_tbl')->result_array();
        $changes = array_diff_multi($user_roles_old, $new_array, 'fk_role_id');
        foreach ($changes['added'] as $added_role) {
            $role_rec = $this->db->where('role_id', $added_role['fk_role_id'])->get('sec_role_tbl')->row();
            $this->activity->set_url('dashboard/role/user_access_role')->set_user($user_id)->log([
                'role_assigned',
                $role_rec->role_name,
            ], get_employee_by_user_id($user_id)->employee_id, 'employee');
        }
        foreach ($changes['removed'] as $removed_role) {
            $role_rec = $this->db->where('role_id', $removed_role['fk_role_id'])->get('sec_role_tbl')->row();
            $this->activity->set_url('dashboard/role/user_access_role')->set_user($user_id)->log([
                'role_unassigned',
                $role_rec->role_name,
            ], get_employee_by_user_id($user_id)->employee_id, 'employee');
        }
        $this->db->where('fk_user_id', $new_array[0]['fk_user_id'])->delete('sec_user_access_tbl');
        $this->db->insert_batch('sec_user_access_tbl', $new_array);
        $this->session->set_flashdata('message', display('update_successfully'));
        redirect("dashboard/role/user_access_role");
    }
    public function delete_access_role($id)
    {
        $user_rec = $this->db->select('user.firstname, user.lastname')->where('sec_user_access_tbl.role_acc_id', $id)->join('user', 'sec_user_access_tbl.fk_user_id=user.id', 'left')->get('sec_user_access_tbl')->row();
        $res = $this->db->where('role_acc_id', $id)->delete('sec_user_access_tbl');
        if ($res) {
            $this->activity->log([
                'user_access_deleted',
                $user_rec->firstname,
                $user_rec->lastname,
            ]);
        }
        $this->session->set_flashdata('message', display('delete_successfully'));
        redirect("dashboard/role/user_access_role");
    }
    public function checkedrole()
    {
        $user_id = $this->input->post('user_id');
        $data = $this->db->select('fk_role_id')->from('sec_user_access_tbl')->where('fk_user_id', $user_id)->get()->result();
        $role = $data->fk_role_id;
        $r = [];
        foreach ($data as $value) {
            $r[] = $value->fk_role_id;
        }
        if (!empty($r)) {
            $info = array(
                'role' => $r,
                'status' => 'true',
            );
        } else {
            $info = array(
                'role' => $r,
                'status' => 'false',
            );
        }
        echo json_encode($info);
    }
}
