<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Award_model extends CI_Model {
 
    public function award_view($id=null)
	{
		$admin               = $this->session->userdata('isAdmin');
		$is_supervisor       = $this->session->userdata('supervisor');
		$direct_supervisor   = $this->session->userdata('direct_supervisor');
		$indirect_supervisor = $this->session->userdata('indirect_supervisor');
		$employee_id         = $this->session->userdata('employee_id');
		$this->db->select('count(DISTINCT(aw.award_id)) as award_id,aw.*,p.employee_id,p.first_name,p.last_name,
			(select employee_history.first_name from employee_history where employee_history.employee_id = aw.approved_by) as approvedBy
			')->from('award aw')
			  ->join('employee_history p', 'aw.employee_id = p.employee_id', 'left');
              $userId = $this->session->userdata('employee_id');
          	  if($admin !=1){
	           	if($is_supervisor == 1){
	        	 $this->db->where('p.super_visor_id',$employee_id);
	        	 $this->db->or_where('p.employee_id',$employee_id);
	        	 $this->db->or_where('p.indirect_super_visor_id',$employee_id);
	        	}else{
	             $this->db->where('p.employee_id',$employee_id);
	            }
		      }
		      if(isset($id)){
		      	$this->db->where('aw.award_id',$id);
		      }
      return $this->db->group_by('aw.award_id')->order_by('aw.award_id', 'desc')->get()->result();
	}
	
	public function award_create($data = array())
	{
		$res = $this->db->insert('award', $data);
		if($res){

			// $this->notify->employee($data['employee_id'])->send(
			// 	sprintf('You have won an award "%s"', $data['award_name']),
			// 	'award/Award_controller/view_award'
			// );

			$empl_rec = $this->db->select('*, CONCAT_WS(\' \', first_name, last_name) as fullname')->where('employee_id', $data['employee_id'])->get('employee_history')->row();
			
			$this->notify->employee($empl_rec->super_visor_id)->send(
				sprintf('Notification send for approval "%s"', $data['award_name']),
				'award/Award_controller/view_award'
			);
		
			$this->notify->department('hr')->send(
				sprintf('new award "%s" won by %s (%s) need your approval ',$data['award_name'], $empl_rec->fullname, $empl_rec->hrm_id),
				'award/Award_controller/view_award'
			);
		}
		return $res;
	}

	public function award_delete($id = null)
	{
		$this->db->where('award_id',$id)
			->delete('award');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 




public function update_award($data = array())
	{
		return $this->db->where('award_id',$data["award_id"])
			->update("award", $data);


	}
	public function award_updateForm($id){
        $this->db->where('award_id',$id);
        $query = $this->db->get('award');
        return $query->row();
    }
    
     public function dropdown(){
    	$this->db->select('*');
    	$this->db->from('employee_history p');

     $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        $employee_id = $this->session->userdata('employee_id');
        if ($admin != 1) {
            if ($is_supervisor == 1) {
                $this->db->where('p.super_visor_id', $employee_id);
                $this->db->or_where('p.employee_id', $employee_id);
                $this->db->or_where('p.indirect_super_visor_id', $employee_id);
            } else {
                $this->db->where('p.employee_id', $employee_id);
            }
        }



    	$query=$this->db->get();
    	$data=$query->result();
    	$list = array('' => 'Select One...');
    	if(!empty($data)){
    		foreach ($data as  $value) {
    			$list[$value->employee_id]=$value->first_name." ".$value->last_name;
    		}
    	}
    	return $list;
    }
     public  function get_id($id)
    {
        $query=$this->db->get_where('award',array('award_id'=>$id));
        return $query->row_array();
    } 

}
