<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Award_controller extends MX_Controller {

public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		$this->load->model(array(
			'Award_model'
		));	
        if (! $this->session->userdata('isLogIn'))
            redirect('login?rback=' . uri_string());	 
	}

    public function updateAwardStatus($id){

        $empl_rec = $this->db->select('emph.*, CONCAT_WS(\' \', emph.first_name, emph.last_name) as fullname')->join('award','award.employee_id=emph.employee_id')->where('award.award_id', $id)->get('employee_history as emph')->row();

        $Data['award_id'] = $id;
        $Data['approved'] = 1;
        $Data['approved_by'] = $this->session->userdata('id');
        $update = $this->Award_model->update_award($Data);
        
        if($update){
            
            $this->notify->employee($data['employee_id'])->send(
                sprintf('You have won an award "%s"', $data['award_name']),
                'award/Award_controller/view_award'
            );

            $this->notify->employee($empl_rec->super_visor_id)->send(
                sprintf('%s (%s) has won an award "%s"', $empl_rec->fullname, $empl_rec->hrm_id, $data['award_name']),
                'award/Award_controller/view_award'
            );

            echo 1;
        }else{
            echo 0;
        }
    }

public function award_view()
	{   


        $this->permission->method('award','read')->redirect();

		$data['title']    = display('award');  ;
		$data['mang']   = $this->Award_model->award_view();
		$data['module']   = "award";
		$data['page']     = "award_view";   
		echo Modules::run('template/layout', $data); 
	}

public function create_award(){

        $this->form_validation->set_rules('award_name',display('award_name'));
        $this->form_validation->set_rules('aw_description',display('aw_description'));
        $this->form_validation->set_rules('awr_gift_item',display('awr_gift_item'),'max_length[50]');
        $this->form_validation->set_rules('date',display('date')  ,'max_length[50]');
        
        $this->form_validation->set_rules('employee_id',display('employee_id')  ,'max_length[50]');
        $this->form_validation->set_rules('awarded_by',display('awarded_by')  ,'max_length[50]');
      
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [ 
                'award_name'        => $this->input->post('award_name',true),
                'aw_description'    => $this->input->post('aw_description',true),
                'awr_gift_item'     => $this->input->post('awr_gift_item',true),
                'date'              => $this->input->post('date',true),
                'employee_id'       => $this->input->post('employee_id',true),
                'awarded_by'        => $this->input->post('awarded_by',true),
            ];   

            if ($this->Award_model->award_create($postData)) { 
                $this->session->set_flashdata('message', display('successfully_created'));
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }

            redirect("award/Award_controller/create_award");

        } else {
        
        } 


            $data['title']  = display('award');
            $data['module'] = "award";//
            $data['mang']   = $this->Award_model->award_view();
            $data['dropdown']   = $this->Award_model->dropdown();
            $data['page']   = "create_award_form";   
               echo Modules::run('template/layout', $data); 
      
}



public function view_award()
    { 
  
            $data['title']  = display('award');
            $data['module'] = "award";//
            $data['mang']   = $this->Award_model->award_view();
            $data['dropdown']   = $this->Award_model->dropdown();
            $data['page']   = "award_form";   
          echo Modules::run('template/layout', $data); 
         
    }


public function delete_award($id = null) 
	{ 
        $this->permission->method('award','delete')->redirect();

		if ($this->Award_model->award_delete($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));

		}
		redirect("award/Award_controller/award_view");
	}

	public function update_award_form($id = null)
    { 
        $data['title'] = display('award');
        #-------------------------------#
         $this->form_validation->set_rules('award_id',display('award_id'));
       $this->form_validation->set_rules('award_name',display('award_name'));
        $this->form_validation->set_rules('aw_description',display('aw_description'));
        $this->form_validation->set_rules('awr_gift_item',display('awr_gift_item'),'max_length[50]');
        $this->form_validation->set_rules('date',display('date')  ,'max_length[50]');
        
        $this->form_validation->set_rules('employee_id',display('employee_id')  ,'max_length[50]');
        $this->form_validation->set_rules('awarded_by',display('awarded_by')  ,'max_length[50]');
        
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $Data = [    
                        'award_id'       => $this->input->post('award_id',true),
                        'award_name'     => $this->input->post('award_name',true),
                        'aw_description' => $this->input->post('aw_description',true),
                        'awr_gift_item'  => $this->input->post('awr_gift_item',true),
                         'date'       =>date("Y-m-d", strtotime($this->input->post('date',true))),
                        'employee_id'    => $this->input->post('employee_id',true),
                        'awarded_by'     => $this->input->post('awarded_by',true),
                    ];   
            if(isset($id)){
                $update = $this->Award_model->update_award($Data);
            }else{
                if($this->session->userdata('isAdmin') == 1){
                    $Data['approved'] = 1;
                    $Data['approved_by'] = $this->session->userdata('isAdmin');
                }
                $update = $this->Award_model->award_create($Data);
            }
            

            if ($update) { 
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("award/Award_controller/award_view");

        } else {
           $data['title']      = display('update');
            $data['data']      =$this->Award_model->award_updateForm($id);
            $data['dropdown']   = $this->Award_model->dropdown();
            $data['bb']        =$this->Award_model->get_id($id);
            $data['module']    = "award";    
            $data['page']      = "update_award_form";   
            echo Modules::run('template/layout', $data);  
        }   
    }

     public function view_details($id){
            $data['title']     = display('award');
            $data['module']    = "award";    
            $data['page']      = "award_print";   
            $data['mang']      = $this->Award_model->award_view($id);
            echo Modules::run('template/layout', $data);  
     }

         public function download_award($id)
    {       
        $data['row'] =  $this->Award_model->award_view($id)[0];
        $mpdf = new \Mpdf\Mpdf();
        $mpdf->WriteHTML($this->load->view('award_print', $data, true));
        $mpdf->Output($data['row']->award_id, 'D');
    }

    public function getDivisionEmployee($id){
        $this->db->select('divisions.name');
        $this->db->join('employee_history','employee_history.division_id = divisions.id');
        $this->db->where('employee_history.employee_id',$id);
        $result = $this->db->get('divisions')->first_row();
        echo json_encode($result);
    }

}
