<div class="panel panel-default thumbnail">
    <div class="panel-body" id="result_data">
        <table class="table table-striped table-bordered table-hover" width="100%">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>In Time</th>
                    <th>Out Time</th>
                    <th>Reason</th>
                    <th>Status</th>
                    <th>Submitted</th>
                    <th class="hideexport">Action</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('table.table').dataTable($.extend({}, {
            responsive: false,
            processing: true,
            serverSide: true,
            ajax: {
                method: 'post',
                beforeSend: () => {},
            },
            columns: [
                {
                    'data': 'id',
                }, {
                    'data': 'employee_name',
                }, {
                    'data': 'checkin',
                }, {
                    'data': 'checkout',
                }, {
                    'data': 'reason'
                }, {
                    'data': 'hr_status',
                }, {
                    'data': 'added_at',
                }, {
                    'data': 'action',
                    'sortable' : false
                }
            ],
            columnDefs: [ {
                "targets": [2, 3, 6],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }
            
            } ],
            order: [[ 6, "desc" ]]
        }, window.default_datatable_opts))
    });
</script>