<?php
class Timeadjustment extends Loggedin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper('url');
        $this->load->model(['timeadjustment_model', 'Csv_model']);
    }
    public function add_request()
    {
        if ($this->input->post()) {
            $this->create();
        }
        $data['dropdownatn'] = $this->Csv_model->Employeename();
        $data['title'] = 'Time Adjustment: Add Request';
        $data['module'] = "attendance";
        $data['page'] = "adjustment/add_request";
        echo Modules::run('template/layout', $data);
    }
    public function all_requests()
    {
        if($this->input->post()) {
            $this->getDatatable();
        }
        $data['title'] = 'All Time Adjustment Requests';
        $data['module'] = "attendance";
        $data['page'] = "adjustment/requests_list";
        echo Modules::run('template/layout', $data);
    }
    public function process()
    {
        if ($this->input->post('process') == 'approve') {
            $this->timeadjustment_model->process($this->input->post('id'), true);
        } else {
            $this->timeadjustment_model->process($this->input->post('id'), false);
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    private function create()
    {
        $this->form_validation->CI = &$this;
        $rules_config = array(
            array(
                'field' => 'checkin',
                'label' => 'Check In Time',
                'rules' => 'trim|required|callback_valid_datetime',
            ),
            array(
                'field' => 'checkout',
                'label' => 'Check Out Time',
                'rules' => 'trim|required|callback_valid_datetime',
            ),
            array(
                'field' => 'reason',
                'label' => 'Reason',
                'rules' => 'strip_tags|trim|required',
            ),
        );
        if($this->session->userdata('isAdmin')){
            $rules_config[] = [
                'field' => 'employee_id',
                'label' => 'Employee Name',
                'rules' => 'trim|required|is_natural',
            ];
        }
        if(strtotime($this->input->post('checkout')) - strtotime($this->input->post('checkin')) < 0){
            $this->session->set_flashdata('exception', 'Checkin date should be smaller than Checkout date');return;
        }
        $this->form_validation->set_message('valid_datetime', '{field} must have valid date and time.');
        $this->form_validation->set_rules($rules_config);
        if ($this->form_validation->run() === true) {
            if ($this->timeadjustment_model->add($this->input->post())) {
                $this->session->set_flashdata('message', 'Request added successfully');
            } else {
                $this->session->set_flashdata('exception', 'Error while submitting request try again later!');
            }
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function valid_datetime($str)
    {
        $res = preg_match('/\b\d{2}-\d{2}-\d{4}\s\d{2}:\d{2}\b/', $str);
        return is_numeric($res) && $res > 0 ? true : false;
    }
    private function getDatatable()
    {
        $search_arr = [];
        $where_arr = [];
        $search_columns = [
            'tb1.id',
            'tb1.checkin',
            'tb1.checkout',
            'tb1.reason',
            'tb1.added_at',
            'tb2.first_name',
            'tb2.last_name',
            'tb2.hrm_id'
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            $originalSearchVal = $searchVal;
            $searchVal = explode(' ', $searchVal);
            foreach ($searchVal as $keyword) {
                if(!trim($keyword)) {
                    continue;
                }
                foreach ($search_columns as $value) {
                    if(convert_excel_date($keyword)) {
                        $search_arr[] = [$value, convert_excel_date($keyword)];
                    } else {
                        $keyword2 = preg_replace('@\s+@', '%', $keyword);
                        $keyword2 .= '%';
                        $search_arr[] = [$value, $keyword2];
                    }
                }
            }
            if(stripos($originalSearchVal, 'supervisor') !== false) {
                if(stripos($originalSearchVal, 'awaiting') !== false) {
                    $where_arr[] = ['tb1.supervisor_status', 'pending'];
                }
                if(stripos($originalSearchVal, 'approved') !== false) {
                    $where_arr[] = ['tb1.supervisor_status', 'approved'];
                }
                if(stripos($originalSearchVal, 'denied') !== false) {
                    $where_arr[] = ['tb1.supervisor_status', 'denied'];
                }
                $where_arr[] = ['tb1.hr_status', 'pending'];
                $search_arr = [];
            } elseif (stripos($originalSearchVal, 'hr') !== false) {
                if(stripos($originalSearchVal, 'awaiting') !== false) {
                    $where_arr[] = ['tb1.hr_status', 'pending'];
                }
                if(stripos($originalSearchVal, 'approved') !== false) {
                    $where_arr[] = ['tb1.hr_status', 'approved'];
                }
                if(stripos($originalSearchVal, 'denied') !== false) {
                    $where_arr[] = ['tb1.hr_status', 'denied'];
                }
                $search_arr = [];
                $search_arr[] = ['tb1.supervisor_status', 'approved'];
                $search_arr[] = ['tb1.supervisor_status', 'denied'];
            } elseif(stripos($originalSearchVal, 'approved') !== false) {
                $where_arr[] = ['tb1.supervisor_status', 'approved'];
                $where_arr[] = ['tb1.hr_status', 'approved'];
                $search_arr = [];
            } elseif(stripos($originalSearchVal, 'awaiting') !== false) {
                $where_arr[] = ['tb1.supervisor_status', 'pending'];
                $where_arr[] = ['tb1.hr_status', 'pending'];
                $search_arr = [];
            } elseif(stripos($originalSearchVal, 'denied') !== false) {
                $where_arr[] = ['tb1.supervisor_status', 'denied'];
                $where_arr[] = ['tb1.hr_status', 'denied'];
                $search_arr = [];
            }
        };
        $search_arr = array_filter($search_arr, function($v) {
            return !empty(trim($v[1]));
        });
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $out_arr["recordsFiltered"] = $this->timeadjustment_model->countDatatable($search_arr, $where_arr);
        $rows = $this->timeadjustment_model->getDatatable($search_arr, $where_arr);
        
        $subordinates = array_column($this->timeadjustment_model->get_subordinates(true), 'employee_id');
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'checkin':
                    case 'checkout':
                    case 'added_at': {
                        $tdData = formatted_date($rec[$col['data']], true);
                        break;
                    }
                    case 'hr_status': {
                        if($rec['supervisor'] && $rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'pending'){
                            $tdData = 'Awaiting Supervisor Response';
                        }elseif($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'approved'){
                            $tdData = 'Approved By Supervisor';
                        }elseif($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'denied'){
                            $tdData = 'Denied By Supervisor';
                        }elseif($rec['hr_status'] == 'pending' && $rec['supervisor_status'] == 'approved'){
                            $tdData = 'Approved By Supervisor';
                        }elseif(!$rec['supervisor'] && $rec['hr_status'] == 'pending'){
                            $tdData = 'Awaiting HR Response';
                        }elseif($rec['hr_status'] == 'approved'){
                            $tdData = 'Approved By HR';
                        }elseif($rec['hr_status'] == 'denied'){
                            $tdData = 'Denied By HR';
                        }
                        break;
                    }
                    case 'action':{
                            if($rec['hr_status'] == 'approved') {
                                $tdData = '<span>' . display('approved') . '</span>';
                                break;
                            }
                            if($rec['employee_id'] == $this->session->userdata('employee_id')) {
                                break;
                            }
                            $tdData = '<form class="time_action_btn" method="POST" action="' . base_url('attendance/timeadjustment/process') . '"><input type="hidden" name="id" value="' . $rec['id'] . '">';

                            if($this->session->userdata('isAdmin') && $rec['hr_status'] == 'pending'){
                                $tdData .= '<button type="submit" class="btn btn-success btn-sm" name="process" value="approve">Approve</button>';
                                $tdData .= '<button type="submit" class="btn btn-danger btn-sm" name="process" value="reject">Reject</button>';
                            }elseif(in_array($rec['employee_id'], $subordinates) && $rec['supervisor_status'] == 'pending' && $rec['hr_status'] == 'pending' && $rec['employee_id'] != $this->session->userdata('employee_id')){                                    
                                $tdData .= '<button type="submit" class="btn btn-success btn-sm" name="process" value="approve">Approve</button>';
                                $tdData .= '<button type="submit" class="btn btn-danger btn-sm" name="process" value="reject">Reject</button>';
                            }elseif($this->permission->method('atn_time_adjustment_list', 'update')->access() && $rec['hr_status'] == 'pending' && $rec['employee_id'] != $this->session->userdata('employee_id')){
                                $tdData .= '<button type="submit" class="btn btn-success btn-sm" name="process" value="approve">Approve</button>';
                                $tdData .= '<button type="submit" class="btn btn-danger btn-sm" name="process" value="reject">Reject</button>';
                            }

                            $tdData .= '</from>';
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
}
