<?php
/* Employee Module */
$lang['employee_created'] = 'Created Employee {{employee:name}}';
$lang['employee_deleted'] = 'Deleted Employee {{employee:name}}';
$lang['employee_update'] = 'Changed \'%s\' from \'%s\' to \'%s\'';
$lang['employee_update_request'] = 'Approved request to change \'%s\' from \'%s\' to \'%s\'';
$lang['employee_document_added'] = 'Added a document "%s"';
$lang['employee_document_added_missing'] = 'Added a missing document "%s"';
$lang['employee_document_removed'] = 'Removed a document "%s"';
$lang['employee_probation_extension'] = 'Extended probation by %s<br>Reason: "%s"';
$lang['employee_document_approved'] = 'Approved document "%s"';
$lang['employee_document_rejected'] = 'Rejected document "%s"<br>Reason: %s';

$lang['employee_document_type_added'] = 'Added a document type "%s " (#%s)';
$lang['employee_document_type_updated'] = 'Updated document type "%s" (#%s)';
$lang['employee_document_type_deleted'] = 'Removed a document type "%s" (#%s)';

/* Gender */
$lang['gender_inserted'] = 'Added new gender "%s"';
$lang['marital_status_inserted'] = 'Added new marital status "%s"';
$lang['position_inserted'] = 'Added new position "%s"';
$lang['position_updated'] = 'Updated position "%s (#%s)"';
$lang['position_deleted'] = 'Deleted position "%s (#%s)"';

/* Attendance Module */
$lang['attendance_inserted'] = 'Added punch %s time \'%s\' for {{employee:name}}';
$lang['full_attendance_inserted'] = 'Added attendance entry \'%s - %s\' for {{employee:name}}';

$lang['attendance_group_update_in'] = 'Updated check-in of \'%s\' day to \'%s\' for {{employee:name}}';
$lang['attendance_group_update'] = 'Updated attendance of \'%s\' day to \'IN: %s - OUT: %s\' for {{employee:name}}';
$lang['attendance_group_deleted'] = 'Deleted attendance of \'%s\' day for {{employee:name}}';

$lang['timeadjustment_processed'] = '[%s] %s time adjustment request \'#%s\' of \'{{employee:name}}\' for \'%s\' day';

/* Award Module */
$lang['award_type_inserted'] = 'Added new award type \'%s\'';
$lang['award_type_updated'] = 'Updated award type \'%s\'';
$lang['award_type_deleted'] = 'Deleted award type \'%s\'';
$lang['award_assigned'] = 'Assigned an award \'%s\' to {{employee:name}}';
$lang['award_updated'] = 'Updated award \'%s (#%s)\' of {{employee:name}}';
$lang['award_status_updated'] = '%s award \'%s (#%s)\' of {{employee:name}}';
$lang['award_deleted'] = 'Deleted award \'%s (#%s)\' of {{employee:name}}';

/* Settings Module */
$lang['language_inserted'] = 'Added new phrase \'%s\' for languages';
$lang['language_updated'] = 'Updated phrases for \'%s\' language';
$lang['menu_inserted'] = 'Added new menu \'%s\'';
$lang['menu_updated'] = 'Updated menu \'%s (#%s)\'';
$lang['menu_deleted'] = 'Deleted menu \'%s (#%s)\'';
/* Roles */
$lang['role_inserted'] = 'Added new role \'%s\'';
$lang['role_updated'] = 'Updated role \'%s (#%s)\'';
$lang['role_assigned'] = 'Assigned role \'%s\' to {{employee:name}}';
$lang['role_unassigned'] = 'Removed role \'%s\' from {{employee:name}}';
$lang['role_deleted'] = 'Deleted role \'%s (#%s)\'';
$lang['user_access_deleted'] = 'Deleted HRM access and roles for \'%s %s\'';

$lang['benefit_inserted'] = 'Added new benefit \'%s\'';
$lang['benefit_updated'] = 'Updated benefit \'%s (#%s)\'';
$lang['benefit_deleted'] = 'Deleted benefit \'%s (#%s)\'';
$lang['message_inserted'] = 'Sent a message \'%s\' to {{employee:name}}';
$lang['message_deleted'] = 'Deleted a message #%s \'%s\' sent to {{employee:name}}';
$lang['module_inserted'] = 'Installed new module \'%s\'';
$lang['module_deleted'] = 'Uninstalled module \'%s\'';
$lang['module_status_changed'] = '%s module #%s \'%s\'';
$lang['setting_inserted'] = 'Added settings for site \'%s\'';
$lang['setting_updated'] = 'Updated settings for site \'%s\'';
$lang['ftp_inserted'] = 'Added ftp settings with hostname \'%s\'';
$lang['ftp_updated'] = 'Updated ftp settings with hostname \'%s\'';
$lang['temp_category_inserted'] = 'Added new document template category \'%s\'';
$lang['temp_category_updated'] = 'Updated document template category \'%s (#%s)\'';
$lang['temp_category_deleted'] = 'Deleted document template category \'%s (#%s)\'';
$lang['document_template_inserted'] = 'Added new document template \'%s\'';
$lang['document_template_updated'] = 'Updated document template \'%s (#%s)\'';
$lang['document_template_deleted'] = 'Deleted document template \'%s (#%s)\'';
$lang['user_inserted'] = 'Added new user for employee \'{{employee:name}}\'';
$lang['user_updated'] = 'Updated user for employee \'{{employee:name}}\'';
$lang['user_deleted'] = 'Deleted user for employee \'{{employee:name}}\'';
$lang['user_updated_self'] = 'Updated their own user profile (about/password, etc)';
$lang['email_settings_inserted'] = 'Added email setting for division \'{{division:name}}\'';
$lang['email_settings_updated'] = 'Updated email setting for division \'{{division:name}}\'';
$lang['email_settings_deleted'] = 'Deleted email setting for division \'{{division:name}}\'';
$lang['email_settings_testing'] = 'Initiated a test email for division \'{{division:name}}\' to \'%s\'';

/* Department Module */
$lang['shift_inserted'] = 'Added new shift \'%s\'';
$lang['shift_updated'] = 'Updated shift \'{{shift:name}} (#{{shift:id}})\'';
$lang['shift_deleted'] = 'Deleted shift \'{{shift:name}} (#{{shift:id}})\'';
$lang['department_inserted'] = 'Added new department \'{{department:name}}\'';
$lang['department_updated'] = 'Updated department \'{{department:name}}\'';
$lang['department_deleted'] = 'Deleted department \'{{department:name}}\'';
$lang['division_inserted'] = 'Added new division \'{{division:name}}\'';
$lang['division_updated'] = 'Updated division \'{{division:name}}\'';
$lang['division_deleted'] = 'Deleted division \'{{division:name}}\'';

/* Incident Module */
$lang['incident_approved'] = 'Approved %s \'%s\' for {{employee:name}}';
$lang['incident_approved_outside'] = 'Approved %s \'%s\' for %s';
$lang['incident_rejected'] = 'Rejected %s \'%s\' for {{employee:name}}';
$lang['incident_rejected_outside'] = 'Rejected %s \'%s\' for %s';
$lang['incident_contestation_status'] = '%s contestation request for letter \'%s\' against {{employee:name}}';
$lang['incident_contestation_status_outside'] = '%s contestation request for letter \'%s\' against %s';
$lang['incident_contested'] = 'Contested rejection of letter \'%s\' against {{employee:name}}';
$lang['incident_contested_outside'] = 'Contested rejection of letter \'%s\' against %s';

$lang['letter_generated'] = 'Created a letter request \'%s\' #%s for {{employee:name}}';
$lang['incident_generated'] = 'Created an incident \'%s\' #%s for {{employee:name}}';
$lang['letter_generated_outside'] = 'Created a letter request \'%s\' #%s for %s';

$lang['incident_type_inserted'] = 'Added incident type \'%s\'';
$lang['incident_type_updated'] = 'Renamed incident type \'%s\' to \'%s\'';
$lang['incident_type_deleted'] = 'Deleted incident type \'%s (#%s)\'';

$lang['letter_inserted'] = 'Added a letter \'%s\' (SL# %s)';
$lang['letter_updated'] = 'Updated letter \'%s\' (SL# %s)';
$lang['letter_deleted'] = 'Deleted letter \'%s\' (SL# %s)';
$lang['pdf_settings_updated'] = 'Updated %s PDF settings';
$lang['pdf_settings_bg_removed'] = 'Removed background image from {{division:name}}\'s %s letter';

$lang['policy_inserted'] = 'Added a policy \'%s\' (SL# %s)';
$lang['policy_updated'] = 'Updated policy \'%s\' (SL# %s)';
$lang['policy_deleted'] = 'Deleted policy \'%s\' (SL# %s)';

$lang['letter_email_sent'] = 'Sent letter \'%s (#%s)\' to \'%s\' via email';
$lang['letter_policy_sent'] = 'Sent policy \'%s (#%s)\' to \'%s\' via email';

/* Leave Module */
$lang['weeklyleave_inserted'] = 'Added weekly holiday \'%s\' for \'{{shift:name}}\' shift';
$lang['weeklyleave_updated'] = 'Updated weekly holiday to \'%s\' for \'{{shift:name}}\' shift';
$lang['weeklyleave_deleted'] = 'Deleted weekly holiday \'%s\' for \'{{shift:name}}\' shift';

$lang['payroll_holiday_inserted'] = 'Added payroll holiday \'%s\' for \'{{shift:name}}\' shift';
$lang['payroll_holiday_updated'] = 'Updated payroll holiday \'%s\' (SL# %s)';
$lang['payroll_holiday_deleted'] = 'Deleted payroll holiday \'%s\' (SL# %s)';

$lang['leave_type_inserted'] = 'Added a leave type \'%s\'';
$lang['leave_type_updated'] = 'Updated leave type \'%s (#%s)\'';
$lang['leave_type_deleted'] = 'Deleted leave type \'%s (#%s)\'';

$lang['leave_denied'] = 'Denied leave application (#%s) of \'{{employee:name}}\' as %s';
$lang['leave_approved'] = 'Approved leave application (#%s) of \'{{employee:name}}\' as %s';
$lang['leave_deleted'] = 'Deleted leave application (#%s) of \'{{employee:name}}\'';

/* Noticeboard module */
$lang['notice_inserted'] = 'Added a notice \'%s\'';
$lang['notice_inserted_published'] = 'Added and published a notice \'%s\' to noticeboard';
$lang['notice_updated'] = 'Updated notice \'%s (#%s)\'';
$lang['notice_updated_published'] = 'Updated and published a notice \'%s (#%s)\' to noticeboard';
$lang['notice_deleted'] = 'Deleted a notice \'%s (#%s)\'';
$lang['notice_deleted_noticeboard'] = 'Deleted a notice \'%s (#%s)\' from noticeboard';

$lang['notification_deleted'] = 'Deleted a notification #%s<br>Title: %s';

/* Recruitment Module */
$lang['background_check_inserted'] = 'Added a background check for candidate \'{{candidate:name}}\'';

$lang['candidate_shortlisted'] = 'Shortlisted a candidate: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_unshortlisted'] = 'Removed candidate from shortlist: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_rejected'] = 'Rejected a candidate: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_unrejected'] = 'Removed candidate from rejected list: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_onboarded'] = 'On-boarded a candidate: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_onboarding_rejected'] = 'Rejected On-boarding of candidate: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_hired'] = 'Marked a candidate as hired: \'{{candidate:name}}\' for \'{{job:name}}\'';
$lang['candidate_updated'] = 'Updated candidate application of \'{{candidate:name}}\'';
$lang['candidate_deleted'] = 'Deleted candidate application of \'{{candidate:name}}\'';
$lang['candidate_moved_resource_pool'] = 'Moved candidate \'{{candidate:name}}\' to resource pool';
$lang['candidate_moved_job'] = 'Transferred candidate \'{{candidate:name}}\' from \'(#%s) %s\' to \'{{job:name}}\' job';
$lang['candidate_oriented'] = 'Generated credentials of candidate: \'{{candidate:name}}\'';


$lang['interview_conducted'] = 'Marked interview done of \'{{candidate:name}}\' for {{job:name}}';
$lang['interview_scheduled'] = 'Scheduled interview (%s) of \'{{candidate:name}}\' for {{job:name}}. Interviewer \'{{employee:name}}\'';
$lang['interview_canceled'] = 'Canceled interview (%s) of \'{{candidate:name}}\' for {{job:name}}';

$lang['requisition_inserted'] = 'Added a requisition request \'{{job:name}}\'';
$lang['requisition_updated'] = 'Updated a requisition request \'{{job:name}}\'';
$lang['requisition_position_inserted'] = 'Added a new position \'%s\' via requisition';

$lang['job_deleted'] = 'Deleted a job listing for \'{{job:name}}\'';

$lang['requisition_author_status'] = 'Re-submitted requisition for \'{{job:name}}\'';
$lang['requisition_rm_status'] = '%s requisition for \'{{job:name}}\'';
$lang['requisition_hr_status'] = 'Published ad for \'{{job:name}}\'';

$lang['requisition_option_inserted'] = 'Added a requisition option item \'%s\' in group \'%s\'';
$lang['requisition_option_updated'] = 'Updated a requisition option item \'%s\' in group \'%s\'';
$lang['requisition_option_deleted'] = 'Deleted a requisition option item \'%s\' in group \'%s\'';
$lang['requisition_option_sorted'] = 'Sorted requisition options of group \'%s\'';


/* Log Module */
$lang['email_requeued'] = 'Resent email #%s to \'%s\'';