<?php
class AuthHook
{
    private $CI = null;
    public function __construct()
    {
        $this->CI = &get_instance();
    }
    public function load()
    {
        $this->CI->load->driver('cache', array('adapter' => $this->cache_type(), 'backup' => 'file'));
        $this->CI->db->query('SET SESSION sql_mode = ""');
    }
    public function check_role()
    {
        if (!$this->CI->session->userdata('isLogIn')) {
            return;
        }
        if ($this->CI->session->userdata('isAdmin')) {
            return;
        }
        if ($this->CI->session->userdata('loaded') && $this->CI->session->userdata('roles')) {
            if ($this->role_updated()) {
                $this->CI->load->model('dashboard/auth_model');
                $this->CI->auth_model->reload_user_permissions();
            }
        }
    }
    private function role_updated()
    {
        $role_string = implode('', $this->CI->session->userdata('roles'));
        if (!$role_string) {
            $role_string = 'empty';
        }
        if (!$data = $this->CI->cache->get("role.updated.{$role_string}")) {
            $q = $this->CI->db
                ->select('role_id')
                ->where_in('role_id', $this->CI->session->userdata('roles'))
                ->where('updated_at >', $this->CI->session->userdata('loaded'))
            ->get('sec_role_tbl');
            if(!$q) {
                return false;
            }
            $recs = $q->result();
            $this->CI->cache->save("role.updated.{$role_string}", $recs, defined('STAGING_SERVER') ? 10 : 30);
            return $recs;
        }
        return $data;
    }
    private function cache_type()
    {
        if (extension_loaded('wincache') && ini_get('wincache.ucenabled')) {
            return 'wincache';
        } elseif (extension_loaded('apc') && ini_get('apc.enabled')) {
            return 'apc';
        }
        return 'file';
    }
    public function check_status()
    {
        $under_maintenance = false;
        if(file_exists(FCPATH . 'flags/.maintenance_mode')) {
            $under_maintenance = true;
        } else {
            $under_maintenance = $this->CI->db
                ->select('option_key')
                ->where([
                    'option_key' => 'maintenance',
                    'value' => '1',
                    'type' => 'system'
                ])
                ->get('system_options');
            if($under_maintenance) {
                $under_maintenance = $under_maintenance->row();
            }
        }
        
        if($under_maintenance) {
            http_response_code(503);
            readfile(FCPATH . 'crash_pages/maintenance.html');
            exit;
        }
    }
}
