<?php

namespace App\Models;

use CodeIgniter\Model;

class MlcrCollectionModel extends Model
{
	protected $DBGroup              = 'default';
	protected $table                = 'active_collectors_target_details_mlcr_collections';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'array';
	protected $useSoftDelete        = false;
	protected $protectFields        = true;
	protected $allowedFields        = ["week_no",
										"week_start",
										"week_end",
										"days_worked",
										"real_name",
										"alias",
										"employee_id",
										"employee_status",
										"daily_target",
										"weekly_target",
										"paper",
										"team_manager",
										"center",
										"designation",
										"department",
										"date"
										"email_address"
									  ];

	// Dates
	protected $useTimestamps        = false;
	protected $dateFormat           = 'datetime';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = [];
	protected $afterInsert          = [];
	protected $beforeUpdate         = [];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];

	var $column_order = array('id', 'week_start', 'week_end', 'employee_id', 'employee_status');
	var $order = array('id' => 'desc');

}
