<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
	protected $DBGroup              = 'default';
	protected $table                = 'users';
	protected $primaryKey           = 'id';
	protected $useAutoIncrement     = true;
	protected $insertID             = 0;
	protected $returnType           = 'array';
	protected $useSoftDelete        = false;
	protected $protectFields        = true;
	protected $allowedFields        = ['name','email','phone_no','password'];

	// Dates
	protected $useTimestamps        = false;
	protected $dateFormat           = 'datetime';
	protected $createdField         = 'created_at';
	protected $updatedField         = 'updated_at';
	protected $deletedField         = 'deleted_at';

	// Validation
	protected $validationRules      = [];
	protected $validationMessages   = [];
	protected $skipValidation       = false;
	protected $cleanValidationRules = true;

	// Callbacks
	protected $allowCallbacks       = true;
	protected $beforeInsert         = [];
	protected $afterInsert          = [];
	protected $beforeUpdate         = [];
	protected $afterUpdate          = [];
	protected $beforeFind           = [];
	protected $afterFind            = [];
	protected $beforeDelete         = [];
	protected $afterDelete          = [];
	
	public function getUsers($user_id=null,$role_name = null,$role_id=null){
	   $users = $this->db->table($this->table);
       $users->select('users.*,roles.id as role_id,roles.name as role_name');
       $users->join('user_roles', 'user_roles.user_id = users.id','left');
       $users->join('roles','user_roles.role_id=roles.id','left');
       if(isset($user_id)){
           $users->where('users.id',$user_id);
       }
       if(isset($role_name)){
           $users->where('roles.name',$role_name);
       }
       if(isset($role_id)){
           $users->where('roles.id',$role_id);
       }
       $users->where('users.id<>',1);
       $result = $users->get()->getResult();
       if($result){
           return $result;
       }else{
           return false;
       }
       return $result;
	}
	
	public function lastID(){
        $result =   $this->db->query('select * from '.$this->table.' order by id desc limit 1')->getResult();
        return $result[0]->id+1;
    }   
    
    public function getRoles(){
        $result =   $this->db->query('select * from roles where name <> "admin"')->getResult();
        return $result;
    }


}
