$(document).ready(function () {
    "use strict"; // Start of use strict
    // Animate loader off screen
    $(".se-pre-con").fadeOut("slow");
    //back to top
    $('body').append('<div id="toTop" class="btn back-top"><span class="ti-arrow-up"></span></div>');
    $(window).on("scroll", function () {
        if ($(this).scrollTop() !== 0) {
            $('#toTop').fadeIn();
        } else {
            $('#toTop').fadeOut();
        }
    });
    $('#toTop').on("click", function () {
        $("html, body").animate({
            scrollTop: 0
        }, 600);
        return false;
    });
    /* //lobipanel
    $('.lobidrag').lobiPanel({
        sortable: true,
        editTitle: {
            icon: 'ti-pencil'
        },
        unpin: {
            icon: 'ti-move'
        },
        reload: {
            icon: 'ti-reload'
        },
        minimize: {
            icon: 'ti-minus',
            icon2: 'ti-plus'
        },
        close: {
            icon: 'ti-close'
        },
        expand: {
            icon: 'ti-fullscreen',
            icon2: 'ti-fullscreen'
        }
    });
    $('.lobidisable').lobiPanel({
        reload: false,
        close: false,
        editTitle: false,
        sortable: true,
        unpin: {
            icon: 'ti-move'
        },
        minimize: {
            icon: 'ti-minus',
            icon2: 'ti-plus'
        },
        expand: {
            icon: 'ti-fullscreen',
            icon2: 'ti-fullscreen'
        }
    }); */
    $('.btn-goback').on('click', function () {
        history.back();
    })
    //datatable
    $('.datatable').DataTable(window.default_datatable_opts);
    //datatable2
    $('.datatable2').DataTable({
        responsive: true,
        paging: false,
        dom: "<'row'<'col-sm-8'B><'col-sm-4'f>>tp",
        "lengthMenu": [
            [25, 50, 100, 150, 200, 500, -1],
            [25, 50, 100, 150, 200, 500, "All"]
        ],
        buttons: [{
                extend: 'copy',
                className: 'btn-sm'
            },
            {
                extend: 'csv',
                title: 'ExampleFile',
                className: 'btn-sm'
            },
            {
                extend: 'excel',
                title: 'ExampleFile',
                className: 'btn-sm',
                title: 'exportTitle'
            },
            {
                extend: 'pdf',
                title: 'ExampleFile',
                className: 'btn-sm'
            },
            {
                extend: 'print',
                className: 'btn-sm'
            }
        ]
    });
    // select 2 dropdown 
    $("select.form-control:not(.dont-select-me)").select2({
        placeholder: "Select option",
        allowClear: true
    });
    //datepicker
    $(".datepicker").datepicker({
        dateFormat: "dd-mm-yy"
    });
    //timepicker
    $('.timepicker').timepicker({
        timeFormat: 'HH:mm:ss',
        stepMinute: 5,
        stepSecond: 15
    });
    $('input.flatdatepickr').flatpickr({
        dateFormat: 'd-m-Y'
      })
});
function getDate(str) {
    return moment(str, "DD-MM-YYYY").toDate()
}
function isDateBetween(date, start, end) {
    date = date.getTime() / 1000;
    return date >= moment(start).unix() && date <= moment(end).unix()
}
$(document).on('sidebar-collapse', function(){
    $('#big_notif_panel').hide()
    $('#small_notif_panel').show()
})

$(document).on('sidebar-expand', function(){
    $('#big_notif_panel').show()
    $('#small_notif_panel').hide()
})

function confirmdelete(text, url) {
    Swal.fire({
        title: text,
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            $('.se-pre-con').show()
            location.href = url
        }
    })
  }

$.ajaxSetup({
    beforeSend: function() {
        $('.se-pre-con').show()
    },
    complete: function(){
        $('.readmore-block').readmore()
        $('.se-pre-con').hide()
    }
});

function show_spinner() {
    $('.se-pre-con').show()
}

function hide_spinner() {
    $('.se-pre-con').hide()    
}

function validateEmails(value) {
    value = value.split(',');
    var input = document.createElement('input');

    input.type = 'email';
    input.required = true;

    return !value.some((val) => {
        val = val.trim()
        input.value = val;
        return !(typeof input.checkValidity === 'function' ? input.checkValidity() : /\S+@\S+\.\S+/.test(val))
    });
}

function myajax(opts) {
    if(!opts.type) {
        opts.type = 'GET'
    }
    $.ajax({
        type: opts.type,
        url: opts.url,
        data: opts.data,
        beforeSend: function (jXhr, settings) {
            $('.se-pre-con').show()
            opts.beforeSend && opts.beforeSend(jXhr, settings)
        },
        complete: function (jXhr, textStatus) {
            $('.se-pre-con').hide()
            opts.complete && opts.complete(jXhr, textStatus)
        },
        error: function (jXhr, textStatus, errorThrown) {
            alert('Network error, please check your internet');
            opts.error && opts.error(jXhr, textStatus, errorThrown)
        },
        success: function (data, textStatus, jXhr) {
            opts.success && opts.success(data, textStatus, jXhr)
        }
    });
}
window.datatable_error_count = 0;
$.fn.DataTable.ext.errMode = function ( e, settings, techNote, message ) {
    if(e && e.jqXHR && e.jqXHR.status == 401) {
        location.reload();return
    }
    window.datatable_error_count++
    if(window.datatable_error_count >= 5) {
        alert('Unable to load table, check your internet or try again after reloading page');
        window.datatable_error_count = 0;
    }
    console.error(`http://datatables.net/tn/${techNote}`);
    console.error(message);
};