<div class="container-fluid">
    <div class="row">
        <form>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3">
                <div class="form-group">
                  <label for="">Year</label>
                  <select class="form-control" name="year" id="selYear" required>
                    <?php foreach ($dropdowns['years'] as $year) :?>
                        <option value="<?= $year ?>" <?= ($_GET['year'] ?? date('Y')) == $year  ? 'selected' : null ?>><?= $year ?></option>
                    <?php endforeach?>
                  </select>
                </div>
            </div>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3">
                <div class="form-group">
                  <label for="">Leave Types</label>
                  <select class="form-control" name="leave_type[]" id="selLeaveType" multiple>
                    <?php foreach ($dropdowns['leave_types'] as $leave_type) :?>
                        <option value="<?= $leave_type->id ?>" <?= in_array($leave_type->id, $_GET['leave_type'] ?? []) ? 'selected' : null ?>><?= $leave_type->label ?></option>
                    <?php endforeach?>
                  </select>
                </div>
            </div>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3">
                <div class="form-group">
                  <label for="">Employees</label>
                  <select class="form-control" name="employee[]" id="selEmployee" multiple>
                    <?php foreach ($dropdowns['employees'] as $employee) :?>
                        <option value="<?= $employee->id ?>" <?= in_array($employee->id, $_GET['employee'] ?? []) ? 'selected' : null ?>><?= $employee->label ?></option>
                    <?php endforeach?>
                  </select>
                </div>
            </div>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3">
                <div class="form-group">
                  <label for="">Departments</label>
                  <select class="form-control" name="department_id[]" id="selDepartments" multiple>
                    <?php foreach ($dropdowns['department_ids'] as $department) :?>
                        <option value="<?= $department->id ?>" <?= in_array($department->id, $_GET['department_id'] ?? []) ? 'selected' : null ?>><?= $department->label ?></option>
                    <?php endforeach?>
                  </select>
                </div>
            </div>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3">
                <div class="form-group">
                  <label for="">Supervisors</label>
                  <select class="form-control" name="supervisor_id[]" id="selDepartments" multiple>
                    <?php foreach ($dropdowns['supervisors_ids'] as $supervisor) :?>
                        <option value="<?= $supervisor->id ?>" <?= in_array($supervisor->id, $_GET['supervisor_id'] ?? []) ? 'selected' : null ?>><?= $supervisor->label ?></option>
                    <?php endforeach?>
                  </select>
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <button type="submit" class="btn btn-primary pull-right">Filter</button>
            </div>
        </form>
    </div>
    <br>
    <table class="table table-hover">
        <thead>
            <tr>
                <th><?= display('hrm_id') ?></th>
                <th><?= display('name') ?></th>
                <th><?= display('year') ?></th>
                <th><?= display('type') ?></th>
                <th><?= display('quota') ?></th>
                <th><?= display('remaining') ?></th>
                <th><?= display('applied') ?></th>
                <th><?= display('pending') ?></th>
                <th><?= display('approved') ?></th>
                <th><?= display('denied') ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($rows as $row) :?>
                <tr>
                    <td><?= $row->hrm_id ?></td>
                    <td><?= $row->name ?></td>
                    <td><?= $row->year ?></td>
                    <td><?= $row->type ?></td>
                    <td><?= $row->quota ?></td>
                    <td><?= $row->remaining ?></td>
                    <td><?= $row->applied ?></td>
                    <td><?= $row->pending ?></td>
                    <td><?= $row->approved ?></td>
                    <td><?= $row->denied ?></td>
                </tr>
            <?php endforeach?>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        window.dtable = $('table.table').DataTable($.extend({}, window.default_datatable_opts))
    });
</script>