<style>
    h4 {
        margin-bottom: 25px;
    }
    .check-label {
        padding: 5px 0px;
    }
    .col-extra-margin {
        margin: 0px 20px;
        width: 45%;
        padding: 0px 20px 0px 40px;
    }
    .v-line {
        border-left: 1px solid black;
    }
    div.error {
        color: red;
        display: none;
    }
    .has_error {
        border: 1px solid red;
        padding: 10px;
    }
    .has_error .error {
        display: block;
    }
</style>
<h4 class="text-center">Information Required for: <br><br><?= sprintf('%s %s (%s)', $employee['first_name'], $employee['last_name'], $employee['hrm_id']) ?></h4>
<hr>
<fieldset>
    <input type="hidden" name="employee_id" value="<?= $employee['employee_id'] ?>">
    <div class="row">
        <div class="col-md-6 col-extra-margin">
            <h4 class="text-center">General Information</h4>
            <div class="form-group">
                <label for="selIndManager" class="control-label">Indirect Reporting Manager</label>
                <select class="form-control" id="selIndManager" name="indManager" style="width: 100%;">
                    <option value=""></option>
                    <?php foreach ($supervisors as $supervisor) : ?>
                    <option value="<?= $supervisor->employee_id ?>" <?= @$employee['ind_supervisor_id'] == $supervisor->employee_id ? 'selected' : null ?>>
                        <?= sprintf('%s %s (%s)', $supervisor->first_name, $supervisor->last_name, $supervisor->hrm_id) ?>
                    </option>
                    <?php endforeach ?>
                </select>
            </div>
            <div class="form-group">
                <label for="selManager" class="control-label">Direct Reporting Manager</label>
                <select class="form-control" name="manager" id="selManager" style="width: 100%;">
                    <option value=""></option>
                    <?php foreach ($supervisors as $supervisor) : ?>
                    <option value="<?= $supervisor->employee_id ?>" <?= @$employee['supervisor_id'] == $supervisor->employee_id ? 'selected' : null ?>>
                        <?= sprintf('%s %s (%s)', $supervisor->first_name, $supervisor->last_name, $supervisor->hrm_id) ?>
                    </option>
                    <?php endforeach ?>
                </select>
            </div>
            <div class="form-group">
                <label for="selShift" class="control-label">Shift</label>
                <select class="form-control" name="shift" id="selShift" style="width: 100%;">
                    <option value=""></option>
                    <?php foreach ($shifts as $shift) : ?>
                    <option value="<?= $shift->id ?>" <?= @$employee['shift'] == $shift->id ? 'selected' : null ?>>
                        <?= $shift->name ?>
                    </option>
                    <?php endforeach ?>
                </select>
            </div>
            <div class="form-group">
                <label for="selGender" class="control-label">Gender</label>
                <select class="form-control" name="gender" id="selGender" style="width: 100%;">
                    <option value=""></option>
                    <?php foreach ($genders as $gender) : ?>
                    <option value="<?= $gender->id ?>" <?= @$employee['gender'] == $gender->id ? 'selected' : null ?>>
                        <?= $gender->name ?>
                    </option>
                    <?php endforeach ?>
                </select>
            </div>
            <div class="form-group">
              <label for="txtDOB">Date of Birth</label>
              <input type="text" class="form-control" name="dob" id="txtDOB" value="<?= formatted_date(@$employee['dob']) ?>">
            </div>
            <div class="form-group">
              <label for="txtCNIC">CNIC</label>
              <input type="text" class="form-control" name="cnic" id="txtCNIC" value="<?= @$employee['cnic'] ?>">
            </div>
            <div class="form-group">
              <label for="txtPhone">Phone</label>
              <input type="text" class="form-control" name="phone" id="txtPhone" value="<?= @$employee['phone'] ?>">
            </div>
            <div class="form-group">
              <label for="txtAddress">Present Address</label>
              <textarea class="form-control" name="present_address" id="txtAddress" rows="3"><?= @$employee['present_address'] ?></textarea>
            </div>
            <div class="form-group">
                <div class="col-md-4">
                    <label class="check-label"><?= display('work_from_home') ?>:</label>
                </div>
                <div class="col-md-4">
                    <div class="radio icheck-danger">
                        <input type="radio" id="work_from_homey" name="work_from_home" value="yes" <?= @$employee['work_from_home'] == '1' ? 'checked' : null ?>>
                        <label for="work_from_homey"><?= display('yes') ?></label>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="radio icheck-danger">
                        <input type="radio" id="work_from_homen" name="work_from_home" value="no" <?= @$employee['work_from_home'] == '0' ? 'checked' : null ?>>
                        <label for="work_from_homen"><?= display('no') ?></label>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-4">
                    <label class="check-label"><?= display('transportation_required') ?>:</label>
                </div>
                <div class="col-md-4">
                    <div class="radio icheck-danger">
                        <input type="radio" id="transportation_requiredy" name="transportation_required" value="yes" <?= @$employee['transportation_required'] == '1' ? 'checked' : null ?>>
                        <label for="transportation_requiredy"><?= display('yes') ?></label>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="radio icheck-danger">
                        <input type="radio" id="transportation_requiredn" name="transportation_required" value="no" <?= @$employee['transportation_required'] == '0' ? 'checked' : null ?>>
                        <label for="transportation_requiredn"><?= display('no') ?></label>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-extra-margin v-line">
            <h4 class="text-center">Credentials</h4>
            <?php foreach ($credentials as $cred_key => $cred_value) :?>
            <div>
                <div class="form-group">
                    <div class="col-md-4">
                        <label class="check-label"><?= $cred_value['title'] ?>:</label>
                    </div>
                    <div class="col-md-4">
                        <div class="radio icheck-danger">
                            <input type="radio" id="<?= $cred_key ?>Credy" name="credentials[<?= $cred_key ?>][create]" value="yes">
                            <label for="<?= $cred_key ?>Credy"><?= display('yes') ?></label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="radio icheck-danger">
                            <input type="radio" id="<?= $cred_key ?>Credn" name="credentials[<?= $cred_key ?>][create]" value="no">
                            <label for="<?= $cred_key ?>Credn"><?= display('no') ?></label>
                        </div>
                    </div>
                </div>
                <div class="form-group <?= $cred_key ?>Roles" style="display: none;">
                    <label for="sel<?= $cred_key ?>Roles" class="control-label">Select Role(s)</label>
                    <select class="form-control" name="credentials[<?= $cred_key ?>][role]<?= $cred_value['multi-select'] ? '[]' : null ?>" id="sel<?= $cred_key ?>Roles" style="width: 100%;" <?= $cred_value['multi-select'] ? 'multiple' : null ?>>
                        <option value=""></option>
                        <?php foreach ($cred_value['roles'] as $role) : ?>
                        <option value="<?= $role['id'] ?>" <?= @$role['is_default'] ? 'selected' : null ?>>
                            <?= $role['name'] ?>
                        </option>
                        <?php endforeach ?>
                    </select>
                </div>
            </div>
            <?php endforeach ?>
        </div>
    </div>
</fieldset>
<script>
    $(document).ready(function () {
        $('[name=cnic]').inputmask("99999-9999999-9");
        $('[name=dob]').flatpickr({
            dateFormat: 'd-m-Y'
        })
    });
    <?php foreach ($credentials as $cred_key => $cred_value) :?>
    $('#<?= $cred_key ?>Credy, #<?= $cred_key ?>Credn').on('change', function() {
        let div = $(this).closest('fieldset').find('.<?= $cred_key ?>Roles')
        div.hide()
        if(this.value == 'yes') {
            div.show()
        }
    })
    <?php endforeach ?>
</script>