<style>
    .table .dropdown-menu {
        left: -110px
    }
</style>
<div class="panel panel-default container-fluid">
    <h2><?=$job->position;?></h2>
    <div>&nbsp;</div>
    <h4>Details and manage applicants</h4>
    <div>&nbsp;</div>
</div>
<div class="container-fluid">
    <div class="row">
        <ul class="nav nav-tabs">
            <li data-toggle="tab" data-target="#details" class="active"><a href="#details">Details</a></li>
            <li data-toggle="tab" data-target="#applicants" class=""><a href="#applicants">Applicants (<?=count($candidates) ?>)</a></li>
            <li data-toggle="tab" data-target="#shortlisted" class=""><a href="#shortlisted">Shortlisted Candidates (<?=count($shortlisted)?>)</a></li>
            <li data-toggle="tab" data-target="#rejected" class=""><a href="#rejected">Rejected Candidates (<?=count($rejected)?>)</a></li>
        </ul>

        <div class="tab-content">
            <div class="tab-pane fade in active" id="details">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h2><?=$job->position;?></h2>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <?=implode(', ', $job->cities)?>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <h3>Job Description</h3>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p><?=$job->jp_title_description;?></p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <h3>Job Skill</h3>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <?php foreach ($job->skills as $location) {?>
                                    <span
                                        style='margin-bottom: 10px;background: #eeeeee;padding: 6px 12px;border-radius: 0px;color: #424242;font-weight: 400;'><?=$location['jps_name'];?></span>
                                    <?php }?>
                                </p>
                            </div>
                        </div>
                        <?php if($job->job_wfh): ?>
                            <div class="row">
                                <div class="col-md-12">
                                    <p>
                                        <h3>Work From Home</h3>
                                    </p>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <p>
                                        <?php foreach ($job->job_wfh as $location) {?>
                                        <span
                                            style='margin-bottom: 10px;background: #eeeeee;padding: 6px 12px;border-radius: 0px;color: #424242;font-weight: 400;'><?=$location['jpw_name'];?></span>
                                        <?php }?>
                                    </p>
                                </div>
                            </div>
                        <?php endif ?>
                        <div class="row">
                            <div class="col-md-12">
                                <p>
                                    <h3>Job Details</h3>
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Total Positions:</b>
                                    </div>
                                    <div class="col-md-3">
                                        <?=$job->jp_career_position;?>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Job Type:</b>
                                    </div>
                                    <div class="col-md-3">
                                        <?=$job->jp_employment_type;?>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Shift:</b>
                                    </div>
                                    <div class="col-md-3">
                                        <?=$job->jp_shift?>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Gender:</b>
                                    </div>
                                    <div class="col-md-3">
                                        <?=$job->jp_preference;?>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Minimum Education:</b>
                                    </div>
                                    <div class="col-md-3">
                                        <?=$job->jp_qualification_level;?>&nbsp;<?=$job->jp_qualification_must != 'exactly' ? $job->jp_qualification_must : null?>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Career Level:</b>
                                    </div>
                                    <div class="col-md-3">
                                        <?=$job->jp_career_level;?>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Experience:</b>
                                    </div>
                                    <div class="col-md-3">
                                        <?=$job->jp_experience_min;?> -
                                        <?=$job->jp_experience_max;?>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Salary:</b>
                                    </div>
                                    <div class="col-md-3">
                                        <?=$job->jp_salary_min;?> -
                                        <?=$job->jp_salary_max;?>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Benefit:</b>
                                    </div>
                                    <div class="col-md-9">
                                        <?=str_replace(',', ', ', $job->jp_benefits)?>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Posting Date:</b>
                                    </div>
                                    <div class="col-md-3">
                                        <?=formatted_date($job->jp_posted_on)?>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-3">
                                        <b>Due Date:</b>
                                    </div>
                                    <div class="col-md-3">
                                        <?=formatted_date($job->jp_due_date)?>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="applicants">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <table class="table table-striped table-hover table-candidates" style="width:100%">
                            <thead>
                                <tr>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Status</th>
                                    <th>Applied On</th>
                                    <th class="hideexport">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($candidates as $candidate): ?>
                                <?php
                                    $is_shortlisted = array_search($candidate->can_id, array_column($shortlisted, 'can_id')) !== false;
                                    $is_rejected = array_search($candidate->can_id, array_column($rejected, 'can_id')) !== false;
                                ?>
                                <tr>
                                    <td><?=$candidate->first_name?></td>
                                    <td><?=$candidate->last_name?></td>
                                    <td><?=$candidate->email?></td>
                                    <td><?=$candidate->phone?></td>
                                    <td>
                                        <?php 
                                            if($candidate->status == 'completed'){
                                                echo '<span class="label label-info">Hired</span>';
                                            }elseif($is_shortlisted){
                                                echo '<span class="label label-success">Shortlisted</span>';
                                            }elseif($is_rejected){
                                                echo '<span class="label label-danger">Rejected</span>';
                                            }else{
                                                echo '<span class="label label-primary">Pending</span>';
                                            }
                                        ?>
                                    </td>
                                    <td><?=formatted_date($candidate->applied_on)?></td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Action <span class="caret"></span>
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li><a href="#" class="btn-view-profile" data-id="<?=$candidate->can_id?>">View Profile</a></li>
                                                <li><a href="<?=base_url($candidate->resume)?>" download>Download Resume</a></li>
                                                <?php if($this->permission->method('job_posting', 'update')->access() && !$is_rejected && !$is_shortlisted && $candidate->status != 'completed'): ?>
                                                <li role="separator" class="divider"></li>
                                                <li><a href="#" class="btn-shortlist" data-id="<?=$candidate->can_id?>">Shortlist Candidate</a></li>
                                                <li><a href="#" class="btn-reject" data-id="<?=$candidate->can_id?>">Reject Candidate</a></li>
                                                <!-- <li><a href="#">Separated link</a></li> -->
                                                <?php endif?>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="shortlisted">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <table class="table table-striped table-hover table-shortlisted" style="width:100%">
                            <thead>
                                <tr>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Applied On</th>
                                    <th>Shortlisted On</th>
                                    <th class="hideexport">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($shortlisted as $candidate): ?>
                                <tr>
                                    <td><?=$candidate->first_name?></td>
                                    <td><?=$candidate->last_name?></td>
                                    <td><?=$candidate->email?></td>
                                    <td><?=$candidate->phone?></td>
                                    <td><?=formatted_date($candidate->applied_on)?></td>
                                    <td><?=formatted_date($candidate->date_of_shortlist)?></td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Action <span class="caret"></span>
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li><a href="#" class="btn-view-profile" data-id="<?=$candidate->can_id?>">View Profile</a></li>
                                                <li><a href="<?=base_url($candidate->resume)?>" download>Download Resume</a></li>
                                                <?php if($this->permission->method('job_posting', 'update')->access() && $candidate->status == 'shortlisted'): ?>
                                                <li role="separator" class="divider"></li>
                                                <li><a href="#" class="btn-remove-shortlist" data-id="<?=$candidate->can_short_id?>">Remove From Shortlist</a></li>
                                                <?php endif?>
                                                <!-- <li><a href="#">Separated link</a></li> -->
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="rejected">
                <div class="panel panel-default">
                    <div class="panel-body">
                        <table class="table table-striped table-hover table-rejected" style="width:100%">
                            <thead>
                                <tr>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Applied On</th>
                                    <th>Rejected On</th>
                                    <th>Remarks</th>
                                    <th class="hideexport">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($rejected as $candidate): ?>
                                <tr>
                                    <td><?=$candidate->first_name?></td>
                                    <td><?=$candidate->last_name?></td>
                                    <td><?=$candidate->email?></td>
                                    <td><?=$candidate->phone?></td>
                                    <td><?=formatted_date($candidate->applied_on)?></td>
                                    <td><?=formatted_date($candidate->rejected_on)?></td>
                                    <td><?=$candidate->remarks?></td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Action <span class="caret"></span>
                                            </button>
                                            <ul class="dropdown-menu">
                                                <li><a href="#" class="btn-view-profile" data-id="<?=$candidate->can_id?>">View Profile</a></li>
                                                <li><a href="<?=base_url($candidate->resume)?>" download>Download Resume</a></li>
                                                <?php if($this->permission->method('job_posting', 'update')->access()):?>
                                                <li role="separator" class="divider"></li>
                                                <li><a href="#" class="btn-unreject" data-id="<?=$candidate->rej_id?>">Remove From Rejected List</a></li>
                                                <?php endif?>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function () {
        if(location.hash){
            $(`.nav-tabs a[href="${location.hash}"]`).tab('show')
        }
        $('table.table-candidates').dataTable($.extend({}, window.default_datatable_opts, {
            "columnDefs": [ {
                "targets": [5],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }

            } ],
            "order": [[ 5, "asc" ]]
        }))
        $('table.table-shortlisted').dataTable($.extend({}, window.default_datatable_opts, {
            "columnDefs": [ {
                "targets": [5, 6],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }

            } ],
            "order": [[ 6, "asc" ]]
        }))
        $('table.table-rejected').dataTable($.extend({}, window.default_datatable_opts, {
            "columnDefs": [ {
                "targets": [5, 6],
                "type": "date",
                "render": function ( data, type ) {
                    if(type === 'sort'){
                        return moment(data, 'DD-MM-YYYY')
                    }
                    return data;
                }

            } ],
            "order": [[ 6, "asc" ]]
        }))
        $('.nav-tabs li').on('click', function(e){
            e.preventDefault();
            location.hash = $(this).data('target').replace('#', '')
        })
        $(document).on('click', '.btn-view-profile', function(e){
            e.preventDefault();
            myajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/job_posting/get_profile",
                data: {
                    'can_id': $(this).data('id')
                },
                success: function (res) {
                    if(res.success){
                        $('#model-profile').find('.modal-body').html(res.success)
                        $('#model-profile').modal('show')
                    }else{
                        alert(res.error)
                    }
                }
            });
        })
        $('table.table-candidates').on('click', '.btn-shortlist', function(e){
            e.preventDefault();
            if(!confirm('Are you sure that you want to shortlist this candidate?')){
                return;
            }
            myajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/job_posting/shortlist_candidate",
                data: {
                    'can_id': $(this).data('id')
                },
                complete: function() {
                    $('.se-pre-con').show()
                },
                success: function (res) {
                    $('.se-pre-con').show()
                    location.reload()
                }
            })
        })
        $('table.table-candidates').on('click', '.btn-reject', function(e){
            e.preventDefault();
            if(!confirm('Are you sure that you want to reject this candidate?')){
                return;
            }
            var $modal = $('#modal-reject');
            $modal.find('[name=can_id]').val($(this).data('id'))
            $modal.modal('show')
        })
        $('table.table-shortlisted').on('click', '.btn-remove-shortlist', function(e){
            e.preventDefault();
            if(!confirm('Are you sure that you want to remove this candidate from shortlist?')){
                return;
            }
            myajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/job_posting/unshortlist_candidate",
                data: {
                    can_short_id: $(this).data('id')
                },
                complete: function() {
                    $('.se-pre-con').show()
                },
                success: function (res) {
                    $('.se-pre-con').show()
                    location.reload()
                }
            });
        })
        $('table.table-rejected').on('click', '.btn-unreject', function(e){
            e.preventDefault();
            if(!confirm('Are you sure that you want to remove this candidate from rejected?')){
                return;
            }
            myajax({
                type: "POST",
                url: "<?=base_url()?>recruitment/job_posting/unreject_candidate",
                data: {
                    id: $(this).data('id')
                },
                complete: function() {
                    $('.se-pre-con').show()
                },
                success: function (res) {
                    location.reload()
                }
            });
        })
    });
</script>
<div class="modal fade" id="model-profile" tabindex="-1" role="dialog" aria-labelledby="modelTitleId" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Candidate Information</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
            </div>
            <div class="modal-body">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modal-reject" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <form action="<?=base_url()?>recruitment/job_posting/reject_candidate" method="post">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title">Reject Candidate</h4>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="can_id" value="">
                    <div class="form-group">
                      <label>Remarks</label>
                      <textarea class="form-control" name="remarks" rows="3" required></textarea>
                    </div>
                    <div class="form-group">
                      <label>Tag for future position of (optional)</label>
                      <select class="form-control" name="pos_id" style="width: 100%;">
                        <option value="">None</option>
                        <?php foreach ($positions as $position): ?>
                            <option value="<?=$position->pos_id?>"><?=$position->position_name?></option>
                        <?php endforeach?>
                      </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
            </div>
        </form>
    </div>
</div>
