<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
        <title><?php echo (!empty($setting->title)?$setting->title:null) ?> :: <?php echo (!empty($title)?$title:null) ?></title>

        <!-- Favicon and touch icons -->
        <link rel="shortcut icon" href="<?php echo base_url((!empty($setting->favicon)?$setting->favicon:'assets/img/new-ui/mini-logo.png')) ?>" type="image/x-icon">
        
        <!-- Start Global Mandatory Style -->
        <!-- Bootstrap -->
        <link href="<?php echo base_url('assets/css/bootstrap.min.css') ?>" rel="stylesheet" type="text/css"/>
        <!-- Bootstrap rtl -->
        <!-- <link href="<?php echo base_url('assets/css/bootstrap-rtl.min.css') ?>" rel="stylesheet" type="text/css"/> -->
        <!-- Pe-icon -->
        <link href="<?php echo base_url('assets/css/pe-icon-7-stroke.css') ?>" rel="stylesheet" type="text/css"/>
        
        <!-- Theme style -->
        <link href="<?php echo base_url('assets/css/custom.min.css') ?>" rel="stylesheet" type="text/css"/>
        <!-- Theme style rtl -->
        <!-- <link href="<?php echo base_url('assets/css/custom-rtl.min.css') ?>" rel="stylesheet" type="text/css"/> -->
        
        
    
<style> 
 .career_grid{}
 .career_grid .view-header{display: flex;
align-items: center;}
 .career_grid .view-header .logo{}
 .career_grid .view-header .logo img{    max-width: 100px;}
 .career_grid .view-header h1{margin-left: 20px;
color: #fff;
font-weight: 600;
font-size: 26px;}
 .career_grid .career-bg{padding: 20px 10px;box-shadow: 0px 10px 13px -5px #dcdcdc;}
 .d-flex{display:flex;}
 .align-items-center{align-items:center;}
 .career-bg {background-size: cover;}
 .career_grid .panel-body h3{font-weight: 600;color: #425985;}

 .grid_filter{min-width: 150px;
border: 1px solid #425985;
border-radius: 100px;
max-width: 150px;
text-align: left;
padding: 6px 10px;
font-size: 12px;}
 .grid_filter select{background-color: transparent;border: 0px;width: 100%;}
 
.career-cards {
    background-color: #ebebeb;
    border-radius: 7px;
    color: #05253a;
    text-align: center;
    height: 200px;
    display: grid;
    align-items: center;
    align-content: center;
    justify-content: center;
}
.career-cards:hover {
    background-color: #2c598b;
    color: white;
}
.card-careers-position .btn-career-link {
    background-color: #2c598b;
    color: white;
    padding: 6px 6px;
    border-radius: 10px;
    font-size: 11px;
    text-decoration: none !important;
    width: 110px;
    margin-left: auto;
    margin-right: auto;
}
.space{
    padding-bottom: 28px;
}

.career-cards:hover .btn-career-link {
    background-color: #d04f58;
    color: white;
}

</style>        
        
        
        
        
        
        
        
    </head>
    <body>
              <div class="container career_grid" style="margin-top : 50px">
                <div class="panel panel-bd careers_panel">
                     <div class="panel-heading  career-bg row">
                        <div class="view-header d-flex align-items-center col-sm-12">
                            <div class="logo"><a href="#"> 
                                <span class="logo-lg">
                                    <img src="<?=base_url()?>assets/img/new-ui/new-logo.png" alt="logo">
                                </span>
                            </a></div>
                       <h1>Careers</h1>
                       
                        </div>
                        <div class="">
                            <!-- alert message -->
                            <?php if ($this->session->flashdata('message') != null) {  ?>
                            <div class="alert alert-info alert-dismissable">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <?php echo $this->session->flashdata('message'); ?>
                            </div> 
                            <?php } ?>
                            
                            <?php if ($this->session->flashdata('exception') != null) {  ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <?php echo $this->session->flashdata('exception'); ?>
                            </div>
                            <?php } ?>
                            
                            <?php if (validation_errors()) {  ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <?php echo validation_errors(); ?>
                            </div>
                            <?php } ?> 
                        </div>
                    </div>

                    <div class="panel-body">
<div class="row d-flex align-items-center">
<div class="col-sm-6 pull-left"><h3>Open Positions</h3> </div>
<div class="col-sm-6 text-right">
<div class="grid_filter pull-right">
<select id="job_filter">
<option value="" disabled selected>Location</option>  
<option>Islamabad</option>
<option>Karachi</option>
<?php foreach ($cities as $city_name) :?>
<?php if(in_array($city_name, ['Islamabad','Karachi'])){
continue;
} ?>
<option><?= $city_name ?></option>
<?php endforeach?>
</select>   
    
</div>

</div>   
</div>                        
                   
                         
                        <div class=" b-scroll">
                        <div class="row  ">
                            <div class="col-md-12">
                               <div class="row" id="jobs-list">
                                    <?php foreach($job_posting as $job) {?>
                                    <div class="col-lg-r col-md-4 col-md-6 my-3">
                                        <div class="card card-careers-position card-events career-cards">
                                            <h4><?php echo $job->position ?></h4>
                                            
                                            <p class="space">
                                                <?= $job->cities ?> 
                                            </p>
                                            <!--<p><?= formatted_date($job->jp_posted_on) ?></p>-->
                                            
                                            <a href="<?php echo base_url('recruitment/Careers/job/'.$job->jp_short_url) ?>" class="btn-career-link">View Details</a>
                                        </div>
                                    </div>
                                     <?php }?>
                               </div> 
                            </div>
                           
                        </div>
                        </div>
                    </div>

                </div>
        </div>
        <!-- jQuery -->
        <script src="<?php echo base_url('assets/js/jquery-1.12.4.min.js') ?>" type="text/javascript"></script>
        <!-- Bootstrap -->
        <script src="<?php echo base_url('assets/js/bootstrap.min.js') ?>" type="text/javascript"></script>


        <script type="text/javascript">
        window.jobsdata = JSON.parse('<?= addslashes(json_encode($job_posting)) ?>');
        $('#job_filter').on('change', function (e) { 
            e.preventDefault();
            var html = '';
            var seach_val = $(this).val()
            var jp_url = "<?= base_url('recruitment/Careers/job/') ?>"
            var jobs_filtered = window.jobsdata.filter((job) => {
                if(!job.cities){
                    return true;
                }
                return job.cities.split(',').map($.trim).includes(seach_val)
            })
            jobs_filtered.forEach(function(job){
                html += '<div class="col-lg-r col-md-4 col-md-6 my-3"><div class="card card-careers-position card-events career-cards"><h4>' + job.position + '</h4><p class="space">' + job.cities + '</p><a href="' + jp_url + job.jp_short_url + '" class="btn-career-link">View Details</a></div></div>'
            });
            $('#jobs-list').html(html)
        });
        $(document).ready(function() {
            var info = $('table tbody tr');
            info.click(function() {
                var email    = $(this).children().first().text(); 
                var password = $(this).children().first().next().text();
                $("input[name=email]").val(email);
                $("input[name=password]").val(password);
            });
        });
        </script>



    </body>
</html> 