<?php $skill_labels = end($history)->skill_results ?>
<table class="table table-responsive">
    <caption><?= $history[0]->candidate_name ?></caption>
    <thead>
        <tr>
            <th>Interview No.</th>
            <th>Interview Date</th>
            <th>Position</th>
            <th>Interviewer</th>
            <?php foreach ($skill_labels as $value) :?>
            <th><?= $value->skill ?></th>
            <?php endforeach?>
            <th>Typing Speed</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($history as $key => $hist):?>
        <tr>
            <td><?= $key + 1 ?></td>
            <td><?= formatted_date($hist->interview_date, true) ?></td>
            <td><?= $hist->position ?></td>
            <td><?= $hist->interviewer_name ?> (<?= $hist->hrm_id ?>)</td>
            <?php if($hist->skill_results): ?>
                <?php foreach ($hist->skill_results as $value) :?>
                <td><?= $value->pass ? 'Yes' : 'No' ?></td>
                <?php endforeach?>
            <?php else: ?>
                <?php foreach ($skill_labels as $value) :?>
                <td>No</td>
                <?php endforeach?>
            <?php endif?>
            <td><?= $hist->total_marks ?></td>
        </tr>
        <tr>
            <td></td>
            <th>Recommendation</th>
            <td colspan="6"><?= $hist->recommandation ?></td>
        </tr>
        <tr>
            <td></td>
            <th>Details</th>
            <td colspan="6"><?= $hist->details ?></td>
        </tr>
        <tr>
            <td colspan="8">&nbsp;</td>
        </tr>
        <?php endforeach?>
    </tbody>
</table>