<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Credhrm_model extends CI_Model
{
    public function getRoles()
    {
        if (!$data = $this->cache->get('Cred.HRM.Roles')) {
            $this->load->model('dashboard/role_model');
            $raw_data = $this->role_model->get_roles();
            foreach ($raw_data as $raw_dt) {
                $data[] = [
                    'id' => $raw_dt->id,
                    'name' => $raw_dt->name,
                    'is_default' => !!$raw_dt->is_default,
                ];
            }
            $this->cache->save('Cred.HRM.Roles', $data, 10800);
        }

        return $data;
    }
    public function addUser($username, $employee, $roles)
    {
        $this->load->helper('string');
        $generated_password = str_replace('I', 'L', strtoupper(random_string('alpha', 6)));
        $user_data = [
            'firstname' => $employee->first_name,
            'lastname' => $employee->last_name,
            'email' => $employee->email,
            'password' => md5($generated_password),
            'status' => 1,
            'is_admin' => 0,
        ];
        $this->db->insert('user', $user_data);
        $user_id = $this->db->insert_id();
        foreach ($roles as $role_id) {
            $this->db->insert('sec_user_access_tbl', [
                'fk_user_id' => $user_id,
                'fk_role_id' => $role_id,
            ]);
        }
        return [
            'username' => $employee->email,
            'password' => $generated_password,
        ];
    }
    public function setStatus($email, $status)
    {
        return $this->db->where('email', $email)->update('user', [
            'status' => $status ? '1' : '0'
        ]);
    }
}
