<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Requisition extends Loggedin_Controller
{
    private $ad_save_path;
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'Job_model',
            'requisition_model',
        ));
        $this->ad_save_path = FCPATH . 'uploads/temp/' . date('Y-m-d') . '/';

    }
    function list() {
        $this->permission->method('requisition_list', 'read')->redirect();
        $data['title'] = display('requisition_list');
        $data['module'] = "recruitment";
        $data['page'] = "requisition/list";
        echo Modules::run('template/layout', $data);
    }
    public function view($id)
    {
        $this->permission->method('requisition_list', 'read')->redirect();
        $data['title'] = display('requisition_list');
        $data['module'] = "recruitment";
        $data['page'] = "requisition/view";

        $data['jobs_reads'] = $this->requisition_model->get($id);
        $data['jobs_remarks'] = $this->requisition_model->get_remarks($id);
        echo Modules::run('template/layout', $data);
    }
    public function add()
    {
        $this->permission->method('requisition_list', 'create')->redirect();
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'job_description',
                    'label' => display('job_description'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'benefit_tags',
                    'label' => display('benefits'),
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'job_skill[]',
                    'label' => display('job_skill'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'job_wfh[]',
                    'label' => 'Work From Home',
                    'rules' => '',
                ),
                array(
                    'field' => 'career_level',
                    'label' => display('career_level'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'no_of_position',
                    'label' => display('no_of_position'),
                    'rules' => 'trim|required|is_natural',
                ),
                array(
                    'field' => 'division_id',
                    'label' => 'Division',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'job_location[]',
                    'label' => display('job_location'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'qualification',
                    'label' => display('qualification'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'higher_exactly',
                    'label' => display('higher_exactly'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'min_experience',
                    'label' => display('min_experience'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'max_experience',
                    'label' => display('max_experience'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'from_salary',
                    'label' => display('from_salary'),
                    'rules' => 'required|regex_match[/[\d\,]+/]',
                    'errors' => array(
                        'regex_match' => '%s field can only contain \',\' or numbers',
                    ),
                ),
                array(
                    'field' => 'to_salary',
                    'label' => display('to_salary'),
                    'rules' => 'required|regex_match[/[\d\,]+/]',
                    'errors' => array(
                        'regex_match' => '%s field can only contain \',\' or numbers',
                    ),
                ),
                array(
                    'field' => 'employment_type',
                    'label' => display('employment_type'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'gender_preference',
                    'label' => display('gender_preference'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'benefit_tags',
                    'label' => display('benefit'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'shift',
                    'label' => display('shift'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'due_date',
                    'label' => 'Due Date',
                    'rules' => 'required',
                ),
            );
            if (empty($this->input->post('job_title')) && empty($this->input->post('job_d'))) {
                $rules_config = array(
                    'field' => 'job_title',
                    'label' => display('job_title'),
                    'rules' => 'required',
                );
            }
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                $pos_id = $this->input->post('job_title');
                if (!$this->input->post('job_title')) {
                    $pos_id = $this->requisition_model->get_position_id($this->input->post('job_d'));
                }
                $postData = [
                    'pos_id' => $pos_id,
                    'jp_title_description' => $this->input->post('job_description', true),
                    'jp_career_level' => $this->input->post('career_level', true),
                    'jp_career_position' => $this->input->post('no_of_position', true),
                    'jp_qualification_level' => $this->input->post('qualification', true),
                    'jp_qualification_must' => $this->input->post('higher_exactly', true),
                    'jp_experience_min' => $this->input->post('min_experience', true),
                    'jp_experience_max' => $this->input->post('max_experience', true),
                    'jp_salary_min' => $this->input->post('from_salary', true),
                    'division_id' => $this->input->post('division_id', true),
                    'jp_salary_max' => $this->input->post('to_salary', true),
                    'jp_employment_type' => $this->input->post('employment_type', true),
                    'jp_preference' => $this->input->post('gender_preference', true),
                    'jp_benefits' => $this->input->post('benefit_tags', true),
                    'jp_shift' => $this->input->post('shift', true),
                    'jp_due_date' => date('Y-m-d', strtotime($this->input->post('due_date'))),
                    'jp_short_url' => $this->Job_model->generateShortURlCode(),
                    'created_by' => $this->session->userdata('id'),
                    'jp_is_draft' => isset($_POST['draft']),
                ];
                if ($id = $this->Job_model->create_job($postData, $_POST)) {
                    if (!isset($_POST['draft'])) {
                        $this->notify->role('Recruitment Manager')->send(
                            sprintf('New Requisition Request Added For Post: %s', $this->input->post('job_d')),
                            'recruitment/Requisition/view/' . $id
                        );
                    }
                    $this->session->set_flashdata('message', display('successfully_saved'));
                    redirect('recruitment/Requisition/list');
                } else {
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
            }
        }
        $data['title'] = 'Add Requisition Request';
        $data['module'] = "recruitment";
        $data['page'] = "requisition/add";
        $this->load->model('department/department_model');
        $data['divisions'] = $this->department_model->division_dropdown();
        $data['cities'] = $this->Job_model->cities();
        $data['options'] = $this->requisition_model->get_options();
        echo Modules::run('template/layout', $data);
    }
    public function update($id)
    {
        $error_post = false;
        $req_rec = $this->requisition_model->get($id);
        if ($this->session->userdata('id') != $req_rec->created_by || $req_rec->requisition_status != 'changes_required') {
            $this->permission->method('requisition_list', 'update')->redirect();
        }
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'job_description',
                    'label' => display('job_description'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'benefit_tags',
                    'label' => display('benefits'),
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'job_skill[]',
                    'label' => display('job_skill'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'career_level',
                    'label' => display('career_level'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'no_of_position',
                    'label' => display('no_of_position'),
                    'rules' => 'trim|required|is_natural',
                ),
                array(
                    'field' => 'job_location[]',
                    'label' => display('job_location'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'division_id',
                    'label' => 'Division',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'qualification',
                    'label' => display('qualification'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'higher_exactly',
                    'label' => display('higher_exactly'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'min_experience',
                    'label' => display('min_experience'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'max_experience',
                    'label' => display('max_experience'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'from_salary',
                    'label' => display('from_salary'),
                    'rules' => 'required|regex_match[/[\d\,]+/]',
                    'errors' => array(
                        'regex_match' => '%s field can only contain \',\' or numbers',
                    ),
                ),
                array(
                    'field' => 'to_salary',
                    'label' => display('to_salary'),
                    'rules' => 'required|regex_match[/[\d\,]+/]',
                    'errors' => array(
                        'regex_match' => '%s field can only contain \',\' or numbers',
                    ),
                ),
                array(
                    'field' => 'employment_type',
                    'label' => display('employment_type'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'gender_preference',
                    'label' => display('gender_preference'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'benefit_tags',
                    'label' => display('benefits'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'shift',
                    'label' => display('shift'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'due_date',
                    'label' => 'Due Date',
                    'rules' => 'required',
                ),
            );
            if (empty($this->input->post('job_title')) && empty($this->input->post('job_d'))) {
                $rules_config = array(
                    'field' => 'job_title',
                    'label' => display('job_title'),
                    'rules' => 'required',
                );
            }
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                $pos_id = $this->input->post('job_title');
                if (!$this->input->post('job_title')) {
                    $pos_id = $this->requisition_model->get_position_id($this->input->post('job_d'));
                }
                $postData = [
                    'pos_id' => $pos_id,
                    'jp_title_description' => $this->input->post('job_description', true),
                    'jp_career_level' => $this->input->post('career_level', true),
                    'jp_career_position' => $this->input->post('no_of_position', true),
                    'jp_qualification_level' => $this->input->post('qualification', true),
                    'jp_qualification_must' => $this->input->post('higher_exactly', true),
                    'jp_experience_min' => $this->input->post('min_experience', true),
                    'jp_experience_max' => $this->input->post('max_experience', true),
                    'jp_salary_min' => $this->input->post('from_salary', true),
                    'jp_salary_max' => $this->input->post('to_salary', true),
                    'division_id' => $this->input->post('division_id', true),
                    'jp_employment_type' => $this->input->post('employment_type', true),
                    'jp_preference' => $this->input->post('gender_preference', true),
                    'jp_benefits' => $this->input->post('benefit_tags', true),
                    'jp_shift' => $this->input->post('shift', true),
                    'jp_due_date' => date('Y-m-d', strtotime($this->input->post('due_date'))),
                    'updated_by' => $this->session->userdata('id'),
                    'jp_updated_on' => date('Y-m-d H:i:s'),
                    'jp_is_draft' => isset($_POST['draft']),
                ];
                $requisition_rec = getByWhere('job_posting, position-position.pos_id=job_posting.pos_id-left', 'job_posting.*, position.position_name', ['jp_id' => $id])[0];
                if ($this->input->post('submission') == 'savensubmit') {
                    $postData['requisition_status'] = 'pending_rm';
                    $this->db->where('jp_id', $id)->update('requisition_request_history', [
                        'processed' => true,
                    ]);
                    $this->notify->role('Recruitment Manager')->send(
                        sprintf(
                            'Requisition request for the post \'%s\' has been resubmitted after making amendments',
                            $requisition_rec->position_name,
                        ),
                        'recruitment/Requisition/view/' . $id
                    );
                }
                $_POST['id'] = $id;
                if ($this->Job_model->save_job($postData, $_POST)) {
                    if ($requisition_rec->jp_is_draft && !isset($_POST['draft'])) {
                        $this->notify->role('Recruitment Manager')->send(
                            sprintf('New Requisition Request Added For Post: %s', $requisition_rec->position_name),
                            'recruitment/Requisition/view/' . $id
                        );
                    }
                    $this->session->set_flashdata('message', display('successfully_saved'));
                    if ($this->input->get('redirect')) {
                        redirect($this->input->get('redirect'));
                    } else {
                        redirect('recruitment/Requisition/list');
                    }
                } else {
                    $error_post = true;
                    $this->session->set_flashdata('exception', display('please_try_again'));
                }
            } else {
                $error_post = true;
            }
        }
        $data['title'] = 'Update Requisition Request';
        $data['module'] = "recruitment";
        $data['page'] = "requisition/update";
        $data['job'] = $req_rec;
        $data['after_post'] = $error_post;
        $this->load->model('department/department_model');
        $data['divisions'] = $this->department_model->division_dropdown();
        $data['cities'] = $this->Job_model->cities();
        $data['options'] = $this->requisition_model->get_options();
        $data['jobs_remarks'] = $this->requisition_model->get_remarks($id);
        echo Modules::run('template/layout', $data);
    }
    public function process($id)
    {
        if ($this->input->post()) {
            if (!$id || !$this->input->post('type')) {
                $this->session->set_flashdata('exception', 'Unable to perform this action try again!');
            } else {
                $rules_config = [
                    array(
                        'field' => 'remarks',
                        'label' => 'Remarks',
                        'rules' => 'trim|required|min_length[10]',
                    ),
                ];
                $this->form_validation->set_rules($rules_config);
                if (!in_array($this->input->post('type'), ['pending_rm', 'changes_required', 'rejected_rm']) || $this->form_validation->run() === true) {
                    if ($this->permission->method('requisition_list', 'create')->access() && in_array($this->input->post('type'), ['pending_rm'])) {
                        //Creator block
                        $this->activity->set_job($id)->log('requisition_author_status');
                        if ($this->requisition_model->change_status($id, $this->input->post('type'), $this->input->post('remarks'))) {
                            $this->session->set_flashdata('message', 'Request status updated');
                        } else {
                            $this->session->set_flashdata('exception', 'Unable to change status, try again later!');
                        }
                    } elseif ($this->permission->module('review_requisition_list')->access()
                        && in_array($this->input->post('type'), ['pending_hr', 'changes_required', 'rejected_rm'])) {
                        //Recruitment Manager block
                        $status_text = '';
                        switch ($this->input->post('type')) {
                            case 'pending_hr':{
                                $status_text = 'Approved';
                                break;
                            }
                            case 'rejected_rm':{
                                $status_text = 'Rejected';
                                break;
                            }
                            case 'changes_required':{
                                $status_text = 'Marked as changes required on';
                                break;
                            }
                        }
                        $this->activity->set_job($id)->log([
                            'requisition_rm_status',
                            $status_text
                        ]);
                        if ($this->requisition_model->change_status($id, $this->input->post('type'), $this->input->post('remarks'))) {
                            $this->session->set_flashdata('message', 'Request status updated');
                        } else {
                            $this->session->set_flashdata('exception', 'Unable to change status, try again later!');
                        }
                    } elseif ($this->permission->module('create_ad_from_requisition')->access()
                        && in_array($this->input->post('type'), ['created'])) {
                        //HR Reviewer block
                        $this->activity->set_job($id)->log('requisition_hr_status');
                        switch ($this->input->post('type')) {
                            case 'created':{
                                    if ($this->requisition_model->generate_ad($id)) {
                                        $this->session->set_flashdata('message', 'Request status updated');
                                    } else {
                                        $this->session->set_flashdata('exception', 'Unable to change status, try again later!');
                                    }
                                    break;
                                }
                        }
                    } else {
                        $this->session->set_flashdata('exception', 'You are not allowed to perform this action');
                    }
                } else {
                    $this->session->set_flashdata('exception', validation_errors());
                }
            }
            redirect($_SERVER['HTTP_REFERER']);
        }
    }
    public function options()
    {
        $this->permission->method('requisition_options', 'read')->redirect();
        $data['title'] = display('requisition_options');
        $data['module'] = "recruitment";
        $data['page'] = "requisition/options";

        $data['options'] = $this->requisition_model->get_options();
        echo Modules::run('template/layout', $data);
    }
    public function save_option()
    {
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'type',
                    'label' => 'Type',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'value',
                    'label' => 'Value',
                    'rules' => 'trim|required|strip_tags',
                ),
                array(
                    'field' => 'sort_order',
                    'label' => 'Order',
                    'rules' => 'trim|is_natural',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if ($this->form_validation->run() === true) {
                if ($this->requisition_model->requision_duplicate(
                    $this->input->post('type'),
                    $this->input->post('value'),
                    $this->input->post('id')
                )) {
                    $this->session->set_flashdata('exception',
                        sprintf('Value \'%s\' for option \'%s\' already exists', $this->input->post('value'), ucwords(str_replace(['-', '_'], ' ', $this->input->post('type'))))
                    );
                    redirect($_SERVER['HTTP_REFERER']);
                }
                if ($this->requisition_model->save_option($this->input->post())) {
                    $this->session->set_flashdata('success', 'Option ' . ($this->input->post('id') ? 'update' : 'added') . ' successfully');
                } else {
                    $this->session->set_flashdata('exception', 'Couldn\'t add option, please try again!');
                }
            } else {
                $this->session->set_flashdata('exception', validation_errors());
            }
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function get_option()
    {
        $this->permission->method('requisition_options', 'read')->redirect();
        if ($this->input->post()) {
            $rec = $this->requisition_model->get_option($this->input->post('id'));
            if ($rec) {
                sendJson(['success' => $rec]);
            } else {
                sendJson(['error' => 'Failed to fetch option record, please try again!']);
            }
        }
    }
    public function delete_option($id)
    {
        $this->permission->method('requisition_options', 'delete')->redirect();
        if ($this->requisition_model->delete_option($id)) {
            $this->session->set_flashdata('success', 'Option deleted successfully');
        } else {
            $this->session->set_flashdata('exception', 'Couldn\'t delete option, please try again!');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function sort()
    {
        $this->permission->method('requisition_options', 'update')->redirect();
        if ($this->requisition_model->sort($this->input->post('order'))) {
            sendJson(['success' => 'Option order saved']);
        } else {
            sendJson(['error' => 'Failed to save order']);
        }
    }
    public function get_requisitions()
    {
        $this->permission->method('requisition_list', 'read')->redirect();
        if ($this->input->post()) {
            $search_arr = [];
            $search_columns = [
                'position.position_name',
                'employee_history.first_name',
                'employee_history.middle_name',
                'employee_history.last_name',
                'employee_history.hrm_id',
                'employee_history.email',
                'job_posting.jp_id',
                'job_posting.jp_due_date',
                'job_posting.jp_title_description',
                'job_posting.jp_career_level',
                'job_posting.jp_career_position',
                'job_posting.jp_shift',
                'job_posting.jp_qualification_level',
                'job_posting.jp_experience_min',
                'job_posting.jp_experience_max',
                'job_posting.jp_salary_min',
                'job_posting.jp_salary_max',
                'job_posting.jp_preference',
                'job_posting.jp_employment_type',
                'job_posting.jp_benefits',
                'job_posting.jp_short_url',
            ];
            if (!empty(@$this->input->post('search')['value'])) {
                $searchVal = $this->input->post('search')['value'];
                foreach ($search_columns as $value) {
                    $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
                }
            };
            $notif_recs = $this->requisition_model->requisitions(
                $this->session->userdata('id'),
                $this->input->post('start'),
                $this->input->post('length'),
                [
                    $this->input->post('columns')[$this->input->post('order')[0]['column']]['data'],
                    $this->input->post('order')[0]['dir'],
                ],
                $search_arr
            );
            $total_recs = $this->requisition_model->count_datatable($this->session->userdata('id'), $search_arr);
            $out_arr['draw'] = $_POST['draw'];
            $out_arr['data'] = array();
            $out_arr["recordsTotal"] = $total_recs;
            $out_arr["recordsFiltered"] = $total_recs;
            foreach ($notif_recs as $index => $rec) {
                foreach ($_POST['columns'] as $col) {
                    $tdData = null;
                    switch ($col['data']) {
                        case 'jp_title_description':{
                                $rec[$col['data']] = trim(strip_tags($rec[$col['data']]));
                                if (strlen($rec[$col['data']]) > 60) {
                                    $rec[$col['data']] = substr($rec[$col['data']], 0, 60) . '...';
                                }
                                $tdData = $rec[$col['data']];
                                break;
                            }
                        case 'requisition_status':{
                                switch ($rec[$col['data']]) {
                                    case 'pending_rm':{
                                            $tdData = '<span class="label label-primary">Awaiting Recruitment Manager\'s Response</span>';
                                            break;
                                        }
                                    case 'rejected_rm':{
                                            $tdData = '<span class="label label-danger">Rejected By Recruitment Manager</span>';
                                            break;
                                        }
                                    case 'changes_required':{
                                            $tdData = '<span class="label label-warning">Changes Required</span>';
                                            break;
                                        }
                                    case 'pending_hr':{
                                            $hr_name = null;
                                            if ($rec['hr_assigned']) {
                                                $hr_name = $this->db->select('CONCAT_WS(\' \', firstname, lastname) as name')->where('id', $rec['hr_assigned'])->get('user')->row();
                                                if ($hr_name) {
                                                    $hr_name = $hr_name->name;
                                                } else {
                                                    $hr_name = null;
                                                }
                                            }
                                            if ($hr_name) {
                                                $tdData = sprintf('<span class="label label-primary">Awaiting HR (%s) Review</span>', $hr_name);
                                            } else {
                                                $tdData = '<span class="label label-primary">Awaiting HR Review</span>';
                                            }
                                            break;
                                        }
                                    /* case 'rejected_hr':{
                                    $tdData = '<span class="label label-danger">Rejected by HR</span>';
                                    break;
                                    } */
                                    case 'closed':{
                                            $tdData = '<span class="label label-danger">Closed</span>';
                                            break;
                                        }
                                    case 'created':{
                                            $tdData = '<span class="label label-success">Job Created</spans>';
                                            break;
                                        }
                                    case 'fulfilled':{
                                            $tdData = '<span class="label label-success">Fulfilled</spans>';
                                            break;
                                        }
                                }
                                break;
                            }
                        case 'author':{
                            $tdData = empty($rec[$col['data']]) ? 'HR Admin' : $rec[$col['data']];
                            break;
                        }
                        case 'action':{
                                if ($this->input->get('drafts')) {
                                    $tdData = '<a class="btn btn-primary btn-sm" href="' . base_url('recruitment/Requisition/update/' . $rec['jp_id']) . '"><i class="fa fa-pencil" aria-hidden="true"></i> Edit</a>';
                                } else {
                                    if ($this->session->userdata('isAdmin')) {
                                        $tdData = '<div class="btn-group">
                                        <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                          Action <span class="caret"></span>
                                        </button>
                                        <ul class="dropdown-menu">';
                                        $tdData .= '<li><a href="' . base_url('recruitment/Requisition/view/' . $rec['jp_id']) . '"><i class="fa fa-eye" aria-hidden="true"></i> View</a></li>';
                                        $tdData .= '<li><a href="' . base_url('recruitment/Requisition/update/' . $rec['jp_id']) . '"><i class="fa fa-pencil" aria-hidden="true"></i> Edit</a></li>';
                                        if (in_array($rec['requisition_status'], ['created'])) {
                                            $tdData .= '<li><a class="btn-download" href="#" data-id="' . $rec['jp_id'] . '"><i class="fa fa-download" aria-hidden="true"></i> Download</a></li>';
                                        }
                                        $tdData .= '</ul></div>';
                                    } elseif (in_array($rec['requisition_status'], ['changes_required'])) {
                                        $tdData .= '<a class="btn btn-primary" href="' . base_url('recruitment/Requisition/view/' . $rec['jp_id']) . '"><i class="fa fa-pencil" aria-hidden="true"></i> Update</a>';
                                    } elseif ($this->permission->module('create_ad_from_requisition')->access() && in_array($rec['requisition_status'], ['created'])) {
                                        $tdData .= '<button type="button" class="btn btn-success btn-download" data-id="' . $rec['jp_id'] . '"><i class="fa fa-download" aria-hidden="true"></i> Download</button>';
                                    } elseif (
                                        $this->permission->module('review_requisition_list')->access()
                                        || $this->permission->module('create_ad_from_requisition')->access()) {
                                        $tdData .= '<a class="btn btn-primary" href="' . base_url('recruitment/Requisition/view/' . $rec['jp_id']) . '"><i class="fa fa-eye" aria-hidden="true"></i> View</a>';
                                    }
                                }
                                break;
                            }
                        default:{
                                $tdData = $rec[$col['data']];
                                break;
                            }
                    }
                    $out_arr['data'][$index][$col['data']] = $tdData;
                }
            }
            sendJson($out_arr);
        }
    }
    function print($type = 'apd', $id) {
        $job = $this->requisition_model->get($id);
        if ($this->input->post('file')) {
            try {
                $data = $_POST['file'];
                list($type, $data) = explode(';', $data);
                list(, $data) = explode(',', $data);
                $data = base64_decode($data);

                if (!is_dir($this->ad_save_path)) {
                    mkdir($this->ad_save_path);
                }
                $file = $this->ad_save_path . time() . '.png';
                file_put_contents($this->ad_save_path . time() . '.png', $data);
                sendJson(['success' => str_replace(FCPATH, '', $file)]);
            } catch (\Throwable $e) {
                sendJson(['error' => $e->getMessage()]);
            }
            return;
        } elseif ($this->input->get('url')) {
            if (!file_exists(FCPATH . $this->input->get('url'))) {
                show_404();
            }
            $im = imagecreatefrompng(FCPATH . $this->input->get('url'));

            // Crop the extra white area
            $cropped = imagecropauto($im, IMG_CROP_WHITE);

            // Convert it to a png file
            header("Content-Description: File Transfer");
            header("Content-Type: application/octet-stream");
            header("Content-Disposition: attachment; filename=\"" . $job->position . ".png\"");
            imagepng($cropped);
            return;
        }
        $data['job'] = $job;
        $division = $this->db->where('id', $data['job']->division_id)->get('divisions')->row();
        if (!$division) {
            return;
        }
        $this->load->view('ads/' . strtolower($division->prefix), $data);
    }
    public function pdf($id)
    {
        $data['job'] = $this->requisition_model->get($id);
        $this->load->library('pdfgenerator');
        $this->pdfgenerator->generate($this->load->view('requisition/pdf', $data, true), $data['job']->position);
    }
}
