<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Hired extends Loggedin_Controller
{
    private $_active_creds = [];
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'Selection_model',
            'Hired_model',
        ));
        $this->_active_creds = $this->load->config('other_portals', true);
    }
    function list() {
        $this->permission->module('hired_candidate', 'read')->redirect();
        if ($this->input->post()) {
            $this->get_datatable();return;
        }
        $this->load->model('employee/Employees_model');
        $data['positions'] = $this->Employees_model->designation();
        $data['dropdowns'] = $this->Selection_model->get_dropdowns();
        $data['title'] = display('hired_candidate');
        $data['module'] = "recruitment";
        $data['page'] = "hired_candidate";
        echo Modules::run('template/layout', $data);
    }
    public function orientation_done()
    {
        if (!$this->permission->module('hired_candidate', 'update')->access()) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        if ($this->input->post('id')) {
            $emp_rec = $this->db->select('employee_id, first_name, last_name, hrm_id, super_visor_id as supervisor_id, indirect_super_visor_id as ind_supervisor_id, present_address, phone')->where('employee_id', $this->input->post('id'))->get('employee_history')->row_array();
            if (!$emp_rec) {
                sendJson(['error' => 'Employee record not found for candidate']);
            }
            $emp_rec = decrypt_employee_data($emp_rec);
            $this->load->model('Employee/Employees_model');

            foreach ($this->_active_creds as $cred_key => $cred_value) {
                $this->load->model('Cred'.$cred_key.'_model');
                $this->_active_creds[$cred_key]['roles'] = $this->{'Cred'.$cred_key.'_model'}->getRoles();
            }

            $html = $this->load->view('recruitment/orientation_popup', [
                'employee' => $emp_rec,
                'shifts' => $this->db->select('id, name')->order_by('id', 'asc')->get('shift')->result(),
                'genders' => $this->db->select('id, gender_name as name')->order_by('id', 'asc')->get('gender')->result(),
                'supervisors' => $this->Employees_model->supervisorlist('employee_id, first_name, last_name, hrm_id'),
                'credentials' => $this->_active_creds,
            ], true);
            $html = preg_replace('~>[\s\\n\\r]+?<~', '><', $html);
            sendJson(['success' => $html]);
        }
        sendJson(['error' => 'Invalid request']);
    }
    public function hire()
    {
        if (!$this->permission->module('hired_candidate', 'update')->access()) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        if ($this->input->post('employee_id')) {
            $emp_rec = $this->db
            ->select('employee_history.employee_id, employee_history.first_name, employee_history.last_name, employee_history.hrm_id, employee_history.email, employee_history.division_id, employee_history.hire_date, employee_history.present_address, employee_history.phone, candidate_basic_info.orientation, candidate_basic_info.can_id, department.department_name as department, shift.name as shift, shift.start as shift_start, shift.end as shift_end, shift.flexible_shift')
            ->where('employee_history.employee_id', $this->input->post('employee_id'))
            ->join('candidate_basic_info', 'employee_history.employee_id=candidate_basic_info.employee_id', 'left')
            ->join('department', 'employee_history.dept_id=department.dept_id', 'left')
            ->join('shift', 'employee_history.shift=shift.id', 'left')
            ->get('employee_history')->row();
            if (!$emp_rec) {
                sendJson(['error' => 'Employee record not found for this candidate']);
            }
            if($emp_rec->orientation != 'pending') {
                sendJson(['error' => 'Employee\'s orientation is already marked done. Refresh your page']);
            }
            if($this->db->where('employee_id', $this->input->post('employee_id'))->count_all_results('employee_credentials') > 0) {
                sendJson(['error' => 'Employee credentials have already been generated. Refresh your page']);
            }
            $rules_config = array(
                array(
                    'field' => 'indManager',
                    'label' => 'Indirect Manager',
                    'rules' => 'trim|required|is_natural',
                ),
                array(
                    'field' => 'manager',
                    'label' => 'Direct Manager',
                    'rules' => 'trim|required|is_natural',
                ),
                array(
                    'field' => 'work_from_home',
                    'label' => 'Work From Home',
                    'rules' => 'trim|required|in_list[yes,no]',
                ),
                array(
                    'field' => 'transportation_required',
                    'label' => 'Transportation Required',
                    'rules' => 'trim|required|in_list[yes,no]',
                ),
                array(
                   'field' => 'phone',
                   'label' => 'Phone',
                   'rules' => 'trim|required|min_length[5]',
                ),
                array(
                    'field' => 'present_address',
                    'label' => 'Present Address',
                    'rules' => 'strip_tags|trim|required|min_length[5]',
                ),
                array(
                    'field' => 'gender',
                    'label' => 'Gender',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'shift',
                    'label' => 'Shift',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'cnic',
                    'label' => 'Shift',
                    'rules' => 'trim|required',
                ),
                array(
                    'field' => 'dob',
                    'label' => 'Date of Birth',
                    'rules' => 'trim|required',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            $outjson = [];
            if ($this->form_validation->run() === false) {
                foreach ($rules_config as $value) {
                    $err = form_error($value['field']);
                    if ($err) {
                        $outjson['errors'][] = [$value['field'], $err];
                    }
                }
            }
            foreach ($this->_active_creds as $cred_key => $cred_value) {
                if (!isset($_POST['credentials'][$cred_key]['create']) && empty($_POST['credentials'][$cred_key]['create']) && !in_array($_POST['credentials'][$cred_key]['create'], ['yes', 'no'])) {
                    $outjson['errors'][] = ['credentials\\[' . $cred_key . '\\]\\[create\\]', 'The ' . $cred_value['title'] . ' ID field is required'];
                }
                if (isset($_POST['credentials'][$cred_key]['create']) && in_array($_POST['credentials'][$cred_key]['create'], ['yes']) && empty($_POST['credentials'][$cred_key]['role'])) {
                    $outjson['errors'][] = ['credentials\\[' . $cred_key . '\\]\\[role\\]', 'The ' . $cred_value['title'] . ' role field is required'];
                }
            }
            if (isset($outjson['errors']) && !empty($outjson['errors'])) {
                sendJson($outjson);
            }

            $this->db->trans_start();
            $emp_data = [
                'status' => 'active',
                'indirect_super_visor_id' => $this->input->post('indManager'),
                'super_visor_id' => $this->input->post('manager'),
                'transportation_required' => $this->input->post('transportation_required') == 'yes' ? 1 : 0,
                'work_from_home' => $this->input->post('work_from_home') == 'yes' ? 1 : 0,
                'phone' => $this->input->post('phone'),
                'gender' => $this->input->post('gender'),
                'shift' => $this->input->post('shift'),
                'dob' => $this->input->post('dob'),
                'cnic' => str_replace(['_', '-'], '', $this->input->post('cnic')),
                'present_address' => strip_tags($this->input->post('present_address')),
            ];
            $this->db->where('employee_id', $this->input->post('employee_id'))->update('employee_history', encrypt_employee_data($emp_data));
            $this->db->where('employee_id', $this->input->post('employee_id'))->update('candidate_basic_info', [
                'orientation' => 'done',
                'updated_at' => current_date(true),
            ]);

            $credentials = $this->Hired_model->generate_credentials($_POST, $emp_rec);

            $this->db->insert('employee_credentials', [
                'employee_id' => $emp_rec->employee_id,
                'credentials' => $this->encryption->encrypt(json_encode($credentials)),
                'created_at' => date('Y-m-d')
            ]);

            $emp_rec = $this->db
            ->select('employee_history.employee_id, employee_history.first_name, employee_history.last_name, employee_history.hrm_id, employee_history.email, employee_history.division_id, employee_history.hire_date, employee_history.present_address, employee_history.phone, candidate_basic_info.orientation, candidate_basic_info.can_id, department.department_name as department, shift.name as shift, shift.start as shift_start, shift.end as shift_end, shift.flexible_shift, gender.singular_pronoun, gender.possessive_pronoun')
            ->where('employee_history.employee_id', $this->input->post('employee_id'))
            ->join('candidate_basic_info', 'employee_history.employee_id=candidate_basic_info.employee_id', 'left')
            ->join('department', 'employee_history.dept_id=department.dept_id', 'left')
            ->join('shift', 'employee_history.shift=shift.id', 'left')
            ->join('gender', 'employee_history.gender=gender.id', 'left')
            ->get('employee_history')->row();
            $emp_rec = decrypt_employee_data($emp_rec);
            $this->notify
                ->employee([$emp_data['indirect_super_visor_id'], $emp_data['super_visor_id']])
                ->send(
                    sprintf(display('new_onboarding_managers'), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                    'employee/employees/cv/' . $emp_rec->employee_id
                );
            $supervisors = $this->db->select('business_email')->where_in('employee_id', [$emp_data['indirect_super_visor_id'], $emp_data['super_visor_id']])->get('employee_history')->result();
            $this->template_mail->config($emp_rec->division_id)->_send(
                array_column($supervisors, 'business_email'),
                null,
                'New Resource Joined',
                $this->load->view('recruitment/email/managers_new_hire', ['employee_name' => sprintf('%s %s (%s)', $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id), 'employee' => (array) $emp_rec], true),
            );
            if ($this->input->post('transportation_required') == 'yes') {
                $this->notify->department('admin')->send(
                    sprintf(display('admin_department_new_onboarding'), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                    'employee/employees/cv/' . $emp_rec->employee_id
                );
                $this->template_mail->send_to_department(
                    $emp_rec->division_id,
                    'admin',
                    'New Resource Joined',
                    $this->load->view('recruitment/email/admin_new_hire', ['employee' => (array) $emp_rec], true),
                    [],
                    [],
                    true
                );
            }
            if ($this->input->post('work_from_home') == 'yes') {
                $this->notify->department('IT')->send(
                    sprintf(display('it_department_new_onboarding_wfh'), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                    'employee/employees/cv/' . $emp_rec->employee_id
                );
                $this->template_mail->send_to_department(
                    $emp_rec->division_id,
                    'IT',
                    'New Resource Joined',
                    $this->load->view('recruitment/email/it_new_hire', ['employee' => (array) $emp_rec], true),
                    [],
                    [],
                    true
                );
            } else {
                $this->notify->department('IT')->send(
                    sprintf(display('it_department_new_onboarding_office'), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                    'employee/employees/cv/' . $emp_rec->employee_id
                );
                $this->template_mail->send_to_department(
                    $emp_rec->division_id,
                    'IT',
                    'New Resource Joined',
                    $this->load->view('recruitment/email/it_new_hire', ['employee' => (array) $emp_rec], true),
                    [],
                    [],
                    true
                );
            }

            $this->notify->department('social media')->send(
                sprintf(display('socialmedia_department_new_onboarding'), $emp_rec->first_name, $emp_rec->last_name, $emp_rec->hrm_id),
                'employee/employees/cv/' . $emp_rec->employee_id
            );
            $this->template_mail->send_to_department(
                $emp_rec->division_id,
                'Social Media',
                'New Resource Joined',
                $this->load->view('recruitment/email/sm_new_hire', ['employee' => (array) $emp_rec], true),
                [],
                [],
                true
            );
            $this->Selection_model->make_required_documents($this->input->post('employee_id'));
            $this->db->trans_complete();
            if ($this->db->trans_status()) {
                $this->activity->set_candidate($emp_rec->can_id)->log('candidate_oriented');
                sendJson(['success' => 'Orientation is complete, download employee credentials from menu']);
            } else {
                sendJson(['error' => 'Unable to perform this operation, try again']);
            }
        }
        sendJson(['error' => 'Invalid Request']);
    }
    public function get_credentials()
    {
        if (!$this->permission->module('hired_candidate', 'update')->access()) {
            sendJson(['error' => 'You don\'t have permission to perform this action']);
        }
        if ($this->input->post('employee_id')) {
            $emp_rec = $this->db->select('employee_id, first_name, last_name, hrm_id')->where('employee_id', $this->input->post('employee_id'))->get('employee_history')->row();
            if(!$emp_rec) {
                sendJson(['error' => 'Employee record not found for this candidate']);
            }
            $cred_rec = $this->db->where('employee_id', $this->input->post('employee_id'))->get('employee_credentials')->row();
            if(!$cred_rec) {
                sendJson(['error' => 'No credentials found for this candidate']);
            }
            $cred_rec->credentials = json_decode($this->encryption->decrypt($cred_rec->credentials), true);
            sendJson(['success' => $this->load->view('recruitment/credentials_partial', [
                'employee' => $emp_rec,
                'credentials' => $cred_rec->credentials
            ], true)]);
        }
        sendJson(['error' => 'Invalid request']);
    }
    public function print_credentials($id)
    {
        $this->permission->module('hired_candidate', 'update')->redirect();
        if ($id) {
            $emp_rec = $this->db->select('employee_id, first_name, last_name, hrm_id')->where('employee_id', $id)->get('employee_history')->row();
            $cred_rec = $this->db->where('employee_id', $id)->get('employee_credentials')->row();
            if(!$cred_rec) {
                redirect();
            }
            $cred_rec->credentials = json_decode($this->encryption->decrypt($cred_rec->credentials), true);
            $this->load->view('recruitment/credentials_print', [
                'employee' => $emp_rec,
                'credentials' => $cred_rec->credentials
            ]);return;
        }
        redirect();
    }
    private function get_datatable()
    {
        $search_arr = [];
        $search_columns = [
            'employee_history.hrm_id',
            'employee_history.hire_date',
            'position.position_name',
            'candidate_basic_info.first_name',
            'candidate_basic_info.last_name',
            'candidate_basic_info.orientation',
            'candidate_basic_info.updated_at',
        ];
        if (!empty(@$this->input->post('search')['value'])) {
            $searchVal = $this->input->post('search')['value'];
            foreach ($search_columns as $value) {
                $search_arr[$value] = preg_replace('@\s+@', '%', $searchVal);
            }
        };
        $out_arr['draw'] = $_POST['draw'];
        $out_arr['data'] = array();
        $out_arr["recordsTotal"] = $this->Hired_model->countAllRows();
        $out_arr["recordsFiltered"] = $this->Hired_model->countDatatable($search_arr);
        $rows = $this->Hired_model->getDatatable($this->input->post(), $search_arr);
        foreach ($rows as $index => $rec) {
            foreach ($_POST['columns'] as $col) {
                $tdData = null;
                switch ($col['data']) {
                    case 'orientation':{
                            $tdData = ucfirst($rec[$col['data']]);
                            break;
                        }
                    case 'hire_date':{
                            $tdData = formatted_date($rec[$col['data']]);
                            break;
                        }
                    case 'updated_at':{
                            $tdData = formatted_date($rec[$col['data']], true);
                            break;
                        }
                    case 'action':{
                            $tdData = '<div class="btn-group"><button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Action <span class="caret"></span></button><ul class="dropdown-menu">';
                            $btns = [];
                            if ($this->permission->method('hired_candidate', 'update')->access()) {
                                if ($rec['orientation'] == 'pending') {
                                    $btns[] = '<li><a href="#" class="btn-orientation-done" data-id="' . $rec['employee_id'] . '">Mark Orientation Done</a></li>';
                                    $btns[] = '<li role="separator" class="divider"></li>';
                                }
                                if ($rec['orientation'] == 'done') {
                                    $btns[] = '<li><a href="#" class="btn-get-credentials" data-id="' . $rec['employee_id'] . '">View Credentials</a></li>';
                                    $btns[] = '<li><a href="#" class="btn-print-credentials" data-id="' . $rec['employee_id'] . '">Print Credentials</a></li>';
                                    $btns[] = '<li role="separator" class="divider"></li>';
                                }
                            }
                            $btns[] = '<li><a href="#" class="btn-view-profile" data-id="' . $rec['can_id'] . '">Candidate Information</a></li>';
                            $btns[] = '<li><a href="' . base_url($rec['resume']) . '" download>Download Resume</a></li>';
                            $btns[] = '<li role="separator" class="divider"></li>';
                            $btns[] = '<li><a href="#" class="btn-interview-history" data-id="' . $rec['can_id'] . '">Interview History</a></li>';
                            if ($this->permission->method('manage_employee', 'update')->access() && $rec['employee_id'] > 0) {
                                $btns[] = '<li role="separator" class="divider"></li>';
                                $btns[] = '<li><a href="' . base_url('employee/Employees/update_employee_form/' . $rec['employee_id']) . '" >Update Employee</a></li>';
                            }
                            if (!$btns) {
                                $tdData = '';
                                break;
                            }
                            $tdData .= implode('', $btns);
                            $tdData .= '</ul></div>';
                            break;
                        }
                    default:{
                            $tdData = $rec[$col['data']];
                            break;
                        }
                }
                $out_arr['data'][$index][$col['data']] = $tdData;
            }
        }
        sendJson($out_arr);
    }
}
