<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Careers extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(array(
            'Selection_model',
            'Job_model',
            'Candidate_model',
        ));
    }
    public function index()
    {
        redirect('careers');
    }
    public function jobs()
    {
        redirect('careers');
    }
    public function apply($slug = null)
    {
        if ($this->input->post()) {
            $rules_config = array(
                array(
                    'field' => 'job_id',
                    'label' => display('job_id'),
                    'rules' => 'required',
                ),
                array(
                    'field' => 'first_name',
                    'label' => display('first_name'),
                    'rules' => 'strip_tags|trim|required',
                ),
                array(
                    'field' => 'last_name',
                    'label' => display('last_name'),
                    'rules' => 'strip_tags|trim|required',
                ),
                array(
                    'field' => 'email',
                    'label' => display('email'),
                    'rules' => 'trim|required|valid_email',
                ),
                array(
                    'field' => 'phone',
                    'label' => display('phone'),
                    'rules' => 'strip_tags|trim|required|is_natural|min_length[6]|max_length[11]',
                ),
                array(
                    'field' => 'alter_phone',
                    'label' => display('alter_phone'),
                    'rules' => 'strip_tags|trim|max_length[11]',
                ),
                array(
                    'field' => 'address',
                    'label' => display('address'),
                    'rules' => 'strip_tags|required',
                ),
                array(
                    'field' => 'last_employer',
                    'label' => display('last_employer'),
                    'rules' => 'strip_tags|trim|required',
                ),
                array(
                    'field' => 'total_years_of_experience',
                    'label' => display('total_years_of_experience'),
                    'rules' => 'trim|required|is_natural',
                ),
            );
            $this->form_validation->set_rules($rules_config);
            if (empty($_FILES['resume_uploads']['name'])) {
                $this->form_validation->set_rules('resume_uploads', 'Resume', 'required');
            }
            if ($this->form_validation->run() === true) {
                $job_data = $this->Job_model->specificJobPostingBySlug($slug);
                if (!$job_data) {
                    $this->session->set_flashdata('exception', 'Error submitting your application, try again');
                    redirect($_SERVER['HTTP_REFERER']);
                }
                foreach ($job_data->skills as $skill_rec) {
                    if ($skill_rec->jps_must_or_nice == 'must' && !in_array($skill_rec->jps_id, $_POST['skills'])) {
                        $this->session->set_flashdata('exception', 'Your application is rejected because you do not meet our minimum requirments.');
                        redirect($_SERVER['HTTP_REFERER']);
                    }
                }
                if($job_data->job_wfh){
                    foreach ($job_data->job_wfh as $wfh_rec) {
                        if ($wfh_rec->jpw_must_or_nice == 'must' && !in_array($wfh_rec->jpw_id, $_POST['wfh_items'])) {
                            $this->session->set_flashdata('exception', 'Your application is rejected because you do not meet our minimum requirments.');
                            redirect($_SERVER['HTTP_REFERER']);
                        }
                    }
                }
                $this->load->library('myupload');
                $id = $this->generate->id();
                $file = $this->myupload->do_upload(
                    './application/modules/recruitment/assets/candidates_resume/',
                    'resume_uploads',
                    10// size in MBs
                );
                if (!$file) {
                    $this->session->set_flashdata('exception', 'Invalid resume file type/size, only pdf, jpg, png, jpeg, gif, doc type and size < 10 MBs are allowed');
                    redirect($_SERVER['HTTP_REFERER']);
                }
                $postData1 = [
                    'can_id' => $id,
                    'first_name' => $this->input->post('first_name', true),
                    'last_name' => $this->input->post('last_name', true),
                    'email' => $this->input->post('email', true),
                    'phone' => $this->input->post('phone', true),
                    'alter_phone' => $this->input->post('alter_phone', true),
                    'address' => $this->input->post('address', true),
                    'last_employer' => $this->input->post('last_employer', true),
                    'resume' => $file,
                    'total_years_of_experience' => $this->input->post('total_years_of_experience', true),
                    'jp_id' => $this->input->post('job_id', true),
                    'applied_on' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s'),
                ];
                $job_exist = $this->db->get_where('job_posting', array('jp_id' => $this->input->post('job_id', true)))->result();
                $candidate_found = $this->db->select('can_id')
                    ->where('email', $this->input->post('email', true))
                    ->where('jp_id', $this->input->post('job_id', true))
                    ->get('candidate_basic_info')->result();
                if ($job_exist && !$candidate_found) {
                    $res = $this->db->insert('candidate_basic_info', $postData1);
                    if ($res) {
                        $this->notify->department('hr')->send(
                            sprintf('A new candidate %s has entered into recruitment pool', implode(' ', [$postData1['first_name'], $postData1['last_name'], '(' . $postData1['can_id'] . ')'])),
                            'recruitment/job_posting/details/' . $this->input->post('job_id') . '#applicants'
                        );
                        $this->session->set_flashdata('message', display('Successfully_applied'));
                        redirect($_SERVER['HTTP_REFERER']);
                    }
                }else{
                    $this->session->set_flashdata('exception', display('you_already_applied_for_this_job'));
                    redirect($_SERVER['HTTP_REFERER']);
                }
                $settings = get_settings();
                if($settings && !empty(trim($settings->email))) {
                    $this->session->set_flashdata('exception', 'Unable to apply at this time, send us an email at ' . $settings->email);
                } else {
                    $this->session->set_flashdata('exception', 'Unable to apply at this time, try again later');
                }
                redirect($_SERVER['HTTP_REFERER']);
            }
        }
        if (!empty($slug)) {
            $job_data = $this->Job_model->specificJobPostingBySlug($slug);
            if (!empty($job_data)) {
                $data['title'] = display('career');
                $data['module'] = "recruitment";
                $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
                $data['jobs_reads'] = $job_data;
                $data['setting'] = $this->Job_model->setting();
                $this->load->view('caninfo_apply', $data);
            } else {
                $this->session->set_flashdata('exception', display('job_data_not_found'));
                redirect("careers");
            }
        } else {
            $this->session->set_flashdata('exception', display('job_data_not_found'));
            redirect("careers");
        }
    }
    public function open()
    {
        $data['title'] = display('career');
        $data['module'] = "recruitment";
        $data['job_posting'] = $this->Job_model->get_open_listings();
        $data['cities'] = $this->Job_model->job_cities();
        $data['setting'] = $this->Job_model->setting();
        //$data['dropdown'] = $this->Selection_model->dropdownPosition();
        $this->load->view('job_listing', $data);
    }
    public function job_details($id = null)
    {
        $job_data = $this->Job_model->specificJobPosting($id);
        if (!empty($job_data)) {
            $data['title'] = display('career');
            $data['module'] = "recruitment";
            $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
            $data['jobs_reads'] = $job_data;
            $data['setting'] = $this->Job_model->setting();
            $this->load->view('job_details', $data);
        } else {
            $this->session->set_flashdata('exception', display('job_data_not_found'));
            redirect("careers");
        }
    }
    public function job($slug = null)
    {
        $job_data = $this->Job_model->specificJobPostingBySlug($slug);
        if (!empty($job_data)) {
            $data['title'] = display('career');
            $data['module'] = "recruitment";
            $data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
            $data['jobs_reads'] = $job_data;
            $data['setting'] = $this->Job_model->setting();
            $this->load->view('job_details', $data);
        } else {
            $this->session->set_flashdata('exception', display('job_data_not_found'));
            redirect("careers");
        }
    }
    public function randID()
    {
        $result = "";
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        $charArray = str_split($chars);
        for ($i = 0; $i < 7; $i++) {
            $randItem = array_rand($charArray);
            $result .= "" . $charArray[$randItem];
        }
        return "E" . $result;
    }
}
