<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Notice_model extends CI_Model {
 
    public function notice_view($id=null)
	{

		$this->db->select('notice_board.*')->from('notice_board');

		$isAdmin = $this->session->userdata('isAdmin');

		$hr_dept = $this->session->userdata('dept_id');
		
		if($this->permission->method('noticeboard','create')->access()){

			$this->db->select('user.firstname');

			$this->db->join('user','user.id=notice_board.created_by');

		}else{

			$this->db->where('notice_board.status',1);

		}

		if(isset($id)){

			$this->db->where('notice_board.notice_id',$id);			

		}

		$result = $this->db->order_by('notice_board.notice_id', 'desc')->get()->result();
		
		return $result;

	}
	
	public function notice_create($data = array())
	{
		$res = $this->db->insert('notice_board', $data);
		if($res){
			$res = $this->db->insert_id();
			$this->activity->log([
				$data['status'] == 1 ? 'notice_inserted_published' : 'notice_inserted',
				$data['notice_type']
			]);
			return $res;
		}
		return $res;
	}

	public function notice_delete($id = null)
	{
		$notice_rec = $this->db->where('notice_id',$id)->get('notice_board')->row();
		$this->activity->log([
			$notice_rec->status ? 'notice_deleted_noticeboard' : 'notice_deleted',
			$notice_rec->notice_type,
			$id
		]);
		$this->db->where('notice_id',$id)
			->delete('notice_board');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 




public function update_notice($data = array())
	{
		$notice_rec = $this->db->where('notice_id', $data['notice_id'])->get('notice_board')->row();
		if($notice_rec->status == 0 && @$data['status'] == 1){
			$this->activity->log([
				'notice_updated_published',
				$notice_rec->notice_type,
				$notice_rec->notice_id
			]);
		}else{
			$this->activity->log([
				'notice_updated',
				$notice_rec->notice_type,
				$notice_rec->notice_id
			]);
		}
		return $this->db->where('notice_id',$data["notice_id"])
			->update("notice_board", $data);


	}
	public function notice_updateForm($id){
        $this->db->where('notice_id',$id);
        $query = $this->db->get('notice_board');
        return $query->row();
    }
    
     public function details($id)
    {
         return $this->db->select('*')	
			->from('notice_board')
			 ->where('notice_id',$id)
			->get()
			->result();
    }
    

}
