<div class="container-fluid">
    <div class="row">
        <form>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3">
                <div class="form-group">
                  <label for="">User</label>
                  <select class="form-control" name="user" id="selUser">
                      <option value="">Filter By User</option>
                    <?php foreach ($users as $user) :?>
                        <option value="<?= $user->id ?>" <?= $user->id == $_GET['user'] ? 'selected' : null ?>><?= $user->name ?></option>
                    <?php endforeach?>
                  </select>
                </div>
            </div>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3">
                <div class="form-group">
                  <label for="">Modules</label>
                  <select class="form-control" name="module" id="selModule">
                      <option value="">Filter By Module</option>
                    <?php foreach ($modules as $module) :?>
                        <option value="<?= $module ?>" <?= $module == $_GET['module'] ? 'selected' : null ?>><?= ucfirst($module) ?></option>
                    <?php endforeach?>
                  </select>
                </div>
            </div>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3">
                <div class="form-group">
                    <label for="">From</label>
                    <input type="text" class="form-control flatpickr" name="from" id="txtFrom" value="<?= empty($_GET['from']) ? formatted_date($curr_month_range['first']) : formatted_date($_GET['from']) ?>">
                </div>
            </div>
            <div class="col-xs-3 col-sm-3 col-md-3 col-lg-3">
                <div class="form-group">
                    <label for="">To</label>
                    <input type="text" class="form-control flatpickr" name="to" id="txtTo" value="<?= empty($_GET['from']) ? formatted_date($curr_month_range['last']) : formatted_date($_GET['to']) ?>">
                </div>
            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                <button type="submit" class="btn btn-primary pull-right">Filter</button>
            </div>
        </form>
    </div>
    <br>
    <table class="table table-hover">
        <thead>
            <tr>
                <th>Module</th>
                <th>User</th>
                <th>IP Address</th>
                <th>Time</th>
                <th>Action Performed</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($rows as $row) :?>
                <tr>
                    <td><?= ucfirst($row->module) ?></td>
                    <?php if(empty($row->employee)): ?>
                        <td><?= $row->username ?></td>
                    <?php else: ?>
                        <td><?= $row->employee . ($row->hrm_id ? sprintf(' (%s)', $row->hrm_id) : null) ?></td>
                    <?php endif ?>
                    <td><?= $row->ip_address ?></td>
                    <td><?= $row->logged ?></td>
                    <?php if(empty($row->url)): ?>
                        <td><?= $row->message ?></td>
                    <?php else: ?>
                        <td><a target="_blank" href="<?= base_url($row->url) ?>"><?= $row->message ?></a></td>
                    <?php endif ?>
                </tr>
            <?php endforeach?>
        </tbody>
    </table>
</div>
<script>
    $(document).ready(function () {
        $('.flatpickr').flatpickr({
            dateFormat: 'd-m-Y'
        })
        window.dtable = $('table.table').DataTable($.extend({},
            window.default_datatable_opts, {
                responsive: false,
                columnDefs: [{
                    targets: [3],
                    type: "date",
                    render: function ( data, type ) {
                        if(type === 'sort'){
                            return moment(data, 'DD-MM-YYYY hh:mm:ss A')
                        }
                        return data;
                    }
                }],
                order: [
                    [3, 'desc']
                ]
            }
        ))
    });
</script>