<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Leave_model extends CI_Model {
 
    public function viewWeekly()
	{
		return $this->db->select('weekly_holiday.*,shift.name as shift_name')->from('weekly_holiday')
            ->join('shift','shift.id=weekly_holiday.shift_id')
            ->order_by('weekly_holiday.wk_id', 'desc')
			->get()
			->result();
	}
	public function weekleave_create($data = array()){
        $this->activity->set_shift($data['shift_id'])->log([
            'weeklyleave_inserted',
            $data['dayname']
        ]);
       $this->db->insert('weekly_holiday',$data);
	}

	public function weekleave_delete($id = null){
        $leave_rec = $this->db->where('wk_id', $id)->get('weekly_holiday')->row();
        $this->activity->set_shift($leave_rec->shift_id)->log([
            'weeklyleave_deleted',
            $leave_rec->dayname
        ]);
		$this->db->where('wk_id',$id)
			->delete('weekly_holiday');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 


public function update_weeklev($data = array()){
    $this->activity
    ->set_url('leave/Leave/create_weekleave')
    ->set_shift($data['shift_id'])
    ->log([
        'weeklyleave_updated',
        $data['dayname']
    ]);
		return $this->db->where('wk_id',$data["wk_id"])
			->update("weekly_holiday", $data);
	}
	public function weekleave_updateForm($id){
        $this->db->where('wk_id',$id);
        $query = $this->db->get('weekly_holiday');
        return $query->row();
    }
    
    
public function viewholiday(){
return $this->db->select('payroll_holiday.*, GROUP_CONCAT(shift.name) as shifts')	
			->from('payroll_holiday')
            ->join('payroll_holiday_shift_wise', 'payroll_holiday_shift_wise.payrl_holi_id=payroll_holiday.payrl_holi_id','right')
            ->join('shift', 'shift.id=payroll_holiday_shift_wise.shift_id','left')
			->order_by('payroll_holiday.payrl_holi_id', 'desc')
            ->group_by('payroll_holiday.payrl_holi_id')
			->get()
			->result();
    }
	
    public function view_shift_holiday($id=null){
        if(isset($id)){
            return $this->db->get_where('payroll_holiday_shift_wise',['id'=>$id])->result();
        }else{
            return $this->db->select("ph.holiday_name as holiday_name, GROUP_CONCAT(s.name) AS shift_name,ph.*")   
                ->from('payroll_holiday_shift_wise as phsw')
                ->join('payroll_holiday as ph','phsw.payrl_holi_id = ph.payrl_holi_id')
                ->join('shift as s','s.id = phsw.shift_id','left')
                ->order_by('ph.payrl_holi_id', 'desc')
                ->group_by('ph.payrl_holi_id')
                ->get()
                ->result();   
        }
    }
    	
    public function view_shift_holiday_calendar($id=null){
        if(isset($id)){
            return $this->db->get_where('payroll_holiday_shift_wise',['id'=>$id])->result();
        }else{
            $this->db->select("ph.holiday_name as holiday_name, GROUP_CONCAT(s.name) AS shift_name,ph.*")   
                ->from('payroll_holiday_shift_wise as phsw')
                ->join('payroll_holiday as ph','phsw.payrl_holi_id = ph.payrl_holi_id')
                ->join('shift as s','s.id = phsw.shift_id','left');
                if($this->session->userdata('isAdmin')==1){

                }else{
                    $this->db->where('phsw.shift_id',$this->session->userdata('shift'));
                }

            return  $this->db->order_by('ph.start_date', 'asc')
                ->group_by('ph.payrl_holi_id')
                ->get()
                ->result();   
        }
    }
    
	public function holiday_create($data){
        $this->db->trans_begin();

        $res = $this->db->insert('payroll_holiday', [
            'holiday_name' => $data['holiday_name'],
            'start_date' => date('Y-m-d', strtotime($data['start_date'])),
            'end_date' => date('Y-m-d', strtotime($data['end_date'])),
            'no_of_days' => $data['no_of_days'],
            'created_by' => $this->session->userdata('id'),
            'updated_by' => $this->session->userdata('id'),
        ]);

        if($res){
            $res = $this->db->insert_id();
            foreach ($data['shifts'] as $shift_id) {
                $this->activity
                ->set_shift($shift_id)
                ->log([
                    'payroll_holiday_inserted',
                    $data['holiday_name']
                ]);
                $this->db->insert('payroll_holiday_shift_wise', [
                    'payrl_holi_id' => $res,
                    'shift_id' => $shift_id
                ]);
            }
        }

        if ($this->db->trans_status() === FALSE)
        {
                $this->db->trans_rollback();
                return false;
        }
        else
        {
                $this->db->trans_commit();
                return true;
        }
	}

public function holiday_delete($id = null,$table=null){
    if(isset($table)){
            $this->db->where('id',$id)
            ->delete($table);
    }else{
            $leave_rec = $this->db->where('payrl_holi_id',$id)->get('payroll_holiday')->row();
            $this->activity->log([
                'payroll_holiday_deleted',
                $leave_rec->holiday_name,
                $id
            ]);
            $this->db->where('payrl_holi_id',$id)->delete('payroll_holiday');
            $this->db->where('payrl_holi_id', $id)->delete('payroll_holiday_shift_wise');
    }
		
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 


	public function update_holiday($data){
        $this->db->trans_begin();

        $res = $this->db->where('payrl_holi_id', $data["payrl_holi_id"])
            ->update("payroll_holiday", [
                'holiday_name' => $data['holiday_name'],
                'start_date' => date('Y-m-d', strtotime($data['start_date'])),
                'end_date' => date('Y-m-d', strtotime($data['end_date'])),
                'no_of_days' => $data['no_of_days'],
                'updated_by' => $this->session->userdata('id'),
            ]);  

        if($res){
            $this->activity
            ->set_url('leave/Leave/holiday_view')
            ->log([
                'payroll_holiday_updated',
                $data['holiday_name'],
                $data["payrl_holi_id"]
            ]);
            $res = $data["payrl_holi_id"];
            $this->db->where('payrl_holi_id', $res)->delete('payroll_holiday_shift_wise');
            foreach ($data['shifts'] as $shift_id) {
                $this->db->insert('payroll_holiday_shift_wise', [
                    'payrl_holi_id' => $res,
                    'shift_id' => $shift_id
                ]);
            }
        }

        if ($this->db->trans_status() === FALSE)
        {
                $this->db->trans_rollback();
                return false;
        }
        else
        {
                $this->db->trans_commit();
                return true;
        } 
	}
	public function holiday_updateForm($id){
        return $this->db->select('payroll_holiday.*, GROUP_CONCAT(shift.id) as shifts')
            ->where('payroll_holiday.payrl_holi_id',$id)
            ->join('payroll_holiday_shift_wise', 'payroll_holiday_shift_wise.payrl_holi_id=payroll_holiday.payrl_holi_id','right')
            ->join('shift', 'shift.id=payroll_holiday_shift_wise.shift_id','left')
			->order_by('payroll_holiday.payrl_holi_id', 'desc')
            ->group_by('payroll_holiday.payrl_holi_id')
			->get('payroll_holiday')
			->row();
    }

	public function application_create($data = array())
	{
		return $this->db->insert('leave_apply', $data);
	}
    public function get_subordinates($include = true, $override = false)
    {
        $this->load->model('employee/employees_model');
        return $this->employees_model->get_subordinates(null, $include, $override);
    }
	 public function dropdown(){
         $data = [];
	     if($this->session->userdata('isAdmin') == 1 || $this->permission->full('leave')->access()){
            $data = $this->db->select('employee_id, first_name, last_name')->order_by('first_name', 'asc')->get('employee_history')->result_array();
         }elseif($this->session->userdata('supervisor') == 1){
            $data = $this->get_subordinates();
         }else{
            $data = $this->db->select('employee_id, first_name, last_name')->where('employee_history.employee_id',$this->session->userdata('employee_id'))->get('employee_history')->result_array();             
         }
    	$list = array('' => 'Select One...');
    	if(!empty($data)){
    		foreach ($data as  $value) {
    			$list[$value['employee_id']]=$value['first_name']." ".$value['last_name'];
    		}
    	}
    	return $list;
    }

    public function manageleave()
	{
        $subords = [];
        if($this->session->userdata('supervisor') == 1){
            $subords = array_column($this->get_subordinates(true, true), 'employee_id');
        }
       $this->db->select('ap.*,p.employee_id,p.first_name,p.last_name, p.hrm_id, type.leave_type')   
            ->from('leave_apply ap')
            ->join('employee_history p', 'ap.employee_id = p.employee_id', 'left')
            ->join('leave_type as type', 'ap.leave_type_id = type.leave_type_id', 'left');

            if($this->session->userdata('isAdmin') || $this->permission->full('leave')->access()) {
            } elseif ($this->permission->method('leave_application','update')->access()) {
            } elseif ($this->session->userdata('supervisor') == 1 && count($subords) > 0) {
                $this->db->where_in('p.employee_id',$subords);
            } else {
                $this->db->where('p.employee_id', $this->session->userdata('employee_id'));
            }


      return      $this->db->group_by('ap.leave_appl_id')
            ->order_by('ap.leave_appl_id', 'desc')
            ->get()
            ->result();
    }
    public function application_delete($id = null)
	{
        $leave_rec = $this->db->where('leave_appl_id',$id)->get('leave_apply')->row();
        $this->activity->set_employee($leave_rec->employee_id)
        ->log([
            'leave_deleted',
            $id
        ]);
		$this->db->where('leave_appl_id',$id)
			->delete('leave_apply');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 
	public function update_application($data = array())
	{
		return $this->db->where('leave_appl_id', $data["leave_appl_id"])
			->update("leave_apply", $data);


	}
	public function application_updateForm($id){
        $this->db->where('leave_appl_id',$id);
        $query = $this->db->get('leave_apply');
        return $query->row();
    }
     public  function get_id($id)
    {
        $query=$this->db->select('leave_apply.*, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as employee_fullname, leave_type.leave_type as leave_name')
		->join('employee_history', 'leave_apply.employee_id=employee_history.employee_id','left')
		->join('leave_type', 'leave_type.leave_type_id=leave_apply.leave_type_id','left')
		->get_where('leave_apply',array('leave_appl_id'=>$id));
        return $query->row_array();
    } 

    // insert others leave type 
    public function save_leave_type($data = array()){
        $this->activity->log([
            'leave_type_inserted',
            $data['leave_type']
        ]);
    	return $this->db->insert('leave_type', $data);
    }  

     // get all leave type for apply leave
     public function get_leave_type(){
    	$this->db->select('*');
    	$this->db->from('leave_type');
    	$query=$this->db->get();
    	$data=$query->result();
        $list = array('' => 'Select One...');
    	if(!empty($data)){
    		foreach ($data as  $value) {
    			$list[$value->leave_type_id]=$value->leave_type;
    		}
    	}
    	return $list;
    }

    // get all leave type 
     public function get_all_leave_type(){
    	$this->db->select('*');
    	$this->db->from('leave_type');
    	$query=$this->db->get();
    	return $query->result();
    }

    //get leave type by leave type id
    public function get_leave_type_by_id($id){
        $this->db->where('leave_type_id',$id);
        $query = $this->db->get('leave_type');
        return $query->row();
    }

    // update leave type 
    public function save_update_leave_type($data = array()){
        $this->activity->log([
            'leave_type_updated',
            $data["leave_type"],
            $data["leave_type_id"],
        ]);
    	$this->db->where('leave_type_id', $data["leave_type_id"])
  			     ->update('leave_type', $data);
    }

    // delete leave type by id 
    public function delete_leave_type($id = null)
	{
        $leave_rec = $this->db->where('leave_type_id',$id)->get('leave_type')->row();
        $this->activity->log([
            'leave_type_deleted',
            $leave_rec->leave_type,
            $id
        ]);
		$this->db->where('leave_type_id',$id)
			->delete('leave_type');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 

    public function supervisorList(){
        return $result = $this->db->select('first_name,last_name,employee_id')->from('employee_history')->where('is_super_visor',1)->get()->result();
    }
    public function get_annual_holidays($shift_ids = null)
    {
        $this->db->select('payroll_holiday.holiday_name, payroll_holiday.start_date, payroll_holiday.end_date, GROUP_CONCAT(payroll_holiday_shift_wise.shift_id) as shifts')
        ->join('payroll_holiday_shift_wise', 'payroll_holiday.payrl_holi_id=payroll_holiday_shift_wise.payrl_holi_id', 'right')
        ->group_by('payroll_holiday_shift_wise.payrl_holi_id');

        if($shift_ids){
            $this->db->where_in('payroll_holiday_shift_wise.shift_id', is_array($shift_ids) ? $shift_ids : [$shift_ids]);
        }

        return $this->db->get('payroll_holiday')
        ->result_array();
    }
    public function countAllRows()
    {
        $this->query();
        return $this->db->count_all_results('leave_apply');
    }
    public function query()
    {
        $subords = [];
        if ($this->session->userdata('supervisor') == 1) {
            $subords = array_column($this->get_subordinates(true, true), 'employee_id');
        }
        $this->db->select('leave_apply.*, employee_history.employee_id, CONCAT_WS(\' \', employee_history.first_name, employee_history.last_name) as employee_name, employee_history.hrm_id, leave_type.leave_type')
            ->join('employee_history', 'leave_apply.employee_id = employee_history.employee_id', 'left')
            ->join('leave_type', 'leave_apply.leave_type_id = leave_type.leave_type_id', 'left');

        if ($this->session->userdata('isAdmin') || $this->permission->full('leave')->access()) {
        } elseif ($this->permission->method('leave_application', 'update')->access()) {
        } elseif ($this->session->userdata('supervisor') == 1 && count($subords) > 0) {
            $this->db->where_in('employee_history.employee_id', $subords);
        } else {
            $this->db->where('employee_history.employee_id', $this->session->userdata('employee_id'));
        }
    }
    public function countDatatable($orWhere, $where_arr = [])
    {
        $this->query();
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $value) {
                if(strpos($value[1], '%') === false) {
                    $this->db->or_where($value[0], $value[1]);
                } else {
                    $this->db->or_like($value[0], $value[1], 'right', false);
                }
            }
            $this->db->group_end();
        }
        foreach ($where_arr as $where_ar) {
            $this->db->where($where_ar[0], $where_ar[1]);
        }
        return $this->db->count_all_results('leave_apply');
    }
    public function getDatatable($orWhere, $where_arr = [])
    {
        $post = $this->input->post();
        $this->query();
        if ($orWhere) {
            $this->db->group_start();
            foreach ($orWhere as $value) {
                if(strpos($value[1], '%') === false) {
                    $this->db->or_where($value[0], $value[1]);
                } else {
                    $this->db->or_like($value[0], $value[1], 'right', false);
                }
            }
            $this->db->group_end();
        }
        foreach ($where_arr as $where_ar) {
            $this->db->where($where_ar[0], $where_ar[1]);
        }
        $this->db->order_by($post['columns'][$post['order'][0]['column']]['data'], $post['order'][0]['dir'])
            ->limit($post['length'] > 0 ? $post['length'] : 0, $post['start']);
        return $this->db->get('leave_apply')->result_array();
    }
    public function send_email($leave, $type)
    {
        $emp_info = $this->employee_info($leave['employee_id']);
        $days = formatted_date($leave['apply_strt_date']);
        if($leave['apply_strt_date'] != $leave['apply_end_date']) {
            $days = sprintf('%s - %s', $days, formatted_date($leave['apply_end_date']));
        }
        $this->template_mail->config($emp_info['division_id'])
        ->_send(
            $emp_info['email'],
            null,
            sprintf('Leave Application for %s (#%s) is %s', $days, $leave['leave_appl_id'], ucfirst($type)),
            $this->load->view('leave/emails/process', ['employee' => $emp_info, 'days' => $days, 'request' => (array) $leave, 'action' => $type], true),
            $emp_info['supervisor_email']
        );
    }
    public function employee_info($id)
    {
        return $this->db
        ->select('eh.first_name, eh.last_name, COALESCE(eh.business_email, eh.home_email) as email, COALESCE(supervisor.business_email, supervisor.home_email) as supervisor_email, eh.division_id, d.name as division')
        ->join('divisions d', 'eh.division_id=d.id', 'left')
        ->join('employee_history supervisor', 'eh.super_visor_id=supervisor.employee_id', 'left')
        ->where('eh.employee_id', $id)
        ->get('employee_history eh')->row_array();
    }
}
