<script src="<?= base_url() ?>assets/plugins/tinymce/tinymce.min.js"></script>
<script src="<?= base_url() ?>assets/plugins/tinymce/jquery.tinymce.min.js"></script>
<script>
    $(document).ready(function () {
        var useDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;
        tinymce.init({
            selector: 'textarea.editor',
            plugins: 'print preview paste importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount imagetools textpattern noneditable help charmap quickbars emoticons',
            imagetools_cors_hosts: ['picsum.photos'],
            menubar: 'file edit view insert format tools table help',
            toolbar: 'undo redo | bold italic underline strikethrough | fontselect fontsizeselect formatselect | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
            toolbar_sticky: true,
            images_upload_url: '<?= base_url() ?>dashboard/home/tmce_upload',
            images_upload_base_path: '<?= base_url() ?>',
            relative_urls : false,
            remove_script_host : false,
            convert_urls : true,
            autosave_ask_before_unload: true,
            autosave_interval: '30s',
            autosave_prefix: '{path}{query}-{id}-',
            autosave_restore_when_empty: false,
            autosave_retention: '2m',
            image_advtab: true,
            template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',
            template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',
            height: 600,
            image_caption: true,
            quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
            noneditable_noneditable_class: 'mceNonEditable',
            toolbar_mode: 'sliding',
            contextmenu: 'link image imagetools table',
            skin: useDarkMode ? 'oxide-dark' : 'oxide',
            content_css: useDarkMode ? 'dark' : 'default',
            content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:14px }',
            setup: function(editor){
                var full_suggestions = JSON.parse('<?= addslashes(json_encode($full_suggestions)) ?>')
                var onAction = function (autocompleteApi, rng, value) {
                    editor.selection.setRng(rng);
                    editor.insertContent(value);
                    autocompleteApi.hide();
                };
                var getMatchedChars = function (pattern, cback) {
                    var items = []
                    if(full_suggestions){
                        var items2 = full_suggestions.filter(function (char) {
                            return char.indexOf(pattern) !== -1;
                        }).map(function(item){
                            return `{{${item}}}`
                        });
                    }else{
                        console.error('full_suggestions not found');
                    }
                    cback(items.concat(items2))
                };
                editor.ui.registry.addAutocompleter('specialchars', {
                    ch: '{',
                    minChars: 0,
                    columns: 1,
                    onAction: onAction,
                    fetch: function (pattern) {
                        return new tinymce.util.Promise(function (resolve) {
                            getMatchedChars(pattern, function(items){
                                var results = items.map(function (char) {
                                    return {
                                        type: 'autocompleteitem',
                                        value: char,
                                        text: char,
                                    }
                                });
                                resolve(results);
                            })
                        });
                    }
                });
            }
        });
    });
</script>